import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class SphereTest {


    /**This tests that every point on the boundary
       of the sphere of radius sq(2)/3 about (1/3,1/3) is
       mapped inside the ball bounded by S.*/

    /**Hermitian norm*/

    public static double hermitianNorm(Complex[] z) {
	double d1=z[0].norm();
	double d2=z[1].norm();
	double d=d1*d1+d2*d2;
	return(Math.sqrt(d));
    }

    /**distance in C2*/
    public static double dist(Complex[] z,Complex[] p) {
	double d1=Complex.dist(z[0],p[0]);
	double d2=Complex.dist(z[1],p[1]);
	double d=d1*d1+d2*d2;
	return(Math.sqrt(d));
    }
    
    /**This produces a random point on the unit sphere*/

    public static Complex[] randomS() {	
        Complex z1=new Complex(Math.random()-.5,Math.random()-.5);
	Complex z2=new Complex(Math.random()-.5,Math.random()-.5);
	Complex[] z={z1,z2};
	double d=hermitianNorm(z);
	z1=Complex.times(new Complex(1/d,0),z1);
	z2=Complex.times(new Complex(1/d,0),z2);
	z[0]=z1;
	z[1]=z2;
	return(z);
    }

    /**This produces a random point on the sphere of radius r about
       the point p*/

    public static Complex[] randomS(double r,Complex[] p) {
	Complex[] z=randomS();
	for(int i=0;i<2;++i) {
	  z[i]=Complex.times(z[i],new Complex(r,0));
	  z[i]=Complex.plus(z[i],p[i]);
	}
	return(z);
    }
}

