import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class SquareTest {


    /**This tests that every point on the boundary
       of the sphere of radius sq(2)/3 about (1/3,1/3) is
       mapped inside the ball bounded by S.*/

    public static double infinityNorm(Complex[] z) {
	double d1=z[0].infinityNorm();
	double d2=z[1].infinityNorm();
	double d=Math.max(d1,d2);
	return(d);
    }

    /**L_infty distance in C2*/
    public static double infinityDist(Complex[] z,Complex[] p) {
	Complex[] w={Complex.minus(z[0],p[0]),Complex.minus(z[1],p[1])};
	return(infinityNorm(w));
    }

    /**produces a random point on the square of sidelength 2/3 about
       the point 1/3,1/3*/
    

    /**This produces a random point in the 2-skeleton of the
       cube of sidelength 2/3 centered at (1/3,1/3) in C2.*/

    public static Complex[] randomCube() {
	double s=1.0/3;
	double d1=random(0,2*s);
	double d2=random(0,2*s);
	double d3=0;
	double d4=0;
	if(Math.random()>.5) d3=2*s;
	if(Math.random()>.5) d4=2*s;
	double t=Math.random();
	if(t<1.0/6) {
	    Complex[] z={new Complex(d1,d2-s),new Complex(d3,d4-s)};
	    return(z);
	}

	if(t<2.0/6) {
	    Complex[] z={new Complex(d1,d3-s),new Complex(d2,d4-s)};
	    return(z);
	}

	if(t<3.0/6) {
	    Complex[] z={new Complex(d3,d1-s),new Complex(d2,d4-s)};
      	    return(z);
	}
	

	if(t<4.0/6) {
	    Complex[] z={new Complex(d2,d3-s),new Complex(d4,d1-s)};
      	    return(z);
	}

	if(t<5.0/6) {
	    Complex[] z={new Complex(d3,d2-s),new Complex(d4,d1-s)};
      	    return(z);
	}
	
	

	Complex[] z={new Complex(d4,d3-s),new Complex(d2,d1-s)};
	return(z);
    }


    public static double random(double a,double b) {
	double t=Math.random();
	return((1-t)*a+t*b);
    }


    public static double normTest1(Complex x,Complex y) {
	Complex z1=new Complex(-5,0);
	Complex z2=Complex.times(new Complex(4,0),Complex.times(x,y));
	Complex z3=Complex.times(Complex.times(x,y),y);
	Complex w3=Complex.plus(z1,x);
	w3=Complex.minus(w3,y);
	w3=Complex.plus(w3,z2);
	w3=Complex.plus(w3,z3);
	return(w3.norm());
    }

    public static double normTest2(Complex x,Complex y) {
	Complex z1=new Complex(6,0);
	Complex z2=Complex.times(z1,Complex.times(x,y));
	Complex z3=Complex.times(Complex.times(Complex.times(x,x),y),y);
	Complex w2=Complex.minus(z1,x);
	w2=Complex.minus(w2,z2);
	w2=Complex.plus(w2,z3);
	return(w2.norm());
    }

}

