import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

   /**This class allows one to select a collection of chains.
       The A-chains are in 1-1 correspondence with the A-renorm tiles
       that partition the A-renorm set.**/

public class ChainSelector {
    int x;
    int y;
    ControlPanel LEVEL,BRANCH;
    SelectInteger INT;

    public ChainSelector(int xx,int yy) {
	x=xx;
	y=yy;
	setControls();
	INT=new SelectInteger(x+5,y+175,40,20,0,0,40,1);  //chain selector
    }

     public void setControls() {
       	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,200,0)};
       	 Color[] C2={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,0,0)};

         String[] LevelString={"00","01","02","03","04","15","20","21","22","layer"};
         int[] LevelState={0,0,0,0,0,0,0,0,0};
         LEVEL=new ControlPanel(C2,LevelString,LevelState,9);


	 String[] BranchString={"0","1","2","3","br"};
         int[] BranchState={0,0,0,0};
         BRANCH=new ControlPanel(C2,BranchString,BranchState,4);

    }


    public void render(Graphics2D g) {
	drawChainSelector(g);
    }

    public void render2(Graphics2D g) {
	drawChainSelector2(g);
    }

    int[] lookup(int k) {
	int[][] A={{0,0},{0,1},{0,2},{0,3},{0,4},{1,5},{2,0},{2,1},{2,2}};
	return(A[k]);}

    public int[] getIndex() {

         int count1=0;
	 int count2=0;
	 int index1=0;
	 int index2=0;

	 for(int i=0;i<9;++i) {
	     if(LEVEL.L[i].on==1) {
                 ++count1;
		 index1=i;
	     }
	 }
	 for(int i=0;i<4;++i) {
	     if(BRANCH.L[i].on==1) {
                  ++count2;
		  index2=i;
	     }
	 }
	 if((count1==1)&&(count2==1)) {
	     int[] L=lookup(index1);
	     int[] X={L[0],L[1],index2,INT.val};
	     return(X);
	 }
	 return(null);
    }


    public int getLimit() {
	int[] L=getIndex();
	if(L==null) return(0);
        int lim=DataRenormReturn.limits(L[1],L[2]);
	return(lim);
    }






    public void drawChainSelector(Graphics2D g) {
         LEVEL.render(g,x,y,45);
	 BRANCH.render(g,x+50,y,45); 
	 int lim=getLimit();
	 if(lim>0) {
              INT.render(g,Color.blue,Color.white,Color.white,"chain index");
	      Integer LIM=new Integer(lim);
	      g.setColor(Color.white); 
              g.setFont(new Font("Helvetica",Font.PLAIN,12));
	      g.drawString(LIM.toString(),x+10,y+215);
	 }

    }

    public void drawChainSelector2(Graphics2D g) {
         LEVEL.render(g,x,y,45);
    }




    public void toggle(Manager M,Point X) {
         LEVEL.toggle(X);
         BRANCH.toggle(X);
	 int lim=getLimit();
	 if(lim>0) 
         INT.max=lim;
	 if(INT.val>INT.max-1) INT.val=0;
       	 INT.modifyCyclic(X);
 	 documentStuff(M,X);
    }




    public void switchMode(Manager M,Point X) {
         LEVEL.switchMode(X);
         BRANCH.switchMode(X);
	 int lim=getLimit();
	 if(lim>0) 
         INT.max=lim;
	 if(INT.val>INT.max-1) INT.val=0;
       	 INT.modifyCyclic(X);
	 documentStuff(M,X);
    }


    /**DOCUMENTATION**/


    public void documentStuff(Manager M,Point X) {
	DocumentChains DOC=new DocumentChains(M);
	if(LEVEL.getInfo(X)==true) DOC.chainInfo();
	if(BRANCH.getInfo(X)==true) DOC.chainInfo();
    }




}


