import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Characteristics {

    /**Our basic parameter interval is [0,2].  This interval
       has two partitions.  The A-partition is made from 18
       smaller intervals.  The B-partition is made from 6
       smaller intervals.  The purpose of this class is to
       return information about which interval contains a given point.
       We will give both floating point routines and golden
       arithmetic routines.**/




    /**FLOATING POINT**/

    /*The basic dividing points*/

    public static double cut(int n) {
	GoldenReal r=cutG(n);
	return(r.toDouble());
    }

    public static int getInterval1(double h) {
	for(int i=0;i<6;++i) {
	    if(h<cut(i+1)) return(i);
	}
	return(5);
    }

    /**In this routine, intervals 2 and 3 are amalgameted. 
       So  0,1,2,3,4,5 --> 0,1,2,3,4 **/

    public static int getInterval2(double h) {
	int k=getInterval1(h);
	if(k<3) return(k);
	return(k-1);
    }

    /**getting the levels of a point**/

    public static int getCharB(double d) {
	return(getInterval1(d));
    }

    public static int[] getCharA(double h) {
	if(Math.abs(h-1)<.0000000001) {
	    int[] L={2,2};
	    return(L);
	}
	int LA=getInterval2(h);
	double h1=GroupAction.map(h);
	int LB=getInterval1(h1);
	int[] L={LA,LB};
	return(L);
    }


    /**This routine gets the endpoints of the Lth interval of the B-partition.**/

    public static double[] getHeightB(int L) {
	double[] d={cut(L),cut(L+1)};
	return(d);
    }


    /**This routine gets the endpoints of the (LA,LB)th interval of the A-partition.**/


    public static double[] getHeightA(int LA,int LB) {
	GoldenReal[] r=getGoldenHeightA(LA,LB);
	if(r==null) return(null);
	double[] d={r[0].toDouble(),r[1].toDouble()};
	return(d);
    }

    /**GOLDEN ARITHMETIC**/

    public static int[] getCharA(GoldenReal h) {
	int LA=getCharB2(h);
	GoldenReal h1=map(h);
	int LB=getCharB(h1);
	int[] L={LA,LB};
	return(L);
    }

    public static GoldenReal map(GoldenReal y1) {
	GoldenReal ONE=new GoldenReal(1,0);
	GoldenReal TWO=new GoldenReal(2,0);
	if(GoldenReal.isLess(y1,ONE)) return(map0(y1));
	GoldenReal y2=GoldenReal.minus(TWO,y1);
	y2=map0(y2);
	y2=GoldenReal.minus(TWO,y2);
	return(y2);
    }

    public static GoldenReal map0(GoldenReal y1) {
	GoldenReal ONE=new GoldenReal(1,0);
	GoldenReal A=new GoldenReal(-3,2);  //phi^{-3}
	GoldenReal B=new GoldenReal(1,2);   //phi^3
	int i=getCharB(y1);
	GoldenReal y2=new GoldenReal(0,0);
 	if(i==0) y2=GoldenReal.times(B,y1);
 	if(i==1) y2=GoldenReal.plus(y1,new GoldenReal(-2,2));
 	if(i==2) y2=GoldenReal.times(B,GoldenReal.minus(GoldenReal.plus(A,y1),ONE));
	y2=y2.dec(2);
        return(y2);
    }

    public static GoldenReal cutG(int n) {
	int[][] A={{0,0},{2,-1},{4,-2},{1,0},{-2,2},{0,1},{2,0}};
	if(n<0) return(new GoldenReal(0,0));
	if(n>5) return(new GoldenReal(2,0));
	return(new GoldenReal(A[n][0],A[n][1]));
    }

    public static int getCharB(GoldenReal h) {
	for(int i=0;i<6;++i) {
	    if(GoldenReal.isLess(h,cutG(i+1))==true) return(i);
	}
	return(5);
    }


    public static int getCharB2(GoldenReal h) {
	int k=getCharB(h);
	if(k<3) return(k);
	return(k-1);
    }



    public static GoldenReal[] getGoldenHeightA(int LA,int LB) {
	int[][] A={{0,0},{0,1},{0,2},{0,3},{0,4},{1,5},{2,0},{2,1},{2,2},{2,3},{2,4},{2,5},{3,0},{4,1},{4,2},{4,3},{4,4},{4,5}};
	int index=-1;
	for(int i=0;i<18;++i) {
	    if((LA==A[i][0])&&(LB==A[i][1])) index=i;
	}
	if(index==-1) return(null);
	GoldenReal[] r=new GoldenReal[2];
	r[0]=getLevelA(index);
	r[1]=getLevelA(index+1);
	return(r);
    }

    public static GoldenReal getLevelA(int k) {
	int[][] A={{0,0},{-8,5},{-16,10},{-3,2},{10,-6},{2,-1},{4,-2},{-4,3},{-12,8},{1,0},{14,-8},{6,-3},{-2,2},{0,1},{-8,6},{5,-2},{18,-10},{10,-5},{2,0}};GoldenReal r=new GoldenReal(A[k][0],A[k][1]);return(r);}

    public static GoldenReal getLevelB(int k) {
	int[][] A={{0,0},{2,-1},{4,-2},{1,0},{-2,2},{0,1},{2,0}};GoldenReal r=new GoldenReal(A[k][0],A[k][1]);return(r);}



}