import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class has floating point versions of the routines in the
file ProofCompactify.  The routines here are present mainly for
the purpose of debugging.**/


public class Compactify {

    /**This embeds the plane in R^4**/

    public static Vector4 tilde_theta(Complex z) {
	double x=z.x;
	double y=z.y;
	double p=GoldenRatio.phi(1);
	double[] X=new double[4];
	X[0]=x+y;
	X[1]=x-y;
	X[2]=(x+y)/p;
	X[3]=(x-y)/p;
	Vector4 V=new Vector4(X);
	return(V);
    }



    public static Vector tilde_pi(Vector4 VV) {
	Vector4 V=new Vector4(VV);
	for(int j=1;j<=8;++j) {
	    V=tilde_E(j%4,V);
	}

	Vector W=tilde_zeta(V);
	return(W);
    }



    /**The piecewise affine maps of R^4**/

    public static Polytope tilde_E(int j,Polytope X) {
	Polytope Y=new Polytope();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) Y.V[i]=tilde_E(j,X.V[i]);
	return(Y);
    }

    public static Vector4 tilde_E(int j,Vector4 V) {
	return(Vector4.plus(linear(j%4,V),translate(j%4,V)));
    }

    public static Vector4 linear(int qq,Vector4 V) {
	int q=qq%4;
	double p=GoldenRatio.phi(1);
	double[][] m0={{1,0,0,0},{0,1,0,0},{-1+p,0,0,0},{0,0,0,1}};
	double[][] m1={{1,0,0,0},{0,1,0,0},{0,-p+1,1,1},{0,p-1,0,0}};
	double[][] m2={{1,0,0,0},{0,1,0,0},{0,0,1,0},{-1,-1+p,p,0}};
	double[][] m3={{p,-1,-1,p},{-1+p,0,-1,p},{-p+1,1,2,-p},{-p+1,1,1,-p+1}};
	double[][][] m={m0,m1,m2,m3};
	Vector4 W=new Vector4(0,0,0,0);
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) W.x[i]=W.x[i]+m[q][i][j]*V.x[j];
	}
	return(W);
    }

    public static Vector4 translate(int k,Vector4 V) {
	double[] x=V.toComponents();
	double p2=GoldenRatio.phi(2);
	double p=GoldenRatio.phi(1);
	double d=0;
	if(k%4==0)  d=x[0]+1.0;
	if(k%4==1)  d=x[1]+1.0;
	if(k%4==2)  d=x[1]+x[2]+2+p;
	if(k%4==3)  d=x[0]+x[3]+2+p;
	d=4*Math.floor(d/4);
        d=d*GoldenRatio.phi(1);
	if(k==0) return(new Vector4(0,0,-d,0));
	if(k==1) return(new Vector4(0,0,d,-d));
	if(k==2) return(new Vector4(0,0,0,-d));
	if(k==3) return(new Vector4(-d,-d,d,d));
	return(null);
    }

    public static Vector tilde_zeta_linear(Vector4 V) {
	double[] A=V.toComponents();
	double[] x=new double[3];
	x[0]=A[2]+A[3];
	x[1]=A[1];
	x[2]=A[0]-A[1];
	for(int i=0;i<3;++i) x[i]=.5*x[i];
	Complex z=new Complex(x[0],x[1]);
	z=TorusMap.fundamentalDomain(z);
	x[2]=TorusMap.dec(2,x[2]);
	Vector W=new Vector(z.x,z.y,x[2]);
	return(W);
    }


    public static Vector tilde_zeta(Vector4 V) {
	double[] A=V.toComponents();
	double[] x=new double[3];
	x[0]=2.0+A[2]+A[3];
	x[1]=1.0+A[1];
	x[2]=A[0]-A[1];
	for(int i=0;i<3;++i) x[i]=.5*x[i];
	Complex z=new Complex(x[0],x[1]);
	z=TorusMap.fundamentalDomain(z);
	x[2]=TorusMap.dec(2,x[2]);
	Vector W=new Vector(z.x,z.y,x[2]);
	return(W);
    }

    public static Polyhedron tilde_zeta(Polytope X) {
	Polyhedron P=new Polyhedron();
	P.count=X.count;
	for(int i=0;i<P.count;++i) P.V[i]=tilde_zeta(X.V[i]);
	return(P);
    }



    /**Here is the affine lift of a vector. This these are the maps
       iota_k in the paper**/

    public static Polytope I(int k,Polyhedron P) {
	Polytope X=new Polytope();
	X.count=P.count;
	for(int i=0;i<P.count;++i) {
	    X.V[i]=I(k,P.V[i]);
	}
	return(X);
    }



    /**we have a number of lifts we want to use**/
    public static Vector4 I(int k,Vector V) {
	double p=GoldenRatio.phi(1);
	double f=0;
	if(k==1) f=2;
	if(k==2) f=1+GoldenRatio.phi(-3);
	if(k==3) f=-1+GoldenRatio.phi(-3);
	double u=V.x[0]-1;
	double v=V.x[1]-.5;
	double w=V.x[2];
	double[] a={2*v+w,2*v+w,u,u};
	double[] b={w,-w,w/p-f,-w/p+f};
	double[] c={a[0]+b[0],a[1]+b[1],a[2]+b[2],a[3]+b[3]};
	Vector4 v0=new Vector4(c[0],c[1],c[2],c[3]);
	return(v0);
    }



    /**we have a number of lifts we want to use**/
    public static Vector4 I_linear(Vector V) {
	double p=GoldenRatio.phi(1);
	double u=V.x[0];
	double v=V.x[1];
	double w=V.x[2];
	double[] a={2*v+w,2*v+w,u,u};
	double[] b={w,-w,w/p,-w/p};
	double[] c={a[0]+b[0],a[1]+b[1],a[2]+b[2],a[3]+b[3]};
	Vector4 v0=new Vector4(c[0],c[1],c[2],c[3]);
	return(v0);
    }




    /**This checks if the kth affine map is entirely defined on the polytope*/

    public static boolean checkSqueezed(int k,Polytope X) {
	for(int i=0;i<X.count-1;++i) {
	    int d1=determine(k,X.V[i]);
	    int d2=determine(k,X.V[i+1]);
	    if(d1!=d2) return(false);
	}
	return(true);
    }

    public static int[] determineSequence(Vector4 X) {
	int[] u=new int[9];
	for(int k=1;k<=8;++k) {
	   u[k]=determine(k,X);
	   X=tilde_E(k,X);
	}
	return(u);
    }


    public static int determine(int k,Vector4 V) {
	double[] x=V.toComponents();
	double p2=GoldenRatio.phi(2);
	double d=0;
	if(k%4==0)  d=x[0]+1.0;
	if(k%4==1)  d=x[1]+1.0;
	if(k%4==2)  d=x[1]+x[2]+4-1/p2;
	if(k%4==3)  d=x[0]+x[3]+4-1/p2;
	int e=4*(int)(Math.floor(d/4));
	return(e);
    }

}







