import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    int history,parity;

    
    /**constructors*/

    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 

    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }

    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }

    /**arithmetic**/

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }
    
    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }

    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(z.norm());
    }
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }
    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }

    public Complex conjugate() {
        return new Complex(x,-y);
    }


    /**other functions*/

    public static double area(Complex z1,Complex z2,Complex z3) {
        double a;
        Complex[] z=new Complex[10];
        for(int i=1;i<=9;++i) z[i]=new Complex();
        z[1]=z1.minus(z2,z1);
        z[2]=z1.minus(z3,z1);
        z[3]=z[2].conjugate();
        z[4]=z1.times(z[1],z[3]);
        a=-z[4].y;
        return(a);
    }


    /**This decides if a triangle is positively oriented**/

    public static boolean isPositivelyOriented(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=z[2].conjugate();
        z[4]=Complex.times(z[1],z[3]);
	if(z[4].y<0) return(true);
	return(false);
    }


    /**This makes a regular polygon around the given point.
       r is the radius and n is the number of points.*/

       

    public PolyWedge toPolygonDisk(double r, int N) {
	PolyWedge P=new PolyWedge();
	for(int k=0;k<N;++k) {
	    double t=2.0*Math.PI*k/N;
	    double c=this.x+r*Math.cos(t);
	    double s=this.y+r*Math.sin(t);
	    P.z[k]=new Complex(c,s);
	}
	return(P);
    }


    public GeneralPath toDisk(double r, int N) {
	GeneralPath gp=new GeneralPath();
	for(int k=0;k<=N;++k) {
	    double t=2.0*Math.PI*k/N;
	    double c=this.x+r*Math.cos(t);
	    double s=this.y+r*Math.sin(t);
	    if(k==0) gp.moveTo((float)(c),(float)(s));
	    if(k!=0) gp.lineTo((float)(c),(float)(s));
	}
	return(gp);
    }


    public static Complex scale(Complex FIX,double SIZE,Complex z) {
	Complex w=new Complex(z);
	w=Complex.minus(w,FIX);
	w=new Complex(SIZE*w.x,SIZE*w.y);
	w=Complex.plus(w,FIX);
	return(w);
    }


    public Complex scale(Complex z,double r) {
        Complex w=new Complex();
        w.x=r*x+(1.0-r)*z.x;
        w.y=r*y+(1.0-r)*z.y;
        return(w);
    }



    public static Complex random(double RANGE) {
          double x1=2*RANGE*Math.random()-RANGE;
	  double x2=2*RANGE*Math.random()-RANGE; 
	  return(new Complex(x1,x2));
    }

    public static boolean between(Complex z,Complex w1,Complex w2) {
	double d1=dist(z,w1);
	double d2=dist(z,w2);
	double d3=dist(w1,w2);
	if(d1+d2<d3+.00000000001) return(true);
	return(false);
    }


}

