import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Compute3D implements Runnable {
    Manager M;
    int CHOICE;
    int halt;

    public Compute3D() {}

    public Compute3D(int choice,Manager MM) {
	this.CHOICE=choice;
	this.M=MM;
    }

    public void run() {

	double t1=System.currentTimeMillis();
	int act=M.C.CON_P.ACTION.mode;
	int obj=M.C.CON_P.OBJECT.mode; 
	int ban=M.C.CON_P.BAND.mode;
	int link=M.C.LINK.L[0].on;
	if(obj<4) runTile(act,obj);
	if(obj>=4) runRenorm(ban,obj);
	M.repaint();
    }


    public void runTile(int act,int obj) {
 	if(obj==0) tilePartial();
	if(act==0) {
	  if(obj==1) tile(0,0);
	  if(obj==2) tile(0,1);
	  if(obj==3) tile(0,2);
	}
	if(act==1) {
	  if(obj==1) orbit(0,0,true);
	  if(obj==2) orbit(0,1,true);
	  if(obj==3) orbit(0,2,true);
	}
	if(act==2) {
	  if(obj==1) orbit(0,0,false);
	  if(obj==2) orbit(0,1,false);
	  if(obj==3) orbit(0,2,false);
	}
    }


    public void runRenorm(int ban,int obj) {

	if(ban==0) { 
          if(obj==4) tile(1,1);

          if(obj==5) {
  	       double h=M.C.getOffsetY(CHOICE);
	       int L=Characteristics.getCharB(h);
	       int mode=3;
	       if(L==0) mode=2;
	       if(L==5) mode=2;
               tile(mode,2);
	  }
	}

	if(ban==1) {
          if(obj==4) orbit(1,1,false);

          if(obj==5) {
  	       double h=M.C.getOffsetY(CHOICE);
	       int L=Characteristics.getCharB(h);
	       int mode=3;
	       if(L==0) mode=2;
	       if(L==5) mode=2;
               orbit(mode,2,false);
	  }

	}

	if(ban==2) {
          if(obj==4) orbitPlus(1,1,false);

          if(obj==5) {
  	       double h=M.C.getOffsetY(CHOICE);
	       int L=Characteristics.getCharB(h);
	       int mode=3;
	       if(L==0) mode=2;
	       if(L==5) mode=2;
               orbitPlus(mode,2,false);
	  }

	}



	if(ban==3) {
            if(obj==4) bandFillA();
 	    if(obj==5) bandFillB();
	}

	if(ban==4) {
	    if(obj==4) periodFill(0);
	    if(obj==5) periodFill(1);
	}

	if(ban==5) {
	    if(obj==4) periodFill(0);
	    if(obj==5) periodFill(1);  
            if(obj==4) bandFillA();
 	    if(obj==5) bandFillB();
	}
    }


    /**Computes a partial tile: the result of doing k steps
       of the forward polyhedro exchange map**/

    public void tilePartial() {	
        int LIM=(int)(Math.pow(2,M.C.CON_P.ITER.val));
        int dir=M.C.CON_P.PARTIAL.mode;
	Polyhedron P=new Polyhedron();
	Vector V=initialVector();
	if(dir==0) P=PolyhedronExchange.orbitTilePartial(V,LIM);
	if(dir==1) P=PolyhedronExchange.orbitTilePartialInverse(V,LIM);
	recordPoly(P);
    }


    /**computes the basic tile. 
       4 choices for the mode:
         mode=0 computes the ordinary tile
         mode=1 computes the A-tiles
         mode=2 computes the B-tiles in the iso-levels
         mode=3 computes the B-tiles in the expansion-levels.
        

       3 choices for the chopping option
         q=0: no chopping
         q=1: tile chopped off at consecutive A levels.
         q=2: tile chopped off at consecutive B levels
    **/

    public void tile(int mode,int q) {
	Polyhedron P=new Polyhedron();
	Vector V=initialVector();
	double[] d=getHeights(q);
 	P=makeTile(mode,d[0],d[1]);
	recordPoly(P);
    }

    /**computes the orbit of a tile.
       Same choices as for the tile routine.*/

    public void orbit(int mode,int q,boolean select) {
	Polyhedron P=new Polyhedron();  
        Vector V=initialVector();
	double[] d=getHeights(q);
 	P=makeTile(mode,d[0],d[1]);
	if((mode<=2)&&(P!=null)) drawOrbit(P,V,select);
	if((mode==3)&&(P!=null)) drawOrbitInverse(P,V,select);
    }

    /**computes the orbit of a tile, and adds an iterate
       at the end. We use this to show the first return map
       for the renorm tiles.**/

    public void orbitPlus(int mode,int q,boolean select) {
	Polyhedron P=new Polyhedron();  
        Vector V=initialVector();
	double[] d=getHeights(q);
 	P=makeTile(mode,d[0],d[1]);
	++P.orbit;
	if((mode<=2)&&(P!=null)) drawOrbit(P,V,select);
	if((mode==3)&&(P!=null)) drawOrbitInverse(P,V,select);
    }



    /**This routine is like the orbit routine,
       except that it works with a precomputed tile.**/

    public void drawOrbit(Polyhedron P,Vector V0,boolean select) {
	Vector V=new Vector(V0);
	halt=1;
	int count=0;
	int history=-1;
	int type=0;
	int t=M.C.CON_P.ZONE.val;
	Polyhedron Q=new Polyhedron(P);
	while((halt==1)&&(count<P.orbit)) {
	    if(history==-1) type=PolyhedronExchange.classify(V);
	    if(history!=-1) type=PolyhedronExchange.classify(V,history);
	    history=type;
	    if(select==false) recordPoly(Q);
	    if((select==true)&&(type==t)) recordPoly(Q);
            V=PolyhedronExchange.doDynamicsPlus(V,type);
	    Q=P.translate(Vector.minus(V,V0));
	    ++count;
	}
    }

    /**This routine is like the previous one, except
       that it does the inverse dynamics.  It is only
       invoked for the expansion level B-tiles.**/

    public void drawOrbitInverse(Polyhedron P,Vector V0,boolean select) {
	Vector V=new Vector(V0);
	halt=1;
	int count=0;
	int type=0;
	int typeX=0;
	int t=M.C.CON_P.ZONE.val;
	Polyhedron Q=new Polyhedron(P);

	while((halt==1)&&(count<P.orbit)) {
	    typeX=PolyhedronExchange.classify(V);
	    type=PolyhedronExchange.classifyInverse(V);
	    if(select==false) recordPoly(Q);
	    if((select==true)&&(typeX==t)) {
                 recordPoly(Q);
		 for(int i=0;i<Q.count;++i) {
		     if(Q.V[i].x[1]<-.0000001) {
			 Q.print();
                           throw(new ProofException("help"));
		     }
		 }
	    }
            V=PolyhedronExchange.doDynamicsMinus(V,type);
	    Q=P.translate(Vector.minus(V,V0));
	    Q=TorusMap.fundamentalDomain(Q);
	    ++count;
	}
    }







    /**Tile making routines. The first one makes the tile
       using the vector selected on the polyhedron exchange
       window, namely the initial vector.  The second routine
       lets you specify a vector. **/

    public Polyhedron makeTile(int mode,double d0,double d1) {
	Vector V=initialVector();
	return(makeTile(mode,V,d0,d1));
    }

    public Polyhedron makeTile(int mode,Vector V,double d0,double d1) {
	int LIM=(int)(Math.pow(2,M.C.CON_P.ITER.val));
	  Polyhedron P=PolyhedronExchange.orbitTile(mode,d0,d1,V,LIM);
	  return(P);
    }


    /**renorm tile routines.**/

    public void bandFillA() {
	halt=1;	
	double h=M.C.getOffsetY(CHOICE);
	int[] L=Characteristics.getCharA(h);
	for(int b=0;b<4;++b) bandFillA(L[0],L[1],b);
    }

    public void bandFillB() {
	halt=1;	
        double h=M.C.getOffsetY(CHOICE);
	int LB=Characteristics.getCharB(h);
	for(int b=0;b<4;++b) bandFillB(LB,b);
	halt=0;
    }

    public void bandFillA(int LA,int LB,int branch) { 
	int lim=DataRenormReturn.limits(LB,branch);
	double[] d=getHeights(1);
	for(int i=0;i<lim;++i) {
	    Polyhedron Q=DataRenormReturn.getA(LA,LB,branch,i,0);
	    Vector W=Q.getCenter();
	    Polyhedron P=makeTile(1,W,d[0],d[1]);
	      if(P!=null) {
                  drawOrbit(P,W,true);
		  M.PC1.repaint();
		  M.PC2.repaint();
	      }
	}  
    }

    public void bandFillB(int LB,int branch) { 
	int lim=DataRenormReturn.limits(LB,branch);
	double[] d=getHeights(2);

	for(int i=0;i<lim;++i) {
	    Polyhedron Q=DataRenormReturn.getB(LB,branch,i,0);
	    Vector W=Q.getCenter();
	    Polyhedron P=makeTile(2,W,d[0],d[1]);
	    if(P!=null) drawOrbit(P,W,true);
	    M.PC1.repaint();
	    M.PC2.repaint();
	}
    }




    /**FILLING REGIONS WITH PERIODIC TILES**/

    /**These routines fill up the selected region with
       periodic tiles that do not enter into the renorm set.
       Certain of these periodic tiles are drawn on one dynamical
       level and not another.  The routines getBlockA() and getBlockB()
       prohibit plotting on the wrong level.**/


    public void periodFill(int q) {
	if(q==0) periodFillA();
	if(q==1) periodFillB();
    }

    public void periodFillA() {
	double h=M.C.getOffsetY(CHOICE);
	int[] L=Characteristics.getCharA(h);
	for(int i=0;i<140;++i) {
	    boolean block=DataPeriodicRaw.getBlockA(L[0],L[1],i);
	    Polyhedron P=DataPeriodic.getA(i);
	    Vector[] X=P.boundingBox();
	    Vector V=P.getCenter();
	    if(block==false) drawOrbit(P,V,true);

	}
	M.PC1.repaint();
	M.PC2.repaint();
    }


    public void periodFillB() { 
       double h=M.C.getOffsetY(CHOICE);
       int LB=Characteristics.getCharB(h);
       for(int i=0;i<48;++i) {
	  boolean block=DataPeriodicRaw.getBlockB(LB,i);
	  Polyhedron P=DataPeriodic.getB(i);
	  Vector V=P.getCenter();
	  if(block==false) drawOrbit(P,V,true);
       }

	M.PC1.repaint();
	M.PC2.repaint();
    }



    /**SUPPORTING ROUTINES.*/


    /**This routine gets the heights of the slab
       that contains the polyhedron to be plotted. 
       The choice q=1 is associated to the A-tiles.
       The choice q=2 is associated to the B-tiles.
    **/


    public double[] getHeights(int q) {
	double[] d={0,2};
	double h=M.C.getOffsetY(CHOICE);
	if(q==1) {
	    int[] L=Characteristics.getCharA(h);
	    d=Characteristics.getHeightA(L[0],L[1]);
	}
	if(q==2) {
	   int L=Characteristics.getCharB(h);
	   d[0]=Characteristics.cut(L);
	   d[1]=Characteristics.cut(L+1);
	}
	return(d);
    }


    /**Gets the vector on the polyhedron exchange window.
       The variable CHOICE tells whether we are using
       the left or the right window.*/

    public Vector initialVector() {
	Complex Z0=new Complex(M.PC1.SOURCE);
	double h=M.C.getOffsetY(CHOICE);
	if(CHOICE==2)  Z0=new Complex(M.PC2.SOURCE);
	Vector V=new Vector(Z0.x,Z0.y,h);
	return(V);
    }


    /**This records the computed polyhedra.  
       When the link variable is on, the relevant
       slice of the polyhedron is drawn in the 
       outer billiards window.**/


    public void recordPoly(Polyhedron Q) {
	if(Q!=null) {
          if(CHOICE==1) M.PC1.nextPolyLast(Q);
          if(CHOICE==2) M.PC2.nextPolyLast(Q);
	  if(M.C.LINK.L[0].on==1) {
	      Vector V=TorusMap.theta(M.T.SOURCE);
	      PolyWedge W=PolyhedronSlicer.specialSlice(Q,V);
	      if(W!=null) {
	        W=W.translate(M.T.SOURCE);
	        M.T.addPoly(W,Color.red);
	      }
	  }
	}
    }




}

