import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeGraph implements Runnable {
    int halt;
    Complex SOURCE; 
    Manager M;
    PolyWedge P;
    int TYPE;
    boolean[][] USED=new boolean[4096][4096];

public ComputeGraph() {}

    public ComputeGraph(int type,Manager MM) {
	this.M=MM;
	this.TYPE=type;
	SOURCE=M.A1.SOURCE;
    }

    public void run() {
	P=PolyWedge.penroseKite();
	int mode=M.C.CON_G.ACTION.mode;
	if(mode==0) runBasic();
	if(mode==1) runTarget();
	if(mode==2) runSeek();
	if(mode==3) chain();
	M.repaint();
    }

    public void runBasic() {
	int mode=M.C.CON_G.BASIC.mode;
	if(mode==0) doOrbit(0);
	if(mode==1) doOrbit(1);
	if(mode==2) block(); 
    }


    public void runTarget() {
	int mode=M.C.CON_G.TARGET.mode;
	if(mode==0) renormSite(0); 
	if(mode==1) renormSite(1); 
    }


    public void runSeek() {
	int mode=M.C.CON_G.SEEK.mode;
	System.out.println("mode "+mode);
	if(mode==0) linkSeek(0);
	if(mode==1) linkSeek(1);
    }

    public void recordPath(GeneralPath gp) {
	recordPath(gp,M.K.SC.C);
    }


    public void recordPath(GeneralPath gp,Color C) {
	int f=M.C.getFocus();
	if(f==1) M.A1.nextPathLast(gp);
	else {
	    int L=M.C.getOffsetZone(M.C.getOffsetY(1));
	    double t=1;
	    if(L%2==0) t=-GoldenRatio.phi(3);
 	    AffineTransform AFF=AffineTransform.getScaleInstance(t,t);
	    GeneralPath gp2=new GeneralPath(gp);
            gp2.transform(AFF);
            M.A1.nextPathLast(gp2,C);
	}
    }




     public int[] forwardReturn(int[] d,PolyWedge P) {
        int f=M.C.getFocus();
	PinwheelMap PIN=new PinwheelMap();
	Complex z=TorusMap.gridToStrip(d[0],d[1],M.C.getOffsetX(f),M.C.getOffsetY(f));
	int[] d1=PIN.piIntegral(z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	return(d1);
    }

    public int[] backwardReturn(int[] d,PolyWedge P) {	
        int f=M.C.getFocus();
        PinwheelMap PIN=new PinwheelMap();
	Complex z=TorusMap.gridToStrip(d[0],d[1],M.C.getOffsetX(f),M.C.getOffsetY(f));
	int[] d1=PIN.piInverseIntegral(z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	return(d1);
    }



    public void doCircle(int i,int j,double d) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(i-d),(float)(j-d));
	gp.lineTo((float)(i+d),(float)(j-d));
	gp.lineTo((float)(i+d),(float)(j+d));
	gp.lineTo((float)(i-d),(float)(j+d));
	gp.closePath();
	recordPath(gp);
    }



    public void doOrbit(int choice) {
	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);
	doOrbit(choice,x,y,true);
    }






    public void doOrbit(int choice,int x,int y,boolean HALT) {
	int[] d={x,y};
	int[] d2={d[0],d[1]};
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	double LIM=M.C.CON_G.INT[0].val;
	LIM=Math.pow(2,LIM);
	halt=1;
	int i=0;
	while((i<LIM)&&(halt==1)) {
	    gp2.reset();
            gp2.moveTo(d[0],d[1]);
	    USED[d[0]+2048][d[1]+2048]=true;
	    if(choice==0) d=forwardReturn(d,P);
	    if(choice==1) d=backwardReturn(d,P);
	    gp2.lineTo(d[0],d[1]);
	    recordPath(gp2);
	    gp.append(gp2,false);
	    if((d[0]==d2[0])&&(d[1]==d2[1])) halt=0;
	    ++i;
	}
	if(HALT==false) halt=1;  	
    }






     public void block() {
 	double LIM1=M.C.CON_G.INT[1].val;
 	double LIM2=M.C.CON_G.INT[2].val;
 	LIM1=Math.pow(2,LIM1);
 	LIM2=Math.pow(2,LIM2);

        GeneralPath gp=new GeneralPath();
        GeneralPath gp2=new GeneralPath();
	int i=(int)(-LIM1);
 	int j=(int)(-LIM2);
 	halt=1;
 	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);

 	while(halt==1) {
	     gp2.reset();
	     int[] d1={x+i,y+j};
	     int[] d2=forwardReturn(d1,P);
             gp2.moveTo(d1[0],d1[1]);
	     gp2.lineTo(d2[0],d2[1]);
	     if((d1[0]!=d2[0])||(d1[1]!=d2[1])) recordPath(gp2); 

	     ++j;
	     if(j>LIM2) {
	        j=(int)(-LIM2);
	       ++i; 
	     }
	     if(i>LIM1) halt=0;
	}
 	halt=0;  
    }



    /**Seeking the graph**/

    public void refreshGrid() {
	 for(int i=0;i<4096;++i) {
	     for(int j=0;j<4096;++j) {
		 USED[i][j]=false;
	     }
	 }

    }

    public int[] getLimits() {
 	double LIM1=M.C.CON_G.INT[1].val;
 	double LIM2=M.C.CON_G.INT[2].val;
 	LIM1=Math.pow(2,LIM1);
 	LIM2=Math.pow(2,LIM2);
	int[] LIM={(int)(LIM1),(int)(LIM2)};
	return(LIM);
    }

    public GeneralPath getTarget(int t) {
	 GeneralPath poly=new GeneralPath();
	 if(t==1) poly=M.PC1.getContains();
	 if(t==2) poly=M.PC2.getContains();
	 return(poly);
    }

    public Complex getProbe(int t,int i,int j) {
	Complex z=new Complex();
        if(t==1) z=TorusMap.map(i,j,M.C.getOffsetX(1),M.C.getOffsetY(1));
        if(t==2) z=TorusMap.map(i,j,M.C.getOffsetX(2),M.C.getOffsetY(2));
	return(z);
    }


    /**limit is a 4096x4096 grid about origin**/

    public void linkSeek(int k1) {
	 refreshGrid();
	 GeneralPath poly=getTarget(TYPE);

	 int[] LIM=getLimits();
	 int LIM1=LIM[0];
	 int LIM2=LIM[1];

	 int i=-LIM1;
	 int j=-LIM2;
 	 halt=1;
	 if(poly==null) halt=0;

 	while(halt==1) {
	     Complex z=getProbe(TYPE,i,j);

	     if(k1==0) {
		 if(poly.contains(z.x,z.y)==true) doCircle(i,j,.25);
	     }

	     if(k1==1) {
	        if((USED[i+2048][j+2048]==false)&&(poly.contains(z.x,z.y)==true)) 	
                doOrbit(0,i,j,false);
	     }

             ++i;
	     if(i>LIM1) {
	        i=(int)(-LIM1);
	        ++j; 
	        sendMessage(j);
	     }
	     if(j>LIM2) halt=0;
	}

    }



    /**Finds the sites that map into the renormalization zone**/

    public void renormSite(int choice) {
	double rad=.25;
	if(choice==1) rad=.5;
 	double LIM1=M.C.CON_G.INT[1].val;
 	double LIM2=M.C.CON_G.INT[2].val;
 	LIM1=Math.pow(2,LIM1);
 	LIM2=Math.pow(2,LIM2);
 	int i=(int)(-LIM1);
 	int j=(int)(-LIM2);
 	halt=1;
	double A=GoldenRatio.phi(-3);

	double h=M.C.getOffsetY(1);

 	while(halt==1) {
	    int jj=(int)(-A*i+j);
	    Complex z=TorusMap.map(i,jj,M.C.getOffsetX(1),h);
 	    boolean test=true;
	    Vector V=new Vector(z.x,z.y,h);
	    if(choice==0) test=DataRenorm.insideA(V);
	    if(choice==1) test=DataRenorm.insideB(V);
	    if(test==true)  doCircle(i,jj,rad);
            ++i;
	    if(i>LIM1) {
	        i=(int)(-LIM1);
	       ++j; 
	       sendMessage(j);
	    }
	    if(j>LIM2) halt=0;
	}

     }

    public Vector initialVector() {
	Complex Z0=new Complex(M.PC1.SOURCE);
	double h=M.C.getOffsetY(TYPE);
	if(TYPE==2)  Z0=new Complex(M.PC2.SOURCE);
	Vector V=new Vector(Z0.x,Z0.y,h);
	return(V);
    }

    public void chain() {
	Color C4=M.C.CON_G.MARKINGS.M[4].C;
	Color C5=M.C.CON_G.MARKINGS.M[5].C;
	int[] L=M.C.CON_G.B.getIndex();
	int[] list=VerifySupport.itineraryChain(0,L[0],L[1],L[2],L[3]);

	GeneralPath gp=new GeneralPath();
	int[] m={0,0};
	for(int i=0;i<list.length;++i) {
	    int[] move=DataPartition.getMove(list[i]);
	    gp.reset();
	    gp.moveTo(m[1],m[0]);
	    m[0]=m[0]+move[0];
	    m[1]=m[1]+move[1];
	    gp.lineTo(m[1],m[0]);
	    M.A1.nextPathLast(gp,C4,false);
	}

	int dir=0;
	if(L[0]%2==0) dir=1;
	list=VerifySupport.itineraryChain(1,L[0],L[1],L[2],L[3]);
	m[0]=0;
	m[1]=0;
	for(int i=0;i<list.length;++i) {
	    int[] move=DataPartition.getMove(list[i]);
            gp.reset();
	    gp.moveTo(m[1],m[0]);
	    m[0]=m[0]+move[0];
	    m[1]=m[1]+move[1];
	    gp.lineTo(m[1],m[0]); 
            gp.lineTo(m[1],m[0]);
	    if(dir==1) M.A1.nextPathLast(gp,C5,true);
	    if(dir==0) M.A1.nextPathLast(gp,C5,false);
	}
	M.A1.repaint();
    }

    public void sendMessage(int n) {
    }




}


