import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

import java.awt.geom.*;
import java.math.*;

/**This computes the tiling in the 2D dynamical plane.**/

public class ComputeOuter implements Runnable {
    int halt;
    Manager M;

    public ComputeOuter() {}

    public ComputeOuter(Manager MM) {
	this.M=MM;
    }

    public void run() {   
        int mode=M.C.CON_T.MULTI.mode;
	PolyWedge W=new PolyWedge();
	int k=M.C.CON_T.ITER.val;
	int iter=M.C.CON_T.MAP.mode+1;
	if(mode==1) runTile();
	if(mode==2) runStrip();
	if(mode==3) runRenorm();
	M.T.repaint();
    }

    public void runTile() {
	PolyWedge W=makeTile(M.T.SOURCE);   
        boolean v=M.C.CON_T.getVerify();
        TileStats.stats(M.C,W,M.T.SOURCE,1,v);
	int mode=M.C.CON_T.OUTER.mode;
	int k=M.C.CON_T.ITER.val;
	int map=M.C.CON_T.MAP.mode+1;
        if(mode==0) sendIterates(1,W,1);
	if(mode==1) sendIterates(map,W,k);
	if(mode==2) sendIterates(map,W,W.orbit);
	if(mode==3) sendStripReturn(W,k);
	if(mode==4) sendStripReturn(W,W.strip);
	if(mode==5) sendTriReturn(W,k);
    }


    public void runStrip() {
	int mode=M.C.CON_T.STRIP.mode;
	int nat=M.C.CON_T.NATURAL.mode;
	int k=M.C.CON_T.ITER.val;
	PolyWedge W=new PolyWedge();
        if(mode==0) W=makeReturnTile(M.T.SOURCE,k);
        if(mode==1) W=makeReturnTileForward(M.T.SOURCE,k);
        if(mode==2) W=makeReturnTileBackward(M.T.SOURCE,k);
	Color C=M.K.SC.C;
	if(nat==1) {
	    boolean test=comesCloser(M.T.SOURCE,k,mode);
	    if(test==false) C=M.C.CON_T.COLORS.L[2].C;
	    if(test==true)  C=M.C.CON_T.COLORS.L[3].C;
	}
        boolean v=M.C.CON_T.getVerify();
        TileStats.stats(M.C,W,M.T.SOURCE,2,false);
	M.T.addPoly(W,C);
    }

    public void runRenorm() {
	int mode=M.C.CON_T.RENORM.mode;
	if(mode==0) doRenorm(false,false);
	if(mode==1) doRenorm(true,false);
	if(mode==2) doRenormFill(false);
	if(mode==3) doRenormFill(true);
    }

    /**This is the main routine. It computes the orbit tile.**/

    public PolyWedge makeTile(Complex zz) {
       PolyWedge KITE=PolyWedge.penroseKite();
       if(KITE.inside(zz)==true) return(null);
       halt=1;
       PinwheelMap PIN=new PinwheelMap();
       Complex z=OuterBilliards.goodStart(zz);
       int sector=PIN.findSector(z);
       Complex z1=PIN.E(sector%4,z);
       double[][] d={{1,-1},{1,-1},{1,-1},{1,-1}};
       int test=0;
       int count=0;
       int orbit=0;
       int choice=0;

       while((count<10000000)&&(halt==1)&&(test==0)) {
	    choice=(sector+count)%4;
            double temp=PIN.getStripPosition(choice,z);
            orbit=orbit+(int)(Math.abs(PIN.getDepth(choice,z)));
	    z=PIN.E(choice,z);
	    if(d[choice][0]>temp) d[choice][0]=temp;
	    if(d[choice][1]<temp) d[choice][1]=temp;
            double dist=Complex.dist(z1,z);
            if((count%8==0)&&(count>1)&&(dist<.00000001)) test=1; 
            ++count;    
       }
       halt=0;
       if(count>99998) orbit=0;
       PolyWedge W=PIN.createShape(d,zz); 
       boolean v=M.C.CON_T.getVerify();
       if(v==true) W=trim(W);
       W.orbit=orbit-1;
       W.strip=count/8;
       return(W);
    }


    public PolyWedge trim(PolyWedge W) {
	double[] d={0,2};
	if(M.T.SOURCE.y<0) d[1]=-2;
	PolyWedge X=PolyWedge.merge(W,PolyWedge.strip(1000,d));
	return(X);
    }

    public void sendSingle(PolyWedge W) {
	Complex z=W.getCenter();
	int test=OuterBilliards.positiveTest(z)+OuterBilliards.negativeTest(z);
	if(test!=0) M.T.addPoly(W);
    }

    public void sendIterates(int skip,PolyWedge W,int kk) {
	int k=kk;
	if(kk>10000) k=10000;
	PolyWedge W2=new PolyWedge(W);
	for(int i=0;i<k;++i) {
	    M.T.addPoly(W2);
            for(int j=0;j<skip;++j) W2=OuterBilliards.nextPoly(W2);
	}
    }

    public void sendStripReturn(PolyWedge W,int kk) {
	PolyWedge W2=new PolyWedge(W); 
        int k=kk+1; 
	if(kk>10000) k=10000;
	Complex z=W2.getCenter();
	double test=Math.abs(z.y);
	if(test>1.9999999) k=1;
	if(test>2.0000001) k=0;
	int test2=OuterBilliards.negativeTest(z)+OuterBilliards.positiveTest(z);
	if(test2==0) k=0;
        PolyWedge P=PolyWedge.penroseKite();
	PinwheelMap PIN=new PinwheelMap();

	for(int i=0;i<k;++i) {
	    M.T.addPoly(W2);  
	    W2=PIN.pi(W2);
	}
    }



    /**RETURN TO FUNDAMENTAL TRIANGLE**/

    public void sendTriReturn(PolyWedge W,int kk) {
	PolyWedge W2=new PolyWedge(W);
	int k=kk;
	Complex w=W2.getCenter();
        boolean test=Fundamental.inTriangle(w);
	if(test==false) k=0;
	for(int i=0;i<k;++i) {
	    M.T.addPoly(W2);
            W2=returnTriangle(W2);
	}
    }

    public PolyWedge returnTriangle(PolyWedge PW) {
          PolyWedge P=PolyWedge.penroseKite();
	  PolyWedge WEDGE=new PolyWedge(PW);
	  Complex z1=WEDGE.getCenter();
	  Complex z2=returnTriangle1(z1);
	  Complex z3=Complex.minus(z2,z1);
	  for(int i=0;i<WEDGE.count;++i) WEDGE.z[i]=Complex.plus(z3,WEDGE.z[i]);
	  return(WEDGE);
    }

    public Complex returnTriangle1(Complex z) {
        halt=1;
	boolean test=false;
	int choice=0;
	int count=0;
	while((halt==1)&&(test==false)) {
	    z=OuterBilliards.nextComplex(z);
	    z=OuterBilliards.nextComplex(z); //2nd iterate deliberate
	    test=Fundamental.inTriangle(z);
	    ++count;
	}
	halt=0;
	return(z);
    }






    /**STRIP RETURN TILES**/

public static PolyWedge makeReturnTile(Complex z,int k) {
    PolyWedge W1=makeReturnTileForward(z,k);
    PolyWedge W2=makeReturnTileBackward(z,k);
    PolyWedge W=PolyWedge.merge(W1,W2);
    return(W);
    }

    public static PolyWedge makeReturnTileForward(Complex z,int k) {
	Vector V=TorusMap.theta(z);
	Polyhedron P=PolyhedronExchange.orbitTilePartial(V,k);
	PolyWedge Q=PolyhedronSlicer.specialSlice(P,V);
	Q=Q.translate(z);
	return(Q);
    }


    public static PolyWedge makeReturnTileBackward(Complex z,int k) {
	Vector V=TorusMap.theta(z.conjugate());
	Polyhedron P=PolyhedronExchange.orbitTilePartial(V,k);
	PolyWedge Q=PolyhedronSlicer.specialSlice(P,V);
 	Q=Q.translate(z.conjugate());
	for(int i=0;i<Q.count;++i) Q.z[i]=Q.z[i].conjugate();
	return(Q);
    }

    public static boolean comesCloser(Complex z0,int k,int mode) {
	PinwheelMap PIN=new PinwheelMap();
	double target=Math.abs(z0.x);
	boolean test1=false;
	boolean test2=false;

	Complex z=new Complex(z0);
	for(int i=0;i<k;++i) {
	    z=PIN.pi(z);
	    double test=Math.abs(z.x);
	    if(test<target-.001) test1=true;
	}

	z=new Complex(z0);
	for(int i=0;i<k;++i) {
	    z=PIN.piInverse(z);
	    double test=Math.abs(z.x);
	    if(test<target-.001) test2=true;
	}
	if(mode==0) {
	    if(test1==true) return(true);
	    if(test2==true) return(true);
	}

	if((mode==1)&&(test1==true)) return(true);
	if((mode==2)&&(test2==true)) return(true);
	return(false);
    }





    /*RENORMALIZATION TILES**/

    public void doRenorm(boolean orbit,boolean psi) {
	Complex z0=new Complex(M.T.SOURCE);
        Vector V=TorusMap.theta(z0);
	boolean reverse=false;
        int[] L=Characteristics.getCharA(V.x[2]);
	if(L[0]%2==0) reverse=true;

	Complex zA=StripRenorm.inside(z0,false,false,true);

	if(zA!=null) {
           Vector VA=TorusMap.theta(zA);
           Polyhedron PA=PolyhedronExchange.orbitTile(1,0,2,VA,1000);  
           PolyWedge WA=PolyhedronSlicer.specialSlice(PA,VA);
	   WA=WA.translate(z0); 
	   boolean v=M.C.CON_T.getVerify(); 
	   TileStats.stats(M.C,WA,M.T.SOURCE,3,v);
	   Vector VB=StripRenorm.mapAtoB(VA);
	   Polyhedron PB=StripRenorm.mapAtoB(PA);
	   Complex zB=StripRenorm.renorm(zA,reverse);
           PolyWedge WB=PolyhedronSlicer.specialSlice(PB,VB);
	   WB=WB.translate(zB);
	   Color CA=M.C.CON_T.COLORS.L[2].C;
	   Color CB=M.C.CON_T.COLORS.L[4].C;
           M.T.addPoly(WA,CA);
           M.T.addPoly(WB,CB);


	   if(orbit==true) {
               Complex[] LIST=StripRenorm.renormBand(zA,reverse);  
	       for(int i=0;i<LIST.length;++i) {
                 WB=PolyhedronSlicer.specialSlice(PB,VB);
		 Complex ww=LIST[i];
	         WB=WB.translate(ww); 
                 M.T.addPoly(WB,CB);
	       }
	   }


	   if(orbit==true) {
               Complex[] LIST=StripRenorm.bandListA(zA);
	       for(int i=0;i<LIST.length;++i) {
                 WA=PolyhedronSlicer.specialSlice(PA,VA);
		 Complex ww=LIST[i];
	         WA=WA.translate(ww); 
                 M.T.addPoly(WA,CA);
	       }
	   }
	}

	else doPeriodic();
    }

    public void doPeriodic() {
         Complex z=M.T.SOURCE;
         Vector V=TorusMap.theta(z);
   	 int[] L=Characteristics.getCharA(V.x[2]);
	 double[] d=Characteristics.getHeightA(L[0],L[1]);
         Polyhedron P=PolyhedronExchange.orbitTile(0,d[0],d[1],V,100000); 
	 PolyWedge W=PolyhedronSlicer.specialSlice(P,V);
	 W=W.translate(z);  
	 boolean v=M.C.CON_T.getVerify();
	 TileStats.stats(M.C,W,M.T.SOURCE,1,v);   
         Color C=M.C.CON_T.COLORS.L[3].C;
         if(W!=null) M.T.addPoly(W,C);
    }



    /**The restrict variable tells us whether or not
       we want to restrict the filling to the currently
       selected tile.**/


    public boolean goodIndex(int LA,int LB,boolean restrict) {
	if((LA==0)&&(LB==5)) return(false);
	if((LA==1)&&(LB!=5)) return(false);
	if((LA==3)&&(LB!=0)) return(false);
	if((LA==4)&&(LB==0)) return(false);
	if(restrict==false) return(true);
        PolyWedge X=M.T.TILE[M.T.INDEX];
	double min=2;
	double max=0;
	for(int i=0;i<X.count;++i) {
	    if(min>X.z[i].y) min=X.z[i].y;
	    if(max<X.z[i].y) max=X.z[i].y;
	}
        double[] d=Characteristics.getHeightA(LA,LB);
	if(d[1]<min) return(false);
	if(d[0]>max) return(false);
	return(true);
    }



    public void doRenormFill(boolean restrict) {
	System.out.println("public static int[][] cover(int k) {");
	System.out.print("int[][][] A={");
	periodFill(restrict);
	bandFillA(restrict);
	System.out.println("};return(A[k]);}");
	System.out.println("");
    }

    public void bandFillA(boolean restrict) {
	Vector V=TorusMap.theta(M.T.SOURCE);
	int t=PolyhedronExchange.classify(V);
	for(int LA=0;LA<5;++LA) {
	    for(int LB=0;LB<6;++LB) {
		for(int b=0;b<4;++b){
		    if(goodIndex(LA,LB,restrict)==true) bandFillA(LA,LB,b,t,restrict);
		}
	    }
	}
    }

    public void bandFillA(int LA,int LB,int branch,int t,boolean restrict) { 

	int max=0;
 	Vector V=TorusMap.theta(M.T.SOURCE);
	int lim=DataRenormReturn.limits(LB,branch);  
        double[] d=Characteristics.getHeightA(LA,LB);
	for(int i=0;i<lim;++i) {
	    Polyhedron Q=DataRenormReturn.getA(LA,LB,branch,i,0);
	    Vector W=Q.getCenter();
	    Polyhedron P=PolyhedronExchange.orbitTile(1,d[0],d[1],W,800);
	      if(P!=null) {
                  drawOrbit(LA,LB,P,W,t,restrict,Color.red);
	      }
	      M.C.repaint();
	}  
    }

    public void periodFill(boolean restrict) {
	for(int LA=0;LA<5;++LA) {
	    for(int LB=0;LB<6;++LB) {
		if(goodIndex(LA,LB,restrict)==true) periodFill(LA,LB,restrict);
	    }
	}
    }


    public void periodFill(int LA,int LB,boolean restrict) {
	Vector V=TorusMap.theta(M.T.SOURCE);
	int t=PolyhedronExchange.classify(V);
	for(int i=0;i<140;++i) {
	    boolean block=DataPeriodicRaw.getBlockA(LA,LB,i);
	    Polyhedron P=DataPeriodic.getA(i);
	    V=P.getCenter();
	    if(block==false) drawOrbit(LA,LB,P,V,t,restrict,Color.blue);

	}
    }


    public void drawOrbit(int LA,int LB,Polyhedron P,Vector V0,int t,boolean restrict,Color C) {
	Vector V=new Vector(V0);
	halt=1;
	int count=0;
	int history=-1;
	int type=0;
	Polyhedron Q=new Polyhedron(P);
	while((halt==1)&&(count<P.orbit)) {
	    if(history==-1) type=PolyhedronExchange.classify(V);
	    if(history!=-1) type=PolyhedronExchange.classify(V,history);
	    history=type;
	    if(type==t) recordPoly(LA,LB,Q,restrict,C);
            V=PolyhedronExchange.doDynamicsPlus(V,type);
	    Q=P.translate(Vector.minus(V,V0));
	    ++count;
	}
    }


    public void recordPoly(int LA,int LB,Polyhedron Q,boolean restrict,Color C) {
	Vector V=TorusMap.theta(M.T.SOURCE);
        double[] d=Characteristics.getHeightA(LA,LB);
	if(d!=null) {
	  PolyWedge S=PolyWedge.strip(100,d);
	  PolyWedge W=PolyhedronSlicer.specialSlice(Q,V);

	  if(goodPoly(W,false)==true) {
	      W=W.translate(M.T.SOURCE);
              W=PolyWedge.merge(W,S);
	      if(goodPoly(W,restrict)==true) {
   	          GoldenPolyWedge G=new GoldenPolyWedge(W,20,.00000001);
	          G.print2();
	          M.T.addPoly(W,C);
	          M.T.repaint();
	      }
	  }
	}
    }

    public boolean goodPoly(PolyWedge W,boolean restrict) {
       if(W==null) return(false);
       if(W.count<3) return(false);
       if(restrict==false) return(true);
       PolyWedge X=M.T.TILE[M.T.INDEX];
       GeneralPath gp=X.toGeneralPath();
       Complex z=W.getCenter();
       return(gp.contains(z.x,z.y));
   }












}









