import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ControlCanvas extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ControlPanel GLOBAL,RESET,LINK,TOGGLE;
    ListenSquare GO,HALT,CLEAR,EXPORT,ANIMATE;
    String[] MESSAGE=new String[30];
    Color[] COLOR=new Color[30];
    int COUNT;

    ControlOuter CON_T;
    ControlGraph CON_G;
    ControlPartition CON_P;
    ControlData CON_D;
    ControlChecks CON_C;
    ControlProof CON_X;
    ControlColor COL;

    double OFFSETX;

    Compute3D C3D;
    ComputeGraph CG;
    ComputeFoliation CD;
    GenerateData GD; 
    ComputeProof CP;
    ListenSquare[] FOCUS=new ListenSquare[3];
    ListenSquare AUX1=new ListenSquare();

     public ControlCanvas() {
	 addMouseListener(this);
  	 addMouseMotionListener(this);
 	 addKeyListener(this);
	 setControlPanels();
	 setControls();
	 CG=new ComputeGraph(); 
	 C3D=new Compute3D();
	 CD=new ComputeFoliation();
	 GD=new GenerateData();
	 CP=new ComputeProof();

	 CON_T=new ControlOuter(90,0);
	 CON_G=new ControlGraph(90,0);
	 CON_P=new ControlPartition(90,0);
	 CON_D=new ControlData(90,0);
	 CON_C=new ControlChecks(90,0);
	 CON_X=new ControlProof(90,0);
	 COL=new ControlColor(0,355);
     }

     public void setControls() {
	 GO=  new ListenSquare(90,440,65,25,Color.white);GO.on=1;
	 EXPORT=  new ListenSquare(90,470,65,25,Color.white);GO.on=1;
	 AUX1=  new ListenSquare(273,440,12,12,Color.white);AUX1.on=1;
	 HALT=new ListenSquare(160,440,65,25,Color.white);HALT.on=1; 
	 FOCUS[0]=new ListenSquare(160,470,125,25); FOCUS[0].on=1;	
         FOCUS[2]=new ListenSquare(255,475,25,15); FOCUS[2].on=1;
	 FOCUS[1]=new ListenSquare(165,475,25,15); FOCUS[1].on=0;

    }


    public void setControlPanels() {	 
       	 Color[] C0={new Color(200,0,0),Color.white,Color.white,Color.black,new Color(50,100,255)};
       	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,200,0)};

	 //link
	 String[] LinkString={"strip2torus","grid2torus","grid2strip","slider2strip","Y lock","links"};
	 int[] LinkState={0,0,0,0,0};
         LINK=new ControlPanel(C0,LinkString,LinkState,5);

	 //global
	 String[] GlobalString={"outer","graph","3D poly","data","checks","proofs","global"};
	 int[] GlobalState={0,0,1,0,0,0};
         GLOBAL=new ControlPanel(C0,GlobalString,GlobalState,6);
	 GLOBAL.forceMode(2);

	 //reset
	 String[] ResetString={"outer","graph","3D poly","all","reset"};
	 int[] ResetState={0,0,0,0};
          RESET=new ControlPanel(C0,ResetString,ResetState,4);

	 //toggle
	  String[] ToggleString={"1","2","color mode"};
	 int[] ToggleState={1,0};
          TOGGLE=new ControlPanel(C0,ToggleString,ToggleState,2);

    }

    public double phi(int k) {
	return(GoldenRatio.phi(k));
    }

    public int getFocus() {
	if(FOCUS[1].on==1) return(1);
	if(FOCUS[2].on==1) return(2);
	return(0);
    }

    public static int getOffsetZone(double y) {	
        double x2=GoldenRatio.phi(-2);
        double x3=GoldenRatio.phi(-3);
	if(y<x2) return(0);
	if((y>x2)&&(y<2*x2)) return(1);
	if((y>2*x2)&&(y<1+x3)) return(2);
	if((y>1+x3)&&(y<2-x2)) return(3);
	return(4);
    }

    public double getOffsetX(int k) {
	double a=OFFSETX;
	if(k==1) return(a);
	int v=getOffsetZone(getOffsetY(1));
	double b=GroupAction.mapx(v,a);
        return(b);
    }

    public double getOffsetY(int k) {
	if(k==1) return(M.C.CON_P.PARAMETER[0]);
	if(k==2) return(M.C.CON_P.PARAMETER[1]);
	return(0);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g); 
      drawControls(g); 
      if(GLOBAL.mode==0) CON_T.render(g); 
      if(GLOBAL.mode==1) CON_G.render(g); 
      if(GLOBAL.mode==2) CON_P.render(g);  
      if(GLOBAL.mode==3) CON_D.render(g);  
      if(GLOBAL.mode==4) CON_C.render(g);  
      if(GLOBAL.mode==5) CON_X.render(g);  
      COL.render(g,TOGGLE.mode); 
      g.setColor(Color.white);
      g.drawRect(0,0,getWidth()-1,getHeight()-1);
      drawMessage(g);

   }



    public void drawMessage(Graphics2D g) {

	int[] y={10,25,50,65,90,105,130,145,170,185,210,225,250,265,290,305,330,345,370,385,410,425};
	g.translate(-5,5);
        g.setFont(new Font("Helvetica",Font.PLAIN,12)); 
	for(int i=0;i<COUNT;++i) {
    	    g.setColor(COLOR[i]);
	    g.drawString(MESSAGE[i],300,y[i]); 
	}
	g.translate(5,-5);
    }






    /**This draws the background**/

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,50,50));
	g.fillRect(90,0,getWidth()-205,getHeight()-65);
	g.setColor(Color.white);
	g.drawRect(90,0,getWidth()-205,getHeight()-65);
    }



    public void drawControls(Graphics2D g) {

      GLOBAL.render(g,0,0,85);
      LINK.render(g,0,200,85);
      RESET.render(g,0,115,85);
      TOGGLE.render(g,0,300,85);
      GO.render(g,new Color(200,0,0));
      EXPORT.render(g,new Color(0,0,255));
      AUX1.infoRender(g);
      g.setFont(new Font("Helvetica",Font.PLAIN,18));
      g.setColor(Color.white);	 
      g.drawString("export",(int)(EXPORT.x+6),(int)(EXPORT.y+18));
      g.drawString("go",(int)(GO.x+6),(int)(GO.y+17));


      drawHalt(g);
      FOCUS[0].render(g,new Color(0,0,255));
      for(int i=1;i<3;++i) {
	  Color C=Color.yellow;
	  if(FOCUS[i].on==0) C=Color.black;
	  FOCUS[i].renderSmooth(g,C,Color.white);
      }
      g.setColor(Color.white);
      g.drawString("focus",200,488);
    }

    public void setFocus(Point X) {
	if(FOCUS[1].inside(X)==1) {
	    FOCUS[1].on=1;
	    FOCUS[2].on=0;
	}
	if(FOCUS[2].inside(X)==1) {
	    FOCUS[2].on=1;
	    FOCUS[1].on=0;
	}
    }

    public void drawHalt(Graphics2D g) {
	boolean test=false;
	try{
	  if(C3D.halt==1) test=true;
	  if(CG.halt==1) test=true;
	  if(CP.halt==1) test=true;
	  if(GD.halt==1) test=true;
	  if(CON_C.halt==1) test=true;
	  if(CP.halt==1) test=true;
	}
	catch(Exception e) {}
	if(test==true) {
	  HALT.render(g,new Color(0,0,255));
	  g.drawString("halt",(int)(HALT.x+5),(int)(HALT.y+HALT.h-8));
	}
      } 

    /**The computations**/

    public void doAction(Point X,int mode) {
     if(GO.inside(X)==1) { 

       if(GLOBAL.mode==1) {  
	 int choice=getFocus();
	 CG=new ComputeGraph(choice,M);
	 new Thread(CG).start();
       }

       if(GLOBAL.mode==2) {  
	   int choice=getFocus();
	 C3D=new Compute3D(choice,M);
	 new Thread(C3D).start();
       }

       if(GLOBAL.mode==3) {  
	     GD=new GenerateData(M);
	      new Thread(GD).start();
       }

       if(GLOBAL.mode==4) {  
	 CON_C.M=this.M;
	 new Thread(CON_C).start();
       }


       if(GLOBAL.mode==5) {  
	 CP=new ComputeProof(M);
	 new Thread(CP).start();
       }

     }
    }



    /**halt computations**/

       public void haltComputations() {
	  C3D.halt=0;
	  CG.halt=0;
	  GD.halt=0;
	  CP.doHalt();
	  CON_C.doHalt();
       }



    /**reset routines**/

    public void resetStuff(Point X) {
	int mode=RESET.getValue(X);
	if(mode==3) {
         M.PC1.COUNT=0; 
         M.PC2.COUNT=0; 
	 M.A1.count=0;
	 M.T.tile=0;
	}	 
        if(mode==0) {
	  M.T.tile=0;
	} 
        if(mode==1) {
	  M.A1.count=0;
	}
	if(mode==2) {
            M.PC1.COUNT=0; 
            M.PC2.COUNT=0; 
	}
     }




    /**mouse action**/

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int info1=GLOBAL.switchMode(J.X);
	LINK.toggle(J.X);
	TOGGLE.switchMode(J.X);
	doAction(J.X,J.mode);
	resetStuff(J.X);
	setFocus(J.X);
	CON_X.M=this.M;
	if(HALT.inside(J.X)==1) haltComputations();         //halt computations
	if(GLOBAL.mode==0) CON_T.process(M,e,M.K.SC.C);
	if(GLOBAL.mode==1) CON_G.process(M,e,M.K.SC.C);
	if(GLOBAL.mode==2) CON_P.process(M,e,M.K.SC.C);
	if(GLOBAL.mode==3) CON_D.process(M,e,M.K.SC.C);
	if(GLOBAL.mode==4) CON_C.process(M,e,M.K.SC.C);
	if(GLOBAL.mode==5) CON_X.process(e,M.K.SC.C);
	COL.process(e,M.K.SC.C,TOGGLE.mode);
	if(LINK.L[3].on==1) Links.slider(M);
	if(EXPORT.inside(J.X)==1) EXPORT.on=1-EXPORT.on;
	documentStuff(J.X);
	M.repaint();
    }

  public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(LINK.L[3].on==1) Links.slider(M);
	M.repaint();
  }



    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void keyTyped(KeyEvent e) {
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}




    /**DOCUMENTATION**/

    public void documentStuff(Point X) {
	DocumentControl DOC=new DocumentControl(M);
	if(GLOBAL.getInfo(X)==true) DOC.globalInfo();
	if(RESET.getInfo(X)==true) DOC.resetInfo();
	if(LINK.getInfo(X)==true) DOC.linksInfo();
	if(TOGGLE.getInfo(X)==true) DOC.colorInfo();
	if(AUX1.inside(X)==1) DOC.clusterInfo();
    }



}

