import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**This class controls the informal computational checks
   we made during the creation of the program.**/


public class ControlChecks implements Runnable {
    Manager M;
    int x,y; 
    int halt;
    ControlPanel COMPACT, ACTION, PEX; 
    SelectInteger[] INT=new SelectInteger[6];
    SanityCheck1 S1;
    SanityCheck2 S2;


    public ControlChecks(int xx,int yy) {
	x=xx;
	y=yy;
	setControls();
	S1=new SanityCheck1(M);
	S2=new SanityCheck2(M);
    }

    public void run() {
	halt=1;
	int mode=ACTION.mode;

	if(mode==0 ) {
	   S1=new SanityCheck1(M);
           new Thread(S1).start();
	}

	if(mode==1 ) {
	   S2=new SanityCheck2(M);
           new Thread(S2).start();
	}
    }

    public void doHalt() {
	S1.halt=0;
	halt=0;	 
    }


     public void setControls() {

       	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,200,0)};

         String[] CheckString={"compact","misc","check"};
         int[] CheckState={1,0};
         ACTION=new ControlPanel(C1,CheckString,CheckState,2);

         String[] CompactString={"0","1","2","3","4","5","6","7","8","9","10","11","compact"};
         int[] CompactState={1,0,0,0,0,0,0,0,0,0,0,0};
         COMPACT=new ControlPanel(C1,CompactString,CompactState,12);

         String[] PEXString={"0","1","2","3","renorm"};
         int[] PEXState={1,0,0,0};
         PEX=new ControlPanel(C1,PEXString,PEXState,4);

	 INT[0]=new SelectInteger(x+5,y+200,40,20,10,5,25,1);
	 INT[1]=new SelectInteger(x+5,y+250,40,20,2,1,10,1);
	 INT[2]=new SelectInteger(x+5,y+300,40,20,0,0,64,1);



    }

    public void render(Graphics2D g) {
	int xx=(int)(x);
	int yy=(int)(y);
        ACTION.render(g,xx,yy,100);
	if(ACTION.mode==1) PEX.render(g,xx+105,yy,80);
	if(ACTION.mode==0) { 
           COMPACT.render(g,xx+105,yy,80);
	   g.setColor(Color.white);
           g.setFont(new Font("Helvetica",Font.PLAIN,12));
	   g.drawString("# points",x+5,235+y);
	   g.drawString("point range",x+5,285+y);
	   INT[0].render2(g,Color.red,Color.white,Color.white);
	   INT[1].render2(g,Color.red,Color.white,Color.white);
	   if(COMPACT.mode==0) {
              g.drawString("which poly",x+5,335+y);
              INT[2].render(g,Color.red,Color.white,Color.white);
	   }
	}
    }

    public int getPointNumber() {
	int x=INT[0].val;
	double d=Math.pow(2,x);
	return((int)(d));
    }

    public int getPointRange() {
	int x=INT[1].val;
	double d=Math.pow(2,x);
	return((int)(d));
    }

    public void process(Manager M,MouseEvent e,Color C) {
         MouseData J=MouseData.process(e);
         ACTION.switchMode(J.X); 
	 if(ACTION.mode==1) COMPACT.switchMode(J.X); 
	 if(ACTION.mode==2) PEX.switchMode(J.X); 
	 INT[0].modify(J.X);        
	 INT[1].modify(J.X);        
	 INT[2].modifyCyclic(J.X); 
          documentStuff(M,J.X);        
    }


    /**DOCUMENTATION**/

    public void documentStuff(Manager M,Point X) {
	DocumentChecks DOC=new DocumentChecks(M);
	if(ACTION.getInfo(X)==true) DOC.dataInfo();
	if(COMPACT.getInfo(X)==true) DOC.compactInfo();
	if(PEX.getInfo(X)==true) DOC.miscInfo();
    }


}

