import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlColor {
    Lever COLOR;
    ListenSquare OUTLINE,BG;
    int x,y;
    ListenSquare[][] DISPLAY=new ListenSquare[3][3];
    ListenSquare[] PRISM=new ListenSquare[10];


    public ControlColor(int xx,int yy) {
	x=xx;
	y=yy;
	COLOR=new Lever(5+x,y+98,3,4);
	OUTLINE=new ListenSquare(5+x,y+120,45,20,null);
        OUTLINE.on=1;
	OUTLINE.C=Color.white;

	BG=new ListenSquare(55+x,y+120,20,20,null);
        BG.on=1;
	BG.C=new Color(0,80,80);

	/**this is for the color mode 1*/
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		DISPLAY[2-j][2-i]=new ListenSquare(5+x+25*i,4+y+25*j,25,25,null); 
		DISPLAY[2-j][2-i].on=1;
	    }
	}

	/**this is for the color mode 2*/
	int total=0;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<2;++j) {
		PRISM[total]=new ListenSquare(5+x+15*i,4+y+25*j,15,25,null); 
		++total;
	    }
	}


	setColors();
    }

    public void setColors() {

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		int[] m={i-1,j-1};
		Color[] C=getPresetColors(m);
		DISPLAY[i][j].C=C[0];
		OUTLINE.C=C[2];
	    }
	}

	Color[] C0={new Color(255,0,0),new Color(255,150,0),new Color(0,150,0),new Color(0,100,0),new Color(0,0,255),new Color(0,0,200),new Color(150,0,0),new Color(200,0,0),new Color(100,0,255),new Color(100,0,255)};
	for(int i=0;i<10;++i) PRISM[i].C=C0[i];
    }


    public void render(Graphics2D g,int mode) {
        COLOR.render(g,"color ",new Color(0,0,0,0));
        OUTLINE.renderSmooth(g,new Color(100,100,100),OUTLINE.C);
        BG.renderSmooth(g,BG.C,new Color(100,100,100));
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("outline",(int)(x+8),(int)(y+135));
	g.drawString("bg",(int)(x+58),(int)(y+135));

	if(mode==0) {
	  for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		DISPLAY[i][j].renderSmooth(g,DISPLAY[i][j].C,OUTLINE.C);
	    }
	  }
	}

	if(mode==1) {
	  for(int i=0;i<10;++i) {
	    PRISM[i].renderSmooth(g,PRISM[i].C,OUTLINE.C);
	  }
	}


	g.setColor(Color.white);
	g.drawRect(x,y,85,145);
    }

    public Color[] getColor(int[] move) {
	Color[] C=new Color[3];
	int[] m={move[0],-move[1]};
	C[0]=DISPLAY[m[0]+1][m[1]+1].C;
	C[1]=OUTLINE.C;
	C[2]=Color.red;
	return(C);
    }

    public Color getColor2(int p) {
	return(PRISM[p].C);
    }

    public Color[] getPresetColors(int[] move) {
	Color[] C=new Color[3];
	int c0=COLOR.val;
	C[1]=OUTLINE.C;
	if(c0==0) C[0]=getPresetColors0(move);
	if(c0==1) C[0]=getPresetColors1(move);
	if(c0==2) C[0]=getPresetColors2(move);
	if(c0==3) C[0]=getPresetColors3(move);
	if(c0==0) C[2]=Color.black;
	if(c0==1) C[2]=new Color(0,0,150);
	if(c0==2) C[2]=new Color(100,100,100);
	if(c0==3) C[2]=Color.white;
	return(C);
    }

    public static Color getPresetColors0(int[] move) {
	if((move[0]==0)&&(move[1]==0)) return(new Color(210,210,210));
	return(Color.white);
    }


    public static Color getPresetColors1(int[] move) {
	if((move[0]==0)&&(move[1]==0)) return(new Color(40,40,40));
	return(Color.black);
    }

    public static Color getPresetColors3(int[] move) {
	Color C=Color.black;
        if((move[0]==0)&&(move[1]==0)) C=Color.black;
	if((move[0]==1)&&(move[1]==0)) C=new Color(160,0,0);
	if((move[0]==-1)&&(move[1]==0)) C=new Color(255,80,0);
	if((move[0]==1)&&(move[1]==1)) C=new Color(70,120,255);
	if((move[0]==-1)&&(move[1]==-1)) C=new Color(0,0,220);
	if((move[0]==0)&&(move[1]==1)) C=new Color(0,255,255);
	if((move[0]==0)&&(move[1]==-1)) C=new Color(0,160,160);
	if((move[0]==-1)&&(move[1]==1)) C=new Color(0,255,0);
	if((move[0]==1)&&(move[1]==-1)) C=new Color(0,140,0);
	return(C);
    }


    public static Color getPresetColors2(int[] move) {
	Color C=Color.black;
        if((move[0]==0)&&(move[1]==0)) C=Color.black;
	if((move[0]==1)&&(move[1]==0)) C=new Color(255,150,0);
	if((move[0]==-1)&&(move[1]==0)) C=new Color(255,0,0);
	if((move[0]==1)&&(move[1]==1)) C=new Color(50,100,255);
	if((move[0]==-1)&&(move[1]==-1)) C=new Color(0,0,255);
	if((move[0]==0)&&(move[1]==1)) C=new Color(200,0,0);
	if((move[0]==0)&&(move[1]==-1)) C=new Color(150,0,0);
	if((move[0]==-1)&&(move[1]==1)) C=new Color(0,0,200);
	if((move[0]==1)&&(move[1]==-1)) C=new Color(0,0,150);
	return(C);
    }

    public void assignColor0(Point X,Color C) {
	for(int i=0;i<3;++i) {
	  for(int j=0;j<3;++j) {
		int[] m={i-1,j-1};
		if(DISPLAY[i][j].inside(X)==1) DISPLAY[i][j].C=C;
	  }
	}
    }


    public void assignColor1(Point X,Color C) {
	for(int i=0;i<10;++i) {
	  if(PRISM[i].inside(X)==1) PRISM[i].C=C;
	}
    }




    public void process(MouseEvent e,Color C,int mode) { 
	MouseData J=MouseData.process(e);
        COLOR.process(J.X);;
	if(COLOR.isUsed(J.X)==1) setColors();
	if(mode==0) assignColor0(J.X,C);
	if(mode==1) assignColor1(J.X,C);
        if(OUTLINE.inside(J.X)==1) OUTLINE.C=C;
        if(BG.inside(J.X)==1) BG.C=C;
    }



}