import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlGraph {
    Manager M;
    int x,y; 
    ControlPanelColor MARKINGS;
    ControlPanel ACTION,SEEK,BASIC,TARGET;
    SelectInteger[] INT=new SelectInteger[6];
    Lever LA,LB,BRANCH;
    int LIMIT;
    int CHOICE;
    ChainSelector B;
    ListenSquare AUX;
  

    public ControlGraph(int xx,int yy) {
	x=xx;
	y=yy;
	setControls();
	B=new ChainSelector(90,85);
	B.LEVEL.L[0].on=1;
	B.BRANCH.L[0].on=1;
    }

     public void setControls() {
  	Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C0={new Color(200,0,0),Color.white,Color.white,Color.black,new Color(50,90,255)};

	 //arith graph
         String[] ArithGraphString={"basic","renorm","seek","chains","graph options"};
         int[] ArithGraphState={1,0,0,0};
         ACTION=new ControlPanel(C1,ArithGraphString,ArithGraphState,4);

	 //markings
	 String[] MarkingsString={"bg","axes","grid","line","A chains","B chains","markings"};
	 Color[] MarkingsColor={Color.black,new Color(0,100,100),new Color(150,0,0,100),new Color(155,0,255),new Color(200,0,200),Color.blue};
	 int[] MarkingsState={1,1,1,1,1,1};
         MARKINGS=new ControlPanelColor(C1,MarkingsString,MarkingsState,6,MarkingsColor);
	 for(int i=0;i<6;++i) MARKINGS.L[i].on=1;

	 //seek
	 String[] SeekString={"site","graph","seek"};
	 int[] SeekState={1,0};
         SEEK=new ControlPanel(C1,SeekString,SeekState,2);

	 //basic
	 String[] BasicString={"forward","backward","block","basic"};
	 int[] BasicState={1,0,0,0};
         BASIC=new ControlPanel(C1,BasicString,BasicState,3);

	 //target
	 String[] TargetString={"to A","to B","target"};
	 int[] TargetState={1,0,0,0};
         TARGET=new ControlPanel(C1,TargetString,TargetState,2);

	 
         INT[0]=new SelectInteger(x+10,y+185,40,20,12,1,17,1);    //iterates
         INT[1]=new SelectInteger(x+10,y+230,40,20,5,1,17,1);    //block width
         INT[2]=new SelectInteger(x+10,y+260,40,20,5,1,17,1);    //block height
    }




    public void render(Graphics2D g) {
      ACTION.render(g,x,y,95);
      if(ACTION.mode==0) BASIC.render(g,x,y+85,95);
      if(ACTION.mode==1) TARGET.render(g,x,y+85,95);
      if(ACTION.mode==2) SEEK.render(g,x,y+85,95);
      if(ACTION.mode==3) B.render(g);
      MARKINGS.render(g,x+100,y,95);

      if(ACTION.mode==0) {
	  if(BASIC.mode<2) INT[0].render2(g,Color.blue,Color.white,Color.white,"iterates");
	  else {
             INT[1].render2(g,Color.blue,Color.white,Color.white,"block size");
             INT[2].render2(g,Color.blue,Color.white,Color.white,"");
	  }
      }

      if(ACTION.mode==1) {
         INT[1].render2(g,Color.blue,Color.white,Color.white,"block size");
         INT[2].render2(g,Color.blue,Color.white,Color.white,"");
      }

      if(ACTION.mode==2) {
         INT[1].render2(g,Color.blue,Color.white,Color.white,"block size");
         INT[2].render2(g,Color.blue,Color.white,Color.white,"");
      }

    }


	public void process(Manager M,MouseEvent e,Color C) {
         MouseData J=MouseData.process(e);
	 MARKINGS.process(J.X,C);
         ACTION.switchMode(J.X);     
	 B.switchMode(M,J.X);
         for(int i=0;i<3;++i) INT[i].modify(J.X); 
         if(ACTION.mode==0) BASIC.switchMode(J.X);
         if(ACTION.mode==1) TARGET.switchMode(J.X);
         if(ACTION.mode==2) SEEK.switchMode(J.X);
	 documentStuff(M,J.X);
    }


    public void documentStuff(Manager M,Point X) {
	DocumentGraph DOC=new DocumentGraph(M);
	if(MARKINGS.getInfo(X)==true) DOC.markingInfo();
	if(ACTION.getInfo(X)==true) DOC.graphInfo();
	if((ACTION.mode==0)&&(BASIC.getInfo(X)==true)) DOC.basicInfo();
	if((ACTION.mode==1)&&(TARGET.getInfo(X)==true)) DOC.renormInfo();
	if((ACTION.mode==2)&&(SEEK.getInfo(X)==true)) DOC.seekInfo();
    }

}

