import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;





public class ControlOuter {
    Manager M;
    ControlPanel MULTI,COLORS,EDIT,MAP,OUTER,STRIP,RENORM,NATURAL,FUND,FIXED,REDUCE,SPECIAL;
    ControlPanelColor MARKINGS;
    SelectInteger ITER,ZONE,VERTEX,RENORM1,RENORM2,RENORM3,RENORM1X;
    ListenSquare RESCALE,VERIFY,AUX;
    int[] SELECT=new int[3];
    int x,y;
    String[] MESSAGE=new String[20];
    int COUNT;
    GeneralPath CURRENT;

    public ControlOuter(int xx,int yy) {
	x=xx;
	y=yy;
	setPanels();
	RESCALE=new ListenSquare(x,y+415,50,20,null);RESCALE.on=1;
	VERIFY=new ListenSquare(x+50,y+415,40,20,null);VERIFY.on=0;
	AUX=new ListenSquare(x+100,y+415,12,12,null);AUX.on=1;
        ITER=new SelectInteger(x+5,y+370,40,20,1,1,30,1);    //iterates
        RENORM1=new SelectInteger(x+100,y+350,40,20,0,0,6,1); //renorm tile display
        RENORM1X=new SelectInteger(x+100,y+380,40,20,0,0,41,1); //renorm tile display
        RENORM2=new SelectInteger(x+100,y+350,40,20,0,0,48,1); //renorm tile display   
        RENORM3=new SelectInteger(x+100,y+290,30,20,0,0,11,1); //renorm tile display    
       	ZONE=new SelectInteger(x+230,y+80,40,20,130,0,263,1);
	COUNT=0;
	CURRENT=new GeneralPath();
    }


    public void setPanels() {

  Color[] C0={new Color(180,0,180),Color.white,Color.white,Color.black,Color.red};
	Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

	//markings
	String[] MarkingsString={"strip","20 box","xlines","xcursor1","xcursor2","tri","1st return","p strips","cursor","markings"};


	Color[] MarkingsColor={new Color(50,100,255),Color.white,new Color(200,0,200),new Color(255,200,0),new Color(70,120,255),Color.white,new Color(0,0,255,100),new Color(0,0,255,50),new Color(0,250,100,200),new Color(0,180,0)};
	int[] MarkingsState={1,0,0,1,0,0,1,0,1};
        MARKINGS=new ControlPanelColor(C1,MarkingsString,MarkingsState,9,MarkingsColor);


	 //object colors
	String[] ColorString={"kite","edge","A-atoms","periodic","B-atoms","colors"};
	Color[] COL={new Color(100,100,100),Color.white,new Color(50,100,255),new Color(255,0,0),new Color(255,150,0)};
	int[] ColorState={0,0,0,0,0,0,0};
         COLORS=new ControlPanel(C1,ColorString,ColorState,5,COL);


	//orbit type selector
	 String[] IterationString={"edit","outer tile","return tile","atoms","tile modes"};
	 int[] IterationState={1,0,0,0};
        MULTI=new ControlPanel(C1,IterationString,IterationState,4);

	//edit selector
	String[] EditString={"select","erase","recolor","print","edit"};
	int[] EditState={1,0,0,0};
        EDIT=new ControlPanel(C1,EditString,EditState,4);

	//map selector
	String[] MapString={"1st","2nd","map iterate"};
	int[] MapState={0,1};
        MAP=new ControlPanel(C1,MapString,MapState,2);
	MAP.forceMode(1);

	//outer selector
	String[] OuterString={"tile","portion","whole","strip portion","strip whole","tri portion","outer opts"};
	int[] OuterState={1,0,0,0,0,0};
        OUTER=new ControlPanel(C1,OuterString,OuterState,6);

	//strip tile selector
	String[] StripString={"symmetric","forward","backward","return tile opts"};
	int[] StripState={1,0,0};
        STRIP=new ControlPanel(C1,StripString,StripState,3);

	//renorm tile selector
	String[] RenormString={"atom","clain","layer fill","poly fill","renorm opts"};
	int[] RenormState={1,0,0,0};
        RENORM=new ControlPanel(C1,RenormString,RenormState,4);

	//natural color selector
	String[] NaturalString={"natural","forced","color opts"};
	int[] NaturalState={1,0};
        NATURAL=new ControlPanel(C1,NaturalString,NaturalState,2);


	//special renorm tile display
	String[] SpecialString={"none","fund.","fixed point","reduce","reduce 2","atom display"};
 	int[] SpecialState={1,0,0,0,0};
        SPECIAL=new ControlPanel(C1,SpecialString,SpecialState,5);


	 //fundamental orbit theorem colors
	String[] FundString={"A atom","tile","selector","tile type"};
	 Color[] COL_F={new Color(200,0,0),new Color(0,0,200),new Color(255,150,0)};
	 int[] FundState={1,1,1};
         FUND=new ControlPanel(C1,FundString,FundState,3,COL_F);

	 //fixed point theorem  colors
	String[] FixedString={"A atom","tile","selector","tile type"};
	 int[] FixedState={1,1,1};
         FIXED=new ControlPanel(C1,FixedString,FixedState,3,COL_F);

	 //reduce point theorem  colors
	 String[] ReduceString={"all","taut","super taut","tile type"};
	 int[] ReduceState={1,1,1};
         REDUCE=new ControlPanel(C1,ReduceString,ReduceState,3,COL_F);
    }       


    public void render(Graphics2D g) {  
       renderPanels(g);
       renormDisplayRender(g);
       renderButtons(g);
    }

    public void renderPanels(Graphics2D g) { 
       MARKINGS.render(g,x+100,y,95);  
       COLORS.render2(g,x,y,95); 
       MULTI.render2(g,x,y+100,95);
       if(MULTI.mode==0) EDIT.render(g,x,y+185,95);
       if(MULTI.mode==1) OUTER.render(g,x,y+185,95);
       if(MULTI.mode==2) STRIP.render(g,x,y+185,95);
       if(MULTI.mode==2) NATURAL.render(g,x,y+255,95);
       if(MULTI.mode==3) RENORM.render(g,x,y+185,95);
       if((MULTI.mode==1)&&(OUTER.mode<3))MAP.render(g,x,y+300,95); 
       if((MULTI.mode==1)&&(OUTER.mode%2==1)) ITER.render(g,Color.blue,Color.white,Color.white,"iterates");
       if(MULTI.mode==2) ITER.render(g,Color.blue,Color.white,Color.white,"iterates"); 
       if(MARKINGS.L[7].on==1) ZONE.render(g,new Color(200,0,200),Color.white,Color.white);
    }



    public void renormDisplayRender(Graphics2D g) {
        SPECIAL.render(g,x+100,y+160,95);  
	if(SPECIAL.mode==1) {
	   FUND.render2(g,x+100,y+260,95);
           RENORM1.render(g,Color.blue,Color.white,Color.white,"fund"); 
           RENORM1X.render(g,Color.blue,Color.white,Color.white); 
	} 

	if(SPECIAL.mode==2) {
	   FIXED.render2(g,x+100,y+260,95);
           RENORM2.render(g,Color.blue,Color.white,Color.white,"fund"); 
	}

	if(SPECIAL.mode==3) {
	   REDUCE.render2(g,x+100,y+260,95);
	}
    }





    public void renderButtons(Graphics2D g) {
       Color C=new Color(50,100,255);
       RESCALE.renderSmooth(g,C,Color.white,"rescale");  
       if(VERIFY.on==0) C=Color.black;
       VERIFY.renderSmooth(g,C,Color.white,"verify"); 
       C=new Color(50,100,255);
       AUX.infoRender(g); 
    }

    public boolean getVerify() {
	if(VERIFY.on==1) return(true);
	return(false);
    }

    public void setZonePointer(Point X) {
	ZONE.modify(X);
	if(ZONE.isModified(X)==1) {
	   GoldenPolyWedge P=DataPinwheel.returnPoly(ZONE.val);
	}
    }

    public void setRenormDisplay(Point X,Color C) {
	SPECIAL.switchMode(X);
 
	if(SPECIAL.mode==1) {
	    FUND.recolor(X,C);  
            RENORM1.modifyCyclic(X); 
	    if(RENORM1.val<4) RENORM1X.max=41;
	    if(RENORM1.val==4) RENORM1X.max=4;
	    if(RENORM1.val==5) RENORM1X.max=3;
	    if(RENORM1X.val>RENORM1X.max-1) RENORM1X.val=0;
            RENORM1X.modifyCyclic(X);          
	}

	if(SPECIAL.mode==2) {
	    FIXED.recolor(X,C);  
            RENORM2.modifyCyclic(X); 
	}

	if(SPECIAL.mode==3) {
	    REDUCE.recolor(X,C);  
	}


    }



    public void process(Manager M,MouseEvent e,Color C) {
         MouseData J=MouseData.process(e);
	 MARKINGS.process(J.X,C);
         MULTI.switchMode(J.X);  
         MAP.switchMode(J.X);  
         if(MULTI.mode==0) EDIT.switchMode(J.X);
         if(MULTI.mode==1) OUTER.switchMode(J.X);  
         if(MULTI.mode==2) STRIP.switchMode(J.X);    
         if(MULTI.mode==2) NATURAL.switchMode(J.X);    
         if(MULTI.mode==3) RENORM.switchMode(J.X); 
         ITER.modify(J.X);
	 COLORS.recolor(J.X,C);
	 setZonePointer(J.X);	 
	 setRenormDisplay(J.X,M.K.SC.C);
         if(RESCALE.inside(J.X)==1) M.T.setScales(312,160,80,80);
         if(VERIFY.inside(J.X)==1) VERIFY.on=1-VERIFY.on;
	 documentStuff(M,J.X);
    }



    /**DOCUMENTATION**/

    public void documentStuff(Manager M,Point X) {
	DocumentOuter DOC=new DocumentOuter(M);
	if(MULTI.getInfo(X)==true) DOC.tileInfo();
	if(COLORS.getInfo(X)==true) DOC.colorInfo();
	if(MARKINGS.getInfo(X)==true) DOC.markingInfo();
	if(SPECIAL.getInfo(X)==true) DOC.renormDisplayInfo();
	if(EDIT.getInfo(X)==true) DOC.editInfo();
	if(NATURAL.getInfo(X)==true) DOC.naturalInfo();
	if(RENORM.getInfo(X)==true) DOC.atomInfo();
	if(STRIP.getInfo(X)==true) DOC.returnTileInfo();
	if(MAP.getInfo(X)==true) DOC.iterInfo();
	if(OUTER.getInfo(X)==true) DOC.plotInfo();
	if(FUND.getInfo(X)==true) DOC.fundInfo();
	if(REDUCE.getInfo(X)==true) DOC.reduceInfo();
	if(AUX.inside(X)==1) DOC.auxInfo();
    }




}

