import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlPartition {
    Manager M;
    int x,y; 
    ControlPanelColor FOLIATION,SHOW;
    ControlPanel ACTION,PARTIAL,OBJECT,OUTLINE,BAND;
    SelectInteger[] FOL=new SelectInteger[4]; 
    SelectInteger ZONE,POINT,RENORM,ITER;
    double[] PARAMETER=new double[2]; 
    ListenSquare MAIN,TILE,RESET,NAVIGATE,INFO;  

    public ControlPartition(int xx,int yy) {
	x=xx;
	y=yy;
	setPanels();
	setControls();
	PARAMETER[0]=1;
	PARAMETER[1]=1;
    }




     public void setPanels() {
	Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C0={new Color(200,0,0),Color.white,Color.white,Color.black,new Color(50,90,255)};

	  //poly exchange action
         String[] PolyExchangeString={"tile","select","orbit","action"};
         int[] PolyExchangeState={0,0,1};
         ACTION=new ControlPanel(C1,PolyExchangeString,PolyExchangeState,3);
	 ACTION.forceMode(2);

	  //partial tile controls
         String[] PartialString={"forwards","backwards","partial"};
         int[] PartialState={1,0};
         PARTIAL=new ControlPanel(C1,PartialString,PartialState,2);

         //poly exchange object	 
         String[] ObjectString={"partial tile","tile","tile A","tile B","A atom","B atom","object"};
         int[] ObjectState={1,0,0,0,0,0};
         OBJECT=new ControlPanel(C1,ObjectString,ObjectState,6);

         //band routines
         String[] BandString={"tile","chain","chain+return","chain fill","period fill","total fill","chain routines"};
         int[] BandState={1,0,0,0,0,0};
         BAND=new ControlPanel(C1,BandString,BandState,6);

	 //object colors
	 String[] ColorString={"white","black","none","natural","outline"};
	 int[] ColorState={1,0,0,0};
         OUTLINE=new ControlPanel(C1,ColorString,ColorState,4);

	 //foliation
	 String[] FoliationString={"","","","","foliation"};
	 Color[] FoliationColor=new Color[8];
	 for(int i=0;i<8;++i) {
	   FoliationColor[i]=new Color(100,255,255);
	   if((i%4==2)||(i%4==3)) FoliationColor[i]=new Color(255,100,255);
	 }
	 int[] FoliationState={0,0,0,0};
         FOLIATION=new ControlPanelColor(C1,FoliationString,FoliationState,4,FoliationColor);

	 //display
  	 String[] DisplayString={"crosshairs","poly select","vtx select","map image","renorm slice","A set","A atoms","A atoms->","B set","B atoms","B atoms->","B set (2)","B atoms(2)","B atom->(2)","display"};
	 int[] DisplayState={1,0,0,0,1,0,0,0,0,0,0,0,0,0,0};
	 Color[] DisplayColor={new Color(0,180,0),Color.white,Color.orange,Color.black,Color.white,new Color(50,100,255),new Color(200,0,200),new Color(250,100,0),new Color(50,100,255),new Color(0,180,0),Color.red,new Color(50,100,255),new Color(0,180,0),Color.red,new Color(50,100,255),Color.orange};
	 SHOW=new ControlPanelColor(C1,DisplayString,DisplayState,14,DisplayColor);

     }


    public void setControls() {
	 for(int i=0;i<4;++i) FOL[i]=new SelectInteger(x+140,y+255+15*i,30,13,0,0,30,1);
         ITER=new SelectInteger(x+10,y+408,40,20,10,1,16,1);    //iterates
         ZONE=new SelectInteger(x+10,y+327,40,18,0,0,64,1);
         POINT=new SelectInteger(x+10,y+365,40,18,0,0,6,1);
         MAIN=new ListenSquare(365,0,35,499);MAIN.on=1; //parameter slider
	 TILE=new ListenSquare(x+105,y+330,70,20);TILE.on=0;
	 RESET=new ListenSquare(x+105,y+360,70,20);RESET.on=1;
	 NAVIGATE=new ListenSquare(x+105,y+390,70,20);NAVIGATE.on=0;
	 INFO=new ListenSquare(x+163,y+417,12,12);
    }




    public void render(Graphics2D g) {
      OUTLINE.render2(g,x,y,95); 
      OBJECT.render(g,x,y+85,95);
      if(OBJECT.mode==0) PARTIAL.render(g,x,y+200,95);
      if((OBJECT.mode>0)&&(OBJECT.mode<4))  ACTION.render(g,x,y+200,95);
      if(OBJECT.mode>=4) BAND.render(g,x,y+200,95);
      FOLIATION.render(g,x+100,y+235,95);
      SHOW.render(g,x+100,y,95);
      Color C=Color.black;
      if(TILE.on==1) C=new Color(50,100,255);
      TILE.renderSmooth(g,C,Color.white,"tile");
      C=Color.black;
      if(NAVIGATE.on==1) C=new Color(50,100,255);
      NAVIGATE.renderSmooth(g,C,Color.white,"navigator");
      INFO.infoRender(g);
      RESET.renderSmooth(g,new Color(50,100,255),Color.white,"rescale");
      for(int i=0;i<4;++i) FOL[i].render(g,Color.red,Color.white,Color.white);
      drawArrows(g);

    }


    public void drawArrows(Graphics2D g) { 
       g.setColor(Color.white); 
       g.setFont(new Font("Helvetica",Font.PLAIN,12));  
       ITER.render2(g,Color.blue,Color.white,Color.white,"max iterates");  
       if(SHOW.L[1].on==1)  ZONE.render(g,new Color(55,100,255),Color.white,Color.white,"region");
       if(SHOW.L[2].on==1) POINT.render(g,new Color(55,100,255),Color.white,Color.white,"vertex");
    }


    public boolean navigate() {
	if(NAVIGATE.on==1) return(true);
	return(false);
    }

    public void setZonePointer(int choice,Point X,Manager M) {
	ZONE.modifyCyclic(X);
	if(ZONE.isModified(X)==1) {
	   double y=PARAMETER[choice];
	   PolyWedge P=DataPartition.poly(ZONE.val,y);
	   POINT.val=0;
	   POINT.max=0;
	   if(P!=null) POINT.max=P.count;
	}
	if(POINT.isModified(X)==1) {
 	    if(POINT.max>0) POINT.modifyCyclic(X);
	    try{
	       PolyWedge P=DataPartition.poly(ZONE.val,PARAMETER[choice]);
	       if(choice==0) M.PC1.SOURCE=new Complex(P.z[POINT.val]);
	       if(choice==1) M.PC2.SOURCE=new Complex(P.z[POINT.val]);
	    }
	    catch(Exception e) {}
	}
    }

    public void setNavigate(Point X,Manager M) {
	if(NAVIGATE.inside(X)==1) {
	  NAVIGATE.on=1-NAVIGATE.on;
	  if(NAVIGATE.on==0) {
              M.PC1.setScales(62,500,250,250); 
              M.C.LINK.L[3].on=0;
	  }

	  if(NAVIGATE.on==1) {
            M.PC1.setScales(300,250,250,250);
	    M.C.CON_P.TILE.on=1;
	    M.C.CON_P.SHOW.L[0].on=1;
	    M.C.CON_P.SHOW.L[1].on=0;
	    M.C.CON_P.SHOW.L[2].on=0;
	    M.C.CON_P.SHOW.L[3].on=0;
	    M.C.CON_P.SHOW.L[4].on=0;
	    M.C.LINK.L[0].on=1;
	    M.C.LINK.L[3].on=1;
	    M.C.LINK.L[4].on=0;
	    Vector V=TorusMap.theta(M.T.SOURCE);
	    M.PC1.SOURCE=new Complex(V.x[0],V.x[1]);
	    M.C.CON_T.MARKINGS.L[3].on=0;
	  }
	}
    }
    public void setDisplays(Point X) {
	/*
	int o1=OBJECT.mode;
	int o2=OBJECT.getValue(X);
	int a=ACTION.getValue(X);
	int b=BAND.getValue(X);

	if(o2==4) SHOW.L[5].on=1;
	if((o2>-1)&&(o2!=4)) SHOW.L[5].on=0;
	if(o2==5) {
           SHOW.L[8].on=1;
           SHOW.L[11].on=1;
	}
	
        if((o2>-1)&&(o2!=5)) {
           SHOW.L[8].on=0;
           SHOW.L[11].on=0;
	}

	if(o1<4) {
	    if(a==1)   SHOW.L[1].on=1;
	    if(a==0)   SHOW.L[1].on=0;
	    if(a==2)   SHOW.L[1].on=0;
	}

	if(o1>=4) {   
	    if(b==0) SHOW.L[1].on=0;
	    if(b>1) SHOW.L[1].on=1;
	}
	*/
    }





    public void process(Manager M,MouseEvent e,Color C) {
         MouseData J=MouseData.process(e);
	 OUTLINE.switchMode(J.X);
         FOLIATION.process(J.X,C);
         if((OBJECT.mode>0)&&(OBJECT.mode<4)) ACTION.switchMode(J.X);
         if(OBJECT.mode>3) BAND.switchMode(J.X);
         if(OBJECT.mode==0) PARTIAL.switchMode(J.X);
         OBJECT.switchMode(J.X);
         SHOW.process(J.X,C);
	 int choice=M.C.getFocus()-1;
	 setZonePointer(choice,J.X,M);
 	 for(int i=0;i<4;++i) FOL[i].modify(J.X);
	 ITER.modify(J.X); 
	 if(TILE.inside(J.X)==1) TILE.on=1-TILE.on;
	 if(RESET.inside(J.X)==1) {
            M.PC1.setScales(62,500,250,250); 
            M.PC2.setScales(46,314,157,157);
	 }
	 setNavigate(J.X,M);
	 setDisplays(J.X);
	 documentStuff(M,J.X);
    }



    /**DOCUMENTATION**/

    public void documentStuff(Manager M,Point X) {
	Document3D DOC=new Document3D(M);
	if(FOLIATION.getInfo(X)==true) DOC.foliationInfo();
	if(SHOW.getInfo(X)==true) DOC.showInfo();
	if((OBJECT.mode==1)&&(ACTION.getInfo(X)==true)) DOC.actionInfo();
	if((OBJECT.mode==2)&&(ACTION.getInfo(X)==true)) DOC.actionInfo();
	if((OBJECT.mode==3)&&(ACTION.getInfo(X)==true)) DOC.actionInfo();
	if((OBJECT.mode==0)&&(PARTIAL.getInfo(X)==true)) DOC.partialInfo();
	if(OBJECT.getInfo(X)==true) DOC.objectInfo();
	if(OUTLINE.getInfo(X)==true) DOC.outlineInfo();
	if((OBJECT.mode>3)&&(BAND.getInfo(X)==true)) DOC.chainInfo();
	if(INFO.inside(X)==1) DOC.clusterInfo();
    }

}

