import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlProof {
    Manager M;
    int x,y; 
    ControlPanel ACTION,PINWHEEL,COMPACT,RENORM,FUND,FIXED,REDUCE1,ZONE,LAYER;
    SelectInteger[] INT=new SelectInteger[10];
    ChainSelector B;
  

    public ControlProof(int xx,int yy) {
	x=xx;
	y=yy;
	setControls();
	INT[3]=new SelectInteger(x+5,280,40,20,0,0,40,1);  //printout for reduction 1 
	INT[6]=new SelectInteger(x+100,320,40,20,0,0,40,1);  //band selector
    }

     public void setControls() {
       	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,200,0)};
       	 Color[] C2={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(255,0,0)};


         String[] ActionString={"pinwheel","compactify","fundamental","fixed point","reduction 1","reduction 2","renormalize","arithmetic","proofs"};
         int[] ActionState={1,0,0,0,0,0,0,0};
         ACTION=new ControlPanel(C1,ActionString,ActionState,8);

         String[] PinwheelString={"cover","definedness 1","definedness 2","equality","pinwheel tests"};
         int[] PinwheelState={1,0,0,0};
         PINWHEEL=new ControlPanel(C1,PinwheelString,PinwheelState,4);

         String[] CompactString={"cover","defineness","compactify tests"};
         int[] CompactState={1,0};
         COMPACT=new ControlPanel(C1,CompactString,CompactState,2);

         String[] RenormString={"validity","cover 1","cover 2","cover 3","B maximality","renorm tests"};
         int[] RenormState={1,0,0,0,0};
         RENORM=new ControlPanel(C1,RenormString,RenormState,5);

         String[] FundString={"cover","1","2","3","4","5","6","fund. test"};
         int[] FundState={1,0,0,0,0,0,0};
         FUND=new ControlPanel(C2,FundString,FundState,7);

         String[] FixedString={"cover","main","fixed point test"};
         int[] FixedState={0,0,0};
         FIXED=new ControlPanel(C2,FixedString,FixedState,2);


         String[] Reduce1String={"cover","validity 1","validity 2","validity 3", "taut", "super taut", "sup taut ren.","reduce 1"};
         int[] Reduce1State={0,0,0,0,0,0,0};
         REDUCE1=new ControlPanel(C2,Reduce1String,Reduce1State,7);

	 String[] ZoneString={"23","25","32","40","41","44","46","53","61","62","zone"};
         int[] ZoneState={0,0,0,0,0,0,0,0,0,0};
         ZONE=new ControlPanel(C2,ZoneString,ZoneState,10);

	 String[] LayerString={"0","1","2","layer"};
         int[] LayerState={0,0,0};
         LAYER=new ControlPanel(C2,LayerString,LayerState,3);

	 B=new ChainSelector(190,0);

    }

    public void render(Graphics2D g) {
        ACTION.render(g,x,y,95);
	if(ACTION.mode==0) PINWHEEL.render(g,x,y+145,95);
	if(ACTION.mode==1) COMPACT.render(g,x,y+145,95);
        if(ACTION.mode==2) FUND.render(g,x,y+145,95);
	if(ACTION.mode==3) FIXED.render(g,x,y+145,95);
	if(ACTION.mode==4) REDUCE1.render(g,x,y+145,95);
	if(ACTION.mode==5) B.render(g);

	if(ACTION.mode==6) {
             RENORM.render(g,x,y+145,95);
	     if(RENORM.mode==0) B.render(g);
	     if(RENORM.mode==3) B.render(g);
	     if(RENORM.mode==2) ZONE.render(g,x,y+245,45);
	     if(RENORM.mode==2) LAYER.render(g,x+50,y+245,45);
	}
    }

    public void process(MouseEvent e,Color C) {
         MouseData J=MouseData.process(e);
         ACTION.switchMode(J.X);         
         if(ACTION.mode==0) PINWHEEL.switchMode(J.X); 
	 if(ACTION.mode==1) COMPACT.switchMode(J.X);
	 if(ACTION.mode==6) RENORM.switchMode(J.X);
	 if(ACTION.mode==2) FUND.toggle(J.X);
	 if(ACTION.mode==3) FIXED.toggle(J.X);
	 if(ACTION.mode==4) REDUCE1.toggle(J.X);
	 if(ACTION.mode>=5) B.toggle(M,J.X);
	 if(ACTION.mode==6) ZONE.toggle(J.X);
	 if(ACTION.mode==6) LAYER.toggle(J.X);
         documentStuff(J.X);
    }


    /**DOCUMENTATION**/

    public void documentStuff(Point X) {
	DocumentProof DOC=new DocumentProof(M);
	if(ACTION.getInfo(X)==true) DOC.proofInfo();
	if((ACTION.mode==0)&&(PINWHEEL.getInfo(X)==true)) DOC.pinwheelInfo();
	if((ACTION.mode==1)&&(COMPACT.getInfo(X)==true)) DOC.compactInfo();
	if((ACTION.mode==2)&&(FUND.getInfo(X)==true)) DOC.fundamentalInfo();
	if((ACTION.mode==3)&&(FIXED.getInfo(X)==true)) DOC.fixedInfo();
	if((ACTION.mode==4)&&(REDUCE1.getInfo(X)==true)) DOC.reduce1Info();
	if((ACTION.mode==6)&&(RENORM.getInfo(X)==true)) DOC.renormInfo();
	if((ACTION.mode==6)&&(LAYER.getInfo(X)==true)) DOC.layerInfo();
	if((ACTION.mode==6)&&(ZONE.getInfo(X)==true)) DOC.zoneInfo();
    }

}


