
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class contains the polygons that arise in the proof of the
   renormalization fixed point lemma, concerning the polygon Q1,
   which is based at the point (3,0)**/

public class DataFixedPoint {

    public static PolyWedge getPoly(int i) {
	GoldenPolyWedge G=getGoldenPoly(i);
	return(G.toPolyWedge());
    }

    public static GoldenPolyWedge getGoldenPoly(int i) {
	int[][] B=DataFixedPointRaw.Q(i);
	B=Lists.reverse(B);
	GoldenPolyWedge G=new GoldenPolyWedge(B);
	return(G);
    }


    public static GoldenPolyWedge Q1() {
	int[][] A={{3,0,0,0},{-10,8,13,-8},{3,0,10,-6},{16,-8,13,-8}};
	A=Lists.reverse(A);
	GoldenPolyWedge Q=new GoldenPolyWedge(A);
	return(Q);
    }

    public static GoldenPolyWedge[] polyList() {
	GoldenPolyWedge[] LIST=new GoldenPolyWedge[47];
	int total=0;
	for(int i=0;i<47;++i) {
	    int[][] A=DataFixedPointRaw.Q(i);
	    LIST[total]=new GoldenPolyWedge(A);
	    ++total;
	}

	return(LIST);
    }

}