import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class extracts the data from the class
   DataPartitionRaw and puts it in more usable form.**/

public class DataPartition {

    /**LIST OF NORMALS**/

    public static GoldenVector getNormal(int i) {
	int[]A=DataPartitionRaw.normal(i);
	GoldenVector V=new GoldenVector(A);
	return(V);
    }
    public static Vector getNormalVector(int i) {
	int[]A=DataPartitionRaw.normal(i);
	GoldenVector V=new GoldenVector(A);
	return(V.toVector());
    }

    /**SLICING ROUTINES**/


    /**Slices P(k) by the horizontal plane H(z).
       Then applies the polyhedron exchange map.**/


    public static PolyWedge polyMoved(int q,double y) {
	PolyWedge P=poly(q,y);
	if(P==null) return(null);
   	Complex z=DataPartition.getMove3D(q);
	P=P.translate(z);
	double A=GoldenRatio.phi(-3);
	for(int i=0;i<5;++i) {	
          Complex w=P.getCenter();
	  if(w.y<2-y) P=P.translate(new Complex(0,2));
	  if(w.y>4-y) P=P.translate(new Complex(0,-2));
	  if(functional(w)<-A*(2-y)) P=P.translate(new Complex(2,0)); 
	  if(functional(w)>2-A*(2-y)) P=P.translate(new Complex(-2,0)); 
	}
	return(P);

    }

    public static double functional(Complex z) {
	double A=Math.sqrt(5)-2;
	double t=-A*z.y+z.x+A;
	return(t);
    }

    /**POLY SLICING ROUTINES**/


    public static PolyWedge poly(int k,double z) {
	return(poly(k,z,0,0,0));
    }

    public static PolyWedge poly(int k,double z,int i1,int i2,int i3) {
	Vector F0=new Vector(1,0,0);
	Vector F1=new Vector(0,1,0);
	Vector POS=new Vector(0,0,z);
	return(poly(k,F0,F1,POS,i1,i2,i3,false));
    }

    /**(Main routine) Slices P(k) by the plane  (p-POS).DIR=0.
       Then translates by (i1,i2,i3)*/

    /**Slices P(k) by the plane  (p-POS).DIR=0. */

    public static PolyWedge poly(int k,Vector F0,Vector F1,Vector POS,boolean center) {
	return(poly(k,F0,F1,POS,0,0,0,center));
    }


    /**(Main routine) Slices P(k) by the plane  (p-POS).DIR=0.
       Then translates by (i1,i2,i3)*/


    public static PolyWedge poly(int k,Vector F0,Vector F1,Vector POS,int i1,int i2,int i3,boolean center) {
	Polyhedron P=getPolyhedron(k);
	int[][] EL=DataPartitionRaw.edgeList(k);
	P=P.translate(i1,i2,i3);
	PolyWedge Q=PolyhedronSlicer.slice(EL,F0,F1,POS,P,center);
	if(Q==null) return(null);
	if(Q.count==0) return(null);
	Q=Q.trim();
	return(Q);
    }


    /**EXTRACTING THE POLYHEDRON P(k) FROM THE RAW DATA.**/

    public static Polyhedron getPolyhedron(int k) {
	int[][] A=DataPartitionRaw.P(k);
	GoldenPolyhedron IP=new GoldenPolyhedron(A);
	Polyhedron P=IP.toPolyhedron();
	return(P);
    }

    public static GoldenPolyhedron getGoldenPolyhedron(int k) {
	int[][] A=DataPartitionRaw.P(k);
	GoldenPolyhedron IP=new GoldenPolyhedron(A);
	return(IP);
    }

    /**GETS THE INTERSTITIAL VECTORS**/

    public static GoldenVector interstitial(int k) {
	if(k<25) return(new GoldenVector(DataPartitionRaw.interstitial(k)));
	GoldenVector V=new GoldenVector(DataPartitionRaw.interstitial(k-25));
	V=V.negate();
	return(V);
    }



    /**These routines give the code for the dynamics.  For instance, consider the
       polyhedron P24.  The index 24 appears in the 2nd position, after 22.  The
       pair associated to it is (1,0).  This pair is then converted to an actual
       translation vector T(1,0), and T(1,0) is the translation vector associated
       to P24.**/

    public static int[] getMove(int i) {
	int[][]A={{0,0},{1,0},{1,1},{0,1},{-1,1},{-1,0},{-1,-1},{0,-1},{1,-1}};
	int[] B={22,30,33,41,43,51,54,62};
	for(int j=0;j<8;++j) if(i<B[j]) return(A[j]);
	return(A[8]);
    }

    public static Complex getMove3D(int i) {
	int[] move=getMove(i);
	return(convert(move));
    }

    /**This is for the original polyhedron exchange**/

    public static GoldenVector getMoveGolden(int i) {
	int[] move=getMove(i);

	return(goldenConvert(move));
    }

    public static Complex convert(int[] move) {
	GoldenVector V=goldenConvert(move);
	Complex z=new Complex(V.x[0].toDouble(),V.x[1].toDouble());
	return(z);
    }

    public static GoldenVector goldenConvert(int[] move) {
	GoldenReal x=new GoldenReal(-2*move[0]+10*move[1],2*move[0]-6*move[1]);
	GoldenReal y=new GoldenReal(-2*move[1],2*move[1]);
	GoldenVector V=new GoldenVector(x,y,new GoldenReal(0,0));
	return(V);
    }
}



