import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**this class has a number of precomputed data associated to the polyhedra
   in the polyhedron exchange map.

   1.  the list of vertices P0,...,P63
   2.  the lists of edges Ek for the polyhedron Pk
   3.  the list of prism groupings
   4.  the lists of outward normals to the union of faces.
   5.  the polyhedron-by=polyhedron list of outward normals
   6.  the sequence succession rule for the symbolic dynamics

**/ 

public class DataPartitionRaw {

    /**The list of vertices.  Here P(q) is the qth polyhedron.  The number {a1,a2,a3,a4,a5,a6} represents
       the GoldenVector (a0+a1 phi,a2+a3 phi,a4+a5 phi).**/


    public static int[][] P(int q) {
	int[][][]A={{{3,-1,0,1,2,-1},{-3,3,2,0,2,-1},{0,1,2,0,2,0},{1,0,1,0,2,0},{3,-1,0,0,2,0},{0,1,0,0,2,0},{-3,3,2,-1,2,0},{-1,2,2,0,2,0},{0,1,2,0,0,0}},{{-1,1,2,0,2,-1},{5,-3,0,1,2,-1},{2,-1,0,0,2,0},{1,0,1,0,2,0},{-1,1,2,0,2,0},{2,-1,2,0,2,0},{5,-3,0,1,2,0},{3,-2,0,0,2,0},{2,-1,2,0,0,0}},{{3,-1,0,0,0,1},{-3,3,2,-1,0,1},{0,1,0,0,2,0},{0,1,2,0,0,0},{1,0,1,0,0,0},{3,-1,0,0,0,0},{0,1,0,0,0,0},{-3,3,2,-1,0,0},{-1,2,2,0,0,0}},{{-1,1,2,-1,0,1},{5,-3,0,0,0,1},{2,-1,0,0,2,0},{2,-1,0,0,0,0},{1,0,1,0,0,0},{-1,1,2,0,0,0},{2,-1,2,0,0,0},{5,-3,0,1,0,0},{3,-2,0,0,0,0}},{{1,0,0,0,1,0},{6,-3,-1,1,0,0},{1,0,0,0,0,0},{2,-1,0,0,0,0},{1,0,1,0,0,0}},{{1,0,2,0,1,0},{-4,3,3,-1,2,0},{1,0,2,0,2,0},{0,1,2,0,2,0},{1,0,1,0,2,0}},{{1,0,1,0,1,0},{-4,3,3,-1,0,0},{1,0,2,0,0,0},{0,1,2,0,0,0},{1,0,1,0,0,0}},{{1,0,1,0,1,0},{6,-3,-1,1,2,0},{1,0,0,0,2,0},{2,-1,0,0,2,0},{1,0,1,0,2,0}},{{6,-3,2,0,-1,1},{-4,3,3,-1,-1,1},{1,0,1,0,1,0},{1,0,2,0,1,0},{6,-3,-2,2,3,-1},{-4,3,3,-1,3,-1},{1,0,1,0,2,0},{1,0,2,0,0,0}},{{-4,3,4,-2,-1,1},{6,-3,-1,1,-1,1},{1,0,0,0,1,0},{1,0,1,0,1,0},{6,-3,-1,1,3,-1},{-4,3,0,0,3,-1},{1,0,0,0,2,0},{1,0,1,0,0,0}},{{6,-3,0,0,-1,1},{1,0,0,0,0,0},{6,-3,0,0,0,0},{11,-6,-3,2,0,0},{6,-3,-1,1,0,0}},{{-4,3,3,-1,-1,1},{1,0,2,0,0,0},{-4,3,2,0,0,0},{-9,6,5,-2,0,0},{-4,3,3,-1,0,0}},{{11,-6,0,0,-3,2},{6,-3,0,0,0,0},{11,-6,-3,2,0,0},{3,-1,0,0,0,0}},{{-9,6,5,-2,-3,2},{-4,3,2,0,0,0},{-9,6,5,-2,0,0},{-1,1,2,0,0,0}},{{5,-2,0,0,-3,2},{0,1,0,0,0,0},{-3,3,2,-1,0,0},{5,-2,0,0,0,0}},{{-3,2,5,-2,-3,2},{2,-1,2,0,0,0},{5,-3,0,1,0,0},{-3,2,2,0,0,0}},{{1,0,0,0,2,0},{6,-3,0,0,2,0},{11,-6,-3,2,2,0},{6,-3,-1,1,2,0},{6,-3,-1,1,3,-1}},{{1,0,2,0,2,0},{-4,3,2,0,2,0},{-9,6,5,-2,2,0},{-4,3,3,-1,2,0},{-4,3,2,0,3,-1}},{{6,-3,0,0,2,0},{11,-6,-3,2,2,0},{3,-1,0,0,2,0},{11,-6,-3,2,5,-2}},{{-4,3,2,0,2,0},{-9,6,5,-2,2,0},{-1,1,2,0,2,0},{-9,6,2,0,5,-2}},{{0,1,0,0,2,0},{-3,3,2,-1,2,0},{5,-2,0,0,2,0},{5,-2,-3,2,5,-2}},{{2,-1,2,0,2,0},{5,-3,0,1,2,0},{-3,2,2,0,2,0},{-3,2,2,0,5,-2}},{{-4,3,3,-1,-1,1},{1,0,1,0,1,0},{1,0,2,0,0,0},{-4,3,3,-1,0,0}},{{5,-3,0,1,2,-1},{3,-2,0,0,1,0},{3,-2,0,0,2,0},{2,-1,0,0,2,0},{2,-1,2,0,0,0},{5,-3,0,1,0,0}},{{3,-1,0,1,2,-1},{-5,4,0,0,5,-2},{3,-1,0,0,2,0},{0,1,0,0,2,0},{-5,4,5,-2,0,0},{0,1,2,0,0,0}},{{-1,1,0,0,2,-1},{1,0,1,0,1,0},{1,0,0,0,2,0},{2,-1,0,0,2,0},{2,-1,0,0,0,0},{-1,1,2,-1,0,0}},{{3,-1,0,0,2,-1},{11,-6,-3,2,5,-2},{3,-1,0,0,2,0},{6,-3,0,0,2,0},{11,-6,-3,2,0,0},{6,-3,0,0,0,0}},{{8,-5,0,0,-1,1},{3,-2,0,0,1,0},{3,-2,0,0,0,0},{8,-5,-1,1,0,0}},{{5,-2,-3,2,5,-2},{5,-2,0,0,2,0},{0,1,0,0,2,0},{0,1,0,0,3,-1}},{{1,0,0,0,5,-2},{1,0,0,0,2,0},{6,-3,0,0,2,0},{6,-3,-1,1,3,-1}},{{-9,6,7,-4,-3,2},{-1,1,0,0,2,-1},{-4,3,0,0,4,-2},{-9,6,0,0,4,-2},{-1,1,2,-1,0,0},{-4,3,4,-2,0,0}},{{5,-2,0,0,-3,2},{-3,3,2,-1,2,-1},{0,1,0,0,4,-2},{5,-2,0,0,4,-2},{-3,3,2,-1,0,0},{0,1,0,0,0,0}},{{-7,5,6,-3,0,1},{3,-1,0,0,0,1},{1,0,1,0,5,-2},{-5,4,0,0,5,-2},{-7,5,4,-2,2,0},{3,-1,0,0,2,0},{1,0,1,0,0,0},{-5,4,5,-2,0,0}},{{1,0,1,0,5,-2},{1,0,1,0,2,0},{-7,5,4,-2,2,0},{-7,5,6,-3,0,1}},{{-9,6,7,-4,-3,2},{-4,3,4,-2,-1,1},{-4,3,0,0,4,-2},{-9,6,0,0,4,-2},{1,0,0,0,1,0},{-4,3,0,0,3,-1},{1,0,1,0,0,0},{-4,3,4,-2,0,0}},{{5,-2,0,0,4,-2},{0,1,0,0,4,-2},{0,1,0,0,3,-1},{-3,3,2,-1,2,0},{5,-2,0,0,2,0},{-3,3,2,-1,2,-1}},{{-9,6,2,0,5,-2},{-9,6,5,-2,2,0},{-1,1,2,0,2,0},{-1,1,2,0,0,1}},{{1,0,2,0,-3,2},{-4,3,3,-1,-1,1},{-4,3,2,0,4,-2},{1,0,2,0,4,-2},{-9,6,5,-2,1,0},{-4,3,3,-1,3,-1},{-9,6,5,-2,0,0},{-4,3,2,0,0,0}},{{-4,3,2,0,3,-1},{-9,6,5,-2,2,0},{-4,3,3,-1,2,0},{-9,6,5,-2,1,0}},{{-4,3,3,-1,3,-1},{-4,3,3,-1,2,0},{1,0,1,0,2,0},{1,0,2,0,1,0}},{{-11,8,2,0,4,-2},{-6,5,2,0,4,-2},{-6,5,3,-1,3,-1},{-3,3,2,-1,2,0},{-11,8,4,-2,2,0},{-3,3,2,0,2,-1}},{{-1,2,2,0,1,0},{-6,5,2,0,3,-1},{-6,5,3,-1,3,-1},{-11,8,4,-2,2,0},{-6,5,3,-1,2,0},{-11,8,2,0,4,-2},{-6,5,2,0,4,-2}},{{-9,6,5,-2,1,0},{-4,3,3,-1,3,-1},{-4,3,2,0,3,-1},{1,0,2,0,2,0},{-4,3,3,-1,2,0},{1,0,2,0,4,-2},{-4,3,2,0,4,-2}},{{6,-3,-1,1,3,-1},{1,0,0,0,2,0},{6,-3,-1,1,2,0},{1,0,1,0,1,0}},{{-1,2,2,0,1,0},{-3,3,2,-1,0,1},{0,1,0,0,2,0},{-3,3,2,-1,2,0},{-1,2,2,0,0,0},{0,1,2,0,0,0}},{{7,-4,2,0,-3,2},{-1,1,2,-1,0,1},{7,-4,-3,2,2,0},{2,-1,0,0,2,0},{-1,1,2,0,0,0},{2,-1,2,0,0,0}},{{1,0,1,0,1,0},{3,-1,2,0,0,1},{0,1,2,0,2,0},{3,-1,0,1,2,0},{1,0,2,0,0,0},{0,1,2,0,0,0}},{{-9,6,5,-2,-3,2},{-1,1,2,0,0,1},{-9,6,5,-2,2,0},{-4,3,2,0,2,0},{-1,1,2,0,0,0},{-4,3,2,0,0,0}},{{-6,5,2,0,3,-1},{-1,2,2,0,2,0},{-6,5,3,-1,2,0},{-1,2,2,0,1,0}},{{-3,2,5,-2,-3,2},{2,-1,2,0,-1,1},{-3,2,2,0,0,0},{2,-1,2,0,0,0}},{{1,0,2,0,-3,2},{-4,3,3,-1,-1,1},{1,0,2,0,0,0},{-4,3,2,0,0,0}},{{3,-1,2,0,0,1},{11,-6,-5,4,5,-2},{3,-1,0,1,2,0},{6,-3,-2,2,2,0},{6,-3,2,0,-2,2},{11,-6,2,0,-2,2}},{{5,-3,0,1,0,1},{-3,2,2,0,5,-2},{5,-3,0,1,2,0},{2,-1,2,0,2,0},{2,-1,2,0,-2,2},{-3,2,2,0,-2,2}},{{1,0,1,0,-3,2},{7,-4,2,0,-3,2},{9,-5,-4,3,2,-1},{-1,1,2,0,2,-1},{1,0,1,0,2,0},{7,-4,-3,2,2,0},{9,-5,-2,2,0,0},{-1,1,2,0,0,0}},{{1,0,1,0,-3,2},{9,-5,-4,3,2,-1},{1,0,1,0,0,0},{9,-5,-2,2,0,0}},{{1,0,2,0,1,0},{6,-3,2,0,-2,2},{11,-6,2,0,-2,2},{6,-3,-2,2,3,-1},{11,-6,-5,4,5,-2},{1,0,1,0,2,0},{6,-3,-2,2,2,0},{6,-3,2,0,-1,1}},{{2,-1,2,0,-1,1},{2,-1,2,0,-2,2},{-3,2,2,0,-2,2},{5,-3,0,1,0,1},{5,-3,0,1,0,0},{-3,2,2,0,0,0}},{{11,-6,0,0,-3,2},{3,-1,0,0,2,-1},{11,-6,-3,2,0,0},{3,-1,0,0,0,0}},{{11,-6,-3,2,1,0},{6,-3,0,0,-2,2},{1,0,0,0,-2,2},{6,-3,-1,1,3,-1},{1,0,0,0,5,-2},{11,-6,-3,2,2,0},{6,-3,0,0,2,0},{6,-3,-1,1,-1,1}},{{6,-3,0,0,-1,1},{11,-6,-3,2,1,0},{11,-6,-3,2,0,0},{6,-3,-1,1,0,0}},{{6,-3,-1,1,-1,1},{1,0,0,0,1,0},{6,-3,-1,1,0,0},{1,0,1,0,0,0}},{{8,-5,-1,1,-1,1},{8,-5,0,0,-2,2},{13,-8,0,0,-2,2},{5,-3,0,0,0,1},{5,-3,0,1,0,0},{13,-8,-2,2,0,0}},{{8,-5,0,0,-1,1},{8,-5,-1,1,-1,1},{3,-2,0,0,1,0},{13,-8,0,0,-2,2},{8,-5,0,0,-2,2},{13,-8,-2,2,0,0},{8,-5,-1,1,0,0}},{{6,-3,-1,1,-1,1},{6,-3,0,0,-1,1},{11,-6,-3,2,1,0},{1,0,0,0,-2,2},{6,-3,0,0,-2,2},{1,0,0,0,0,0},{6,-3,-1,1,0,0}}};return(A[q]);}




    /**the list of edges**/

    public static int[][] edgeList(int q) {
	int[][][] A={{{0,3},{0,4},{0,8},{1,6},{1,7},{1,8},{2,3},{2,7},{2,8},{3,4},{4,5},{5,6},{5,8},{6,7}},{{0,3},{0,4},{0,8},{1,6},{1,7},{1,8},{2,3},{2,7},{2,8},{3,4},{4,5},{5,6},{5,8},{6,7}},{{0,2},{0,4},{0,5},{1,2},{1,7},{1,8},{2,3},{2,6},{3,4},{3,8},{4,5},{5,6},{6,7},{7,8}},{{0,2},{0,4},{0,5},{1,2},{1,7},{1,8},{2,3},{2,6},{3,4},{3,8},{4,5},{5,6},{6,7},{7,8}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,3},{0,4},{0,7},{1,2},{1,5},{1,7},{2,4},{2,6},{2,7},{3,5},{3,6},{3,7},{4,6},{5,6}},{{0,3},{0,5},{0,7},{1,2},{1,4},{1,7},{2,5},{2,6},{2,7},{3,4},{3,6},{3,7},{4,6},{5,6}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,1},{0,2},{0,3},{0,4},{1,2},{1,4},{2,3},{3,4}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,3},{0,4},{1,2},{1,4},{2,3},{2,4},{3,4}},{{0,1},{0,3},{0,4},{1,2},{1,4},{2,3},{2,4},{3,4}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,5},{2,3},{3,4},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{3,5},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,5},{2,3},{3,4},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{3,5},{4,5}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,3},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{2,5},{4,5}},{{0,3},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{2,5},{4,5}},{{0,2},{0,4},{0,7},{1,3},{1,5},{1,6},{2,4},{2,6},{3,5},{3,7},{4,5},{6,7}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,3},{0,7},{1,5},{1,6},{2,3},{2,4},{2,7},{3,5},{4,5},{4,6},{6,7}},{{0,1},{0,4},{0,5},{1,2},{1,5},{2,3},{2,4},{3,4},{3,5}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,3},{0,7},{1,5},{1,6},{2,3},{2,4},{2,7},{3,5},{4,5},{4,6},{6,7}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,4},{0,5},{1,2},{1,5},{2,3},{2,4},{3,4},{3,5}},{{0,1},{0,2},{0,4},{0,6},{1,4},{1,5},{2,3},{2,6},{3,4},{3,5},{5,6}},{{0,1},{0,2},{0,4},{0,6},{1,4},{1,5},{2,3},{2,6},{3,4},{3,5},{5,6}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,3},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{2,5},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{3,5},{4,5}},{{0,3},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{2,5},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,4},{2,3},{3,5},{4,5}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,5},{2,3},{3,4},{4,5}},{{0,2},{0,4},{0,5},{1,2},{1,3},{1,5},{2,3},{3,4},{4,5}},{{0,2},{0,4},{0,6},{1,3},{1,5},{1,7},{2,5},{2,6},{3,4},{3,7},{4,5},{6,7}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,5},{0,7},{1,2},{1,6},{2,4},{2,7},{3,4},{3,5},{3,7},{4,6},{5,6}},{{0,1},{0,4},{0,5},{1,2},{1,3},{2,3},{2,5},{3,4},{4,5}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,5},{0,7},{1,2},{1,6},{2,4},{2,7},{3,4},{3,5},{3,7},{4,6},{5,6}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,2},{0,3},{1,2},{1,3},{2,3}},{{0,1},{0,4},{0,5},{1,2},{1,3},{2,3},{2,5},{3,4},{4,5}},{{0,2},{0,3},{0,6},{1,2},{1,4},{1,5},{2,4},{2,6},{3,4},{3,5},{5,6}},{{0,2},{0,3},{0,6},{1,2},{1,4},{1,5},{2,4},{2,6},{3,4},{3,5},{5,6}}};return(A[q]);}




    /**It turns out that there are 18 different outward normal directions to the faces of our polyhedra.
       Here is the list of them.   We have not listed unit normals, but only GoldenVectors that are
       perpendicular to the faces.**/


    public static int[] normal(int k) {
	int[][] A={{0,0,0,0,1,0},{1,1,1,-1,1,-1},{1,0,1,-1,1,-1},{0,0,1,0,0,0},{0,0,-1,0,-1,0},{0,-1,1,-1,1,-1},{0,-1,1,0,0,0},{-1,-1,-1,1,0,0},{0,1,-1,1,0,0},{0,0,0,0,-1,0},{1,1,1,-1,0,0},{1,0,1,-1,0,0},{0,0,1,0,1,0},{0,-1,1,-1,0,0},{0,0,-1,0,0,0},{-1,0,-1,1,-1,1},{-1,-1,-1,1,-1,1},{0,1,-1,1,-1,1}};
	return(A[k]);
    }


    /**The 18 normal planes, when moved so as to contain the origin, divide space into 50 regions.
       The following list of 25 vectors, when combined with the negatives of the vectors, gives one
       vector per region.**/


    public static int[] interstitial(int k) {
	int[][] A={{1,0,-1,1,1,0},{-8,5,-1,1,1,0},{-24,15,-1,1,1,0},{-13,8,-1,1,1,0},{16,-10,-1,1,1,0},{-1,0,-1,1,1,0},{-8,5,9,-5,1,0},{5,-3,2,-1,1,0},{8,-5,-8,5,1,0},{-3,2,-8,5,1,0},{-5,3,8,-5,1,0},{-1,0,-1,0,1,0},{14,-9,-1,0,1,0},{-2,1,-1,0,1,0},{-5,3,-1,0,1,0},{5,-3,-1,0,1,0},{-1,1,-1,0,1,0},{1,0,-1,0,1,0},{1,0,-2,2,1,0},{1,0,2,0,1,0},{2,-1,2,0,1,0},{5,-3,2,0,1,0},{1,-1,2,0,1,0},{-5,3,2,0,1,0},{-1,0,2,0,1,0}};return(A[k]);}



    /**polyhedron by polyhedron list of outward normals.  There are a
       total of 18 possible normal vectors, and here we list the indices.
       For instance, polyhedron P1 has normals n0,...,n6.**/

    public static int[] polyNormal(int q) {
	int[][] A={{0,1,2,3,4,5,6},{0,7,6,4,3,8,2},{9,10,11,12,13,14,15},{9,16,15,14,17,12,11},{9,15,14,17,10},{0,2,3,5,7},{9,11,12,13,16},{0,6,4,8,1},{15,11,7,4,13,3,17,1},{12,14,8,2,10,6,16,5},{9,17,11,16,14},{9,13,15,10,12},{9,17,14,15},{9,13,12,11},{9,10,14,15},{9,16,12,11},{8,2,7,4,0},{5,6,1,3,0},{8,4,6,0},{5,3,2,0},{1,4,6,0},{7,3,2,0},{1,7,13,12},{2,14,6,12,7},{2,14,6,12,5},{6,12,2,14,1},{6,12,2,14,8},{7,1,17,14},{14,6,1,12},{12,2,7,14},{2,14,6,12,16},{6,12,2,14,10},{2,14,13,17,6,12},{17,4,6,13},{2,14,17,4,6,16},{16,6,10,4,14},{13,3,2,17},{6,12,13,3,2,10},{13,1,6,17},{17,2,7,13},{10,2,16,3,12},{4,16,2,10,3,17},{3,10,6,16,4,13},{16,8,4,10},{4,11,3,15,10},{4,11,3,15,17},{3,15,4,11,16},{3,15,4,11,13},{10,5,3,16},{3,4,11,16},{4,3,15,10},{4,11,3,15,1},{3,15,4,11,7},{3,15,5,8,4,11},{5,8,12,11},{11,1,12,5,15,3},{7,12,1,11,3},{8,5,14,15},{15,7,14,8,11,4},{8,5,16,11},{5,8,15,10},{1,14,7,15,4},{12,7,15,1,5,14},{14,1,11,7,8,12}};return(A[q]);}

   /**lists a single vertex index per face of the given polyhedron.**/

    public static int[] faceAnchor(int q) {
	int[][] A={{2,1,1,1,0,0,0},{2,1,1,1,0,0,0},{3,1,1,1,0,0,0},{3,1,1,1,0,0,0},{1,0,0,0,0},{1,0,0,0,0},{1,0,0,0,0},{1,0,0,0,0},{3,2,1,1,1,0,0,0},{3,2,1,1,1,0,0,0},{1,0,0,0,0},{1,0,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{2,1,0,0,0},{2,1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,1,0,0,0},{1,0,0,0},{2,2,1,0,0,0},{2,1,0,0,0},{1,0,0,0},{2,2,1,0,0,0},{1,0,0,0},{1,0,0,0},{2,1,0,0,0},{2,1,0,0,0,0},{2,1,0,0,0,0},{1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,0,0,0},{1,0,0,0},{1,0,0,0},{1,1,0,0,0},{1,1,0,0,0},{1,1,1,0,0,0},{1,0,0,0},{3,2,1,0,0,0},{2,1,0,0,0},{1,0,0,0},{3,2,1,0,0,0},{1,0,0,0},{1,0,0,0},{2,1,0,0,0},{1,1,1,0,0,0},{1,1,1,0,0,0}};return(A[q]);}


    /**list of prism groupings. The numbers refer to various P's*/

    public static int[] prism(int k) {int[][] A={{15,21,49,52,56},{14,20,28,31,35},{0,2,24,32,33,40,41,44,48},{4,7,9,25,30,34,43,60},{11,17,37,38,42,50},{10,16,29,58,59,63},{5,6,8,22,39,51,46,55},{12,18,26,57},{13,19,36,47}};
	return(A[k]);}


    /**Gets the prism number**/

    public static int getPrism(int i) {
    int[] A={3,2,3,2,4,5,5,4,5,4,6,7,8,9,1,0,6,7,8,9,1,0,5,2,3,4,8,2,1,6,4,1,3,3,4,1,9,7,7,5,3,3,7,4,3,2,5,9,3,0,7,5,0,2,2,5,0,8,6,6,4,2,2,6};
    return(A[i]);}

    /**This routine picks out the possible continuations of the 
       symbolic sequence.  For instance, the 22th entry is {61,23,56}.  This means
       that only the transitions 22-->61  22-->23  22-->56 in the symbolic
       dynamics are allowed**/

    public static int[] successor(int q) {
	int[][] A={{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{61,23,56},{63,58,29,32,26,24},{25,53,37},{31,35,28,27,23,62,61},{25},{63},{25},{23},{23},{32},{25,30,47,36,34,37,42,38,39},{32},{46,26,32},{44,40,41,48},{39},{32},{32,33},{32},{48,23},{43,32,46},{44,40,41},{35,44,40},{45,53,47,37,50,42},{58,32,46},{44,40,41,48,56,52,49},{46},{42},{46},{44},{44},{53},{55,63,60,46,59,58,51,26,57},{53},{47,25,53},{27,62,23,61},{60},{53},{53,54},{53},{44,27},{53,22,25},{62,61,23}};return(A[q]);}


    /**the list of heights of the vertices*/

    public static GoldenReal[] getHeight() {
	GoldenReal[] r=new GoldenReal[11];
	for(int i=0;i<11;++i) r[i]=getHeight(i);
	return(r);
    }

    public static GoldenReal getHeight(int k) {
	int[][] A={{0,0},{-3,2},{2,-1},{-1,1},{4,-2},{1,0},{-2,2},{3,-1},{0,1},{5,-2},{2,0}};
	GoldenReal r=new GoldenReal(A[k][0],A[k][1]);
	return(r);
    }

}
