
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DataReduction {


    /**the big polygons**/

    public static PolyWedge getBig(int i) {
	GoldenPolyWedge G=getGoldenBig(i);
	return(G.toPolyWedge());
    }

    public static GoldenPolyWedge getGoldenBig(int i) {
	int[][] B=DataReductionRaw.big(i);
	GoldenPolyWedge G=new GoldenPolyWedge(B);
	return(G);
    }


    /**The renorm tiles that partition the big tiles.**/

    public static GoldenPolyWedge[] polyList(int k) {
	int lim=limit(k);
	GoldenPolyWedge[] LIST=new GoldenPolyWedge[lim];
	for(int i=0;i<lim;++i) LIST[i]=getGoldenPoly(k,i);
	return(LIST);
    }

    public static PolyWedge getPoly(int k,int i) {
	GoldenPolyWedge G=getGoldenPoly(k,i);
	return(G.toPolyWedge());
    }

    public static GoldenPolyWedge getGoldenPoly(int k,int i) {
	int[][] B=DataReductionRaw.cover(k,i);	
	if(k>0) B=Lists.reverse(B);
	GoldenPolyWedge G=new GoldenPolyWedge(B);
	return(G);
    }

    public static int limit(int k) {
	int[] A={183,20,6,13,1,4,26,17,57,57,39,56,61,43,2,20,2,132,1,54,49,2,1};
	return(A[k]);
    }



    public static GoldenPolyWedge getSuperTaut(int i) {
	int[][] MIN=DataReductionRaw.superTaut();
        return(getGoldenPoly(MIN[i][0],MIN[i][1]));
    }




    /**The 2nd renorm tiles that partition the big tiles.**/

    public static GoldenPolyWedge[] polyListRenorm(int k) {
	int lim=limitRenorm(k);
	GoldenPolyWedge[] LIST=new GoldenPolyWedge[lim];
	for(int i=0;i<lim;++i) LIST[i]=getGoldenPolyRenorm(k,i);
	return(LIST);
    }

    public static PolyWedge getPolyRenorm(int k,int i) {
	GoldenPolyWedge G=getGoldenPolyRenorm(k,i);
	return(G.toPolyWedge());
    }

    public static GoldenPolyWedge getGoldenPolyRenorm(int k,int i) {
	int[][] B=DataReductionRaw.renormA(k,i);
	B=Lists.reverse(B);
	GoldenPolyWedge G=new GoldenPolyWedge(B);
	return(G);
    }

    public static int limitRenorm(int k) {
	int[] A={3,2,4,4,8,5,3,8,3,27,4,2,4};
	return(A[k]);
    }


    /**the big renorm polygons**/

    public static GoldenPolyWedge getSuperTautRenorm(int i) {
	int[][] B=DataReductionRaw.renormB(i);
	GoldenPolyWedge G=new GoldenPolyWedge(B);
	return(G);
    }



}