import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This has the data for the Reduction Theorem II*/


public class DataReductionRaw  {

    /**These are the super taut tiles whose renormalizations are closer to the origin.  We need to
       look at the second renormalization to understand these tiles.*/

    public static int[][] superTaut() {
	int[][] A={{0,140},{0,143},{6,18},{6,23},{6,24},{6,25},{6,20},{6,19},{10,16},{10,18},{10,19},{6,17}};return(A);}


    /**These are the taut tiles:  They are closest to the origin within their band.**/

 public static int[][] taut() {
     int[][] A={{0,62},{0,64},{0,67},{0,69},{0,71},{0,74},{0,81},{0,82},{0,83},{0,84},{0,86},{0,87},{0,90},{0,91},{0,92},{0,93},{0,95},{0,96},{0,105},{0,106},{0,108},{0,109},{0,110},{0,111},{0,113},{0,114},{0,115},{0,116},{0,118},{0,119},{0,120},{0,121},{0,123},{0,124},{0,125},{0,126},{0,128},{0,129},{0,130},{0,131},{0,133},{0,134},{0,140},{0,143},{1,7},{1,8},{1,13},{1,14},{1,15},{3,8},{3,9},{6,17},{6,18},{6,19},{6,20},{6,21},{6,22},{6,23},{6,24},{6,25},{8,16},{8,17},{8,18},{8,19},{8,23},{8,26},{8,27},{8,28},{8,29},{8,30},{8,31},{8,32},{8,36},{8,39},{8,42},{10,16},{10,18},{10,19},{10,28},{10,30},{10,31},{10,32},{10,33},{10,34},{10,35},{10,36},{10,37},{10,38},{11,13},{11,15},{11,16},{11,19},{11,20},{11,24},{11,27},{11,30},{11,49},{11,50},{11,51},{11,52},{11,53},{12,51},{13,17},{13,20},{13,25},{13,27},{13,28},{13,29},{13,30},{13,31},{13,32},{13,33},{13,34},{13,35},{13,36},{13,37},{13,38},{13,39},{13,40},{13,42},{17,38},{19,8},{21,1}};return(A);}




    /**the 23 big polygons**/

    public static int[][] big(int k) {
	int[][][] A={{{3,0,0,0},{6,-2,-3,2},{3,0,-2,2},{0,2,-3,2}},{{-6,6,-3,2},{-11,9,2,-1},{10,-4,7,-4},{-1,3,-4,3}},{{-18,14,-9,6},{3,1,-4,3},{-5,6,4,-2}},{{8,-2,-3,2},{-18,14,-9,6},{-5,6,4,-2},{-8,8,7,-4},{13,-5,2,-1}},{{-3,6,-2,2},{-16,14,11,-6},{-3,6,8,-4},{10,-2,11,-6}},{{37,-18,0,0},{3,3,-8,5},{-18,16,13,-8}},{{3,4,-12,8},{-15,15,6,-3},{6,2,11,-6},{3,4,8,-4},{0,6,11,-6},{21,-7,6,-3}},{{-3,8,14,-8},{26,-10,-15,10},{-3,8,-8,6},{-32,26,-15,10}},{{-1,7,12,-7},{-3,8,14,-8},{-6,10,11,-6}},{{3,5,12,-7},{8,2,11,-6},{5,4,14,-8}},{{3,6,14,-8},{32,-12,21,-12},{3,6,-8,6},{-26,24,21,-12}},{{-1,9,16,-9},{36,-14,-21,14},{-6,12,-11,8},{-27,25,10,-5}},{{3,7,16,-9},{63,-30,2,0},{-34,30,-21,14}},{{-3,12,-16,10},{-42,36,-25,16},{-3,12,14,-8},{36,-12,-25,16}},{{-6,14,-15,10},{-19,22,-2,2},{-27,27,-10,7}},{{3,9,-16,11},{-44,38,31,-18},{79,-38,2,0}},{{8,6,-15,10},{29,-7,-10,7},{21,-2,-2,2}},{{3,10,-16,10},{6,8,-19,12},{-31,31,-10,7},{3,10,24,-14},{37,-11,-10,7},{0,12,-19,12}},{{-3,14,20,-12},{52,-20,33,-20},{-3,14,-22,14},{-58,48,33,-20}},{{-6,16,-19,12},{-3,14,-22,14},{-1,13,-20,13}},{{-60,50,-35,22},{3,11,-20,13},{-21,26,4,-2}},{{8,8,-19,12},{29,-5,-14,9},{21,0,-6,4}},{{3,12,20,-12},{58,-22,-35,22},{3,12,-22,14},{-52,46,-35,22}}};return(A[k]);}


    public static int[][] cover(int choice,int k) {
	if(choice==0) return(cover0(k));
	if(choice==1) return(cover1(k));
	if(choice==2) return(cover2(k));
	if(choice==3) return(cover3(k));
	if(choice==4) return(cover4(k));
	if(choice==5) return(cover5(k));
	if(choice==6) return(cover6(k));
	if(choice==7) return(cover7(k));
	if(choice==8) return(cover8(k));
	if(choice==9) return(cover9(k));
	if(choice==10) return(cover10(k));
	if(choice==11) return(cover11(k));
	if(choice==12) return(cover12(k));
	if(choice==13) return(cover13(k));
	if(choice==14) return(cover14(k));
	if(choice==15) return(cover15(k));
	if(choice==16) return(cover16(k));
	if(choice==17) return(cover17(k));
	if(choice==18) return(cover18(k));
	if(choice==19) return(cover19(k));
	if(choice==20) return(cover20(k));
	if(choice==21) return(cover21(k));
	if(choice==22) return(cover22(k));
	return(null);
    }


public static int[][] cover22(int k) {
int[][][] A={{{3,12,20,-12},{58,-22,-35,22},{3,12,-22,14},{-52,46,-35,22}}};return(A[k]);}


public static int[][] cover21(int k) {
int[][][] A={{{8,8,-19,12},{29,-5,-14,9},{-13,21,28,-17},{76,-34,49,-30}},{{76,-34,49,-30},{-13,21,28,-17},{21,0,-6,4}}};return(A[k]);}


public static int[][] cover20(int k) {
int[][][] A={{{-60,50,-35,22},{-5,16,-22,14},{-115,84,4,-2},{-21,26,4,-2}},{{-5,16,-22,14},{105,-52,4,-2},{-115,84,4,-2}},{{-115,84,4,-2},{-81,63,-4,3},{-13,21,-4,3},{-21,26,4,-2}},{{105,-52,4,-2},{139,-73,-4,3},{-149,105,-4,3},{-115,84,4,-2}},{{-81,63,-4,3},{8,8,-25,16},{-13,21,-4,3}},{{139,-73,-4,3},{-5,16,30,-18},{-149,105,-4,3}},{{-18,24,-25,16},{37,-10,-12,8},{-5,16,-12,8}},{{37,-10,-12,8},{-18,24,1,0},{-5,16,-12,8}},{{92,-44,1,0},{-141,100,-54,34},{92,-44,-109,68},{37,-10,-54,34}},{{50,-18,17,-10},{160,-86,-93,58},{-217,147,-4,3},{139,-73,-4,3}},{{160,-86,17,-10},{-73,58,-38,24},{160,-86,-93,58},{105,-52,-38,24}},{{-348,228,-51,32},{-60,50,17,-10},{-115,84,-38,24},{-170,118,17,-10},{-259,173,38,-23}},{{-128,92,-51,32},{160,-86,17,-10},{105,-52,-38,24},{50,-18,17,-10},{-39,37,38,-23}},{{-170,118,17,-10},{-115,84,-38,24},{-170,118,-93,58},{63,-26,-38,24}},{{-170,118,-93,58},{207,-115,-4,3},{-81,63,-4,3}},{{-60,50,17,-10},{-149,105,-4,3},{207,-115,-4,3},{-170,118,-93,58}},{{-73,58,-38,24},{71,-31,-4,3},{160,-86,-93,58}},{{160,-86,-93,58},{71,-31,-4,3},{-217,147,-4,3}},{{63,-26,-38,24},{-170,118,-93,58},{-81,63,-4,3}},{{-115,84,4,-2},{-348,228,-51,32},{-259,173,38,-23}},{{105,-52,4,-2},{-128,92,-51,32},{-39,37,38,-23}},{{-217,147,-4,3},{-39,37,-46,29},{50,-18,43,-26},{-5,16,30,-18},{139,-73,-4,3}},{{71,-31,-4,3},{215,-120,30,-18},{71,-31,64,-39},{-73,58,-80,50},{-128,92,-25,16},{-217,147,-4,3}},{{-217,147,64,-39},{-73,58,-80,50},{160,-86,153,-94}},{{-5,16,30,-18},{-238,160,-25,16},{-5,16,208,-128},{228,-128,-25,16}},{{215,-120,30,-18},{-18,24,-25,16},{215,-120,208,-128},{448,-264,-25,16}},{{228,-128,-25,16},{-5,16,208,-128},{-149,105,64,-39}},{{448,-264,-25,16},{215,-120,208,-128},{71,-31,64,-39}},{{-149,105,-4,3},{-5,16,30,-18},{-60,50,43,-26},{8,8,-25,16},{-81,63,-4,3}},{{-128,92,-25,16},{-217,147,64,-39},{160,-86,153,-94},{-39,37,-46,29}},{{-238,160,-25,16},{139,-73,64,-39},{-5,16,208,-128}},{{-5,16,208,-128},{139,-73,64,-39},{283,-162,98,-60},{139,-73,132,-81},{-5,16,-12,8},{-60,50,43,-26},{-149,105,64,-39}},{{283,-162,98,-60},{50,-18,43,-26},{139,-73,132,-81}},{{325,-188,56,-34},{92,-44,1,0},{558,-332,1,0}},{{37,-10,166,-102},{181,-99,22,-13},{325,-188,56,-34},{558,-332,1,0},{-484,312,1,0},{-251,168,56,-34},{-107,79,22,-13}},{{969,-586,-232,144},{1956,-1196,1,0},{-18,24,1,0}},{{736,-442,289,-178},{-484,312,1,0},{1956,-1196,1,0},{969,-586,-232,144},{359,-209,-88,55}},{{270,-154,-67,42},{37,-10,166,-102},{-107,79,22,-13}},{{-251,168,56,-34},{736,-442,289,-178},{359,-209,-88,55}},{{37,-10,-12,8},{181,-99,22,-13},{270,-154,-67,42}},{{-484,312,1,0},{-251,168,234,-144},{-18,24,1,0}},{{-429,278,234,-144},{558,-332,467,-288},{181,-99,90,-55}},{{92,-44,1,0},{-285,189,-376,233},{-1882,1176,1,0}},{{-141,100,-54,34},{3,11,-20,13},{92,-44,-109,68}},{{-484,312,1,0},{-107,79,90,-55},{-251,168,234,-144}},{{2532,-1552,1,0},{935,-565,-376,233},{558,-332,1,0}},{{558,-332,1,0},{181,-99,90,-55},{37,-10,-54,34},{-107,79,90,-55},{-484,312,1,0}},{{558,-332,1,0},{325,-188,234,-144},{558,-332,467,-288},{-429,278,234,-144}},{{-1882,1176,1,0},{-285,189,-376,233},{325,-188,234,-144},{935,-565,-376,233},{2532,-1552,1,0}}};return(A[k]);}





public static int[][] cover19(int k) {
int[][][] A={{{62,-26,-35,22},{23,-2,4,-2},{117,-60,4,-2},{7,8,-22,14}},{{7,8,-22,14},{117,-60,4,-2},{-103,76,4,-2}},{{23,-2,4,-2},{15,3,-4,3},{83,-39,-4,3},{117,-60,4,-2}},{{117,-60,4,-2},{151,-81,-4,3},{-137,97,-4,3},{-103,76,4,-2}},{{15,3,-4,3},{-6,16,-25,16},{83,-39,-4,3}},{{151,-81,-4,3},{7,8,30,-18},{-137,97,-4,3}},{{20,0,-25,16},{7,8,-12,8},{-35,34,-12,8}},{{7,8,-12,8},{20,0,1,0},{-35,34,-12,8}},{{159,-86,-6,4},{-74,58,-61,38},{15,3,28,-17}},{{-6,16,-19,12},{-74,58,49,-30},{15,3,28,-17},{-27,29,-14,9}},{{10,6,-35,22},{-58,48,33,-20},{31,-7,12,-7},{10,6,-9,6},{-45,40,-22,14}},{{-11,19,-14,9},{10,6,-35,22},{-45,40,-22,14}},{{-74,58,49,-30},{-19,24,-6,4},{-74,58,-61,38},{159,-86,-6,4}},{{-19,24,-6,4},{-53,45,28,-17},{-87,66,20,-12},{-53,45,12,-7},{-19,24,46,-28},{-6,16,33,-20},{15,3,28,-17}},{{-32,32,33,-20},{78,-36,59,-36},{23,-2,4,-2},{-19,24,46,-28}},{{-53,45,28,-17},{-11,19,-14,9},{-45,40,-22,14},{-11,19,-30,19},{78,-36,59,-36}},{{-87,66,20,-12},{-32,32,33,-20},{-87,66,-22,14},{-142,100,33,-20}},{{-6,16,7,-4},{49,-18,20,-12},{-6,16,33,-20},{62,-26,-35,22},{-27,29,-14,9}},{{15,3,28,-17},{49,-18,20,-12},{-6,16,7,-4}},{{-142,100,33,-20},{-87,66,-22,14},{-53,45,12,-7}},{{-58,48,33,-20},{-3,14,-22,14},{31,-7,12,-7}},{{-45,40,-22,14},{10,6,-9,6},{-11,19,-30,19}},{{62,-26,17,-10},{172,-94,-93,58},{-205,139,-4,3},{151,-81,-4,3}},{{172,-94,17,-10},{-61,50,-38,24},{172,-94,-93,58},{117,-60,-38,24}},{{-336,220,-51,32},{-48,42,17,-10},{-103,76,-38,24},{-158,110,17,-10},{-247,165,38,-23}},{{-116,84,-51,32},{172,-94,17,-10},{117,-60,-38,24},{62,-26,17,-10},{-27,29,38,-23}},{{-158,110,17,-10},{-103,76,-38,24},{-158,110,-93,58},{75,-34,-38,24}},{{-158,110,-93,58},{219,-123,-4,3},{-69,55,-4,3}},{{-48,42,17,-10},{-137,97,-4,3},{219,-123,-4,3},{-158,110,-93,58}},{{-61,50,-38,24},{83,-39,-4,3},{172,-94,-93,58}},{{172,-94,-93,58},{83,-39,-4,3},{-205,139,-4,3}},{{75,-34,-38,24},{-158,110,-93,58},{-69,55,-4,3}},{{-103,76,4,-2},{-336,220,-51,32},{-247,165,38,-23}},{{117,-60,4,-2},{-116,84,-51,32},{-27,29,38,-23}},{{-205,139,-4,3},{-27,29,-46,29},{62,-26,43,-26},{7,8,30,-18},{151,-81,-4,3}},{{83,-39,-4,3},{227,-128,30,-18},{83,-39,64,-39},{-61,50,-80,50},{-116,84,-25,16},{-205,139,-4,3}},{{-205,139,64,-39},{-61,50,-80,50},{172,-94,153,-94}},{{7,8,30,-18},{-226,152,-25,16},{7,8,208,-128},{240,-136,-25,16}},{{227,-128,30,-18},{-6,16,-25,16},{227,-128,208,-128},{460,-272,-25,16}},{{240,-136,-25,16},{7,8,208,-128},{-137,97,64,-39}},{{460,-272,-25,16},{227,-128,208,-128},{83,-39,64,-39}},{{-137,97,-4,3},{7,8,30,-18},{-48,42,43,-26},{20,0,-25,16},{-69,55,-4,3}},{{-116,84,-25,16},{-205,139,64,-39},{172,-94,153,-94},{-27,29,-46,29}},{{-226,152,-25,16},{151,-81,64,-39},{7,8,208,-128}},{{7,8,208,-128},{151,-81,64,-39},{295,-170,98,-60},{151,-81,132,-81},{7,8,-12,8},{-48,42,43,-26},{-137,97,64,-39}},{{295,-170,98,-60},{62,-26,43,-26},{151,-81,132,-81}},{{253,-144,56,-34},{20,0,1,0},{486,-288,1,0}},{{-35,34,166,-102},{109,-55,22,-13},{253,-144,56,-34},{486,-288,1,0},{-556,356,1,0},{-323,212,56,-34},{-179,123,22,-13}},{{897,-542,-232,144},{1884,-1152,1,0},{-90,68,1,0}},{{664,-398,289,-178},{-556,356,1,0},{1884,-1152,1,0},{897,-542,-232,144},{287,-165,-88,55}},{{198,-110,-67,42},{-35,34,166,-102},{-179,123,22,-13}},{{-323,212,56,-34},{664,-398,289,-178},{287,-165,-88,55}},{{-35,34,-12,8},{109,-55,22,-13},{198,-110,-67,42}},{{20,0,1,0},{-1,13,-20,13},{-90,68,1,0}}};return(A[k]);}


public static int[][] cover18(int k) {
int[][][] A={{{-3,14,20,-12},{52,-20,33,-20},{-3,14,-22,14},{-58,48,33,-20}}};return(A[k]);}


public static int[][] cover17(int k) {
int[][][] A={{{3,10,-16,10},{-31,31,18,-11},{-120,86,-3,2},{126,-66,-3,2},{37,-11,18,-11}},{{-31,31,18,-11},{-10,18,-3,2},{-120,86,-3,2}},{{37,-11,18,-11},{126,-66,-3,2},{16,2,-3,2}},{{-120,86,-3,2},{-65,52,10,-6},{71,-32,10,-6},{126,-66,-3,2}},{{-10,18,-3,2},{11,5,-24,15},{155,-84,10,-6},{-65,52,10,-6},{-120,86,-3,2}},{{126,-66,-3,2},{71,-32,10,-6},{-149,104,10,-6},{-5,15,-24,15},{16,2,-3,2}},{{84,-40,65,-40},{-149,104,10,-6},{29,-6,10,-6}},{{-78,60,65,-40},{-23,26,10,-6},{155,-84,10,-6}},{{-65,52,10,-6},{-99,73,2,-1},{105,-53,2,-1},{71,-32,10,-6}},{{155,-84,10,-6},{-78,60,-45,28},{-10,18,23,-14},{-65,52,10,-6}},{{71,-32,10,-6},{16,2,23,-14},{84,-40,-45,28},{-149,104,10,-6}},{{19,0,-32,20},{-15,21,2,-1},{53,-21,2,-1}},{{-13,20,-32,20},{-47,41,2,-1},{21,-1,2,-1}},{{29,-6,-32,20},{173,-95,2,-1},{-115,83,2,-1}},{{-23,26,-32,20},{121,-63,2,-1},{-167,115,2,-1}},{{-149,104,10,-6},{84,-40,-45,28},{29,-6,10,-6}},{{-23,26,10,-6},{-78,60,-45,28},{155,-84,10,-6}},{{-26,28,-45,28},{29,-6,-32,20},{-115,83,2,-1},{241,-137,2,-1},{63,-27,44,-27}},{{-78,60,-45,28},{-23,26,-32,20},{-167,115,2,-1},{189,-105,2,-1},{11,5,44,-27}},{{84,-40,-45,28},{-5,15,44,-27},{-183,125,2,-1},{173,-95,2,-1},{29,-6,-32,20}},{{32,-8,-45,28},{-57,47,44,-27},{-235,157,2,-1},{121,-63,2,-1},{-23,26,-32,20}},{{-99,73,2,-1},{-91,68,4,-2},{97,-48,4,-2},{105,-53,2,-1}},{{-91,68,4,-2},{-57,47,-4,3},{63,-27,-4,3},{97,-48,4,-2}},{{-57,47,-4,3},{-23,26,-12,8},{29,-6,-12,8},{63,-27,-4,3}},{{-23,26,-12,8},{-78,60,1,0},{84,-40,1,0},{29,-6,-12,8}},{{-78,60,1,0},{11,5,-20,13},{45,-16,14,-8},{-39,36,14,-8},{-5,15,-20,13},{84,-40,1,0}},{{100,-50,69,-42},{-133,94,14,-8},{45,-16,14,-8}},{{-94,70,69,-42},{-39,36,14,-8},{139,-74,14,-8}},{{45,-16,14,-8},{3,10,-28,18},{-39,36,14,-8}},{{3,10,-28,18},{-31,31,6,-3},{37,-11,6,-3}},{{-10,18,-41,26},{45,-16,-28,18},{-99,73,6,-3},{257,-147,6,-3},{79,-37,48,-29}},{{16,2,-41,26},{-73,57,48,-29},{-251,167,6,-3},{105,-53,6,-3},{-39,36,-28,18}},{{-133,94,14,-8},{100,-50,-41,26},{45,-16,14,-8}},{{-39,36,14,-8},{-94,70,-41,26},{139,-74,14,-8}},{{-31,31,6,-3},{-65,52,-2,2},{71,-32,-2,2},{37,-11,6,-3}},{{-99,73,6,-3},{-10,18,-15,10},{-120,86,95,-58},{257,-147,6,-3}},{{-65,52,-2,2},{-31,31,-10,7},{3,10,24,-14},{37,-11,-10,7},{71,-32,-2,2}},{{-5,15,-24,15},{-149,104,10,-6},{84,-40,65,-40}},{{11,5,-24,15},{-78,60,65,-40},{155,-84,10,-6}},{{194,-108,-155,96},{-39,36,78,-48},{-183,125,-66,41}},{{142,-76,-155,96},{-91,68,78,-48},{-235,157,-66,41}},{{-191,130,-32,20},{-47,41,2,-1},{42,-14,-87,54}},{{97,-48,78,-48},{241,-137,-66,41},{385,-226,-32,20},{241,-137,2,-1},{-47,41,2,-1},{-191,130,-32,20},{-47,41,-66,41}},{{45,-16,78,-48},{189,-105,-66,41},{333,-194,-32,20},{189,-105,2,-1},{-99,73,2,-1},{-243,162,-32,20},{-99,73,-66,41}},{{-39,36,78,-48},{105,-53,-66,41},{249,-142,-32,20},{105,-53,2,-1},{-183,125,2,-1},{-327,214,-32,20},{-183,125,-66,41}},{{-91,68,78,-48},{53,-21,-66,41},{197,-110,-32,20},{53,-21,2,-1},{-235,157,2,-1},{-379,246,-32,20},{-235,157,-66,41}},{{197,-110,-32,20},{-36,34,-87,54},{53,-21,2,-1}},{{-136,96,-155,96},{241,-137,-66,41},{97,-48,78,-48}},{{-188,128,-155,96},{189,-105,-66,41},{45,-16,78,-48}},{{152,-82,133,-82},{-81,62,78,-48},{152,-82,23,-14},{241,-137,-66,41},{-136,96,-155,96}},{{100,-50,133,-82},{-133,94,78,-48},{100,-50,23,-14},{189,-105,-66,41},{-188,128,-155,96}},{{241,-137,-66,41},{152,-82,23,-14},{385,-226,-32,20}},{{189,-105,-66,41},{100,-50,23,-14},{333,-194,-32,20}},{{105,-53,-66,41},{16,2,23,-14},{249,-142,-32,20}},{{53,-21,-66,41},{-36,34,23,-14},{197,-110,-32,20}},{{42,-14,23,-14},{-191,130,-32,20},{42,-14,-87,54},{-13,20,-32,20}},{{29,-6,10,-6},{84,-40,-45,28},{29,-6,-32,20},{-26,28,-45,28}},{{-23,26,10,-6},{32,-8,-45,28},{-23,26,-32,20},{-78,60,-45,28}},{{-36,34,23,-14},{19,0,-32,20},{-36,34,-87,54},{197,-110,-32,20}},{{-47,41,-66,41},{-191,130,-32,20},{42,-14,23,-14}},{{-99,73,-66,41},{-243,162,-32,20},{-10,18,23,-14}},{{-183,125,-66,41},{-327,214,-32,20},{-94,70,23,-14}},{{-235,157,-66,41},{-379,246,-32,20},{-146,102,23,-14}},{{-5,15,44,-27},{139,-74,-100,62},{372,-218,133,-82}},{{-57,47,44,-27},{87,-42,-100,62},{320,-186,133,-82}},{{-94,70,133,-82},{194,-108,-155,96},{-183,125,-66,41},{-94,70,23,-14},{139,-74,78,-48}},{{-146,102,133,-82},{142,-76,-155,96},{-235,157,-66,41},{-146,102,23,-14},{87,-42,78,-48}},{{139,-74,-100,62},{-94,70,133,-82},{139,-74,78,-48},{372,-218,133,-82}},{{87,-42,-100,62},{-146,102,133,-82},{87,-42,78,-48},{320,-186,133,-82}},{{-81,62,-100,62},{-314,206,133,-82},{-81,62,78,-48},{152,-82,133,-82}},{{-133,94,-100,62},{-366,238,133,-82},{-133,94,78,-48},{100,-50,133,-82}},{{63,-27,44,-27},{-314,206,133,-82},{-81,62,-100,62}},{{11,5,44,-27},{-366,238,133,-82},{-133,94,-100,62}},{{105,-53,2,-1},{-5,15,28,-17},{-26,28,7,-4},{-81,62,-6,4},{-115,83,2,-1}},{{53,-21,2,-1},{-57,47,28,-17},{-78,60,7,-4},{-133,94,-6,4},{-167,115,2,-1}},{{42,-14,-35,22},{-26,28,33,-20},{-136,96,59,-36},{-47,41,-30,19},{-13,20,-22,14}},{{87,-42,-6,4},{53,-21,-14,9},{32,-8,7,-4}},{{-81,62,-6,4},{-26,28,7,-4},{-47,41,-14,9}},{{21,-1,-14,9},{-13,20,20,-12},{-68,54,-35,22}},{{-115,83,2,-1},{-26,28,-19,12},{-47,41,2,-1}},{{-167,115,2,-1},{-78,60,-19,12},{-99,73,2,-1}},{{-47,41,2,-1},{-81,62,-6,4},{-47,41,-14,9},{-13,20,20,-12},{21,-1,-14,9},{0,12,-19,12},{21,-1,2,-1}},{{-15,21,-14,9},{-91,68,4,-2},{32,-8,33,-20}},{{-13,20,20,-12},{42,-14,-35,22},{-13,20,-22,14},{-68,54,-35,22}},{{-15,21,2,-1},{6,8,-19,12},{-49,42,-6,4}},{{53,-21,-14,9},{19,0,20,-12},{-36,34,-35,22}},{{-47,41,2,-1},{-26,28,-19,12},{-81,62,-6,4}},{{-99,73,2,-1},{-78,60,-19,12},{-133,94,-6,4}},{{32,-8,7,-4},{53,-21,-14,9},{-36,34,-35,22},{32,-8,33,-20},{-23,26,20,-12}},{{-15,21,2,-1},{-49,42,-6,4},{-15,21,-14,9},{19,0,20,-12},{53,-21,-14,9},{87,-42,-6,4},{53,-21,2,-1}},{{-47,41,-30,19},{-136,96,59,-36},{97,-48,4,-2}},{{-26,28,7,-4},{29,-6,20,-12},{-26,28,33,-20},{42,-14,-35,22},{-47,41,-14,9}},{{-5,15,28,-17},{29,-6,20,-12},{-26,28,7,-4}},{{-57,47,28,-17},{-23,26,20,-12},{-78,60,7,-4}},{{-47,41,-14,9},{42,-14,-35,22},{-13,20,20,-12}},{{11,5,-20,13},{-133,94,14,-8},{100,-50,69,-42}},{{-5,15,-20,13},{-94,70,69,-42},{139,-74,14,-8}},{{126,-66,-151,94},{-107,78,82,-50},{-251,167,-62,39}},{{-175,120,-28,18},{-31,31,6,-3},{58,-24,-83,52}},{{113,-58,82,-50},{257,-147,-62,39},{401,-236,-28,18},{257,-147,6,-3},{-31,31,6,-3},{-175,120,-28,18},{-31,31,-62,39}},{{-107,78,82,-50},{37,-11,-62,39},{181,-100,-28,18},{37,-11,6,-3},{-251,167,6,-3},{-395,256,-28,18},{-251,167,-62,39}},{{181,-100,-28,18},{-52,44,-83,52},{37,-11,6,-3}},{{-120,86,-151,94},{257,-147,-62,39},{113,-58,82,-50}},{{168,-92,137,-84},{-65,52,82,-50},{168,-92,27,-16},{257,-147,-62,39},{-120,86,-151,94}},{{257,-147,-62,39},{168,-92,27,-16},{401,-236,-28,18}},{{37,-11,-62,39},{-52,44,27,-16},{181,-100,-28,18}},{{58,-24,27,-16},{-175,120,-28,18},{58,-24,-83,52},{3,10,-28,18}},{{45,-16,14,-8},{100,-50,-41,26},{45,-16,-28,18},{-10,18,-41,26}},{{-39,36,14,-8},{16,2,-41,26},{-39,36,-28,18},{-94,70,-41,26}},{{-52,44,27,-16},{3,10,-28,18},{-52,44,-83,52},{181,-100,-28,18}},{{-31,31,-62,39},{-175,120,-28,18},{58,-24,27,-16}},{{-251,167,-62,39},{-395,256,-28,18},{-162,112,27,-16}},{{-73,57,48,-29},{71,-32,-96,60},{304,-176,137,-84}},{{-162,112,137,-84},{126,-66,-151,94},{-251,167,-62,39},{-162,112,27,-16},{71,-32,82,-50}},{{71,-32,-96,60},{-162,112,137,-84},{71,-32,82,-50},{304,-176,137,-84}},{{-65,52,-96,60},{-298,196,137,-84},{-65,52,82,-50},{168,-92,137,-84}},{{79,-37,48,-29},{-298,196,137,-84},{-65,52,-96,60}},{{257,-147,6,-3},{113,-58,-138,86},{-31,31,6,-3}},{{37,-11,6,-3},{-107,78,-138,86},{-251,167,6,-3}},{{79,-37,-36,23},{-65,52,-2,2},{168,-92,53,-32}},{{71,-32,40,-24},{126,-66,-15,10},{71,-32,-2,2},{16,2,-15,10}},{{-120,86,95,-58},{-65,52,40,-24},{-120,86,-15,10},{113,-58,40,-24}},{{-31,31,6,-3},{113,-58,-138,86},{346,-202,95,-58}},{{-251,167,6,-3},{-107,78,-138,86},{126,-66,95,-58}},{{-251,167,6,-3},{126,-66,95,-58},{16,2,-15,10},{105,-53,6,-3}},{{79,-37,-104,65},{-10,18,-15,10},{223,-126,-70,44}},{{-65,52,40,-24},{79,-37,-104,65},{223,-126,-70,44},{79,-37,-36,23},{168,-92,53,-32},{-120,86,-15,10}},{{126,-66,95,-58},{-107,78,40,-24},{126,-66,-15,10},{71,-32,40,-24}},{{113,-58,-138,86},{-120,86,95,-58},{113,-58,40,-24},{346,-202,95,-58}},{{-107,78,-138,86},{-340,222,95,-58},{-107,78,40,-24},{126,-66,95,-58}},{{257,-147,6,-3},{-120,86,95,-58},{113,-58,-138,86}},{{37,-11,6,-3},{-340,222,95,-58},{-107,78,-138,86}}};return(A[k]);}



public static int[][] cover16(int k) {
int[][][] A={{{8,6,-15,10},{63,-28,-2,2},{21,-2,-2,2}},{{63,-28,-2,2},{29,-7,-10,7},{21,-2,-2,2}}};return(A[k]);}

public static int[][] cover15(int k) {
int[][][] A={{{-86,64,73,-44},{-31,30,18,-10},{147,-80,18,-10}},{{24,-4,-37,24},{-65,51,52,-31},{-243,161,10,-5},{113,-59,10,-5},{-31,30,-24,16}},{{-31,30,18,-10},{-86,64,-37,24},{147,-80,18,-10}},{{-243,161,10,-5},{134,-72,99,-60},{24,-4,-11,8},{113,-59,10,-5}},{{3,9,-16,11},{-86,64,73,-44},{147,-80,18,-10}},{{134,-72,-147,92},{-99,72,86,-52},{-243,161,-58,37}},{{-99,72,86,-52},{45,-17,-58,37},{189,-106,-24,16},{45,-17,10,-5},{-243,161,10,-5},{-387,250,-24,16},{-243,161,-58,37}},{{45,-17,-58,37},{-44,38,31,-18},{189,-106,-24,16}},{{-31,30,18,-10},{24,-4,-37,24},{-31,30,-24,16},{-86,64,-37,24}},{{-243,161,-58,37},{-387,250,-24,16},{-154,106,31,-18}},{{-65,51,52,-31},{79,-38,-92,58},{312,-182,141,-86}},{{-154,106,141,-86},{134,-72,-147,92},{-243,161,-58,37},{-154,106,31,-18},{79,-38,86,-52}},{{79,-38,-92,58},{-154,106,141,-86},{79,-38,86,-52},{312,-182,141,-86}},{{45,-17,10,-5},{-99,72,-134,84},{-243,161,10,-5}},{{79,-38,44,-26},{134,-72,-11,8},{79,-38,2,0},{24,-4,-11,8}},{{-243,161,10,-5},{-99,72,-134,84},{134,-72,99,-60}},{{-243,161,10,-5},{134,-72,99,-60},{24,-4,-11,8},{113,-59,10,-5}},{{134,-72,99,-60},{-99,72,44,-26},{134,-72,-11,8},{79,-38,44,-26}},{{-99,72,-134,84},{-332,216,99,-60},{-99,72,44,-26},{134,-72,99,-60}},{{45,-17,10,-5},{-332,216,99,-60},{-99,72,-134,84}}};return(A[k]);}

public static int[][] cover14(int k) {
int[][][] A={{{-6,14,-15,10},{-19,22,-2,2},{-61,48,-2,2}},{{-19,22,-2,2},{-27,27,-10,7},{-61,48,-2,2}}};return(A[k]);}

public static int[][] cover13(int k) {
int[][][] A={{{-3,12,-16,10},{52,-22,-3,2},{-58,46,-3,2}},{{52,-22,-3,2},{107,-56,10,-6},{-113,80,10,-6},{-58,46,-3,2}},{{107,-56,10,-6},{73,-35,2,-1},{-79,59,2,-1},{-113,80,10,-6}},{{73,-35,2,-1},{81,-40,4,-2},{-87,64,4,-2},{-79,59,2,-1}},{{81,-40,4,-2},{115,-61,-4,3},{-121,85,-4,3},{-87,64,4,-2}},{{115,-61,-4,3},{149,-82,-12,8},{-155,106,-12,8},{-121,85,-4,3}},{{78,-38,43,-26},{-155,106,-12,8},{23,-4,-12,8}},{{-84,62,43,-26},{-29,28,-12,8},{149,-82,-12,8}},{{149,-82,-12,8},{5,7,22,-13},{-16,20,1,0},{10,4,1,0},{-11,17,22,-13},{-155,106,-12,8}},{{-155,106,-12,8},{78,-38,-67,42},{23,-4,-12,8}},{{-29,28,-12,8},{-84,62,-67,42},{149,-82,-12,8}},{{-16,20,1,0},{-3,12,14,-8},{10,4,1,0}},{{26,-6,17,-10},{136,-74,-93,58},{-241,159,-4,3},{115,-61,-4,3}},{{136,-74,17,-10},{-97,70,-38,24},{136,-74,-93,58},{81,-40,-38,24}},{{-320,208,-51,32},{-32,30,17,-10},{-87,64,-38,24},{-142,98,17,-10},{-231,153,38,-23}},{{-152,104,-51,32},{136,-74,17,-10},{81,-40,-38,24},{26,-6,17,-10},{-63,49,38,-23}},{{-142,98,17,-10},{-87,64,-38,24},{-142,98,-93,58},{91,-46,-38,24}},{{-142,98,-93,58},{235,-135,-4,3},{-53,43,-4,3}},{{-32,30,17,-10},{-121,85,-4,3},{235,-135,-4,3},{-142,98,-93,58}},{{-97,70,-38,24},{47,-19,-4,3},{136,-74,-93,58}},{{136,-74,-93,58},{47,-19,-4,3},{-241,159,-4,3}},{{91,-46,-38,24},{-142,98,-93,58},{-53,43,-4,3}},{{-87,64,4,-2},{-320,208,-51,32},{-231,153,38,-23}},{{81,-40,4,-2},{-152,104,-51,32},{-63,49,38,-23}},{{-241,159,-4,3},{-63,49,-46,29},{26,-6,43,-26},{-29,28,30,-18},{115,-61,-4,3}},{{47,-19,-4,3},{191,-108,30,-18},{47,-19,64,-39},{-97,70,-80,50},{-152,104,-25,16},{-241,159,-4,3}},{{-241,159,64,-39},{-97,70,-80,50},{136,-74,153,-94}},{{-29,28,30,-18},{-262,172,-25,16},{-29,28,208,-128},{204,-116,-25,16}},{{23,-4,30,-18},{-210,140,-25,16},{23,-4,208,-128},{256,-148,-25,16}},{{191,-108,30,-18},{-42,36,-25,16},{191,-108,208,-128},{424,-252,-25,16}},{{204,-116,-25,16},{-29,28,208,-128},{-173,117,64,-39}},{{256,-148,-25,16},{23,-4,208,-128},{-121,85,64,-39}},{{424,-252,-25,16},{191,-108,208,-128},{47,-19,64,-39}},{{-121,85,-4,3},{23,-4,30,-18},{-32,30,43,-26},{36,-12,-25,16},{-53,43,-4,3}},{{-152,104,-25,16},{-241,159,64,-39},{136,-74,153,-94},{-63,49,-46,29}},{{-262,172,-25,16},{115,-61,64,-39},{-29,28,208,-128}},{{-210,140,-25,16},{167,-93,64,-39},{23,-4,208,-128}},{{-29,28,208,-128},{115,-61,64,-39},{259,-150,98,-60},{115,-61,132,-81},{-29,28,-12,8},{-84,62,43,-26},{-173,117,64,-39}},{{23,-4,208,-128},{167,-93,64,-39},{311,-182,98,-60},{167,-93,132,-81},{23,-4,-12,8},{-32,30,43,-26},{-121,85,64,-39}},{{259,-150,98,-60},{26,-6,43,-26},{115,-61,132,-81}},{{311,-182,98,-60},{78,-38,43,-26},{167,-93,132,-81}},{{-155,106,-12,8},{-11,17,22,-13},{78,-38,-67,42}},{{149,-82,-12,8},{-84,62,-67,42},{5,7,22,-13}}};return(A[k]);}

public static int[][] cover12(int k) {
int[][][] A={{{-81,59,0,1},{-115,80,-8,6},{21,-4,-8,6},{-34,30,-21,14},{-13,17,0,1}},{{139,-77,0,1},{105,-56,-8,6},{-115,80,-8,6},{-149,101,0,1}},{{-149,101,0,1},{-60,46,-21,14},{-170,114,89,-54},{207,-119,0,1}},{{-217,143,0,1},{160,-90,89,-54},{50,-22,-21,14},{139,-77,0,1}},{{-115,80,-8,6},{-60,46,5,-2},{76,-38,5,-2},{21,-4,-8,6}},{{105,-56,-8,6},{-39,33,26,-15},{-5,12,60,-36},{29,-9,26,-15},{-115,80,-8,6}},{{-60,46,5,-2},{-5,12,18,-10},{-47,38,18,-10},{-13,17,-16,11},{76,-38,5,-2}},{{-102,72,73,-44},{-47,38,18,-10},{131,-72,18,-10}},{{-5,12,18,-10},{-60,46,31,-18},{-47,38,18,-10}},{{8,4,-37,24},{-81,59,52,-31},{-259,169,10,-5},{97,-51,10,-5},{-47,38,-24,16}},{{-47,38,18,-10},{-102,72,-37,24},{131,-72,18,-10}},{{-259,169,10,-5},{118,-64,99,-60},{8,4,-11,8},{97,-51,10,-5}},{{-5,12,8,-4},{50,-22,-47,30},{-5,12,-34,22},{-60,46,-47,30}},{{37,-14,50,-30},{92,-48,-5,4},{37,-14,8,-4},{-18,20,-5,4}},{{3,7,16,-9},{92,-48,-5,4},{37,-14,50,-30}},{{8,4,21,-12},{-81,59,0,1},{-13,17,0,1}},{{-60,46,-47,30},{-5,12,-34,22},{-149,101,0,1},{-81,59,0,1},{8,4,21,-12}},{{-18,20,-5,4},{37,-14,8,-4},{-18,20,21,-12},{-5,12,8,-4}},{{50,-22,-47,30},{-18,20,21,-12},{71,-35,0,1},{-149,101,0,1}},{{-81,59,0,1},{-170,114,89,-54},{63,-30,34,-20}},{{29,-9,-42,27},{-115,80,-8,6},{118,-64,47,-28}},{{160,-90,89,-54},{-73,54,34,-20},{160,-90,-21,14},{105,-56,34,-20}},{{105,-56,34,-20},{160,-90,-21,14},{-128,88,47,-28},{-39,33,-42,27},{-183,122,-76,48},{-39,33,-110,69}},{{-39,33,-110,69},{-183,122,-76,48},{50,-22,-21,14}},{{207,-119,0,1},{-170,114,89,-54},{-81,59,0,1}},{{71,-35,0,1},{-73,54,34,-20},{160,-90,89,-54}},{{-39,33,-42,27},{-128,88,47,-28},{105,-56,-8,6}},{{-217,143,0,1},{-73,54,-144,90},{160,-90,89,-54}},{{-170,114,89,-54},{-115,80,34,-20},{-170,114,-21,14},{63,-30,34,-20}},{{71,-35,0,1},{-73,54,-144,90},{-217,143,0,1}},{{-115,80,34,-20},{-60,46,-21,14},{29,-9,-42,27},{118,-64,47,-28},{-170,114,-21,14}},{{50,-22,115,-70},{-183,122,60,-36},{50,-22,5,-2},{-5,12,60,-36}},{{173,-98,-118,74},{-60,46,115,-70},{173,-98,60,-36},{406,-242,115,-70}},{{-183,122,-118,74},{-416,266,115,-70},{-183,122,60,-36},{50,-22,115,-70}},{{-39,33,26,-15},{-416,266,115,-70},{-183,122,-118,74}},{{29,-9,26,-15},{173,-98,-118,74},{406,-242,115,-70}},{{139,-77,-84,53},{50,-22,5,-2},{516,-310,5,-2}},{{-60,46,115,-70},{-5,12,60,-36},{-60,46,5,-2},{173,-98,60,-36}},{{-5,12,60,-36},{139,-77,-84,53},{516,-310,5,-2},{-526,334,5,-2},{-149,101,-84,53}},{{-149,101,-84,53},{-526,334,5,-2},{-60,46,5,-2}},{{139,-77,-16,11},{-5,12,18,-10},{228,-132,73,-44}},{{516,-310,5,-2},{283,-166,-50,32},{139,-77,-16,11},{228,-132,73,-44},{-293,190,-50,32},{-526,334,5,-2}},{{-526,334,5,-2},{694,-420,-283,176},{317,-187,94,-57},{-60,46,5,-2}},{{50,-22,5,-2},{283,-166,-50,32},{516,-310,5,-2}},{{-13,17,-16,11},{-102,72,73,-44},{131,-72,18,-10}},{{317,-187,94,-57},{694,-420,-283,176},{-293,190,-50,32}},{{118,-64,-147,92},{-115,80,86,-52},{-259,169,-58,37}},{{-115,80,86,-52},{29,-9,-58,37},{173,-98,-24,16},{29,-9,10,-5},{-259,169,10,-5},{-403,258,-24,16},{-259,169,-58,37}},{{29,-9,-58,37},{-60,46,31,-18},{173,-98,-24,16}},{{-47,38,18,-10},{8,4,-37,24},{-47,38,-24,16},{-102,72,-37,24}},{{-259,169,-58,37},{-403,258,-24,16},{-170,114,31,-18}},{{-81,59,52,-31},{63,-30,-92,58},{296,-174,141,-86}},{{-170,114,141,-86},{118,-64,-147,92},{-259,169,-58,37},{-170,114,31,-18},{63,-30,86,-52}},{{63,-30,-92,58},{-170,114,141,-86},{63,-30,86,-52},{296,-174,141,-86}},{{29,-9,10,-5},{-115,80,-134,84},{-259,169,10,-5}},{{63,-30,44,-26},{118,-64,-11,8},{63,-30,2,0},{8,4,-11,8}},{{-259,169,10,-5},{-115,80,-134,84},{118,-64,99,-60}},{{-259,169,10,-5},{118,-64,99,-60},{8,4,-11,8},{97,-51,10,-5}},{{118,-64,99,-60},{-115,80,44,-26},{118,-64,-11,8},{63,-30,44,-26}},{{-115,80,-134,84},{-348,224,99,-60},{-115,80,44,-26},{118,-64,99,-60}},{{29,-9,10,-5},{-348,224,99,-60},{-115,80,-134,84}}};return(A[k]);}



public static int[][] cover11(int k) {
int[][][] A={{{15,-1,0,1},{36,-14,-21,14},{-19,20,-8,6},{117,-64,-8,6},{83,-43,0,1}},{{151,-85,0,1},{117,-64,-8,6},{-103,72,-8,6},{-137,93,0,1}},{{-137,93,0,1},{-48,38,-21,14},{-158,106,89,-54},{219,-127,0,1}},{{-205,135,0,1},{172,-98,89,-54},{62,-30,-21,14},{151,-85,0,1}},{{-19,20,-8,6},{-74,54,5,-2},{62,-30,5,-2},{117,-64,-8,6}},{{117,-64,-8,6},{-27,25,26,-15},{7,4,60,-36},{41,-17,26,-15},{-103,72,-8,6}},{{-74,54,5,-2},{15,-1,-16,11},{49,-22,18,-10},{7,4,18,-10},{62,-30,5,-2}},{{104,-56,73,-44},{-129,88,18,-10},{49,-22,18,-10}},{{49,-22,18,-10},{62,-30,31,-18},{7,4,18,-10}},{{-6,12,-37,24},{49,-22,-24,16},{-95,67,10,-5},{261,-153,10,-5},{83,-43,52,-31}},{{-129,88,18,-10},{104,-56,-37,24},{49,-22,18,-10}},{{-95,67,10,-5},{-6,12,-11,8},{-116,80,99,-60},{261,-153,10,-5}},{{-6,12,21,-12},{15,-1,0,1},{83,-43,0,1}},{{7,4,8,-4},{62,-30,-47,30},{7,4,-34,22},{-48,38,-47,30}},{{-35,30,50,-30},{20,-4,-5,4},{-35,30,8,-4},{-90,64,-5,4}},{{-48,38,-47,30},{7,4,-34,22},{-137,93,0,1},{-69,51,0,1},{20,-4,21,-12}},{{62,-30,-47,30},{-6,12,21,-12},{83,-43,0,1},{-137,93,0,1}},{{20,-4,-5,4},{7,4,8,-4},{20,-4,21,-12},{-35,30,8,-4}},{{-1,9,16,-9},{-35,30,50,-30},{-90,64,-5,4}},{{-69,51,0,1},{-158,106,89,-54},{75,-38,34,-20}},{{41,-17,-42,27},{-103,72,-8,6},{130,-72,47,-28}},{{172,-98,89,-54},{-61,46,34,-20},{172,-98,-21,14},{117,-64,34,-20}},{{117,-64,34,-20},{172,-98,-21,14},{-116,80,47,-28},{-27,25,-42,27},{-171,114,-76,48},{-27,25,-110,69}},{{-27,25,-110,69},{-171,114,-76,48},{62,-30,-21,14}},{{219,-127,0,1},{-158,106,89,-54},{-69,51,0,1}},{{83,-43,0,1},{-61,46,34,-20},{172,-98,89,-54}},{{-27,25,-42,27},{-116,80,47,-28},{117,-64,-8,6}},{{-205,135,0,1},{-61,46,-144,90},{172,-98,89,-54}},{{-158,106,89,-54},{-103,72,34,-20},{-158,106,-21,14},{75,-38,34,-20}},{{83,-43,0,1},{-61,46,-144,90},{-205,135,0,1}},{{-103,72,34,-20},{-48,38,-21,14},{41,-17,-42,27},{130,-72,47,-28},{-158,106,-21,14}},{{62,-30,115,-70},{-171,114,60,-36},{62,-30,5,-2},{7,4,60,-36}},{{185,-106,-118,74},{-48,38,115,-70},{185,-106,60,-36},{418,-250,115,-70}},{{-171,114,-118,74},{-404,258,115,-70},{-171,114,60,-36},{62,-30,115,-70}},{{-27,25,26,-15},{-404,258,115,-70},{-171,114,-118,74}},{{41,-17,26,-15},{185,-106,-118,74},{418,-250,115,-70}},{{151,-85,-84,53},{62,-30,5,-2},{528,-318,5,-2}},{{-48,38,115,-70},{7,4,60,-36},{-48,38,5,-2},{185,-106,60,-36}},{{7,4,60,-36},{151,-85,-84,53},{528,-318,5,-2},{-514,326,5,-2},{-137,93,-84,53}},{{-137,93,-84,53},{-514,326,5,-2},{-48,38,5,-2}},{{151,-85,-16,11},{7,4,18,-10},{240,-140,73,-44}},{{15,-1,-16,11},{-129,88,18,-10},{104,-56,73,-44}},{{528,-318,5,-2},{295,-174,-50,32},{151,-85,-16,11},{240,-140,73,-44},{-281,182,-50,32},{-514,326,5,-2}},{{-514,326,5,-2},{706,-428,-283,176},{329,-195,94,-57},{-48,38,5,-2}},{{62,-30,5,-2},{295,-174,-50,32},{528,-318,5,-2}},{{329,-195,94,-57},{706,-428,-283,176},{-281,182,-50,32}},{{117,-64,86,-52},{261,-153,-58,37},{405,-242,-24,16},{261,-153,10,-5},{-27,25,10,-5},{-171,114,-24,16},{-27,25,-58,37}},{{-116,80,-147,92},{261,-153,-58,37},{117,-64,86,-52}},{{172,-98,141,-86},{-61,46,86,-52},{172,-98,31,-18},{261,-153,-58,37},{-116,80,-147,92}},{{261,-153,-58,37},{172,-98,31,-18},{405,-242,-24,16}},{{49,-22,18,-10},{104,-56,-37,24},{49,-22,-24,16},{-6,12,-37,24}},{{-27,25,-58,37},{-171,114,-24,16},{62,-30,31,-18}},{{-61,46,-92,58},{-294,190,141,-86},{-61,46,86,-52},{172,-98,141,-86}},{{83,-43,52,-31},{-294,190,141,-86},{-61,46,-92,58}},{{261,-153,10,-5},{117,-64,-134,84},{-27,25,10,-5}},{{261,-153,10,-5},{-116,80,99,-60},{117,-64,-134,84}}};return(A[k]);}

public static int[][] cover10(int k) {
int[][][] A={{{3,6,-28,18},{-31,27,6,-3},{37,-15,6,-3}},{{-31,27,6,-3},{-65,48,-2,2},{71,-36,-2,2},{37,-15,6,-3}},{{3,6,24,-14},{58,-28,-31,20},{3,6,-18,12},{-52,40,-31,20}},{{58,-28,-31,20},{11,1,16,-9},{32,-12,21,-12},{11,1,0,1},{79,-41,0,1},{3,6,-18,12}},{{-31,27,-10,7},{58,-28,-31,20},{3,6,24,-14}},{{37,-15,-10,7},{3,6,24,-14},{-52,40,-31,20}},{{-65,48,-2,2},{-31,27,-10,7},{3,6,24,-14},{37,-15,-10,7},{71,-36,-2,2}},{{11,1,0,1},{-10,14,-21,14},{79,-41,0,1}},{{-73,53,0,1},{16,-2,-21,14},{-5,11,0,1}},{{147,-83,0,1},{3,6,34,-20},{-141,95,0,1}},{{-175,116,-28,18},{-31,27,6,-3},{58,-28,-83,52}},{{181,-104,-28,18},{-52,40,-83,52},{37,-15,6,-3}},{{58,-28,27,-16},{-175,116,-28,18},{58,-28,-83,52},{3,6,-28,18}},{{-52,40,27,-16},{3,6,-28,18},{-52,40,-83,52},{181,-104,-28,18}},{{-230,150,-41,26},{58,-28,27,-16},{3,6,-28,18},{-52,40,27,-16},{-141,95,48,-29}},{{3,6,14,-8},{-230,150,-41,26},{-141,95,48,-29}},{{3,6,-18,12},{79,-41,0,1},{-141,95,0,1},{-107,74,8,-4}},{{-65,48,-2,2},{-10,14,11,-6},{-31,27,-10,7}},{{-107,74,8,-4},{-52,40,21,-12},{-73,53,0,1}},{{-52,40,21,-12},{-141,95,0,1},{-73,53,0,1}},{{-10,14,11,-6},{45,-20,24,-14},{-10,14,37,-22},{58,-28,-31,20},{-31,27,-10,7}},{{45,-20,24,-14},{11,1,16,-9},{-10,14,37,-22}},{{-52,40,-31,20},{3,6,-18,12},{-73,53,0,1},{-5,11,0,1},{-26,24,21,-12},{-5,11,16,-9}},{{71,-36,-2,2},{37,-15,-10,7},{16,-2,11,-6}},{{16,-2,11,-6},{37,-15,-10,7},{-52,40,-31,20},{16,-2,37,-22},{-39,32,24,-14}},{{-39,32,24,-14},{16,-2,37,-22},{-39,32,-18,12},{-94,66,37,-22}},{{-94,66,37,-22},{-39,32,-18,12},{-5,11,16,-9}},{{-209,137,0,1},{-31,27,-42,27},{58,-28,47,-28},{3,6,34,-20},{147,-83,0,1}},{{79,-41,0,1},{223,-130,34,-20},{79,-41,68,-41},{-65,48,-76,48},{-120,82,-21,14},{-209,137,0,1}},{{-209,137,68,-41},{-65,48,-76,48},{168,-96,157,-96}},{{3,6,34,-20},{-230,150,-21,14},{3,6,212,-130},{236,-138,-21,14}},{{223,-130,34,-20},{-10,14,-21,14},{223,-130,212,-130},{456,-274,-21,14}},{{236,-138,-21,14},{3,6,212,-130},{-141,95,68,-41}},{{456,-274,-21,14},{223,-130,212,-130},{79,-41,68,-41}},{{-141,95,0,1},{3,6,34,-20},{-52,40,47,-28},{16,-2,-21,14},{-73,53,0,1}},{{-120,82,-21,14},{-209,137,68,-41},{168,-96,157,-96},{-31,27,-42,27}},{{-230,150,-21,14},{147,-83,68,-41},{3,6,212,-130}},{{3,6,212,-130},{147,-83,68,-41},{291,-172,102,-62},{147,-83,136,-83},{3,6,-8,6},{-52,40,47,-28},{-141,95,68,-41}},{{291,-172,102,-62},{58,-28,47,-28},{147,-83,136,-83}}};return(A[k]);}


public static int[][] cover9(int k) {
int[][][] A={{{-18,18,-9,6},{37,-16,4,-2},{-5,10,4,-2}},{{8,2,17,-10},{-81,57,-4,3},{-13,15,-4,3}},{{37,-16,4,-2},{-18,18,17,-10},{-5,10,4,-2}},{{-5,10,-38,24},{139,-79,-4,3},{-149,99,-4,3}},{{50,-24,-51,32},{-39,31,38,-23},{-217,141,-4,3},{139,-79,-4,3},{-5,10,-38,24}},{{-81,57,-4,3},{-115,78,-12,8},{-21,20,-12,8},{-13,15,-4,3}},{{139,-79,-4,3},{105,-58,-12,8},{-115,78,-12,8},{-149,99,-4,3}},{{-217,141,-4,3},{160,-92,85,-52},{50,-24,-25,16},{139,-79,-4,3}},{{-149,99,-4,3},{-60,44,-25,16},{-170,112,85,-52},{207,-121,-4,3}},{{-115,78,-12,8},{-60,44,1,0},{-8,12,1,0},{-21,20,-12,8}},{{105,-58,-12,8},{-39,31,22,-13},{-5,10,56,-34},{29,-11,22,-13},{-115,78,-12,8}},{{-60,44,1,0},{-5,10,14,-8},{5,4,14,-8},{-8,12,1,0}},{{-5,10,14,-8},{29,-11,6,-3},{13,-1,6,-3},{5,4,14,-8}},{{29,-11,6,-3},{63,-32,-2,2},{21,-6,-2,2},{13,-1,6,-3}},{{63,-32,-2,2},{8,2,11,-6},{21,-6,-2,2}},{{3,5,12,-7},{37,-16,4,-2},{-18,18,-9,6}},{{-5,10,4,-2},{50,-24,-51,32},{-5,10,-38,24},{-60,44,-51,32}},{{207,-121,-72,45},{118,-66,17,-10},{351,-210,-38,24}},{{71,-37,-72,45},{-18,18,17,-10},{215,-126,-38,24}},{{-39,31,38,-23},{105,-58,-106,66},{338,-202,127,-78}},{{-170,112,-161,100},{207,-121,-72,45},{63,-32,72,-44}},{{118,-66,127,-78},{-115,78,72,-44},{118,-66,17,-10},{207,-121,-72,45},{-170,112,-161,100}},{{-60,44,-51,32},{-5,10,-38,24},{-149,99,-4,3},{207,-121,-4,3},{29,-11,38,-23}},{{-128,86,127,-78},{-73,52,72,-44},{-128,86,17,-10},{105,-58,72,-44}},{{63,-32,72,-44},{207,-121,-72,45},{351,-210,-38,24},{207,-121,-4,3},{-81,57,-4,3},{-225,146,-38,24},{-81,57,-72,45}},{{-73,52,72,-44},{71,-37,-72,45},{215,-126,-38,24},{71,-37,-4,3},{-217,141,-4,3},{-361,230,-38,24},{-217,141,-72,45}},{{-81,57,-72,45},{-225,146,-38,24},{8,2,17,-10}},{{-217,141,-72,45},{-361,230,-38,24},{-128,86,17,-10}},{{105,-58,-106,66},{-128,86,127,-78},{105,-58,72,-44},{338,-202,127,-78}},{{-115,78,-106,66},{-348,222,127,-78},{-115,78,72,-44},{118,-66,127,-78}},{{29,-11,38,-23},{-348,222,127,-78},{-115,78,-106,66}},{{-81,57,-4,3},{-170,112,85,-52},{63,-32,30,-18}},{{29,-11,-46,29},{-115,78,-12,8},{118,-66,43,-26}},{{160,-92,85,-52},{-73,52,30,-18},{160,-92,-25,16},{105,-58,30,-18}},{{105,-58,30,-18},{160,-92,-25,16},{-128,86,43,-26},{-39,31,-46,29},{-183,120,-80,50},{-39,31,-114,71}},{{-39,31,-114,71},{-183,120,-80,50},{50,-24,-25,16}},{{207,-121,-4,3},{-170,112,85,-52},{-81,57,-4,3}},{{71,-37,-4,3},{-73,52,30,-18},{160,-92,85,-52}},{{-39,31,-46,29},{-128,86,43,-26},{105,-58,-12,8}},{{-217,141,-4,3},{-73,52,-148,92},{160,-92,85,-52}},{{-170,112,85,-52},{-115,78,30,-18},{-170,112,-25,16},{63,-32,30,-18}},{{71,-37,-4,3},{-73,52,-148,92},{-217,141,-4,3}},{{-115,78,30,-18},{-60,44,-25,16},{29,-11,-46,29},{118,-66,43,-26},{-170,112,-25,16}},{{50,-24,111,-68},{-183,120,56,-34},{50,-24,1,0},{-5,10,56,-34}},{{173,-100,-122,76},{-60,44,111,-68},{173,-100,56,-34},{406,-244,111,-68}},{{-183,120,-122,76},{-416,264,111,-68},{-183,120,56,-34},{50,-24,111,-68}},{{-39,31,22,-13},{-416,264,111,-68},{-183,120,-122,76}},{{29,-11,22,-13},{173,-100,-122,76},{406,-244,111,-68}},{{139,-79,-88,55},{50,-24,1,0},{516,-312,1,0}},{{-60,44,111,-68},{-5,10,56,-34},{-60,44,1,0},{173,-100,56,-34}},{{-5,10,56,-34},{139,-79,-88,55},{516,-312,1,0},{-526,332,1,0},{-149,99,-88,55}},{{-149,99,-88,55},{-526,332,1,0},{-60,44,1,0}},{{139,-79,-20,13},{-5,10,14,-8},{228,-134,69,-42}},{{516,-312,1,0},{283,-168,-54,34},{139,-79,-20,13},{228,-134,69,-42},{-293,188,-54,34},{-526,332,1,0}},{{-526,332,1,0},{694,-422,-287,178},{317,-189,90,-55},{-60,44,1,0}},{{50,-24,1,0},{283,-168,-54,34},{516,-312,1,0}},{{317,-189,90,-55},{694,-422,-287,178},{-293,188,-54,34}}};return(A[k]);}

    public static int[][] cover8(int k) {
	int[][][]A={{{20,-6,-9,6},{7,2,4,-2},{-35,28,4,-2}},{{-6,10,17,-10},{15,-3,-4,3},{83,-45,-4,3}},{{7,2,4,-2},{20,-6,17,-10},{-35,28,4,-2}},{{7,2,-38,24},{151,-87,-4,3},{-137,91,-4,3}},{{62,-32,-51,32},{-27,23,38,-23},{-205,133,-4,3},{151,-87,-4,3},{7,2,-38,24}},{{15,-3,-4,3},{23,-8,-12,8},{117,-66,-12,8},{83,-45,-4,3}},{{151,-87,-4,3},{117,-66,-12,8},{-103,70,-12,8},{-137,91,-4,3}},{{-205,133,-4,3},{172,-100,85,-52},{62,-32,-25,16},{151,-87,-4,3}},{{-137,91,-4,3},{-48,36,-25,16},{-158,104,85,-52},{219,-129,-4,3}},{{23,-8,-12,8},{10,0,1,0},{62,-32,1,0},{117,-66,-12,8}},{{117,-66,-12,8},{-27,23,22,-13},{7,2,56,-34},{41,-19,22,-13},{-103,70,-12,8}},{{10,0,1,0},{-3,8,14,-8},{7,2,14,-8},{62,-32,1,0}},{{-3,8,14,-8},{-11,13,6,-3},{-27,23,6,-3},{7,2,14,-8}},{{-11,13,6,-3},{-19,18,-2,2},{-61,44,-2,2},{-27,23,6,-3}},{{-19,18,-2,2},{-6,10,11,-6},{-61,44,-2,2}},{{-1,7,12,-7},{20,-6,-9,6},{-35,28,4,-2}},{{7,2,4,-2},{62,-32,-51,32},{7,2,-38,24},{-48,36,-51,32}},{{219,-129,-72,45},{130,-74,17,-10},{363,-218,-38,24}},{{83,-45,-72,45},{-6,10,17,-10},{227,-134,-38,24}},{{-27,23,38,-23},{117,-66,-106,66},{350,-210,127,-78}},{{-158,104,-161,100},{219,-129,-72,45},{75,-40,72,-44}},{{130,-74,127,-78},{-103,70,72,-44},{130,-74,17,-10},{219,-129,-72,45},{-158,104,-161,100}},{{-48,36,-51,32},{7,2,-38,24},{-137,91,-4,3},{219,-129,-4,3},{41,-19,38,-23}},{{-116,78,127,-78},{-61,44,72,-44},{-116,78,17,-10},{117,-66,72,-44}},{{75,-40,72,-44},{219,-129,-72,45},{363,-218,-38,24},{219,-129,-4,3},{-69,49,-4,3},{-213,138,-38,24},{-69,49,-72,45}},{{-61,44,72,-44},{83,-45,-72,45},{227,-134,-38,24},{83,-45,-4,3},{-205,133,-4,3},{-349,222,-38,24},{-205,133,-72,45}},{{-69,49,-72,45},{-213,138,-38,24},{20,-6,17,-10}},{{-205,133,-72,45},{-349,222,-38,24},{-116,78,17,-10}},{{117,-66,-106,66},{-116,78,127,-78},{117,-66,72,-44},{350,-210,127,-78}},{{-103,70,-106,66},{-336,214,127,-78},{-103,70,72,-44},{130,-74,127,-78}},{{41,-19,38,-23},{-336,214,127,-78},{-103,70,-106,66}},{{-69,49,-4,3},{-158,104,85,-52},{75,-40,30,-18}},{{41,-19,-46,29},{-103,70,-12,8},{130,-74,43,-26}},{{172,-100,85,-52},{-61,44,30,-18},{172,-100,-25,16},{117,-66,30,-18}},{{117,-66,30,-18},{172,-100,-25,16},{-116,78,43,-26},{-27,23,-46,29},{-171,112,-80,50},{-27,23,-114,71}},{{-27,23,-114,71},{-171,112,-80,50},{62,-32,-25,16}},{{219,-129,-4,3},{-158,104,85,-52},{-69,49,-4,3}},{{83,-45,-4,3},{-61,44,30,-18},{172,-100,85,-52}},{{-27,23,-46,29},{-116,78,43,-26},{117,-66,-12,8}},{{-205,133,-4,3},{-61,44,-148,92},{172,-100,85,-52}},{{-158,104,85,-52},{-103,70,30,-18},{-158,104,-25,16},{75,-40,30,-18}},{{83,-45,-4,3},{-61,44,-148,92},{-205,133,-4,3}},{{-103,70,30,-18},{-48,36,-25,16},{41,-19,-46,29},{130,-74,43,-26},{-158,104,-25,16}},{{62,-32,111,-68},{-171,112,56,-34},{62,-32,1,0},{7,2,56,-34}},{{185,-108,-122,76},{-48,36,111,-68},{185,-108,56,-34},{418,-252,111,-68}},{{-171,112,-122,76},{-404,256,111,-68},{-171,112,56,-34},{62,-32,111,-68}},{{-27,23,22,-13},{-404,256,111,-68},{-171,112,-122,76}},{{41,-19,22,-13},{185,-108,-122,76},{418,-252,111,-68}},{{151,-87,-88,55},{62,-32,1,0},{528,-320,1,0}},{{-48,36,111,-68},{7,2,56,-34},{-48,36,1,0},{185,-108,56,-34}},{{7,2,56,-34},{151,-87,-88,55},{528,-320,1,0},{-514,324,1,0},{-137,91,-88,55}},{{-137,91,-88,55},{-514,324,1,0},{-48,36,1,0}},{{151,-87,-20,13},{7,2,14,-8},{240,-142,69,-42}},{{528,-320,1,0},{295,-176,-54,34},{151,-87,-20,13},{240,-142,69,-42},{-281,180,-54,34},{-514,324,1,0}},{{-514,324,1,0},{706,-430,-287,178},{329,-197,90,-55},{-48,36,1,0}},{{62,-32,1,0},{295,-176,-54,34},{528,-320,1,0}},{{329,-197,90,-55},{706,-430,-287,178},{-281,180,-54,34}}};return(A[k]);}


    public static int[][] cover7(int k) {
	int[][][] A={{{-3,8,14,-8},{5,3,6,-3},{-11,13,6,-3}},{{5,3,6,-3},{26,-10,-15,10},{-29,24,-2,2},{23,-8,-2,2},{-32,26,-15,10},{-11,13,6,-3}},{{-29,24,-2,2},{5,3,-10,7},{-3,8,-18,12},{-11,13,-10,7},{23,-8,-2,2}},{{-37,29,0,1},{-3,8,34,-20},{31,-13,0,1}},{{-3,8,-18,12},{-16,16,-5,4},{-37,29,0,1},{31,-13,0,1},{65,-34,8,-4},{31,-13,16,-9}},{{-11,13,-10,7},{10,0,-31,20},{-45,34,-18,12}},{{52,-26,37,-22},{-37,29,16,-9},{-3,8,-18,12}},{{10,0,-31,20},{-58,42,37,-22},{31,-13,16,-9},{10,0,-5,4},{-45,34,-18,12}},{{-58,42,37,-22},{-3,8,-18,12},{31,-13,16,-9}},{{65,-34,50,-30},{120,-68,-5,4},{65,-34,8,-4},{10,0,-5,4}},{{31,-13,16,-9},{120,-68,-5,4},{65,-34,50,-30}},{{-16,16,-31,20},{39,-18,-18,12},{-16,16,-5,4},{-37,29,16,-9},{52,-26,37,-22}},{{5,3,-10,7},{39,-18,-18,12},{-16,16,-31,20}},{{-3,8,34,-20},{52,-26,-21,14},{-3,8,-8,6},{-58,42,-21,14}},{{-58,42,89,-54},{-3,8,34,-20},{-58,42,-21,14},{175,-102,34,-20}},{{31,-13,0,1},{-58,42,89,-54},{175,-102,34,-20}},{{-37,29,0,1},{52,-26,-21,14},{-3,8,34,-20}}};return(A[k]);}

    public static int[][] cover6(int k) {
	int[][][] A={{{3,4,-12,8},{-10,12,1,0},{16,-4,1,0}},{{-10,12,1,0},{-23,20,14,-8},{29,-12,14,-8},{16,-4,1,0}},{{-23,20,14,-8},{-36,28,27,-16},{53,-27,6,-3},{-47,35,6,-3},{42,-20,27,-16},{29,-12,14,-8}},{{19,-6,-28,18},{-15,15,6,-3},{53,-27,6,-3}},{{-13,14,-28,18},{-47,35,6,-3},{21,-7,6,-3}},{{53,-27,6,-3},{87,-48,-2,2},{-81,56,-2,2},{-47,35,6,-3}},{{-15,15,6,-3},{-49,36,-2,2},{87,-48,-2,2},{53,-27,6,-3}},{{-47,35,6,-3},{-81,56,-2,2},{55,-28,-2,2},{21,-7,6,-3}},{{87,-48,-2,2},{11,-1,16,-9},{3,4,8,-4},{-5,9,16,-9},{-81,56,-2,2}},{{-47,35,-10,7},{42,-20,-31,20},{-13,14,24,-14}},{{53,-27,-10,7},{19,-6,24,-14},{-36,28,-31,20}},{{-49,36,-2,2},{-15,15,-10,7},{19,-6,24,-14},{53,-27,-10,7},{87,-48,-2,2}},{{-81,56,-2,2},{-47,35,-10,7},{-13,14,24,-14},{21,-7,-10,7},{55,-28,-2,2}},{{-191,124,-28,18},{-47,35,6,-3},{42,-20,-83,52}},{{197,-116,-28,18},{-36,28,-83,52},{53,-27,6,-3}},{{42,-20,27,-16},{-191,124,-28,18},{42,-20,-83,52},{-13,14,-28,18}},{{-36,28,27,-16},{19,-6,-28,18},{-36,28,-83,52},{197,-116,-28,18}},{{-81,56,-2,2},{-26,22,11,-6},{-47,35,-10,7}},{{-49,36,-2,2},{6,2,11,-6},{-15,15,-10,7}},{{-26,22,11,-6},{29,-12,24,-14},{-26,22,37,-22},{42,-20,-31,20},{-47,35,-10,7}},{{29,-12,24,-14},{-5,9,16,-9},{-26,22,37,-22}},{{55,-28,-2,2},{21,-7,-10,7},{0,6,11,-6}},{{87,-48,-2,2},{53,-27,-10,7},{32,-14,11,-6}},{{32,-14,11,-6},{53,-27,-10,7},{-36,28,-31,20},{32,-14,37,-22},{-23,20,24,-14}},{{-23,20,24,-14},{32,-14,37,-22},{-23,20,-18,12},{-78,54,37,-22}},{{-78,54,37,-22},{-23,20,-18,12},{11,-1,16,-9}}};return(A[k]);}

    public static int[][] cover5(int k) {
      int[][][] A={{{92,-52,13,-8},{-141,92,-42,26},{92,-52,-97,60},{37,-18,-42,26}},{{-196,126,-55,34},{92,-52,13,-8},{37,-18,-42,26},{-18,16,13,-8},{-107,71,34,-21}},{{-141,92,-42,26},{3,3,-8,5},{92,-52,-97,60}},{{37,-18,0,0},{-196,126,-55,34},{-107,71,34,-21}}};return(A[k]);}

    public static int[][] cover4(int k) {
	int[][][] A={{{-3,6,-2,2},{-16,14,11,-6},{-3,6,8,-4},{10,-2,11,-6}}};return(A[k]);}

    public static int[][] cover3(int k) {
	int[][][] A={{{8,-2,-3,2},{63,-36,10,-6},{21,-10,10,-6}},{{63,-36,10,-6},{29,-15,2,-1},{-55,37,2,-1},{34,-18,23,-14},{21,-10,10,-6}},{{-21,16,-32,20},{-55,37,2,-1},{13,-5,2,-1}},{{29,-15,2,-1},{-5,6,-6,4},{8,-2,-9,6},{-13,11,12,-7},{-55,37,2,-1}},{{-199,126,-32,20},{-55,37,2,-1},{34,-18,-87,54}},{{34,-18,23,-14},{-199,126,-32,20},{34,-18,-87,54},{-21,16,-32,20}},{{-5,6,-6,4},{-18,14,-9,6},{-5,6,4,-2},{8,-2,-9,6}},{{47,-26,-6,4},{13,-5,-14,9},{-8,8,7,-4}},{{76,-44,33,-20},{-13,11,12,-7},{21,-10,-22,14}},{{-34,24,7,-4},{21,-10,20,-12},{-34,24,33,-20},{-21,16,20,-12}},{{-55,37,2,-1},{-89,58,-6,4},{-55,37,-14,9},{-21,16,20,-12},{13,-5,-14,9},{47,-26,-6,4},{13,-5,2,-1}},{{-89,58,-6,4},{-34,24,7,-4},{-55,37,-14,9}},{{21,-10,20,-12},{76,-44,33,-20},{21,-10,-22,14},{-34,24,33,-20}}};return(A[k]);}
    public static int[][] cover2(int k) {
	int[][][] A={{{-18,14,-9,6},{37,-20,4,-2},{-5,6,4,-2}},{{37,-20,4,-2},{-18,14,17,-10},{-5,6,4,-2}},{{92,-54,17,-10},{-141,90,-38,24},{92,-54,-93,58},{37,-20,-38,24}},{{-196,124,-51,32},{92,-54,17,-10},{37,-20,-38,24},{-18,14,17,-10},{-107,69,38,-23}},{{-141,90,-38,24},{3,1,-4,3},{92,-54,-93,58}},{{37,-20,4,-2},{-196,124,-51,32},{-107,69,38,-23}}};return(A[k]);}


  public static int[][] cover1(int k) {
      int[][][] A={{{-6,6,-3,2},{-19,14,10,-6},{-61,40,10,-6}},{{-19,14,10,-6},{-32,22,23,-14},{57,-33,2,-1},{-27,19,2,-1},{-61,40,10,-6}},{{23,-12,-32,20},{-11,9,2,-1},{57,-33,2,-1}},{{20,-10,-9,6},{7,-2,4,-2},{-35,24,4,-2}},{{7,-2,4,-2},{20,-10,17,-10},{-35,24,4,-2}},{{201,-122,-32,20},{-32,22,-87,54},{57,-33,2,-1}},{{-32,22,23,-14},{23,-12,-32,20},{-32,22,-87,54},{201,-122,-32,20}},{{7,-2,-6,4},{-6,6,-9,6},{7,-2,4,-2},{20,-10,-9,6}},{{91,-54,-6,4},{57,-33,-14,9},{36,-20,7,-4}},{{57,-33,-14,9},{23,-12,20,-12},{-32,22,-35,22}},{{36,-20,7,-4},{57,-33,-14,9},{-32,22,-35,22},{36,-20,33,-20},{-19,14,20,-12}},{{57,-33,2,-1},{15,-7,12,-7},{-6,6,-9,6},{7,-2,-6,4},{-27,19,2,-1}},{{-11,9,2,-1},{-45,30,-6,4},{-11,9,-14,9},{23,-12,20,-12},{57,-33,-14,9},{91,-54,-6,4},{57,-33,2,-1}},{{-45,30,-6,4},{10,-4,7,-4},{-11,9,-14,9}},{{-19,14,20,-12},{36,-20,33,-20},{-19,14,-22,14},{-74,48,33,-20}},{{-74,48,33,-20},{-19,14,-22,14},{15,-7,12,-7}},{{-268,168,-51,32},{20,-10,17,-10},{-35,24,-38,24},{-90,58,17,-10},{-179,113,38,-23}},{{-90,58,17,-10},{-35,24,-38,24},{-90,58,-93,58},{143,-86,-38,24}},{{143,-86,-38,24},{-90,58,-93,58},{-1,3,-4,3}},{{-35,24,4,-2},{-268,168,-51,32},{-179,113,38,-23}}};return(A[k]);}

    public static int[][] cover0(int k) {
	int[][][] A={{{79,-47,-8,5},{11,-5,-8,5},{-10,8,13,-8}},{{-5,5,-8,5},{-73,47,-8,5},{16,-8,13,-8}},{{-141,89,-8,5},{147,-89,-8,5},{3,0,-42,26}},{{3,0,-42,26},{147,-89,-8,5},{-209,131,-8,5},{-31,21,34,-21},{58,-34,-55,34}},{{37,-21,34,-21},{215,-131,-8,5},{-141,89,-8,5},{3,0,-42,26},{-52,34,-55,34}},{{79,-47,-8,5},{113,-68,-16,10},{-23,16,-16,10},{11,-5,-8,5}},{{-5,5,-8,5},{29,-16,-16,10},{-107,68,-16,10},{-73,47,-8,5}},{{197,-120,-16,10},{19,-10,-16,10},{-36,24,39,-24}},{{-13,10,-16,10},{-191,120,-16,10},{42,-24,39,-24}},{{42,-24,39,-24},{-191,120,-16,10},{29,-16,-16,10},{-26,18,-29,18}},{{-23,16,-16,10},{197,-120,-16,10},{-36,24,39,-24},{32,-18,-29,18}},{{-141,89,-8,5},{-107,68,-16,10},{113,-68,-16,10},{147,-89,-8,5}},{{147,-89,-8,5},{58,-34,-29,18},{168,-102,81,-50},{-209,131,-8,5}},{{215,-131,-8,5},{-162,102,81,-50},{-52,34,-29,18},{-141,89,-8,5}},{{113,-68,-16,10},{58,-34,-3,2},{32,-18,-3,2},{-23,16,-16,10}},{{29,-16,-16,10},{-26,18,-3,2},{-52,34,-3,2},{-107,68,-16,10}},{{197,-120,-16,10},{53,-31,18,-11},{19,-10,-16,10}},{{-13,10,-16,10},{-47,31,18,-11},{-191,120,-16,10}},{{-191,120,-16,10},{-47,31,18,-11},{-26,18,-3,2},{29,-16,-16,10}},{{-23,16,-16,10},{32,-18,-3,2},{53,-31,18,-11},{197,-120,-16,10}},{{53,-31,18,-11},{142,-86,-3,2},{-104,66,-3,2},{-15,11,18,-11},{19,-10,-16,10}},{{21,-11,18,-11},{110,-66,-3,2},{-136,86,-3,2},{-47,31,18,-11},{-13,10,-16,10}},{{-107,68,-16,10},{37,-21,18,-11},{3,0,52,-32},{-31,21,18,-11},{113,-68,-16,10}},{{58,-34,-3,2},{3,0,10,-6},{87,-52,10,-6},{32,-18,-3,2}},{{-26,18,-3,2},{-81,52,10,-6},{3,0,10,-6},{-52,34,-3,2}},{{142,-86,-3,2},{87,-52,10,-6},{-49,32,10,-6},{-104,66,-3,2}},{{110,-66,-3,2},{55,-32,10,-6},{-81,52,10,-6},{-136,86,-3,2}},{{37,-21,2,-1},{-31,21,2,-1},{3,0,10,-6}},{{3,0,10,-6},{-31,21,2,-1},{53,-31,2,-1},{87,-52,10,-6}},{{-81,52,10,-6},{-47,31,2,-1},{37,-21,2,-1},{3,0,10,-6}},{{87,-52,10,-6},{53,-31,2,-1},{-15,11,2,-1},{-49,32,10,-6}},{{55,-32,10,-6},{21,-11,2,-1},{-47,31,2,-1},{-81,52,10,-6}},{{37,-21,2,-1},{29,-16,4,-2},{-23,16,4,-2},{-31,21,2,-1}},{{29,-16,4,-2},{-5,5,-4,3},{11,-5,-4,3},{-23,16,4,-2}},{{-5,5,-4,3},{3,0,-12,8},{11,-5,-4,3}},{{3,0,-12,8},{45,-26,-12,8},{-10,8,-25,16}},{{-39,26,-12,8},{3,0,-12,8},{16,-8,-25,16}},{{3,0,-12,8},{-10,8,1,0},{45,-26,-12,8}},{{-39,26,-12,8},{16,-8,1,0},{3,0,-12,8}},{{37,-21,22,-13},{126,-76,1,0},{-120,76,1,0},{-31,21,22,-13},{3,0,-12,8}},{{126,-76,1,0},{71,-42,14,-8},{-65,42,14,-8},{-120,76,1,0}},{{71,-42,14,-8},{37,-21,6,-3},{-31,21,6,-3},{-65,42,14,-8}},{{37,-21,6,-3},{3,0,40,-24},{-31,21,6,-3}},{{-52,34,-55,34},{3,0,-42,26},{58,-34,-55,34},{3,0,0,0}},{{359,-220,-42,26},{126,-76,13,-8},{215,-131,-76,47}},{{223,-136,-42,26},{-10,8,13,-8},{79,-47,-76,47}},{{346,-212,123,-76},{113,-68,-110,68},{-31,21,34,-21}},{{71,-42,68,-42},{215,-131,-76,47},{-162,102,-165,102}},{{-162,102,-165,102},{215,-131,-76,47},{126,-76,13,-8},{-107,68,68,-42},{126,-76,123,-76}},{{113,-68,68,-42},{-120,76,13,-8},{-65,42,68,-42},{-120,76,123,-76}},{{-73,47,-76,47},{-217,136,-42,26},{-73,47,-8,5},{215,-131,-8,5},{359,-220,-42,26},{215,-131,-76,47},{71,-42,68,-42}},{{-209,131,-76,47},{-353,220,-42,26},{-209,131,-8,5},{79,-47,-8,5},{223,-136,-42,26},{79,-47,-76,47},{-65,42,68,-42}},{{16,-8,13,-8},{-217,136,-42,26},{-73,47,-76,47}},{{-120,76,13,-8},{-353,220,-42,26},{-209,131,-76,47}},{{346,-212,123,-76},{113,-68,68,-42},{-120,76,123,-76},{113,-68,-110,68}},{{126,-76,123,-76},{-107,68,68,-42},{-340,212,123,-76},{-107,68,-110,68}},{{-107,68,-110,68},{-340,212,123,-76},{37,-21,34,-21}},{{71,-42,26,-16},{-162,102,81,-50},{-73,47,-8,5}},{{126,-76,39,-24},{-107,68,-16,10},{37,-21,-50,31}},{{113,-68,26,-16},{168,-102,-29,18},{-65,42,26,-16},{168,-102,81,-50}},{{29,-16,26,-16},{84,-50,-29,18},{-149,94,26,-16},{84,-50,81,-50}},{{-31,21,-118,73},{-175,110,-84,52},{-31,21,-50,31},{-120,76,39,-24},{168,-102,-29,18},{113,-68,26,-16}},{{-115,73,-118,73},{-259,162,-84,52},{-115,73,-50,31},{-204,128,39,-24},{84,-50,-29,18},{29,-16,26,-16}},{{58,-34,-29,18},{-175,110,-84,52},{-31,21,-118,73}},{{-26,18,-29,18},{-259,162,-84,52},{-115,73,-118,73}},{{-73,47,-8,5},{-162,102,81,-50},{215,-131,-8,5}},{{168,-102,81,-50},{-65,42,26,-16},{79,-47,-8,5}},{{84,-50,81,-50},{-149,94,26,-16},{-5,5,-8,5}},{{113,-68,-16,10},{-120,76,39,-24},{-31,21,-50,31}},{{29,-16,-16,10},{-204,128,39,-24},{-115,73,-50,31}},{{168,-102,81,-50},{-65,42,-152,94},{-209,131,-8,5}},{{-78,50,-29,18},{-23,16,-16,10},{32,-18,-29,18},{-23,16,26,-16}},{{71,-42,26,-16},{-162,102,-29,18},{-107,68,26,-16},{-162,102,81,-50}},{{155,-94,26,-16},{-78,50,-29,18},{-23,16,26,-16},{-78,50,81,-50}},{{155,-94,26,-16},{-78,50,81,-50},{11,-5,-8,5}},{{-209,131,-8,5},{-65,42,-152,94},{79,-47,-8,5}},{{-162,102,-29,18},{126,-76,39,-24},{37,-21,-50,31},{-52,34,-29,18},{-107,68,26,-16}},{{87,-52,52,-32},{142,-86,-3,2},{-91,58,52,-32},{142,-86,107,-66}},{{55,-32,52,-32},{110,-66,-3,2},{-123,78,52,-32},{110,-66,107,-66}},{{3,0,52,-32},{58,-34,-3,2},{-175,110,52,-32},{58,-34,107,-66}},{{414,-254,107,-66},{181,-110,52,-32},{-52,34,107,-66},{181,-110,-126,78}},{{362,-222,107,-66},{129,-78,52,-32},{-104,66,107,-66},{129,-78,-126,78}},{{330,-202,107,-66},{97,-58,52,-32},{-136,86,107,-66},{97,-58,-126,78}},{{142,-86,107,-66},{-91,58,52,-32},{-324,202,107,-66},{-91,58,-126,78}},{{110,-66,107,-66},{-123,78,52,-32},{-356,222,107,-66},{-123,78,-126,78}},{{58,-34,107,-66},{-175,110,52,-32},{-408,254,107,-66},{-175,110,-126,78}},{{-91,58,-126,78},{-324,202,107,-66},{53,-31,18,-11}},{{-123,78,-126,78},{-356,222,107,-66},{21,-11,18,-11}},{{-175,110,-126,78},{-408,254,107,-66},{-31,21,18,-11}},{{414,-254,107,-66},{181,-110,-126,78},{37,-21,18,-11}},{{362,-222,107,-66},{129,-78,-126,78},{-15,11,18,-11}},{{330,-202,107,-66},{97,-58,-126,78},{-47,31,18,-11}},{{608,-374,-3,2},{142,-86,-3,2},{231,-141,-92,57}},{{576,-354,-3,2},{110,-66,-3,2},{199,-121,-92,57}},{{524,-322,-3,2},{58,-34,-3,2},{147,-89,-92,57}},{{472,-290,-3,2},{6,-2,-3,2},{95,-57,-92,57}},{{440,-270,-3,2},{-26,18,-3,2},{63,-37,-92,57}},{{181,-110,52,-32},{-52,34,-3,2},{3,0,52,-32},{-52,34,107,-66}},{{129,-78,52,-32},{-104,66,-3,2},{-49,32,52,-32},{-104,66,107,-66}},{{97,-58,52,-32},{-136,86,-3,2},{-81,52,52,-32},{-136,86,107,-66}},{{-57,37,-92,57},{-434,270,-3,2},{608,-374,-3,2},{231,-141,-92,57},{87,-52,52,-32}},{{-89,57,-92,57},{-466,290,-3,2},{576,-354,-3,2},{199,-121,-92,57},{55,-32,52,-32}},{{-141,89,-92,57},{-518,322,-3,2},{524,-322,-3,2},{147,-89,-92,57},{3,0,52,-32}},{{-193,121,-92,57},{-570,354,-3,2},{472,-290,-3,2},{95,-57,-92,57},{-49,32,52,-32}},{{-225,141,-92,57},{-602,374,-3,2},{440,-270,-3,2},{63,-37,-92,57},{-81,52,52,-32}},{{32,-18,-3,2},{-434,270,-3,2},{-57,37,-92,57}},{{0,2,-3,2},{-466,290,-3,2},{-89,57,-92,57}},{{-52,34,-3,2},{-518,322,-3,2},{-141,89,-92,57}},{{-104,66,-3,2},{-570,354,-3,2},{-193,121,-92,57}},{{-136,86,-3,2},{-602,374,-3,2},{-225,141,-92,57}},{{320,-196,65,-40},{87,-52,10,-6},{231,-141,-24,15}},{{288,-176,65,-40},{55,-32,10,-6},{199,-121,-24,15}},{{236,-144,65,-40},{3,0,10,-6},{147,-89,-24,15}},{{184,-112,65,-40},{-49,32,10,-6},{95,-57,-24,15}},{{152,-92,65,-40},{-81,52,10,-6},{63,-37,-24,15}},{{-434,270,-3,2},{-201,126,-58,36},{320,-196,65,-40},{231,-141,-24,15},{375,-230,-58,36},{608,-374,-3,2}},{{-466,290,-3,2},{-233,146,-58,36},{288,-176,65,-40},{199,-121,-24,15},{343,-210,-58,36},{576,-354,-3,2}},{{-518,322,-3,2},{-285,178,-58,36},{236,-144,65,-40},{147,-89,-24,15},{291,-178,-58,36},{524,-322,-3,2}},{{-570,354,-3,2},{-337,210,-58,36},{184,-112,65,-40},{95,-57,-24,15},{239,-146,-58,36},{472,-290,-3,2}},{{-602,374,-3,2},{-369,230,-58,36},{152,-92,65,-40},{63,-37,-24,15},{207,-126,-58,36},{440,-270,-3,2}},{{32,-18,-3,2},{409,-251,86,-53},{786,-484,-291,180},{-434,270,-3,2}},{{0,2,-3,2},{377,-231,86,-53},{754,-464,-291,180},{-466,290,-3,2}},{{-52,34,-3,2},{325,-199,86,-53},{702,-432,-291,180},{-518,322,-3,2}},{{-104,66,-3,2},{273,-167,86,-53},{650,-400,-291,180},{-570,354,-3,2}},{{-136,86,-3,2},{241,-147,86,-53},{618,-380,-291,180},{-602,374,-3,2}},{{608,-374,-3,2},{375,-230,-58,36},{142,-86,-3,2}},{{576,-354,-3,2},{343,-210,-58,36},{110,-66,-3,2}},{{524,-322,-3,2},{291,-178,-58,36},{58,-34,-3,2}},{{472,-290,-3,2},{239,-146,-58,36},{6,-2,-3,2}},{{440,-270,-3,2},{207,-126,-58,36},{-26,18,-3,2}},{{-201,126,-58,36},{786,-484,-291,180},{409,-251,86,-53}},{{-233,146,-58,36},{754,-464,-291,180},{377,-231,86,-53}},{{-285,178,-58,36},{702,-432,-291,180},{325,-199,86,-53}},{{-337,210,-58,36},{650,-400,-291,180},{273,-167,86,-53}},{{-369,230,-58,36},{618,-380,-291,180},{241,-147,86,-53}},{{-47,31,2,-1},{42,-24,-19,12},{16,-8,7,-4},{37,-21,2,-1}},{{-13,10,-6,4},{42,-24,7,-4},{29,-16,-6,4},{42,-24,-19,12}},{{42,-24,7,-4},{-26,18,-9,6},{-5,5,12,-7},{16,-8,7,-4},{29,-16,-6,4}},{{-10,8,7,-4},{-78,50,-9,6},{-57,37,12,-7},{-36,24,7,-4},{-23,16,-6,4}},{{-23,16,-6,4},{-36,24,7,-4},{19,-10,-6,4},{-36,24,-19,12}},{{53,-31,2,-1},{-36,24,-19,12},{-15,11,2,-1}},{{-31,21,2,-1},{-10,8,7,-4},{-36,24,-19,12},{53,-31,2,-1}},{{-13,10,-6,4},{42,-24,-19,12},{21,-11,2,-1}},{{21,-11,2,-1},{42,-24,-19,12},{-47,31,2,-1}},{{-36,24,-19,12},{19,-10,-6,4},{-15,11,2,-1}},{{-26,18,-9,6},{29,-16,4,-2},{-5,5,12,-7}},{{-78,50,-9,6},{-23,16,4,-2},{-57,37,12,-7}},{{45,-26,30,-18},{100,-60,-25,16},{-133,84,30,-18},{100,-60,85,-52}},{{-99,63,-114,71},{-243,152,-80,50},{-99,63,-46,29},{-188,118,43,-26},{100,-60,-25,16},{45,-26,30,-18}},{{-10,8,-25,16},{-243,152,-80,50},{-99,63,-114,71}},{{100,-60,85,-52},{-133,84,30,-18},{11,-5,-4,3}},{{45,-26,-12,8},{-188,118,43,-26},{-99,63,-46,29}},{{-94,60,-25,16},{-39,26,-12,8},{16,-8,-25,16},{-39,26,30,-18}},{{139,-84,30,-18},{-94,60,-25,16},{-39,26,30,-18},{-94,60,85,-52}},{{139,-84,30,-18},{-94,60,85,-52},{-5,5,-4,3}},{{71,-42,56,-34},{126,-76,1,0},{-107,68,56,-34},{126,-76,111,-68}},{{346,-212,111,-68},{113,-68,56,-34},{-120,76,111,-68},{113,-68,-122,76}},{{126,-76,111,-68},{-107,68,56,-34},{-340,212,111,-68},{-107,68,-122,76}},{{-107,68,-122,76},{-340,212,111,-68},{37,-21,22,-13}},{{346,-212,111,-68},{113,-68,-122,76},{-31,21,22,-13}},{{592,-364,1,0},{126,-76,1,0},{215,-131,-88,55}},{{456,-280,1,0},{-10,8,1,0},{79,-47,-88,55}},{{113,-68,56,-34},{-120,76,1,0},{-65,42,56,-34},{-120,76,111,-68}},{{-73,47,-88,55},{-450,280,1,0},{592,-364,1,0},{215,-131,-88,55},{71,-42,56,-34}},{{-209,131,-88,55},{-586,364,1,0},{456,-280,1,0},{79,-47,-88,55},{-65,42,56,-34}},{{16,-8,1,0},{-450,280,1,0},{-73,47,-88,55}},{{-120,76,1,0},{-586,364,1,0},{-209,131,-88,55}},{{304,-186,69,-42},{71,-42,14,-8},{215,-131,-20,13}},{{168,-102,69,-42},{-65,42,14,-8},{79,-47,-20,13}},{{-450,280,1,0},{-217,136,-54,34},{304,-186,69,-42},{215,-131,-20,13},{359,-220,-54,34},{592,-364,1,0}},{{-586,364,1,0},{-353,220,-54,34},{168,-102,69,-42},{79,-47,-20,13},{223,-136,-54,34},{456,-280,1,0}},{{16,-8,1,0},{393,-241,90,-55},{770,-474,-287,178},{-450,280,1,0}},{{-120,76,1,0},{257,-157,90,-55},{634,-390,-287,178},{-586,364,1,0}},{{592,-364,1,0},{359,-220,-54,34},{126,-76,1,0}},{{456,-280,1,0},{223,-136,-54,34},{-10,8,1,0}},{{-217,136,-54,34},{770,-474,-287,178},{393,-241,90,-55}},{{-353,220,-54,34},{634,-390,-287,178},{257,-157,90,-55}},{{-52,34,-15,10},{3,0,-2,2},{58,-34,-15,10},{3,0,40,-24}},{{181,-110,40,-24},{-52,34,95,-58},{37,-21,6,-3}},{{181,-110,40,-24},{-52,34,-15,10},{3,0,40,-24},{-52,34,95,-58}},{{3,0,40,-24},{58,-34,-15,10},{-175,110,40,-24},{58,-34,95,-58}},{{58,-34,95,-58},{-175,110,40,-24},{-408,254,95,-58},{-175,110,-138,86}},{{-175,110,-138,86},{-408,254,95,-58},{-31,21,6,-3}}};return(A[k]);}




    /**Our proof shows that renormalization brings all but 11 renorm-A tiles closer to the origin.  
       The indices for the 11 bad tiles are given in the routine superMinimizers.  For
       each superminimizer A, we let B=B(A) be the B-renorm tile such that A->B and
       B lies above the x-axis. The tile B is again a finite union of A tiles. 
       In this way, each superminimizer
       gives rise to a finite list of new renorm-A tiles.  Here is the list of these
       tiles.**/

    /**The B tiles**/


    public static int[][] renormB(int choice) {
	if(choice==0) return(renormB0());
	if(choice==1) return(renormB1());
	if(choice==2) return(renormB2());
	if(choice==3) return(renormB3());
	if(choice==4) return(renormB4());
	if(choice==5) return(renormB5());
	if(choice==6) return(renormB6());
	if(choice==7) return(renormB7());
	if(choice==8) return(renormB8());
	if(choice==9) return(renormB9());
	if(choice==10) return(renormB10());
	if(choice==11) return(renormB11());
	return(null);
    }



    public static int[][] renormB0() {
       int[][] A={{-11,9,-2,1},{-32,22,-23,14},{57,-33,-2,1}};return(A);
    }

    public static int[][] renormB1() {
	int[][] A={{-55,37,-2,1},{34,-18,-23,14},{13,-5,-2,1}};return(A);
    }


    public static int[][] renormB2() {
       int[][] A={{-45,34,-2,0},{10,0,11,-8},{-11,13,-10,5}};
       return(A);
    }

    public static int[][] renormB11() {
       int[][] A={{-45,34,-2,0},{10,0,11,-8},{-11,13,-10,5}};
       return(A);
    }

    public static int[][] renormB7() {
	int[][] A={{-6,12,11,-8},{49,-22,24,-16},{-6,12,37,-24},{62,-30,-31,18},{-27,25,-10,5}};
	return(A);
    }

    public static int[][] renormB6() {
	int[][] A={{49,-22,24,-16},{15,-1,16,-11},{-6,12,37,-24}};
	return(A);
    }

    public static int[][] renormB5() {
	int[][] A={{-102,72,37,-24},{-47,38,-18,10},{-13,17,16,-11}};
	return(A);
    }

    public static int[][] renormB4() {
       int[][] A={{-47,38,24,-16},{8,4,37,-24},{-47,38,-18,10},{-102,72,37,-24}};
       return(A);
    }

    public static int[][] renormB3() {
       int[][]A={{8,4,11,-8},{29,-9,-10,5},{-60,46,-31,18},{8,4,37,-24},{-47,38,24,-16}};
       return(A);
    }

    public static int[][] renormB8() {
	int[][] A={{7,4,-18,10},{83,-43,0,-1},{-137,93,0,-1},{-103,72,8,-6}};
	return(A);
    }

    public static int[][] renormB9() {
	int[][] A={{-103,72,8,-6},{-48,38,21,-14},{-69,51,0,-1}};
    return(A);
    }


    public static int[][] renormB10() {
	int[][] A={{-48,38,21,-14},{-137,93,0,-1},{-69,51,0,-1}};
    return(A);
    }




    /**THE A RENORM TILES**/

    public static int[][] renormA(int choice,int k) {
	if(choice==0) return(renormA0(k));
	if(choice==1) return(renormA1(k));
	if(choice==2) return(renormA2(k));
	if(choice==3) return(renormA3(k));
	if(choice==4) return(renormA4(k));
	if(choice==5) return(renormA5(k));
	if(choice==6) return(renormA6(k));
	if(choice==7) return(renormA7(k));
	if(choice==8) return(renormA8(k));
	if(choice==9) return(renormA9(k));
	if(choice==10) return(renormA10(k));
	if(choice==11) return(renormA11(k));
	return(null);
    }

   public static int[][] renormA0(int k) {
       int[][][] A={{{-11,9,-2,1},{23,-12,32,-20},{57,-33,-2,1}},{{57,-33,-2,1},{-32,22,87,-54},{201,-122,32,-20}},{{-32,22,87,-54},{23,-12,32,-20},{-32,22,-23,14},{201,-122,32,-20}}};return(A[k]);}

  public static int[][] renormA1(int k) {
      int[][][] A={{{-55,37,-2,1},{-21,16,32,-20},{13,-5,-2,1}},{{-55,37,-2,1},{34,-18,-23,14},{-21,16,32,-20}}};return(A[k]);}


 public static int[][] renormA2(int k) {
     int[][][] A={{{-45,34,-2,0},{-278,178,-57,34},{-189,123,32,-21}},{{-278,178,-57,34},{10,0,11,-8},{-45,34,-44,26},{-100,68,11,-8},{-189,123,32,-21}},{{-100,68,11,-8},{-45,34,-44,26},{-100,68,-99,60},{133,-76,-44,26}},{{133,-76,-44,26},{-100,68,-99,60},{-11,13,-10,5}}};return(A[k]);}


    public static int[][] renormA8(int k) {
	int[][][] A={{{-6,12,11,-8},{-95,67,-10,5},{261,-153,-10,5},{-116,80,-99,60}},{{-116,80,-99,60},{261,-153,-10,5},{-27,25,-10,5}},{{-95,67,-10,5},{49,-22,24,-16},{-6,12,37,-24},{62,-30,-31,18},{-27,25,-10,5}}};return(A[k]);}

  public static int[][] renormA7(int k) {
      int[][][] A={{{49,-22,24,-16},{-184,122,-31,18},{49,-22,202,-126},{282,-166,-31,18}},{{-184,122,-31,18},{193,-111,58,-37},{49,-22,202,-126}},{{282,-166,-31,18},{49,-22,202,-126},{-95,67,58,-37}},{{49,-22,202,-126},{193,-111,58,-37},{337,-200,92,-58},{193,-111,126,-79},{49,-22,-18,10},{-6,12,37,-24},{-95,67,58,-37}},{{337,-200,92,-58},{104,-56,37,-24},{193,-111,126,-79}},{{104,-56,37,-24},{-129,88,-18,10},{49,-22,-18,10}},{{-129,88,-18,10},{104,-56,-73,44},{49,-22,-18,10}},{{-129,88,-18,10},{15,-1,16,-11},{104,-56,-73,44}}};return(A[k]);}


    public static int[][] renormA6(int k) {
	int[][][] A={{{-102,72,37,-24},{-47,38,-18,10},{131,-72,-18,10}},{{-47,38,-18,10},{-102,72,-73,44},{131,-72,-18,10}},{{131,-72,-18,10},{-102,72,-73,44},{-13,17,16,-11}}};return(A[k]);}


    public static int[][] renormA5(int k) {
	int[][][] A={{{241,-140,92,-58},{8,4,37,-24},{97,-51,126,-79}},{{-47,38,202,-126},{97,-51,58,-37},{241,-140,92,-58},{97,-51,126,-79},{-47,38,-18,10},{-102,72,37,-24},{-191,127,58,-37}},{{-280,182,-31,18},{97,-51,58,-37},{-47,38,202,-126}},{{186,-106,-31,18},{-47,38,202,-126},{-191,127,58,-37}},{{-47,38,24,-16},{-280,182,-31,18},{-47,38,202,-126},{186,-106,-31,18}}};return(A[k]);}


    public static int[][] renormA4(int k) {
	int[][][] A={{{8,4,11,-8},{118,-64,-99,60},{-259,169,-10,5},{97,-51,-10,5}},{{118,-64,-99,60},{29,-9,-10,5},{-259,169,-10,5}},{{-259,169,-10,5},{-81,59,-52,31},{8,4,37,-24},{-47,38,24,-16},{97,-51,-10,5}},{{29,-9,-10,5},{173,-98,24,-16},{29,-9,58,-37},{-115,80,-86,52},{-170,114,-31,18},{-259,169,-10,5}},{{173,-98,24,-16},{-60,46,-31,18},{173,-98,202,-126},{406,-242,-31,18}},{{406,-242,-31,18},{173,-98,202,-126},{29,-9,58,-37}},{{-259,169,58,-37},{-115,80,-86,52},{118,-64,147,-92}},{{-170,114,-31,18},{-259,169,58,-37},{118,-64,147,-92},{-81,59,-52,31}}};return(A[k]);}


    public static int[][] renormA3(int k) {
	int[][][] A={{{-45,34,-2,0},{-278,178,-57,34},{-189,123,32,-21}},{{-278,178,-57,34},{10,0,11,-8},{-45,34,-44,26},{-100,68,11,-8},{-189,123,32,-21}},{{-100,68,11,-8},{-45,34,-44,26},{-100,68,-99,60},{133,-76,-44,26}},{{133,-76,-44,26},{-100,68,-99,60},{-11,13,-10,5}}};return(A[k]);}

 public static int[][] renormA9(int k) {
     int[][][] A={{{7,4,-18,10},{151,-85,16,-11},{240,-140,-73,44}},{{240,-140,-73,44},{7,4,160,-100},{-137,93,16,-11}},{{7,4,160,-100},{151,-85,16,-11},{295,-174,50,-32},{528,-318,-5,2},{-514,326,-5,2},{-281,182,50,-32},{-137,93,16,-11}},{{295,-174,50,-32},{62,-30,-5,2},{528,-318,-5,2}},{{706,-428,283,-176},{-514,326,-5,2},{1926,-1182,-5,2},{939,-572,-238,146},{329,-195,-94,57}},{{939,-572,-238,146},{1926,-1182,-5,2},{-48,38,-5,2}},{{-281,182,50,-32},{706,-428,283,-176},{329,-195,-94,57}},{{62,-30,-5,2},{-315,203,-382,235},{-1912,1190,-5,2}},{{-1912,1190,-5,2},{-315,203,-382,235},{295,-174,228,-142},{905,-551,-382,235},{2502,-1538,-5,2}},{{2502,-1538,-5,2},{905,-551,-382,235},{528,-318,-5,2}},{{528,-318,-5,2},{295,-174,228,-142},{528,-318,461,-286},{-459,292,228,-142}},{{-459,292,228,-142},{528,-318,461,-286},{151,-85,84,-53}},{{528,-318,-5,2},{151,-85,84,-53},{7,4,-60,36},{-137,93,84,-53},{-514,326,-5,2}},{{-514,326,-5,2},{-137,93,84,-53},{-281,182,228,-142}},{{-514,326,-5,2},{-281,182,228,-142},{-48,38,-5,2}},{{62,-30,-5,2},{-171,114,-60,36},{62,-30,-115,70},{7,4,-60,36}},{{-171,114,-60,36},{-27,25,-26,15},{62,-30,-115,70}},{{7,4,-60,36},{-27,25,-26,15},{117,-64,8,-6},{-103,72,8,-6},{41,-17,-26,15}},{{117,-64,8,-6},{151,-85,0,-1},{-137,93,0,-1},{-103,72,8,-6}},{{117,-64,8,-6},{-116,80,-47,28},{-27,25,42,-27}},{{-116,80,-47,28},{172,-98,21,-14},{117,-64,-34,20},{62,-30,21,-14},{-27,25,42,-27}},{{172,-98,21,-14},{-61,46,-34,20},{172,-98,-89,54},{117,-64,-34,20}},{{-61,46,-34,20},{83,-43,0,-1},{172,-98,-89,54}},{{172,-98,-89,54},{83,-43,0,-1},{-205,135,0,-1}},{{62,-30,21,-14},{172,-98,-89,54},{-205,135,0,-1},{151,-85,0,-1}},{{-48,38,-5,2},{7,4,-60,36},{-48,38,-115,70},{185,-106,-60,36}},{{185,-106,-60,36},{-48,38,-115,70},{41,-17,-26,15}}};return(A[k]);}

 public static int[][] renormA10(int k) {
     int[][][] A={{{-103,72,8,-6},{-336,216,-47,28},{-247,161,42,-27}},{{-336,216,-47,28},{-48,38,21,-14},{-103,72,-34,20},{-158,106,21,-14},{-247,161,42,-27}},{{-158,106,21,-14},{-103,72,-34,20},{-158,106,-89,54},{75,-38,-34,20}},{{75,-38,-34,20},{-158,106,-89,54},{-69,51,0,-1}}};return(A[k]);}


    public static int[][] renormA11(int k) {
	int[][][] A={{{-48,38,21,-14},{-137,93,0,-1},{219,-127,0,-1},{-158,106,-89,54}},{{-158,106,-89,54},{219,-127,0,-1},{-69,51,0,-1}}};return(A[k]);
    }


}