import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DataRenorm  {

    public DataRenorm() {} 


    /**This class defines the renormalization polyhedra
       and gives routines for manipulating them.  As in
       the paper, we have sets A subset B.  The set B is
       made from 24=4x6 polyhedra.  The set A is obtained
       by pulling back the members of B under various
       contractions or isometries.**/


    /**THE MAPS BETWEEN A AND B**/

    public static Vector AtoB(int LA,int LB,int branch,Vector V) {
       int[] AFF=DataRenormRaw.getAffine(LA,LB,branch);
       Vector W=Vector.affineInverse(AFF,V);
       return(W);
    }

    public static Vector BtoA(double h,int LB,int branch,Vector V) {
       int LA=Characteristics.getInterval2(h);
       int[] AFF=DataRenormRaw.getAffine(LA,LB,branch);
       Vector W=Vector.affine(AFF,V);
       return(W);
    }




    /**DETECTING WHEN A POINT IS INSIDE THE A RENORM SET**/

    public static boolean insideA(Vector V) {
	for(int i=0;i<4;++i) {
	    if(insideA(i,V)==true) return(true);
	}
	return(false);
    }

    public static int[] indexA(Vector V) {
	int[] L=Characteristics.getCharA(V.x[2]);
	for(int branch=0;branch<4;++branch) {
	    if(insideA(L[0],L[1],branch,V)==true) {
		int[] index={L[0],L[1],branch};
		return(index);
	    }
	}
	return(null);
    }

    public static boolean insideA(int branch,Vector V) {
	int[] L=Characteristics.getCharA(V.x[2]);
	return(insideA(L[0],L[1],branch,V));
    }

    public static boolean insideA(int LA,int LB,int branch,Vector V) {
	GoldenPolyhedron P=getGoldenA(LA,LB,branch);
	int[] N=DataRenormRaw.polyNormal(LB,branch);
	int[] A=DataRenormRaw.faceAnchor(LB,branch);
	for(int i=0;i<A.length;++i) {
	   GoldenVector gn=DataPartition.getNormal(N[i]);
	   Vector n=gn.toVector();
	   Vector p0=P.V[A[i]].toVector();
	   double test=Vector.dot(n,Vector.minus(p0,V));
	   if(test>-.0000000001) test=0;
	   if(test<0) return(false);
	}
	return(true);
    }


    /**DETECTING WHEN A POINT IS INSIDE THE B RENORM SET**/

    public static boolean insideB(Vector V) {
	for(int i=0;i<4;++i) {
	    if(insideB(i,V)==true) return(true);
	}
	return(false);
    }

    public static boolean insideB(int branch,Vector V) {
	int LB=Characteristics.getInterval1(V.x[2]);
	return(insideB(LB,branch,V));
    }


    public static int[] indexB(Vector V) {
	int LB=Characteristics.getInterval1(V.x[2]);
	for(int branch=0;branch<4;++branch) {
	    if(insideB(LB,branch,V)==true) {
		int[] index={LB,branch};
		return(index);
	    }
	}
	return(null);
    }

    public static boolean insideB(int LB,int branch,Vector V) {
	GoldenPolyhedron P=getGoldenB(LB,branch);
	int[] N=DataRenormRaw.polyNormal(LB,branch);
	int[] A=DataRenormRaw.faceAnchor(LB,branch);
	for(int i=0;i<A.length;++i) {
	   GoldenVector gn=DataPartition.getNormal(N[i]);
	   Vector n=gn.toVector();
	   Vector p0=P.V[A[i]].toVector();
	   double test=Vector.dot(n,Vector.minus(p0,V));
	   if(test>-.0000000001) test=0;
	   if(test<0) return(false);
	}
	return(true);
    }


    /**GETTING THE POLYHEDRA**/

    public static Polyhedron getB(int LB,int branch) {
	GoldenPolyhedron IP=getGoldenB(LB,branch);
	Polyhedron P=IP.toPolyhedron();
	return(P);
    }

    public static GoldenPolyhedron getGoldenB(int LB,int branch) {
	    int[][] vertex=DataRenormRaw.B(LB,branch);
            GoldenPolyhedron P=new GoldenPolyhedron(vertex);
	    return(P);
    }

    public static Polyhedron getA(int LA,int LB,int branch) {
	GoldenPolyhedron IP=getGoldenA(LA,LB,branch);
	if(IP==null) return(null); 
	Polyhedron P=IP.toPolyhedron();
	return(P);
    }

    public static GoldenPolyhedron getGoldenA(int LA,int LB,int branch) {
	if((LA==0)&&(LB==5)) return(null);
	if((LA==1)&&(LB!=5)) return(null);
	if((LA==3)&&(LB!=0)) return(null);
	if((LA==4)&&(LB==0)) return(null);
        GoldenPolyhedron P=getGoldenB(LB,branch);
	P=P.affine(DataRenormRaw.getAffine(LA,LB,branch));
        return(P);
    }

    public static Polyhedron getA(int branch, Vector V) {
	double h=V.x[2];
	int LA=Characteristics.getInterval2(h);
	double h1=GroupAction.map(h);
	int LB=Characteristics.getInterval1(h1);
	return(getA(LA,LB,branch));
    }


    public static Polyhedron getB(int branch, Vector V) {
	int LB=Characteristics.getInterval1(V.x[2]);
	return(getB(LB,branch));
    }


    /**POLYHEDRON SLICING ROUTINES **/

    public static PolyWedge polyA(int LA,int LB,int branch,Vector F0,Vector F1,Vector POS,boolean center) {
	Polyhedron P=getA(LA,LB,branch);
	if(P==null) return(null);
	PolyWedge Q=PolyhedronSlicer.slice(F0,F1,POS,P,center);
	if(Q==null) return(null);
	if(Q.count==0) return(null);
	Q=Q.trim();
	return(Q);
    }

    public static PolyWedge polyB(int LB,int branch,Vector F0,Vector F1,Vector POS,boolean center) {
	Polyhedron P=getB(LB,branch);
	PolyWedge Q=PolyhedronSlicer.slice(F0,F1,POS,P,center);
	if(Q==null) return(null);
	if(Q.count==0) return(null);
	Q=Q.trim();
	return(Q);
    }




}