import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class contains the data for the first return map to the renorm sets*/

public class DataRenormReturn  {



    /**lengths of the lists below**/
    public static int limits(int LB,int branch) {
int[][]A={{39,30,29,24},{47,48,9,21},{17,15,25,35}};
if(LB<3) return(A[LB][branch]);
return(A[5-LB][branch]);
    }

    public static Polyhedron getA(int LA,int LB,int branch,int k,int direction) {
	GoldenPolyhedron GP=getGoldenA(LA,LB,branch,k,direction);
	if(GP==null) return(null);
	return(GP.toPolyhedron());
    }

    public static GoldenPolyhedron getGoldenA(int LA,int LB,int branch,int k,int direction) {
	if((LA==0)&&(LB==5)) return(null);
	if((LA==1)&&(LB!=5)) return(null);
	if((LA==3)&&(LB!=0)) return(null);
	if((LA==4)&&(LB==0)) return(null);
	int dir2=1-direction;
	if(LA%2==1) dir2=1-dir2;
        GoldenPolyhedron P=getGoldenB(LB,branch,k,dir2);

	if(dir2==0) {
	  int[] u=DataRenormRaw.getAffine(LA,LB,branch);
          return(P.affine(u));
	}
	  int branch2=branch;
	  if(LB==0) branch2=DataRenormReturnRaw.convert0(branch,k);
	  if(LB==5) branch2=DataRenormReturnRaw.convert5(branch,k);
	  int[] u=DataRenormRaw.getAffine(LA,LB,branch2);
          return(P.affine(u));
    }




    public static Polyhedron getB(int LB,int branch,int k,int direction) {
	GoldenPolyhedron GP=getGoldenB(LB,branch,k,direction);
	if(GP==null) return(null);
	return(GP.toPolyhedron());
    }

    public static GoldenPolyhedron getGoldenB(int LB,int branch,int k,int direction) {
	if(k>=limits(LB,branch)) return(null);
	int[][] A=P(LB,branch,k);
	GoldenPolyhedron P=new GoldenPolyhedron(A);
	if(direction==0) return(P);
	GoldenVector V=getReturn(LB,branch,k);
	P=P.translate(V);
	return(P);
    }
    /**the polyhedra**/

    public static int[][] P(int LB,int branch,int k) {
	if(LB<3) return(P0(LB,branch,k));
	int[][] A=P0(5-LB,branch,k);
        for(int i=0;i<A.length;++i) {
	     A[i][0]=2-A[i][0];
	     A[i][1]=0-A[i][1];
	     A[i][2]=2-A[i][2];
	     A[i][3]=0-A[i][3];
	     A[i][4]=2-A[i][4];
	     A[i][5]=0-A[i][5];
   	  }
	return(A);
    }

    public static int[][] P0(int LB,int branch,int k) {
	int[] LIST=DataRenormReturnRaw.vertexList(4*LB+branch,k);
	int t=LIST.length;
       int[][] A=new int[t][6];
       for(int i=0;i<t;++i) A[i]=DataRenormReturnRaw.V(LIST[i]);
       return(A);
    }


    public static GoldenVector getReturn(int LB,int branch,int number) {
	int[] a=new int[6];
	if(LB==0) a=DataRenormReturnRaw.getReturn0(branch,number);
	if(LB==1) a=DataRenormReturnRaw.getReturn1(branch,number);
	if(LB==2) a=DataRenormReturnRaw.getReturn2(branch,number);
	if(LB==3) a=getReturn3(branch,number);
	if(LB==4) a=getReturn4(branch,number);
	if(LB==5) a=getReturn5(branch,number);
	return(new GoldenVector(a));
    }

    /**The return vectors**/


    public static int[] getReturn3(int branch,int number) {
	int[] a=DataRenormReturnRaw.getReturn2(branch,number);
	for(int i=0;i<6;++i) a[i]=-a[i];
	return(a);
    }


    public static int[] getReturn4(int branch,int number) {
	int[] a=DataRenormReturnRaw.getReturn1(branch,number);
	for(int i=0;i<6;++i) a[i]=-a[i];
	return(a);
    }

    public static int[] getReturn5(int branch,int number) {
	int[] a=DataRenormReturnRaw.getReturn0(branch,number);
	for(int i=0;i<6;++i) a[i]=-a[i];
	return(a);
    }



    /**FINDS WHICH POLYHEDRON CONTAINS THE VECTOR**/

    public static int[] locateA(Vector V) {
	if(DataRenorm.insideA(V)==false) return(null);
	int[] L=Characteristics.getCharA(V.x[2]);
	GoldenVector W=GoldenVector.bestFit(V,500);
	for(int b=0;b<4;++b) {
     	   int lim=limits(L[1],b);
	   for(int k=0;k<lim;++k) {
	     GoldenPolyhedron P=getGoldenA(L[0],L[1],b,k,0);
	     if(P!=null) {
	       if(GoldenPolyCombinatorics.inside(P,W)==true) {
		   int[] X={L[0],L[1],b,k};
	           return(X);
	       }
	     }
	   }
	}
	return(null);
    }



}