import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Document3D {
    Manager M;
    public Document3D(Manager MM) {
	this.M=MM;
    }

    public void polyInfo() {

	String S="polyhedron exchange window.";
	S=S+"\n\nThis is one of the polyhedron exchange windows.   This window lets you explore the dynamics of the polyhedron exchange map Psi_hat from the paper.  The domain for the dynamics is a 3-torus, but we take a particularly useful fundamental domain which is a parallelogram cross the interval [0,2].";

	S=S+"\n\nSince we are representing a 3 dimensional set in a 2 dimensional window, we have to draw slices.  The long blue slider above the window allows you to change slice. Also, if you push the 'animate' button, you can see the slices move continuously.";

        S=S+"\n\nYou activate the controls for this window by clicking the 3D poly mode on the top red control panel at far left. Once you activate this mode, auxilliary controls pop up.  You can read about the function of these controls by clicking on their info buttons.";

S=S+"\n\n You interact with this window using mouse clicks and/or keyboard inputs:";

	S=S+"\n\nbutton 1 or key-z: zoom in.";
	S=S+"\n\nbutton 2 or key-x: select a point.";
	S=S+"\n\nbutton 1 or key-c: zoom out.";
	S=S+"\n\nOnce you select a point, you need to press the go button to see any kind of action.  What happens when you press go depends on the settings of the auxilliary controls.";

	S=S+"\n\nThe left and right PE windows are sliced at different heights.  The heights are related by the circle renormalization map R in our paper.  Thus, as you slice through the left window at a certain rate, the right window is sliced at a rate that is, on average, 3 times as fast.  On the long blue slider, the short fat marker indicates the slice of the left window and the long thin marker indicates the slice of the right window.";

	S=S+"\n\nThe left PE window is the main one, but you can choose to focus on the other one, by clicking on the two sides of the focus bar at bottom left.  The focus tells the computer program which window to plot in.";

	S=S+"\n\nThe long thin window above this one gives you other ways to manipulate the slices.  You can read about it by pressing the info boxes on this window.";

	M.D.setExplain(S);
	M.D.repaint();
    }



    public void foliationInfo() {

	String S="theta image display.";
 
	S=S+"\n\nThe compactification theorem gives us a map Theta from the strip Sigma to the 3-torus Sigma_hat. Theta maps each horizontal like to a dense geodesic in a horizontal slice of the 3-torus.  This control panel lets you see this image.  There are 4 buttons, corresponding to the images of 4 rays, going forwards and backwards, whose union is 2 lines.  The arrow keys control the extent of the plot.";

	M.D.setExplain(S);
	M.D.repaint();
    }



    public void showInfo() {

	String S="auxilliary object display.";
 
	S=S+"\n\nThis control panel lets you display and recolor various auxilliary objects. The left hand column of buttons controls the colors and the right hand column toggles the display of the objects. You change the color by clicking on a left hand button.  The new color is the one currently on the color selector. Here are the objects.";

	S=S+"\n\ncrosshairs: This records the currently selected point.";

	S=S+"\n\npoly select: The polyhedron exchange map is comprised of 64 polyhedra. When this option is on, it allows you to highlight the polyhedron of your choice. When you highlight the polyhedron, the coordinates of its vertices appear at lower right.  You can either select a polygon by using the arrow keys that pop up, or by directly clicking in the PE window.";

	S=S+"\n\nvtx select: This works in tandem with the poly selector. Each polyhedron is displayed as a polygon, obtained by slicing the polyhedron with a horizontal plane.  The vtx selector lets you point to the vertices of this polygon.  It is useful if want to know the coordinates of a particular vertex that is displayed.  You select the vertex with an auxilliary set of arrow keys that pops up.";

	S=S+"\n\nMap image: This shows the image of the left PE exchange under the PE map Psi_hat.  The image turns out to be an offset and rotated copy of the original domain.   To get a map from the domain to itself, one takes the points in the displayed image and translates them back into the fundamental domain by subtracting off suitable even integers from the coordinates.";

	S=S+"\n\nrenorm slice: This turns on and off the display in the right PE window.  The right PE window is auxilliary, and only needed for some purposes.  Sometimes it is useful to turn it off.  For instance, it does not interact well with the navigator feature. The navigator feature is explained by the info box by the navigator button.";


	

	S=S+"\n\nA set: This shows the A renormalization set in the left PE window.  When the A set is shown in the left window and the B set is shown in the right window, there is a link set up betwen the two windows which does the renormalization map. If you click on a point in the A-set on the left then the corresponding point is selected in the B-set on the right. If you then plot orbits of the corresponding selected points, you can see the renormalization theorem in action.";

	S=S+"\n\nA atoms: This shows the partition of the A-set into forward A-atoms.  The image appears in the left PE window.";


	S=S+"\n\nA atoms->: This shows the partition of the A-set into backward A-atoms.  The backward A-atoms are the images of the forward A-atoms under the first return map to the A-set.  The image appears in the left PE window.";




	S=S+"\n\nB set: This shows the B renormalization set in the right PE window.  When the A set is shown in the left window and the B set is shown in the right window, there is a link set up betwen the two windows which does the renormalization map. If you click on a point in the A-set on the left then the corresponding point is selected in the B-set on the right. If you then plot orbits of the corresponding selected points, you can see the renormalization theorem in action.";

	S=S+"\n\nB atoms: This shows the partition of the B-set into forward B-atoms.  The image appears in the right PE window";


	S=S+"\n\nB atoms->: This shows the partition of the B-set into backward B-atoms.  The backward B-atoms are the images of the forward B-atoms under the first return map tp the A-set.  The image appears in the right PE window.";





	S=S+"\n\nB set(2): This shows the B renormalization set in the left PE window.  If you also turn on the A-set, you can directly compare the A-set and the B-set in the same horizontal slice.";

	S=S+"\n\nB atoms(2): This shows the partition of the B-set into forward B-atoms.  The image appears in the left PE window";


	S=S+"\n\nB atoms->(2): This shows the partition of the B-set into backward B-atoms.  The backward B-atoms are the images of the forward B-atoms under the first return map tp the A-set.  The image appears in the left PE window.";



	M.D.setExplain(S);
	M.D.repaint();
    }



    public void outlineInfo() {
	String S="outline control.";
	S=S+"\n\nThis control panel lets you select different options for the outlines of the plotted tiles.";
	S=S+"\n\nwhite: white outline";
	S=S+"\n\nblack: black outline";
	S=S+"\n\nnone: no outline outline";
	S=S+"\n\nnatural: same outline as the tile. This is pretty when you plot with semi-transparent colors.";
	M.D.setExplain(S);
	M.D.repaint();
    }



    public void partialInfo() {
	String S="partial tile control.";
	S=S+"\n\nA partial tile is a maximal polyhedron that is invariant under a certain number of iterates of the PE map, either forwards or backwards iterates. You select the number of iterates using the arrow keys at the bottom of the control window. This control panel lets you toggle between whether you want to use forwards or backwards iterates.";
	M.D.setExplain(S);
	M.D.repaint();
    }


    public void actionInfo() {
	String S="action control.";
	S=S+"\n\nThe way the program works is that it computes the requested tile and then plots some portion of its orbit. This control panel lets you select what portion of the orbit is plotted";

	S=S+"\n\ntile: just plot the tile.";
	S=S+"\n\nselect: This works in tandem with the polyhedron selector. Once you select a polyhedron, this option has the program plot only those tiles in the orbit that are contained in the selected polyhedron.";
	S=S+"\n\nwhole: plots the whole orbit.  You should use this option with care, because some orbits are very long and will overload the program.  At bottom right there is a tracker which counts the number of tiles plotted. If this number gets bigger than about 10000 the program starts bogging down.";

	M.D.setExplain(S);
	M.D.repaint();
    }



    public void objectInfo() {
	String S="tile type selector.";
	S=S+"\n\nThis control panel lets you control what kind of tile is plotted. In all cases, you make a selection, then choose a point on the PE window, and then press go.  The focus buttons tell you which window will record the plot.  Here are the options for tile types.";

	S=S+"\n\npartial tile: A partial tile is a maximal polyhedron that is invariant under a certain number of iterates of the PE map, either forwards or backwards iterates. You select the number of iterates using the arrow keys at the bottom of the control window";

	S=S+"\n\ntile: A tile is a periodic tile.  This is a maximal polyhedron consisting entirely of points having the same period and combinatorial structure. If the period exceeds the limit shown on the arrow keys, nothing is returned from the calculation.  In general, the longer the period, the smaller the tile.  It is safest to just plot single tiles before looking at their orbits, but this approach will get tedious.";

	S=S+"\n\nA tile: The A-set is partitioned into 18 layers, with each layer corresponding to a subset of the 3-torus bounded by horizontal planes.  This routine plots the ordinary tile and then intersects it with the layer. So, the picture looks exactly the same as the ordinary tile in each horizontal slice, but then the tile disappears if the slice moves outside the layer.";

	S=S+"\n\nB tile: The B-set is partitioned into 6 layers, with each layer corresponding to a subset of the 3-torus bounded by horizontal planes.  This routine plots the ordinary tile and then intersects it with the layer. So, the picture looks exactly the same as the ordinary tile in each horizontal slice, but then the tile disappears if the slice moves outside the layer.";

	S=S+"\n\nA atom: Selecting this option brings up a host of possibilities related to the plotting of A-atoms. These possibilities are detailed on the documentation for the chain routine control panel.";

	S=S+"\n\nB atom: Selecting this option brings up a host of possibilities related to the plotting of B-atoms. These possibilities are detailed on the documentation for the chain routine control panel.";


	M.D.setExplain(S);
	M.D.repaint();
    }

    public void chainInfo() {
	String S="atom and chain controls.";

	S=S+"\n\nRecall that an A-atom is a maximal convex polyhedron in the A-renormalization set, such that the first return map to the set is completely defined on the interior. B-atoms are defined similarly, with respect to the B-set. This control panel gives you options for plotting atoms and chains. It is used to illustrate the proof of the Renormalization Theorem in the paper.  We will explain all the options for the A-atoms. For the B-atoms it is the same.";

	S=S+"\n\nA tile: In this option, you select a point in the interior of the A-set and then what is plotted is the A-atom containing the selected point.";


	S=S+"\n\nA tile: In this option, you select a point in the interior of the A-set and then what is plotted is the A-chain containing the selected point. The A-chain is the A-atom, together with all its forward iterates leading up to but not including the return to the A-set.  So, the other atoms in the chain are neutral A-atoms lying outside the A-set.";


	S=S+"\n\nA tile: In this option, you select a point in the interior of the A-set and then what is plotted is the A-chain containing the selected point, together with the next iterate, which is the backwards A-atom. The backwards A-atom is the image of the forwards A-atom under the first return map to the A-set.";


	S=S+"\n\nA period fill: In this option, you select one of the 64 main polyhedra, and then the program fills this region with periodic tiles that do not intersect the A-set.";


	S=S+"\n\nA chain fill: In this option, you select one of the 64 main polyhedra, and then the program fills this region with the forward and neutral A-atoms.";

	S=S+"\n\nA total fill: In this option, you select one of the 64 main polyhedra, and then the program fills this region with periodic tiles AND with forward and neutral A-atoms.  So, the total fill is a combination of the period fill and the chain fill.  Each tile should get completely filled.  This is one of the main steps in the proof of the Renormalization Theorem.  To examine filling, we find it best to use semi-transparent colors and the natural boundary.  This lets you best see that there are no overlapping tiles.";


	M.D.setExplain(S);
	M.D.repaint();
    }



    public void clusterInfo() {
	String S="auxilliary buttons.";

	S=S+"\n\nThese 3 buttons control some features of the display in the PE windows.";

	S=S+"\n\nA tile: When this option is on, it translates the fundamental domain around by the vectors (a,b,0) wher a and b both belong to the set {-2,0,2}.  This gives you a feel for how all of space is tiled by the polyhedra in the PE exchange map. After all, the PE map is really defined on the 3-torus. Here we are trying to give an impression of what the picture would look like in the universal cover.";

	S=S+"\n\nA rescale: This rescales the picture back to the original settings.";


	S=S+"\n\nA navigator:  When this option is on, it activates the navigator. The navigator allows you to control how you slice the 3D image.  You can read more about the navigator by clicking on the info box there.";

	M.D.setExplain(S);
	M.D.repaint();
    }


    public void navigateInfo() {
	String S="navigator";

	S=S+"\n\nThis is the navigator window. It has 2 modes which are unrelated to each other.";

        S=S+"\n\n mode 1: This is active when the navigator button is turned off.  In this mode, the navigator window displays the coordinates of the polyhedra involved in the polyhedron exchange map.  When you click on the left PE window, the corresponding coords appear on the left hand side of the navigator window. On the right hand side, the navigator window displays the action of the PE map Psi_hat on the selected polygon.  Finally, the navigator window also displays on the right hand side the action of the map Psi on polygons in the strip Sigma which map into the selected polyhedron.  The maps Psi and Psi_hat are local translations, so their action is listed in terms of a translation vector.";


	S=S+"\n\nmode 2: This is active when the navigator button is turned on. In this mode, the nabigator window allows you to slice the polyhedron exchange in a flexible way.  The 6 sliders control the values of numbers x1,y1,z1 and x2,y2,z2.  Consider the vectors V1=(x1,y1,z1) and V2=(x2,y2,z2).  The program computes the affine embedding of the plane into space, which carries the standard basis vectors to V1 and V2, and the origin to the selected point in the left PE window.  Then, the program slices the 3-torus with this plane and draws the result in the PE window.  By sliding the sliders around, you can see the image gradually change.";

	S=S+"\n\nThere are certain special settings, which you can access by pressing the 4 buttons at right.  The most interesting setting is the first one.  With this setting, you are using the vectors which implement the map Theta: Sigma __> Sigma_hat from the Compactification Theorem.  You will see a (translated) copy of the outer billiards window inside the PE window!.";

	S=S+"\n\nA nice way to get a feeling for the navigator is as follows:";

	S=S+"\n\n1.Turn on the strip2torus button on the red links control panel.";
	S=S+"\n\n2.Turn on the first return display in the outer billiards control window";
	S=S+"\n\n3.drag the mouse, holding down button-2, over the strip Sigma in the outer billiards window. If you don't have a 3-button mouse, you can hold down the x-key and then just move the mouse around.";

	S=S+"\n\nIf you do this with the special setting mentioned above, you can see the compactification in action, in a very difect way.";

	M.D.setExplain(S);
	M.D.repaint();
    }





}




