import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class DocumentCanvas extends Canvas 
implements MouseListener {
    
    Manager M;
    String[] S=new String[500];
    String[] P=new String[500];
    int paragraphs;
    int linecount;
    String MAIN;
    ListenSquare F;
    SelectInteger I1,I2,I3,I4;
    Integer[] J=new Integer[200];
    ListenSquare L;
    Color COLOR1;
    Color COLOR2;
    
    

    public DocumentCanvas addManager(Manager M) {
	DocumentCanvas XX=this;
	XX.M=M;
	return(XX);
    }
    
    public DocumentCanvas() {
        addMouseListener(this);
        setBackground(Color.black);

        I2=new SelectInteger(25,5,40,20,0,0,199,1);
        I4=new SelectInteger(105,5,40,20,5,1,20,1);
        I3=new SelectInteger(185,5,40,20,12,8,22,1);


        for(int i=0;i<=199;++i) J[i]=new Integer(i);
        L=new ListenSquare(2,2,12,12,Color.black);
        L.on=1;
        paragraphs=0;
        setup();
	COLOR1=new Color(0,50,50);
	COLOR2=Color.white;
    }
    
    
    
    public int wordBreak(String A,int n) {
        String AA=new String();
        for(int i=n;i>0;--i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo(" ")==0) return(i);
        }
        return(n);
    }
    
    
    public void findBreaks(String A) {
        int count=0;
        int pos1=0;
        String AA=new String();
        for(int i=0;i<A.length();++i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo("\n")==0) {
                P[count]=A.substring(pos1,i);
                ++count;
                pos1=i;
            }
        }
        P[count]=A.substring(pos1,A.length());
        ++count;
        paragraphs=count;
    }
    
    
    
    public void paragraphDisplay(String A,int n) {
        
        int L=A.length();
        String AA=new String();
        int pos1=0;
        int pos2=0;
        int count=0;
        int LL=L;
        while(LL>0) {
            pos2=pos1+n;
            if(pos2>=L) {
                S[count+linecount]=A.substring(pos1,L);
                LL=0;
            }
            
            if(pos2<L) {
                pos2=wordBreak(A,pos2);
                S[count+linecount]=A.substring(pos1,pos2);
                ++count;
                LL=LL-(pos2-pos1);
                pos1=pos2;
            }
        }
        linecount=linecount+count+1;
    }
    
    
    
    
    
    public void display(int n) {
        for(int i=0;i<=499;++i) S[i]="";
        findBreaks(MAIN);
        linecount=0;
        for(int i=0;i<paragraphs;++i) {
            paragraphDisplay(P[i],n);
        }
    }
    
    
    
    public void paint(Graphics gfx) {
        
        
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);

        Dimension D=this.getSize();
        g.setColor(Color.black);
        g.fillRect(0,0,D.width-1,D.height-1);


	g.setColor(COLOR1);
	g.fillRect(30,50,getWidth()-31,getHeight()-22);
	g.setColor(Color.white);
	g.drawRect(30,50,getWidth()-31,getHeight()-22);
        
        L.infoRender(g);
        I2.render(g,Color.blue,Color.white,new Color(100,180,255));
        I3.render(g,Color.blue,Color.white,new Color(100,180,255));
        I4.render(g,Color.blue,Color.white,new Color(100,180,255));

	g.setColor(Color.white);
	g.drawString("scroll pos",20,40);
	g.drawString("scroll stepsize",90,40);
	g.drawString("font size",190,40);
        
        g.setFont(new Font("Helvetica",Font.PLAIN,I3.val));
        int space=I3.val+3;
	display(2*getWidth()/(2+I3.val));
        for(int i=0;i<=499;++i) {
           if(45+space*i<D.height-space+5) {
                g.setColor(new Color(100,180,255));
                g.drawString(J[i+I2.val].toString(),5,68+space*i);
		g.setColor(COLOR2);
                g.drawString(S[i+I2.val],35,68+space*i);
	   }
	}
        
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
        
    }
    
    
    
    
    
    
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();

        I2.modify(X);
        I3.modify(X);
        I4.modify(X);
        I2.step=I4.val;
        if(L.inside(X)==1) setup();
        repaint();
    }
    
    public void setup() {
        I2.val=0;
	String S="PENROSE KITE:\n\n";
        S=S+"Richard Evan Schwartz\n";
        S=S+"Brown University\n";
        S=S+"Supported by NSF Grant 0604426.\n";
	S=S+"program started: August 2010\n";
	S=S+"Last updated: 20 Jan 2011";

	    S=S+"\n\n\nOPERATING THIS WINDOW\n\n";

	    S=S+"This window gives explanations for the rest of the program.\n   1. scroll the text using the left arrow keys at the top.\n   2. change the scroll stepsize using the middle arrow keys at the top.\n   3. change the text size using the right arrow keys at the top.\n";	 
            S=S+"You should read the rest of this introduction before starting to play with the program.";



	    S=S+"\n\n\n PURPOSE OF THE PROGRAM \n\n";
	    S=S+" This program serves as a companion to my paper 'Outer Billiards on the Penrose Kite: Compactification and Renormalization'. One purpose of the program is to illustrate the results in the paper, letting the user see pictures in much greater detail than what is shown in the paper.  The second purpose of this program is to run the rigorous calculations that comprise the computer-aided portion of the proofs in the paper.";


            S=S+"\n\n\n KNOWLEDGE REQUIREMENTS";
	    S=S+"\n\nIn order to use this program, you should be familiar with three basic concepts from the paper: the outer billiards map, the arithmetic graph, and the polyhedron exchange map.  We will not define these objects anywhere in the program documentation.  The program illustrates the connection between these three concepts.  Even though we do not define the basic operations in the program, we have made an extensive attempt to document the way the function operates.";

	    S=S+"\n\nGENERAL OVERVIEW\n\n";

	    S=S+"This program has 8 windows:";

	    S=S+"\n\n1. documentation: (this window) An info square is a little black square with a question mark in it. Whenever you click on an info square, information about the function of the program (and sometimes the significance) appears in this window.";

	    S=S+"\n\n2. control panel: (bottom left) The main and always present part of the control panel is the outer rim on the left and bottom.  The rest of the control panel changes, depending on the settings of the main part.";


	    S=S+"\n\n3. coordinate canvas: (long middle) The coordinate canvas lets you select the coordinates for points that lie in some of the other windows, and it also displays these coordinates.  The left side of the coordinate canvas has a color selector, which controls the colors of various plots you make.";

	    S=S+"\n\n4. Left Polyhedron exchange window: (bottom middle)  This window displays a 3-dimensional solid polyhedron that is partitioned into 64 smaller polyhedra.  This is the polyhedron exchange from the paper.  The long blue slider that runs above the window lets you select which horizontal slice is displayed in the window.";

	    S=S+"\n\n5. Right Polyhedron exchange window: (bottom right, but not the very bottom)  This window displays another copy of the poly exchange map.  Under normal operating conditions, the slice in the left PE window is related to the slice in the right PE window by the circle renormalization map from the paper.";

	    S=S+"\n\n6. Navigator: (bottom right)  In one mode, the navigator displays the coordinate of the 64 polyhedra involved in the PE maps.  In the other mode, which you activate with the navigator button, the navigator window lets you slice the figures in the PE window in much more flexible ways.  The navigator mode is tuned to the left PE window, and doesn't interact so well with the right one.";

	    S=S+"\n\n7. outer billiards window (top middle)  This window lets you do the outer billiards map on the penrose kite.";

	    S=S+"\n\n8. Arithmetic Graph window (top right) This window lets you draw the arithmetic graphs associated to the orbits.";

	    S=S+"\n\nThe theorems in the paper discuss connections between outer billiards, the arithmetic graph, and the polyhedron exchange. They also discuss connections between the polyhedron exchange map at one slice (left) and at another slice (right).  You can configure the program so that these various connections are made (to some extent) and an action in one window effects another window simultaneously.";

	    S=S+"\n\nThe info buttons in the corners of these windows, as well as the info buttons in the control panels, have much more information about how these windows function.";

	S=S+"\n\n\nMOUSE COMPATABILITY\n\n";

	S=S+"This program is designed to work best with a 3 button mouse. Generally speaking\n   1. clicking button 1 scales up the picture\n   2. clicking button 2 selects a new point in the window.\n   3. clicking button 3 scales down the picture.\nOn the control panel, all mouse clicks have the same effect.\n";
	S=S+"If you don't have a 3 button mouse, you can use the keyboard buttons Z,X,C to simulate the 3 buttons when you are operating one of the picture windows.";

	S=S+"\n\n\nLOOSE ENDS\n\n";

	S=S+"As thie program gradually evolves I try to keep the documentation up to date, but sometimes there are some loose ends that I haven't tied up.  In this case, the documentation for a new or recently modified feature might be inaccurate or else nonexistent. However, at any given time, the documentation is almost complete, and defintely covers the most important features.";

	MAIN = new String(S);
    }
    
    public void setExplain(String doc) {
        I2.val=0;
        MAIN=doc;
        repaint();
    }
    
}

