import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentControl {
    Manager M;
    public DocumentControl(Manager MM) {
	this.M=MM;
    }


    public void globalInfo() {

	String S="control panel switch";
	S=S+"\n\nThis control panel brings forth the controls for the other windows.  The controls for these other windows appear in the dark green window just to the right of this control panel.  There are 3 other windows, and one extra mode.\n\n";

	S=S+"1. Outer billiards window: Top middle.  This is the outer billiards window.\n\n";


	S=S+"2. Arithmetic graph widow.  Top right.  In this window, you can plot the arithmetic graphs associated to orbits.\n\n";

	S=S+"3. The 3D poly windows:  The bottom left and right windows show the polyhedron exchange map which is the 3D compactification of the outer billiards pinwheel map.\n\n";

	S=S+"4. data:  In this mode, you can run some auxilliary data to re-generate some of the data that is used in the program.   In general, you would re-generate the data, then exit the program, then start it up again.\n\n";

	S=S+"5. checks:  In this mode, you can run various sanity checks which make sure that the program is running correctly.\n\n";

	S=S+"6. proofs:  In this mode, you can run the proofs mentioned in the paper.";



	S=S+"\n\nWhen you click one of the buttons in this control panel, you will see the new controls appear.  You can learn about the function of these new controls using the question buttons on these controls.  You can generally operate one of the other windows without having first selected the controls for that window.  However, if you want to modify the various parameters for that window, you need to bring up the controls.";

	M.D.setExplain(S);
	M.D.repaint();
    }




    public void clusterInfo() {

	String S="bottom controls";
	S=S+"\n\nThere are several buttons on the bottom of the control panel.  Here are their effects:";

	S=S+"\n\ngo: The go button activates programs such as tile plotters.  When you use the outer billiards mode, these programs are launched automatically.  In the other modes, you need to push the go button for anything to happen.";

	S=S+"\n\nhalt: When you have launched a program using the go button, you sometimes have the option of halting it.  This feature works inconsistently.  Sometimes I fully implemented it and sometimes not. In the proof mode, it is pretty well implemented, so that you can stop long calculations before they complete if you run out of patience.";

	S=S+"\n\nexport: This only works in program mode.  When the export option is on, the contents of the graphical windows are stored as tcl files in the subdirectory Output. You can then open these files with the command wish plotter.tcl.  Once you open these files, you can export them to postscript.  This is a rather indirect approach, and it would be better if java had a simple graphics to postscript converter, but I don't know of a simple program that does this. In the applet mode, this function (and all IO features) are disabled for security reasons.";

S=S+"\n\nfocus: The left and right bottom windows show two slices of the polyhedron exchange map.  When you press the go button, certain calculations are made with respect to the one window or the other.  The focus switch selects one of the two windows as the one that determines the plot.";


	M.D.setExplain(S);
	M.D.repaint();
    }

    public void resetInfo() {

	String S="reset button";
	S=S+"\n\nThere are 4 options for the reset button. The first option resets everything. The remaining options only reset the plots that correspond to the selected choice.";

	M.D.setExplain(S);
	M.D.repaint();
    }

    public void linksInfo() {

	String S="link control";
	S=S+"\n\nThe control panel controls the linkages between the 3 main plotting windows:\n\nThe bottom middle window is the main polyhedron exchange window. It represents the 3-torus Sigma_hat in the paper.\n\nThe upper middle window is the outer billiards plane.  In particular a certain strip in this plane is Sigma in the paper.   The top right window is the arithmetic graph window.  Turning the linking features allows you to see the correspondences between these various windows.";

	S=S+"\n\nThe strip2gtorus link, when turned on, realizes the compactification map Theta: Sigma->Sigma_hat. If this button is on, and you click/draw on a point in the outer billiards window, the corresponding point appears in the polyhedron exchange window.  You select points in these windows using the middle mouse button or the key x. One nice way to select points is to hold down the x key and move the mouse around. The strip-to-torus link is the most important one  It gives an illustration of the Compactification Theorem in the paper.";

	S=S+"\n\nThe grid2torus link, when turned on, realizes the map from the arithmetic graph window to the polyhedron exchange window. This map is not studied much in this paper, but it is studied in great depth in our monograph, in connection with the Master Picture Theorem.";

	S=S+"\n\nThe grid2strip link, when turned on, realizes the map from the arithmetic graph window to the outer billiards window. Again, this map is not studied much in this paper, but it is studied in great depth in our monograph, in connection with the Master Picture Theorem.";

	S=S+"\n\nThe slider2strip link, when turned on, shows how the horizontal slices of Sigma_hat correspond to the horizontal lines in Sigma.  The long blue slider controls the horizontal slice of Sigma_hat, and the object called the x-cursor marks off the horizontal lines in Sigma.  You have to go to the outer billiards control panel to turn on the x-cursor.";

	S=S+"\n\nThe Y-lock link should be used in tandem with the strip2torus link.  When activated, the Y-lock locks the y-coordinate of the points you can select in Sigma.  Correspondingly, this keeps you in the same horizontal plane in Sigma_hat.";

	M.D.setExplain(S);
	M.D.repaint();
    }


    public void colorInfo() {
	String S="color control";

	S=S+"\n\nThis toggles between two ways of coloring the polyhedron exchange windows and the outer billiards window.\n\noption 1 colors the pieces according to their dynamics.\n\noption 2 colors the pieces according to the grouping of the exchange-polyhedra into 10 prisms.  In both cases, the colors are coded so that the coloring of the outer billiards window corresponds to the coloring in the polyhedron exchange windows. You can see this by turning on the strip2torus link.";

	S=S+"\n\nOption 2 is not very important and we not say much about it.  All we say is that the color selection controls for option 2 are similar to what they are for option 1.  We will describe the option 1 controls in detail.";

	S=S+"\n\nThe polyhedron exchange map is a local translation, and there are 9 possible translation vectors.  In the first mode, the pieces are colored according to these 9 vectors.  Similarly, when you turn on the `1st return' option in the outer billiards window, the tiles you see there are colored according to the action of the first return map.";

	S=S+"\n\nBy selecting the poly select option on the polyhedron exchange control panel, you can cyclic through the polyhedra and explicitly see the corresponding translation vectors.";

	S=S+"\n\nIf you want to change the coloring, you can do it in one of two ways.  First, you can click one of the 4 preset color options on the little collection of squares at the very bottom right.  Second, you can manually click on the 3x3 checkerboard at bottom right.  Doing so will change the color to be the one currently on the color selector.  You can also change the background and outline colors.";

	M.D.setExplain(S);
	M.D.repaint();
    }



}


