import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentGraph {
    Manager M;
    public DocumentGraph(Manager MM) {
	this.M=MM;
    }


    public void graphInfo() {

	String S="main mode selection";

S=S+"\n\nThis control panel specifies what you plot in the Arithmetic Graph window.  If you don't know what the arithmetic graph is, click on the info button in the bottom left corner of this control panel.  In brief, the arithmetic graph is a 2-dimensional plot which encodes the dynamics of the first return map for the outer billiards map.";

S=S+"\n\nNow I'll suppose you know what the arithmetic graph is. Once you have set the option you like, just push 'go' and see what happens.  Here are the options:";

S=S+"\n\nbasic: This is the straight-up arithmetic graph mode. You should click on the info button in the arithmetic graph window to learn about the arithmetic graph.  The arithmetic graph doesn't really play an inportant role in the paper, but it does illustrate the phenomena very well.";


	S=S+"\n\nrenorm: There is a map from the Z^2 grid into the polyhedron exchange which controls the local nature of the arithmetic graph. In this mode, all points are plotted which get mapped into either the A renormalization set or the B renormalization set.  This control panel lets you toggle between the two target options.";


	S=S+"\n\nseek: There is a map from the Z^2 grid into the polyhedron exchange which controls the local nature of the arithmetic graph. In this mode, the program looks for points in the grid that map into a tile you have selected in the polyhedron exchange window. So, in particular, you need to click the middle mouse button (or the x-key) on an already plotted tile.  Once this is in place, there are two options.";

	S=S+"\n\nchains: This mode lets you plot the arithmetic graphs of the A-chains and the corresponding B-chains.  This gives you a graphical feel for what the renormalization does.  In the paper we discussed these pictures in connection with the Far Reduction Theorem.";



	M.D.setExplain(S);

	M.D.repaint();
    }



    public void basicInfo() {

	String S="basic object selection";

	S=S+"\n\nIn this mode, you are plotting the straight-up arithmetic graph.  There are 3 options";

	S=S+"\n\nforward: The forward option plots the forward orbit of the selected point in the Arithmetic Graph window. You control the number of iterates (always a power of 2 with our interface) using the arrow key at bottom"; 

	S=S+"\n\nbackward: The backward option plots the backward orbit of the selected point in the Arithmetic Graph window. You control the number of iterates as in the forward case."; 

	S=S+"\n\nblock: This option lets you plot all the orbits within a standard rectangle. The rectangle is centered on the point in the window you have selected.  When you select the block option arrow keys appear which let you select the size of the block to plot.  If you select nothing, then the default is (0,0).";

	M.D.setExplain(S);

	M.D.repaint();
    }



    public void renormInfo() {

	String S="renorm target selection";

	S=S+"\n\nThere is a map from the Z^2 grid into the polyhedron exchange which controls the local nature of the arithmetic graph. In this mode, all points are plotted which get mapped into either the A renormalization set or the B renormalization set.  This control panel lets you toggle between the two target options.";

	S=S+"\n\nYou use the blue arrow keys to specify the size of the region in the grid which is sampled.";
	M.D.setExplain(S);
	M.D.repaint();
    }



    public void seekInfo() {

	String S="seek target selection";

	S=S+"\n\nThere is a map from the Z^2 grid into the polyhedron exchange which controls the local nature of the arithmetic graph. In this mode, the program looks for points in the grid that map into a tile you have selected in the polyhedron exchange window. So, in particular, you need to click the middle mouse button (or the x-key) on an already plotted tile.  Once this is in place, there are two options.";

	S=S+"\n\nsite: This option just plots the points which map into the selected tile. This is similar to the renorm mode.";

	S=S+"\n\ngraph: This is the interesting option.  It plots the components of the arithmetic graph that map into the selected tile.";

	S=S+"\n\nYou use the blue arrow keys to specify the size of the region in the grid which is sampled.";

	M.D.setExplain(S);
	M.D.repaint();
    }



    public void arithmeticGraphInfo() {

	String S="arithmetic graph window";
	
        S=S+"\n\nThis window draws the arithmetic graph. You activate controls for this window by selecting the 'graph' option on the red 'controls' control panel. You can read about the various options by clicking on the info buttons on the cyan colored control panels that pop up. The arithmetic graph is an integer lattice polygonal path that encodes the symbolic dynamics of an orbit.  My paper has a definition, and my monograph studies the arithmetic graph in great detail.";

	S=S+"\n\nYou can select points in the graph window by clicking the middle mouse button or using the x-key.  Once you select a point, you can use the forward/backward option on the arithmetic graph control panel to plot the component of the graph containing the point you have selected.";

	S=S+"\n\nThe way that the points in the arithmetic graph correspond with the orbits in the other windows is controlled by a single real parameter called the offset.  The offset is printed out directly beneach the arithmetic graph window. What is crucial is that the offsets have to be set just right to get the correspondence entailed by the renormalization theorem.  The program does this automatically, and the offset is not something you can adjust manually.";

	S=S+"\n\nOnce the offset is specified, there is still a real parameter left. This real parameter coincides with one or the height of the displayed slice in either the left polyhedron exchange window or the right one. These are the two bottom numbers shown in the purple rectangles beneath this window. You decide which of the two heights to use by clicking on the focus button.";

	S=S+"\n\nIf you choose the left focus, the graph is plotted in a straightforward way, on the Z+Z grid.  If you choose the right focus, the situation is more complicated.  If the left height lies in the interval 1 or the interval 3, then the graph is plotted in the straightforward way. If the left height lies in the intervals 0,2,4, then the graph is dilated by a factor of phi^3 before plotting.  You can tell which interval contains the left height by looking at where the white short fat marker sits in the long blue slider.  This slider is alternately colored dark and light blue so as to denote the 5 basic intervals.";

	S=S+"\n\nIn case we draw a right-focus picture, we do the dilation so as to illustrate the Renormalization theorem. If you plot the left-focus picture and then the right-focus picture (using good colors) you will see a rough correspondence between the long components of the one graph and the long components of the other.   This miracle is the content of the Renormalization Theorem.";

	M.D.setExplain(S);
	M.D.repaint();
    }



    public void markingInfo() {
	String S="auxilliary object selector";

	S=S+"\n\nThis control panel manages the basic settings on the arithmetic graph";

	S=S+"\n\nbackground color.  This is the background color on the arithmetic graph window";

	S=S+"\n\ncoordinate axes.  This toggles the display of coordinate axes on the arithmetic graph window";

	S=S+"\n\nthe Z+Z integer grid.  The arithmetic graph has its vertices in the integer lattice.  This toggles the display of a part of this lattice.  The lattice is about 80x80, and automatically centers on any point you click.";

	S=S+"\n\nthe line: this is the line of slope -A through the origin. Here A=phi^{-3}.  This line is the kernel of the map from the grid into the strip and into the torus. The distance from the graph to this line is half the distance from the orbit in the strip to the Y-axis.";

	S=S+"\n\nA-chains.  This controls the colors of the plotted A-chains, in the chain mode.";

	S=S+"\n\nB-chains.  This controls the colors of the plotted B-chains, in the chain mode.";




	M.D.setExplain(S);
	M.D.repaint();
    }




}


