import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.math.*;


public class Fundamental {


    /**This class specifies the fundamental triangle
       that appears in the outer billiards plane.**/


    public Fundamental() {
    }

    public static GeneralPath triangle() {
	PolyWedge P=triangleMain();
 	GeneralPath gp=P.toGeneralPath();
	return(gp);
    }

    public static PolyWedge triangleMain() {
	PolyWedge P=new PolyWedge();
	P.count=3;
	P.z[0]=new Complex(0,1);
	P.z[1]=new Complex(GoldenRatio.phi(-3),0);
	P.z[2]=new Complex(GoldenRatio.phi(-1),GoldenRatio.phi(1));
	return(P);
    }


    public static PolyWedge triangle0() {
	PolyWedge P=new PolyWedge();
	P.count=3;
	P.z[0]=new Complex(0,1);
	P.z[1]=new Complex(GoldenRatio.phi(-3),0);
	P.z[2]=new Complex(2*GoldenRatio.phi(-3),1);
	return(P);
    }

    public static PolyWedge triangle1() {
	PolyWedge P=new PolyWedge();
	P.count=3;
	P.z[0]=new Complex(0,1);
	P.z[1]=new Complex(2*GoldenRatio.phi(-3),1);
	P.z[2]=new Complex(GoldenRatio.phi(-1),GoldenRatio.phi(1));
	return(P);
    }

    public static boolean inTriangle(Complex z) {
	GeneralPath gp=triangle();
	boolean f=gp.contains(z.x,z.y);
	return(f);
    }


    public static int inTriangleSmall(Complex z) {
	PolyWedge P=Fundamental.triangleMain();
	for(int i=0;i<5;++i) {
	    int[] J={i};
	    PolyWedge Q=Fundamental.act(J,P);
	    GeneralPath gp=Q.toGeneralPath();
	    if(gp.contains(z.x,z.y)) return(i);
	    if(gp.contains(2-z.x,z.y)) return(i+5);
	}
	return(-1);
    }

    public static Complex verticalReflect1(Complex z) {
	double A=Math.sqrt(5)-2;
	Complex w=new Complex(2*A-z.x,z.y);
	return(w);
    }


    public static Complex verticalReflect2(Complex z) {
	Complex w=new Complex(2-z.x,z.y);
	return(w);
    }

    public static PolyWedge verticalReflect2(PolyWedge P) {
	PolyWedge Q=new PolyWedge();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.z[i]=verticalReflect2(P.z[i]);
	return(Q);
    }

    public static PolyWedge act(int[] J,PolyWedge P) {
	PolyWedge Q=new PolyWedge(P);
	for(int i=0;i<J.length;++i) {
	    Q=act(J[J.length-i-1],Q);
	}
	return(Q);
    }

    public static PolyWedge act(int j,PolyWedge P) {
	PolyWedge Q=new PolyWedge();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.z[i]=act(j,P.z[i]);
	}
	return(Q);
    }


    public static Complex act(int i,Complex z) {
	if(i==0) return(IR11(z));
	if(i==1) return(IR12(z));
	if(i==2) return(IR31(z));
	if(i==3) return(IR32(z));
	if(i==4) return(IR41(z));
	return(z);
    }

    public static Complex act20(int i,Complex z) {
	if(i==0) return(R11(z));
	if(i==1) return(R12(z));
	if(i==2) return(R31(z));
	if(i==3) return(R32(z));
	if(i==4) return(IR12(R41(z))); //orientation preserving isometry
	return(z);
    }


    public static Complex act2(int i,Complex z) {
	if(i<5) return(act20(i,z));
	Complex w=new Complex(2-z.x,z.y);
	w=act20(i-5,w);
	w.x=2-w.x;
	return(w);
    }

    public static Complex R11(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(A,0));
	w=new Complex(w.x/A,w.y/A);
	w=Complex.plus(w,new Complex(A,0));
	w=verticalReflect1(w);
	return(w);
    }

    public static Complex R12(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(A,0));
	w=new Complex(w.x/A,w.y/A);
	w=Complex.plus(w,new Complex(A,0));
	w.x=2-w.x;
	return(w);
    }

    public static Complex IR11(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(A,0));
	w=new Complex(w.x*A,w.y*A);
	w=Complex.plus(w,new Complex(A,0));
	w=verticalReflect1(w);
	return(w);
    }

    public static Complex IR12(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(A,0));
	w=new Complex(w.x*A,w.y*A);
	w=Complex.plus(w,new Complex(A,0));
	return(w);
    }


    public static Complex R31(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(0,1));
	w=new Complex(w.x/A,w.y/A);
	w=Complex.plus(w,new Complex(0,1));
	w.x=2-w.x;
	return(w);
    }


    public static Complex R32(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=verticalReflect1(z);
	w=Complex.minus(w,new Complex(0,1));
	w=new Complex(w.x/A,w.y/A);
	w=Complex.plus(w,new Complex(0,1));
	return(w);
    }



    public static Complex IR31(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(0,1));
	w=new Complex(w.x*A,w.y*A);
	w=Complex.plus(w,new Complex(0,1));
	return(w);
    }


    public static Complex IR32(Complex z) {	
                  double A=Math.sqrt(5)-2;
	Complex w=Complex.minus(z,new Complex(0,1));
	w=new Complex(w.x*A,w.y*A);
	w=Complex.plus(w,new Complex(0,1));
	w=verticalReflect1(w);
	return(w);
    }


    public static Complex R41(Complex z) {	
                  double A=Math.sqrt(5)-2;
	double phi=(1+Math.sqrt(5))/2;
	Complex w=Complex.minus(z,new Complex(1/phi,phi));
	w=new Complex(w.x/A,w.y/A);
	w=Complex.plus(w,new Complex(1/phi,phi));
	return(w);
    }

    public static Complex IR41(Complex z) {	
                  double A=Math.sqrt(5)-2;
	double phi=(1+Math.sqrt(5))/2;
	Complex w=Complex.minus(z,new Complex(1/phi,phi));
	w=new Complex(w.x*A,w.y*A);
	w=Complex.plus(w,new Complex(1/phi,phi));
	return(w);
    }


}

