import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This file generates some of the pre-stored data that we use.**/

public class GenerateData implements Runnable {
    int halt;
    Manager M;

    public GenerateData() {}

    public GenerateData(Manager MM) {
	this.M=MM;
    }


    public void run() {
	int mode=M.C.CON_D.ACTION.mode;
	if(mode==0) pinwheel();
	if(mode==1) edgeList();
	if(mode==2) phiCover();
	if(mode==3) returnPositive();
	if(mode==4) printHeightsA();
	if(mode==5) printHeightsB();
	if(mode==6) printSequence();
	if(mode==7) printPolys();
	if(mode==8) printAPolys();
	if(mode==9) printBPolys();
    }


    /**LaTeX printout of the partition polyhedra**/

    public void printPolys() {
	for(int i=0;i<64;++i) {
	    GoldenPolyhedron P=DataPartition.getGoldenPolyhedron(i);
	    Integer I=new Integer(i);
	    String S="P"+I.toString();
	    P.texPrint(S);
	}
    }

    /**LaTeX printout of the A renorm polyhedra**/

    public void printAPolys() {
	for(int q=0;q<9;++q) {
	    int[] L=ProofSupport.lookup(q);
	    for(int br=0;br<4;++br) {
		GoldenPolyhedron P=DataRenorm.getGoldenA(L[0],L[1],br);
            Integer I1=new Integer(L[0]+1);
            Integer I2=new Integer(L[1]+1);
            Integer I3=new Integer(br+1);
	    String S="A"+I1.toString()+I2.toString()+I3.toString();
	    P.texPrint(S);
	    }
	}
    }


    /**LaTeX printout of the  B renorm polyhedra**/

    public void printBPolys() {
	for(int LB=0;LB<3;++LB) {
	    for(int br=0;br<4;++br) {
	    GoldenPolyhedron P=DataRenorm.getGoldenB(LB,br);
            Integer I1=new Integer(LB+1);
            Integer I2=new Integer(br+1);
	    String S="B"+I1.toString()+I2.toString();
	    P.texPrint(S);
	    }
	}
    }




    /**This generates and sorts the list of 2nd coordinates
       of the A and B atoms.  In the A case we just list those
       heights in [0,1].  In these routines, we generate the
       initial list of goldenreals, then convert to doubles
       and sort, then convert back. To make sure that there is
       no floating point error, we check that the first and last
       lists match.*/



    public void printSequence() {
	for(int i=22;i<64;++i) {
	    int[] q=DataPartitionRaw.successor(i);
	    System.out.print(i+": ");
            Lists.printout(q);
	}
    }

    public void printHeightsA() {
	for(int q=0;q<18;++q) printHeightsA(q);
    }



    public void printHeightsA(int q) {
	int[] L=ProofSupport.lookup(q);
	int LA=L[0];
	int LB=L[1];
	GoldenReal[] LIST1=new GoldenReal[200];
	int total=0;
	for(int br=0;br<4;++br) {
           int lim=DataRenormReturn.limits(LB,br);
	   for(int k=0;k<lim;++k) {
               GoldenPolyhedron tileA=DataRenormReturn.getGoldenA(LA,LB,br,k,0);
	       for(int i=0;i<tileA.count;++i) {
		   GoldenReal r=tileA.V[i].x[2];
		   if(Lists.match(r,LIST1,total)==false) {
		       LIST1[total]=new GoldenReal(r);
		       ++total;
		   }
	       }
	   }
	}
	System.out.println("");
	double[] LIST2=new double[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST1[i].toDouble();
	Arrays.sort(LIST2);
	GoldenReal[] LIST3=new GoldenReal[total];
	for(int i=0;i<total;++i) LIST3[i]=new GoldenReal(LIST2[i],20,.0000001);
	boolean check=Lists.match(LIST1,LIST3,total);
	if(check==false) throw(new ProofException("printHeightsA"));
	System.out.println("public static int[] heightA"+q+"(int k) {");
	System.out.print("int[][] A={");
	for(int i=0;i<total;++i) {
             System.out.print("{"+LIST3[i].a[0]+","+LIST3[i].a[1]+"}");
	     if(i<total-1) System.out.print(",");
	     if(i==total-1) System.out.print("};return(A[k]);}");
	}
	System.out.println("");
    }






    public void printHeightsB() {
	for(int LB=0;LB<6;++LB) printHeightsB(LB);
    }


    public void printHeightsB(int LB) {
	GoldenReal[] LIST1=new GoldenReal[200];
	int total=0;
	for(int br=0;br<4;++br) {
           int lim=DataRenormReturn.limits(LB,br);
	   for(int k=0;k<lim;++k) {
               GoldenPolyhedron tileB=DataRenormReturn.getGoldenB(LB,br,k,0);
	       for(int i=0;i<tileB.count;++i) {
		   GoldenReal r=tileB.V[i].x[2];
		   if(Lists.match(r,LIST1,total)==false) {
		       LIST1[total]=new GoldenReal(r);
		       ++total;
		   }
	       }
	   }
	}
	System.out.println("");
	double[] LIST2=new double[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST1[i].toDouble();
	Arrays.sort(LIST2);
	GoldenReal[] LIST3=new GoldenReal[total];
	for(int i=0;i<total;++i) LIST3[i]=new GoldenReal(LIST2[i],20,.0000001);
	boolean check=Lists.match(LIST1,LIST3,total);
	if(check==false) throw(new ProofException("printHeightsA"));
	System.out.println("public static int[] heightB"+LB+"(int k) {");
	System.out.print("int[][] A={");
	for(int i=0;i<total;++i) {
             System.out.print("{"+LIST3[i].a[0]+","+LIST3[i].a[1]+"}");
	     if(i<total-1) System.out.print(",");
	     if(i==total-1) System.out.print("};return(A[k]);}");
	}
	System.out.println("");
    }







    /**Generates the polygons for which the
       symmetrized first return map is positive
       in at least one direction.**/

    public void returnPositive() {
	int tot=0;
	int count=DataPinwheel.COUNT();
	for(int i=0;i<count;++i) {
	    for(int j=0;j<count;++j) {
	       GoldenPolyWedge IP1=DataPinwheel.returnPoly(i);
	       GoldenPolyWedge IP2=DataPinwheel.returnPoly(j);
	       PolyWedge P1=IP1.toPolyWedge();
	       PolyWedge P2=IP2.toPolyWedge();
	       Complex z1=P1.getCenter();
	       Complex z2=P2.getCenter();
	       boolean test=true;
	       boolean test1=checkForward(z1);
	       boolean test2=checkForward(z2);
	       if(test1==false) test=false;
	       if(test2==false) test=false;
	       if(z1.y<0) test=false;
	       if(z1.x<2+GoldenRatio.phi(-3)) test=false;
	       if(z2.x<0) test=false;
	       for(int k=0;k<P2.count;++k) P2.z[k]=P2.z[k].conjugate();
	       PolyWedge P=PolyWedge.merge(P1,P2);
	       if(P==null) test=false;
	       if((P!=null)&&(P.count<3)) test=false;
	       if(test==true) {
                    M.T.addPoly(P);
		    GoldenPolyWedge G=new GoldenPolyWedge(P,20,.000000001);
		    ++tot;
	       }
	    }
	}
	M.T.repaint();
	System.out.println("total "+tot);
	System.out.println("");
    }




    public static boolean checkForward(Complex z) { 
            PinwheelMap PIN=new PinwheelMap();
	    int[] r=PIN.piIntegral(z);
	    if((r[1]==1)&&(r[0]==0)) return(true);
	    if((r[1]==1)&&(r[0]==1)) return(true);
	    if((r[1]==1)&&(r[0]==-1)) return(true);
	    if((r[1]==0)&&(r[0]==1)) return(true);
	    return(false);
    }





    /**This generates the covering of the line y=phi^{-1}
       by dynamical tiles.  The value of marker gives the
       limits of the cover.**/


    public void phiCover() {

	PolyWedge[] P=new PolyWedge[2000];
	double marker=-4;
	int count=0;

	while(marker<4) {

	  Complex z=new Complex(marker+.000001,GoldenRatio.phi(-1));
	    P[count]=makeTile(z);
	    P[count].print();
	    int orbit=P[count].orbit;
	    P[count]=P[count].orient();
	    P[count].orbit=orbit;
	    M.T.addPoly(P[count]);
	    Complex[] TEMP=P[count].intersectLine(GoldenRatio.phi(-1));
	    marker=TEMP[1].x;
	    M.T.repaint();
            ++count;
	}
    }

    public static PolyWedge makeTile(Complex z) {
           Vector V=TorusMap.theta(z);
           Polyhedron P=PolyhedronExchange.orbitTile(0,0,2,V,100000); 
	   PolyWedge W=PolyhedronSlicer.specialSlice(P,V);
	   W=W.translate(z);
	   W.orbit=P.orbit;
	   return(W);
    }












    /**This generates the data for the list of edges of the
       64 polyhedra in the 3D polyhedron exchange**/


    public void edgeList() {
	Output OUT=new Output("EdgeList.temp");
	for(int i=0;i<64;++i) {
	    GoldenPolyhedron P=DataPartition.getGoldenPolyhedron(i);
	    int[][] A=GoldenPolyCombinatorics.edgeList(P);
	    print2(OUT,A,i);
	}
    }

    public void print2(Output OUT,int[][] A,int q) {
	      OUT.print("public static int[][] E"+q+"() {");
	      OUT.print("int[][] A={");
              for(int i=0;i<A.length;++i) {
		  OUT.print("{"+A[i][0]+","+A[i][1]+"}");
		  if(i<A.length-1) OUT.print(",");
	      }
              OUT.print("};");
	      OUT.print("return(A);}");
	      OUT.println("");
    }







    /**Here is the data for the pinwheel map**/

    public void pinwheel() {
	Output OUT=new Output("DataPinwheel.temp");
	printTopMatter(OUT);
	PolyWedge[] P=new PolyWedge[2000];
	int count=0;

	int LIM=M.C.CON_D.getLimit(); //extent of plot
	int D=50;                     //density

	LIM=25;
	for(int i=-LIM*D;i<LIM*D;++i) {
	    if(i%D==0) System.out.println(i+" "+count);
	    for(int j=-2*D;j<2*D;++j) {
		Complex z=new Complex(1.0*i/D+.000001,1.0*j/D+.00001);
		if(isCovered(z,P,count)==false) {
		    P[count]=ComputeOuter.makeReturnTileForward(z,1);
		    P[count]=P[count].orient();
		    ++count;
		}
	    }
	}
	System.out.println(count);
	for(int i=0;i<count;++i) M.T.addPoly(P[i]);

	printChoice(OUT,count);
	for(int i=0;i<count;++i) { 
	    GoldenPolyWedge TEST=new GoldenPolyWedge(P[i],20,.00000001);
           print2(OUT,TEST,i);
	}

	OUT.println("public static int classify(int k) {");
	OUT.print("int[] A={");

	for(int i=0;i<count;++i) {
	    Complex z=P[i].getCenter();
	    int k=preClassify(z);
	    Integer K=new Integer(k);
	    OUT.print(K.toString());
	    if(i<count-1) OUT.print(",");
	    if(i==count-1) OUT.print("};");
	}
	OUT.print("return(A[k]);}");
	OUT.println("");
	OUT.println("}");

	M.T.repaint();
    }

    public static int preClassify(Complex z) {
	Vector V=TorusMap.theta(z);
	return(PolyhedronExchange.classify(V));
    }

    public void printTopMatter(Output OUT) {
	OUT.println("import java.applet.Applet;");
	OUT.println("import java.awt.*;");
	OUT.println("import java.awt.event.*;");
	OUT.println("import java.applet.*;");
	OUT.println("import java.awt.geom.*;");
	OUT.println("import java.math.*;");
	OUT.println("");
	OUT.println("public class DataPinwheel {");
	OUT.println("");

    }


    public void printChoice(Output OUT,int count) {

	OUT.println("public static int COUNT() {");
	OUT.println("return("+count+");");
	OUT.println("}");
	OUT.println("");
	OUT.println("");

	OUT.println("public static GoldenPolyWedge returnPoly(int i) {");
	OUT.println("return(new GoldenPolyWedge(returnData(i)));");
	OUT.println("}");
	OUT.println("");
	OUT.println("");

	OUT.println("public static int[][] returnData(int i) {");
	for(int i=0;i<count;++i) OUT.println("if(i=="+i+") return(returnData"+i+"());");
	OUT.println("return(null);");
	OUT.println("}");
	OUT.print("");
	OUT.print("");

    }

    public boolean isCovered(Complex z,PolyWedge[] P,int count) { 
	for(int i=0;i<count;++i) {
	    if(P[i].inside(z)==true) return(true);
	}
	return(false);
    }




    public void print2(Output OUT,GoldenPolyWedge P,int i) {
          if(P.count>0) {
	      OUT.println("public static int[][] returnData"+i+"() {");
	      OUT.print("int[][] A={");
              for(int q=0;q<P.count;++q) {
                if(q<P.count-1) OUT.print("{"+P.z[q].x.a[0]+","+P.z[q].x.a[1]+","+P.z[q].y.a[0]+","+P.z[q].y.a[1]+"},");
                if(q==P.count-1) OUT.print("{"+P.z[q].x.a[0]+","+P.z[q].x.a[1]+","+P.z[q].y.a[0]+","+P.z[q].y.a[1]+"}");


	      }
              OUT.println("};");
	      OUT.println("return(A);}");
	      OUT.println("");
	  }
    }



}