import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


/**These routines help produce the polyhedron coverings**/

public class GoldenPolyProbe {


    public static GoldenVector suggestPointB(GoldenPolyhedron[] LIST,int total,int LB,int branch) {
	for(int i=0;i<LIST.length;++i) {
	    GoldenPolyhedron P=LIST[i];
	    for(int j=0;j<P.count;++j) {
		GoldenVector V=P.V[j];
		for(int k=0;k<50;++k) {
		    GoldenVector W=DataPartition.interstitial(k);
		    GoldenReal r=new GoldenReal(75025,-46368);
		    GoldenVector X=GoldenVector.plus(V,W.scale(r));
		    boolean test1=inside(LIST,total,X);
		    boolean test2=DataRenorm.insideB(LB,branch,X.toVector());
		    if((test1==false)&&(test2==true)) return(X);
		}
	    }
	}
	return(null);
    }

    /**This is applied to the initial situation where the polyhedron is one 
       of the renorm B set.**/

    public static GoldenVector suggestPointB(GoldenPolyhedron P,int LB,int branch) {
	  for(int j=0;j<P.count;++j) {
      	    GoldenVector V=P.V[j];
	    for(int k=0;k<50;++k) {
	       GoldenVector W=DataPartition.interstitial(k);
	       GoldenReal r=new GoldenReal(75025,-46368);
               GoldenVector X=GoldenVector.plus(V,W.scale(r));
	       boolean test=DataRenorm.insideB(LB,branch,X.toVector());
	       if(test==true) return(X);
	    }
	  }
	return(null);
    }


    public static boolean inside(GoldenPolyhedron[] LIST,int total,GoldenVector V) {
	for(int i=0;i<total;++i) {
	    if(GoldenPolyCombinatorics.inside(LIST[i],V)==true) return(true);
	}
	return(false);
    }



}
