import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class GoldenPolyWedge {
    GoldenComplex[] z=new GoldenComplex[20];
    int count;
    int[] r=new int[2];
    int orbit;

    public GoldenPolyWedge() {}

    /**constructors**/

    public GoldenPolyWedge(PolyWedge X,int depth,double tol) {
	for(int i=0;i<X.count;++i) {
	    this.z[i]=new GoldenComplex(X.z[i],depth,tol);
	}
	this.r[0]=X.r[0];
	this.r[1]=X.r[1];
	this.count=X.count;
    }

    public GoldenPolyWedge(int[][] A) {
	this.count=A.length;
	for(int i=0;i<this.count;++i) this.z[i]=new GoldenComplex(A[i][0],A[i][1],A[i][2],A[i][3]);
    }


    public GoldenPolyWedge(GoldenPolyWedge P) {
	this.count=P.count;
	for(int i=0;i<this.count;++i) this.z[i]=new GoldenComplex(P.z[i]);
    }

    public PolyWedge toPolyWedge() {
	PolyWedge X=new PolyWedge();
        X.count=count;
	for(int i=0;i<count;++i) X.z[i]=this.z[i].toComplex();
	return(X);
    }

    /**print routines**/

    public void print() {
	for(int i=0;i<count;++i) this.z[i].print();
    }
    public void print1() {
	PolyWedge X=this.toPolyWedge();
	X.print();
    }

    public void print2() {
          if(count>0) {
	      System.out.print("{");
              for(int q=0;q<count;++q) {
                System.out.print("{"+z[q].x.a[0]+","+z[q].x.a[1]+","+z[q].y.a[0]+","+z[q].y.a[1]+"}");
                if(q!=count-1) System.out.print(",");
	      }
              System.out.print("},");
	  }
    }


    /**tests if a given point is a vertex of the polygon.*/

    public boolean hasVertex(GoldenComplex x) {
	for(int i=0;i<count;++i) {
	    if(GoldenComplex.equals(x,z[i])==true) return(true);
	}
	return(false);
    }


    /**This tests if the polygon is positively oriented and convex.**/

    public boolean isPositivelyConvex() {
	for(int k=0;k<count;++k) {
	  int k1=k;
	  int k2=(k+1)%count;
	  int k3=(k+2)%count;
	  GoldenComplex z1=new GoldenComplex(z[k1]);
	  GoldenComplex z2=new GoldenComplex(z[k2]);
	  GoldenComplex z3=new GoldenComplex(z[k3]);
	  boolean test=GoldenComplex.weakPositivelyOriented(z1,z2,z3);
	  if(test==false) return(false);
	}
	return(true);
    }

    /**translates the polygon**/

    public GoldenPolyWedge translate(GoldenComplex w) {
	GoldenPolyWedge Q=new GoldenPolyWedge();
	Q.count=count;
	for(int i=0;i<count;++i) Q.z[i]=GoldenComplex.plus(w,z[i]);
	return(Q);
    }


    /**complex-conjugates the polygon. That is, reflects it through
       the x-axis.**/

    public GoldenPolyWedge conjugate() {
	GoldenPolyWedge P=new GoldenPolyWedge();
	P.count=count;
	for(int i=0;i<count;++i) P.z[i]=z[i].conjugate();
	P.orbit=orbit;
	return(P);
    }



    /**This routine produces a point in the interior of the polygon
       whose coordinates lie in Z[phi].  We take a weighted average
       of the first three vertices, using units of Z[phi]. The point
       is not canonical, but it serves our purposes.*/

    public GoldenComplex cheapInterior() {
	GoldenComplex w=this.z[0];
	for(int i=1;i<this.count;++i) w=average(w,this.z[i]);
	return(w);
    }


    public static GoldenComplex average(GoldenComplex z,GoldenComplex w) {
      GoldenReal r1=new GoldenReal(-1,1);
      GoldenReal r2=new GoldenReal(2,-1);
      GoldenComplex X=GoldenComplex.plus(z.scale(r1),w.scale(r2));
      return(X);
    }



}

