import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class GoldenPolyhedron {
    GoldenVector[] V=new GoldenVector[20];
    int count;

    public GoldenPolyhedron() {}

    /**constructs a GoldenPolyhedron from an nX4 list of integers**/

    public GoldenPolyhedron(int[][] A) {
	this.count=A.length;
	for(int i=0;i<this.count;++i) {
	    this.V[i]=new GoldenVector(A[i]);
	}
    }
    public GoldenPolyhedron(GoldenVector[] LIST) {
	this.count=LIST.length;
	for(int i=0;i<this.count;++i) {
	    this.V[i]=new GoldenVector(LIST[i]);
	}
    }


    /**converts a regular polyhedron into a golden polyhedron
       by recognizing the vertices as elements of Z[phi]. Obviously,
       this is not sure-fire. However, it works in practice for the
       polyhedra of interest to us.*/

    public GoldenPolyhedron(Polyhedron X) {
	double d=.000000000001;
	for(int i=0;i<X.count;++i) {
	    int[] q0=GoldenRatio.recognize(X.V[i].x[0],11,d);
	    int[] q1=GoldenRatio.recognize(X.V[i].x[1],11,d);
	    int[] q2=GoldenRatio.recognize(X.V[i].x[2],11,d);
	    int[] q={q0[0],q0[1],q1[0],q1[1],q2[0],q2[1]};
	    this.V[i]=new GoldenVector(q);
	}
	this.count=X.count;
    }

    /**copy routine*/

    public GoldenPolyhedron(GoldenPolyhedron X) {
	this.count=X.count;
	for(int i=0;i<X.count;++i) {
	    this.V[i]=new GoldenVector(X.V[i]);
	}
    }

    /**removes duplicate vertices**/

    public GoldenPolyhedron trim1() {
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=0;
	for(int i=0;i<this.count;++i) {
	    if(this.redundant1(i)==false) {
		Q.V[Q.count]=this.V[i];
		++Q.count;
	    }
	}
	return(Q);
    }


    public boolean redundant1(int i) {
	for(int j=0;j<i;++j) {
	    if(GoldenVector.equals(V[i],V[j])==true) return(true);
	}
	return(false);
    }


    /**removes redundant vertices: vertices that lie on edges.**/
    public GoldenPolyhedron trim2() {
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=0;
	for(int i=0;i<this.count;++i) {
	    if(this.redundant2(i)==false) {
		Q.V[Q.count]=this.V[i];
		++Q.count;
	    }
	}
	return(Q);
    }




    public boolean redundant2(int i) {
	for(int j=0;j<count;++j) {
	    for(int k=0;k<count;++k) {
		if(redundant2(i,j,k)==true) return(true);
	    }
	}
	return(false);
    }



    public boolean redundant2(int i,int j,int k) {
	if(i==j) return(false);
	if(j==k) return(false);
	if(i==k) return(false);
	GoldenVector V1=V[i];
	GoldenVector V2=V[j];
	GoldenVector V3=V[k];
	GoldenVector V12=GoldenVector.minus(V1,V2);
	GoldenVector V31=GoldenVector.minus(V3,V1);
	boolean test=GoldenVector.isPositiveMultiple(V12,V31);
	return(test);
    }




    /**converts back to an ordinary polyhedron**/

    public Polyhedron toPolyhedron() {
	double PHI=(1.0+Math.sqrt(5.0))/2.0;
	Polyhedron X=new Polyhedron();
        X.count=count;
	for(int i=0;i<count;++i) {
	    X.V[i]=this.V[i].toVector();
	}
	return(X);
    }

    /**scaling*/
    public GoldenPolyhedron scale(GoldenReal t) {
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=this.count;
	for(int i=0;i<count;++i) {
	    Q.V[i]=V[i].scale(t);
	}
	return(Q);
    }

    public GoldenPolyhedron scale(int k) {
	return(scale(new GoldenReal(k,0)));
    }


    /**translating*/

    public GoldenPolyhedron translate(GoldenVector W) {
	GoldenPolyhedron P=new GoldenPolyhedron();
	P.count=this.count;
	for(int i=0;i<P.count;++i) P.V[i]=GoldenVector.plus(W,V[i]);
	return(P);
    }


    /**affine maps: used with the renorm sets**/

    public GoldenPolyhedron affine(int[] a) {
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=this.count;
	for(int i=0;i<Q.count;++i) {
	    Q.V[i]=GoldenVector.affine(a,this.V[i]);
	}
	return(Q);
    }

    /**The canonical reflection*/

    public GoldenPolyhedron reflect() {
	GoldenVector W=new GoldenVector(2,0,2,0,2,0);
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=this.count;
	for(int i=0;i<Q.count;++i) Q.V[i]=GoldenVector.minus(W,this.V[i]);
	return(Q);
    }


    /**This routine produces a point in the interior of the
       polyhedron, which is defined over Z[phi]**/

    public GoldenVector cheapInterior() {
	GoldenVector W=this.V[0];
	for(int i=1;i<this.count;++i) W=average(W,this.V[i]);
	return(W);
    }


    public GoldenVector average(GoldenVector V,GoldenVector W) {
      GoldenReal r1=new GoldenReal(-1,1);
      GoldenReal r2=new GoldenReal(2,-1);
      GoldenVector X=GoldenVector.plus(V.scale(r1),W.scale(r2));
      return(X);
    }


    /**printing routines**/

    public void print() {
	for(int i=0;i<count;++i) {
	    V[i].print();
	}
    }


    public void print2() {
	for(int i=0;i<count;++i) {
	    V[i].print2();
	}
    }

    public void print22() {
	for(int i=0;i<count;++i) {
	    Vector W=V[i].toVector();
	    W=W.scale(.5);
	    W.print();
	}
    }

    public void print3() {
	System.out.print("{");
	for(int i=0;i<count;++i) {
	    GoldenVector W=V[i];
	    System.out.print("{"+W.x[0].a[0]+","+W.x[0].a[1]+","+W.x[1].a[0]+","+W.x[1].a[1]+","+W.x[2].a[0]+","+W.x[2].a[1]+"}");
	    if(i<count-1) System.out.print(",");
	}
	System.out.print("}");
    }



    /**These two routines, practically identical, are what
       we use to print the polyhedra out in LaTeX form*/

    public void texPrint(String S) {
	System.out.println("\\begin{eqnarray}");
	System.out.println("\\nonumber");
	System.out.print(S+"=");
	for(int i=0;i<count;++i) {
	    GoldenVector W=V[i];
	    System.out.print("\\left[\\matrix{");
	    System.out.print(W.x[0].a[0]+"&"+W.x[0].a[1]+"\\cr ");
	    System.out.print(W.x[1].a[0]+"&"+W.x[1].a[1]+"\\cr ");
	    System.out.print(W.x[2].a[0]+"&"+W.x[2].a[1]+"}\\right]");
	    if(i==5) {
                System.out.print("\\");
                System.out.print("\\");
                System.out.print(" \\nonumber ");
	    }
	}
	System.out.println("");
	System.out.println("\\end{eqnarray}");
	System.out.println("");
    }





}

