import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class GoldenVector {
    GoldenReal[] x=new GoldenReal[3];

    public GoldenVector(){}

    public GoldenVector(GoldenVector V){
	x[0]=new GoldenReal(V.x[0]);
	x[1]=new GoldenReal(V.x[1]);
	x[2]=new GoldenReal(V.x[2]);
    }

    public GoldenVector(GoldenReal[] y) {
	x[0]=new GoldenReal(y[0]);
	x[1]=new GoldenReal(y[1]);
	x[2]=new GoldenReal(y[2]);
    }

    public GoldenVector(GoldenReal r0,GoldenReal r1,GoldenReal r2) {
	GoldenReal[] y={r0,r1,r2};
	x[0]=new GoldenReal(y[0]);
	x[1]=new GoldenReal(y[1]);
	x[2]=new GoldenReal(y[2]);
    }

    public GoldenVector(int[] a) {
	x[0]=new GoldenReal(a[0],a[1]);
        x[1]=new GoldenReal(a[2],a[3]);
        x[2]=new GoldenReal(a[4],a[5]);
    }

    public GoldenVector(int a0,int a1,int a2,int a3,int a4,int a5) {
	int[] a={a0,a1,a2,a3,a4,a5};
	x[0]=new GoldenReal(a[0],a[1]);
        x[1]=new GoldenReal(a[2],a[3]);
        x[2]=new GoldenReal(a[4],a[5]);
    }

    public Vector toVector() {
	Vector V=new Vector();
	for(int i=0;i<3;++i) {
	    V.x[i]=this.x[i].toDouble();
	}
	return(V);
    }


    public GoldenVector(Vector V){
	double d=.00000000001;
            int[] q0=GoldenRatio.recognize(V.x[0],11,d);
	    int[] q1=GoldenRatio.recognize(V.x[1],11,d);
	    int[] q2=GoldenRatio.recognize(V.x[2],11,d);
	    int[] q={q0[0],q0[1],q1[0],q1[1],q2[0],q2[1]};
	    GoldenVector G=new GoldenVector(q);
	    for(int i=0;i<3;++i) x[i]=G.x[i];
    }



    public static GoldenVector bestFit(Vector V,int d){
            int[] q0=GoldenRatio.bestFit(V.x[0],d);
	    int[] q1=GoldenRatio.bestFit(V.x[1],d);
	    int[] q2=GoldenRatio.bestFit(V.x[2],d);
	    int[] q={q0[0],q0[1],q1[0],q1[1],q2[0],q2[1]};
	    GoldenVector G=new GoldenVector(q);
	    return(G);
    }


    /** W --> tW + V**/

    public GoldenVector affine(GoldenReal t,GoldenVector V) {
	return(GoldenVector.plus(V,this.scale(t)));
    }

    /** W -> (1/t) W - (1/t) V
        We only use this when t is a unit, so that we can divide
        and remain in the ring**/

    public GoldenVector affineInverse(GoldenReal t,GoldenVector V) {
	GoldenReal s=GoldenReal.specialDivide(new GoldenReal(1,0),t);
	return(minus(this.scale(s),V.scale(s)));
    }

    /** going from the raw data**/
    public static GoldenVector affine(int[] a,GoldenVector W) {
	GoldenReal r=new GoldenReal(a[0],a[1]);
	GoldenVector V=new GoldenVector(a[2],a[3],a[4],a[5],a[6],a[7]);
	return(W.affine(r,V));
    }
    /** going from the raw data**/
    public static GoldenVector affineInverse(int[] a,GoldenVector W) {
	GoldenReal r=new GoldenReal(a[0],a[1]);
	GoldenVector V=new GoldenVector(a[2],a[3],a[4],a[5],a[6],a[7]);
	return(W.affineInverse(r,V));
    }

    public GoldenVector scale(GoldenReal t) {
	GoldenVector V=new GoldenVector();
	for(int i=0;i<3;++i) V.x[i]=GoldenReal.times(x[i],t);
	return(V);
    }

    /**adds 2 vectors*/

    public static GoldenVector plus(GoldenVector V1,GoldenVector V2) {
	GoldenVector W=new GoldenVector();
	for(int i=0;i<3;++i) W.x[i]=GoldenReal.plus(V1.x[i],V2.x[i]);
	return(W);
    }

    public static GoldenVector minus(GoldenVector V1,GoldenVector V2) {
	GoldenVector W=new GoldenVector();
	for(int i=0;i<3;++i) W.x[i]=GoldenReal.minus(V1.x[i],V2.x[i]);
	return(W);
    }

    public static GoldenReal dot(GoldenVector V,GoldenVector W) {
	GoldenReal d=new GoldenReal(0,0);
	for(int i=0;i<3;++i) {
	    d=GoldenReal.plus(d,GoldenReal.times(V.x[i],W.x[i]));
	}
	return(d);
    }

    public static GoldenVector cross(GoldenVector v,GoldenVector w) {
	GoldenVector X=new GoldenVector();
	X.x[0]=GoldenReal.minus(GoldenReal.times(v.x[1],w.x[2]),GoldenReal.times(w.x[1],v.x[2]));
	X.x[1]=GoldenReal.minus(GoldenReal.times(v.x[2],w.x[0]),GoldenReal.times(w.x[2],v.x[0]));
	X.x[2]=GoldenReal.minus(GoldenReal.times(v.x[0],w.x[1]),GoldenReal.times(w.x[0],v.x[1]));
	return(X);
    }



    public static GoldenVector normal(GoldenVector W0,GoldenVector W1,GoldenVector W2) {
	GoldenVector X1=GoldenVector.minus(W1,W0);
	GoldenVector X2=GoldenVector.minus(W2,W0);
	return(GoldenVector.cross(X1,X2));
    }



    public static boolean isPositiveMultiple(GoldenVector V1,GoldenVector V2) {
	GoldenVector W=cross(V1,V2);
	if(W.isZero()==false) return(false);
	for(int i=0;i<3;++i) {
	    GoldenReal r=GoldenReal.times(V1.x[i],V2.x[i]);
	    if(r.isPositiveOrZero()==false) return(false);
	}
	return(true);
    }

    public static boolean equals(GoldenVector V,GoldenVector W) {
	for(int i=0;i<3;++i) {
	    if(GoldenReal.equals(V.x[i],W.x[i])==false) return(false);
	}
	return(true);
    }


    public static GoldenVector random(int N) {
	GoldenReal[] x=new GoldenReal[3];
	for(int i=0;i<3;++i) x[i]=GoldenReal.random(N);
	GoldenVector V=new GoldenVector(x);
	return(V);
    }

    public void print() {
	for(int i=0;i<3;++i) System.out.print(x[i].a[0]+" + "+x[i].a[1]+" phi     ");
	System.out.println("");
    }

    public void print2() {
	for(int i=0;i<3;++i) System.out.print(x[i].toDouble()+" ");
	System.out.println("");
    }

    public void print22() {
	for(int i=0;i<3;++i) System.out.print(.5*x[i].toDouble()+" ");
	System.out.println("");
    }


    public void print4() {
      System.out.print("{"+x[0].a[0]+","+x[0].a[1]+","+x[1].a[0]+","+x[1].a[1]+","+x[2].a[0]+","+x[2].a[1]+"}");
    }



    public int maxCoeff() {
	int max=0;
	for(int i=0;i<3;++i) {
	    int test=(int)(Math.abs(x[i].a[0]));
	    if(max<test) max=test;
	    test=(int)(Math.abs(x[i].a[1]));
	    if(max<test) max=test;
	}
	return(max);
    }


    /**Computes the volume of a tetrahedron*/

    public static GoldenReal volume(GoldenVector[] V) {
	GoldenVector[] W=new GoldenVector[3];
	for(int i=0;i<3;++i) W[i]=minus(V[i],V[3]);
	GoldenReal t=tripleProduct(W[0],W[1],W[2]);
	if(t.isZero()==true) return(t);
	if(t.isPositive()==true) return(t);
	t=new GoldenReal(-t.a[0],-t.a[1]);
	if(t.isPositive()==false) return(null);  //should never happen
	return(t);
    }

    public static GoldenReal tripleProduct(GoldenVector V1,GoldenVector V2,GoldenVector V3) {
	return(dot(V1,cross(V2,V3)));
    }


    public static GoldenVector zero() {
	int[] a={0,0,0,0,0,0};
	GoldenVector Z=new GoldenVector(a);
	return(Z);
    }


    public boolean isZero() {
	if(equals(this,zero())==true) return(true);
	return(false);
    }
    public GoldenVector negate() {
	return(minus(zero(),this));
    }

    /**This produces a vector perpendicular to V that lies in
       the plane spanned by V and W.  This is like Gram-Schmidt,
       except that we don't want to divide.**/

    public static GoldenVector ortho(GoldenVector V,GoldenVector W) {
	GoldenVector X1=W.scale(dot(V,V));
	GoldenVector X2=V.scale(dot(V,W));
	GoldenVector X=minus(X1,X2);
	return(X);
    }

}






