import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the integer arithmetic
  of 4D vectors */


public class GoldenVector4 {
    GoldenReal[] x=new GoldenReal[4];

    public GoldenVector4(){}

    public GoldenVector4(GoldenVector4 V){
	for(int i=0;i<4;++i) x[i]=new GoldenReal(V.x[i]);
    }


    public GoldenVector4(GoldenReal x0,GoldenReal x1,GoldenReal x2,GoldenReal x3) {
	x[0]=new GoldenReal(x0);
	x[1]=new GoldenReal(x1);
	x[2]=new GoldenReal(x2);
	x[3]=new GoldenReal(x3);
    }

    public GoldenVector4(GoldenReal[] y) {
	for(int i=0;i<4;++i) x[i]=new GoldenReal(y[i]);
    }

    public GoldenVector4(Vector4 V) {
	for(int i=0;i<4;++i) {
	    this.x[i]=new GoldenReal(V.x[i],100);
	}
    }

    public static GoldenVector4 plus(GoldenVector4 V1,GoldenVector4 V2) {
	GoldenVector4 W=new GoldenVector4();
	for(int i=0;i<4;++i) W.x[i]=GoldenReal.plus(V1.x[i],V2.x[i]);
	return(W);
    }

    public static GoldenVector4 minus(GoldenVector4 V1,GoldenVector4 V2) {
	GoldenVector4 W=new GoldenVector4();
	for(int i=0;i<4;++i) W.x[i]=GoldenReal.minus(V1.x[i],V2.x[i]);
	return(W);
    }

    public boolean equals(GoldenVector4 V,GoldenVector4 W) {
	for(int i=0;i<4;++i) {
	    if(GoldenReal.equals(V.x[i],W.x[i])==false) return(false);
	}
	return(true);
    }

    public GoldenReal[] toComponents() {
	GoldenReal[] y=new GoldenReal[4];
	for(int i=0;i<4;++i) y[i]=new GoldenReal(x[i]);
	return(y);
    }

    public static GoldenVector4 random(int N) {
	GoldenReal[] x=new GoldenReal[4];
	for(int i=0;i<4;++i) x[i]=GoldenReal.random(N);
	GoldenVector4 V=new GoldenVector4(x);
	return(V);
    }


    public Vector4 toVector4() {
	Vector4 V=new Vector4();
	for(int i=0;i<4;++i) V.x[i]=this.x[i].toDouble();
	return(V);
    }


    public void print() {
	for(int i=0;i<4;++i) this.x[i].print();
    }

}




