import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

import java.awt.geom.*;
import java.math.*;



public class GraphCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    int TYPE;

    AffineTransform[] A=new AffineTransform[5];
    Complex SOURCE;
    Complex MOVE;
    Output OUT;
    Point KEY;
    ListenSquare INFO;

    Color[] COLOR=new Color[100000];
    GeneralPath[] GP=new GeneralPath[100000];

    int SELECT=-1;
    int[] type={3,0};
    int count=0;

    public GraphCanvas(int type) {
	TYPE=type;
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	KEY=new Point();
        SOURCE=new Complex(0,0);
	setScales(200,160,15);
	INFO=new ListenSquare(0,0,12,12);
    }

    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
      RenderingHints.VALUE_ANTIALIAS_ON);
      OUT=new Output("Output/graph");
      OUT.ACTIVE=false;
      if(M.C.EXPORT.on==1) OUT.ACTIVE=true;

      OUT.tclBgSet(M.C.CON_G.MARKINGS.M[0].C);

      drawBG(g);
      if(M.C.CON_G.MARKINGS.L[1].on==1) drawAxesGraph(g,TYPE);
      if(M.C.CON_G.MARKINGS.L[2].on==1)drawGridGraph(g,TYPE);
      if(M.C.CON_G.MARKINGS.L[3].on==1)drawHalflineGraph(g,TYPE);
      drawPath(g); 
      drawSource(g);  
      g.setColor(Color.white);
      g.drawRect(0,0,getWidth()-1,getHeight()-1);  
      INFO.infoRender(g);
    }

    public void drawBG(Graphics2D g) {
      g.setColor(M.C.CON_G.MARKINGS.M[0].C);
      g.fillRect(0,0,this.getWidth(),this.getHeight());
    }

    /**this is the general routine*/

    public void drawPath(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	  g.setColor(COLOR[i]);
          g.setStroke(new BasicStroke((float)(3)));
	  gp=new GeneralPath(GP[i]);   
          OUT.polyPrint(gp,COLOR[i],COLOR[i]);
	  gp=transform(gp);
	  g.setColor(COLOR[i]);
	  g.draw(gp);
	}
        g.setStroke(new BasicStroke(1));
    }

  public void drawSource(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	float x=(float)(SOURCE.x);
	float y=(float)(SOURCE.y);
	gp.moveTo((float)(x-.5),(float)(y-.5));
	gp.lineTo((float)(x-.5),(float)(y+.5));
	gp.lineTo((float)(x+.5),(float)(y+.5));
	gp.lineTo((float)(x+.5),(float)(y-.5));
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.yellow);
	g.draw(gp);
  }

    public void selectPoint(Point X) {

	//integer valued selection
                 MOVE=unTransform(X);
	MOVE.x=1*Math.floor(MOVE.x+.5);
	MOVE.y=1*Math.floor(MOVE.y+.5);


	int test=-1;
	for(int i=0;i<count;++i) {
	    if(GP[i].intersects(MOVE.x-2,MOVE.y-2,4,4)==true) test=i;
	}	
	M.K.IS[0].val=(int)(MOVE.x);
	M.K.IS[1].val=(int)(MOVE.y);
	SOURCE=new Complex(MOVE);
	if(test!=-1) SELECT=test;
    }

    /**add new path to list: invoked by the arithmetic graph computer*/

    public void nextPathLast(GeneralPath X) {
	nextPathLast(X,M.K.SC.C,false);
    }

    public void nextPathLast(GeneralPath X,Color C) {
	double A=2+Math.sqrt(5);
        GP[count]=new GeneralPath(X);
        COLOR[count]=C;
        ++count;
    }

    public void nextPathLast(GeneralPath X,Color C,boolean sc) {
	double A=2+Math.sqrt(5);
	AffineTransform AFF=AffineTransform.getScaleInstance(A,A);
	GeneralPath Y=new GeneralPath(X);
	if(sc==true) Y.transform(AFF);
        GP[count]=new GeneralPath(Y);
        COLOR[count]=C;
        ++count;
    }



    /**markings*/

    public void drawAxesGraph(Graphics2D g,int TYPE) {
	GeneralPath gp=new GeneralPath(); 
	Color  CC=M.C.CON_G.MARKINGS.M[1].C;
	int WW=1000;
	gp.moveTo(0,0);
        gp.lineTo(-WW,0);
	gp.lineTo(+WW,0);
	gp.lineTo(0,0);
        gp.lineTo(0,-WW);
	gp.lineTo(0,WW);
	OUT.polyPrint(gp,CC,CC);
	gp=transform(gp);
        g.setColor(CC);
	g.draw(gp);  
    }

    public void drawHalflineGraph(Graphics2D g,int TYPE) {
	double A=Math.sqrt(5.0)-2.0;
	double d=M.C.getOffsetX(1);
	d=.5*d;
	Color  CC=M.C.CON_G.MARKINGS.M[3].C;
        int WW=1000;
	GeneralPath gp=new GeneralPath(); 
	gp.moveTo((float)(-WW),(float)(-d+WW*A));
	gp.lineTo((float)(+WW),(float)(-d-WW*A));
	g.setColor(CC);	
        OUT.polyPrint(gp,CC,CC);
	gp=transform(gp);
	g.fill(gp);  
        g.draw(gp);
    }

    public void drawGridGraph(Graphics2D g,int TYPE) {
  	GeneralPath gp=new GeneralPath(); 
	Color  CC=M.C.CON_G.MARKINGS.M[2].C;
	AffineTransform A=AffineTransform.getTranslateInstance(M.A1.SOURCE.x,M.A1.SOURCE.y);
	for(int i=-50;i<=50;++i) {
	  gp.moveTo(-50,i);
	  gp.lineTo(+50,i);
	  gp.transform(A);
  	  OUT.polyPrint(gp,CC,CC);
	  gp=transform(gp);
	  g.setColor(CC);
	  g.draw(gp);
	  gp.reset();
	}

	for(int i=-50;i<=50;++i) {
	  gp.moveTo(i,50);
	  gp.lineTo(i,-50);  
          gp.transform(A);
  	  OUT.polyPrint(gp,CC,CC);
	  gp=transform(gp);
	  g.setColor(CC);
	  g.draw(gp);
	  gp.reset();
	}

    }




    /**mouse events */
   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}


   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

    public void mouseMoved(MouseEvent e) {
      MouseData J=MouseData.process(e);
      KEY=J.X;
    }


    public void mouseClicked(MouseEvent e) {

      MouseData J=MouseData.process(e);
      doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {  
        int block=INFO.inside(KEY);
	if((block==0)&&(mode==1))  scaleUp(KEY,0);
	if((block==0)&&(mode==3))  scaleUp(KEY,1);

       if(mode==2) {
          selectPoint(KEY);
          if(M.C.LINK.L[1].on==1) Links.gridToTorus(M);
          if(M.C.LINK.L[2].on==1) Links.gridToStrip(M);
       }
       documentStuff(M,KEY);
       M.repaint();
   }

  
    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }



    public void documentStuff(Manager M,Point X) {
	DocumentGraph DOC=new DocumentGraph(M);
	if(INFO.inside(X)==1) DOC.arithmeticGraphInfo();
    }


}
