import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class helps navigate the partition**/



public class LineCanvas extends ScaleCanvas implements MouseListener  {

     public LineCanvas() {
	 addMouseListener(this);
	 setScales(500,500,200,200);
     }

   public void paint(Graphics g2) {
         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
         drawBG(g); 
	 drawLines(g);
	 drawPoints(g);
	 drawFrame(g);
   }


    public GeneralPath line(double a1,double a2,double a3,double a4) {
	Complex z1=new Complex(a1,a2);
	Complex z2=new Complex(a3,a4);
	Complex z3=new Complex(10*z1.x-9*z2.x,10*z1.y-9*z2.y);
	Complex z4=new Complex(10*z2.x-9*z1.x,10*z2.y-9*z1.y);
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z3.x),(float)(z3.y));
	gp.lineTo((float)(z4.x),(float)(z4.y));
	return(gp);
    }


    public void drawLines(Graphics2D g) {
	g.setColor(Color.white);
	GeneralPath gp=new GeneralPath();

	gp.reset();
	gp=line(1,0,0,0);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,1,0,0);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,1,1,1);
	gp=transform(gp);
	g.draw(gp);

	double p1=GoldenRatio.phi(1);
	double p2=GoldenRatio.phi(2);
	double p3=GoldenRatio.phi(3);

	gp.reset();
	gp=line(0,0,1,p1);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,0,1,p3);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,0,-1,p2);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,1,-1,1+p2);
	gp=transform(gp);
	g.draw(gp);

	gp.reset();
	gp=line(0,1,1,1+p3);
	gp=transform(gp);
	g.draw(gp);
    }


    public void drawPoints(Graphics2D g) {
	for(int i=0;i<25;++i) {  
            GoldenVector GV=DataPartition.interstitial(i);
	    Vector V=GV.toVector();
	    Complex z=new Complex(V.x[0]/V.x[2],V.x[1]/V.x[2]);
	    drawSource(g,Color.red,z,.01);
	}
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
        g.fillRect(0,0,getWidth(),getHeight());	
    }

    public void drawFrame(Graphics2D g) {
	g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }



    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {}

}

