

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class PolygonIntersector {
    public PolygonIntersector() {}



    /**Here is the main routine. It intersects two polyvectors.
       The routine works by considering one polygon as the intersection
       of halfplanes.  Then, the routine SingleChop intersects a general
       polygon with a halfplane, repeatedly, until all halfplanes are used.**/


    public static PolyVector polyChop(PolyVector PV,PolyVector VE) {
	PolyVector Q1=new PolyVector(PV);

	if(VE==null) return(null);
	for(int i=0;i<VE.count;++i) {
	    if(Q1==null) return(null);
	    int i1=i+0;
	    int i2=i+1;
	    int i3=i+2;
	    if(i2>=VE.count) i2=i2-VE.count;
	    if(i3>=VE.count) i3=i3-VE.count;
	    Vector V1=VE.V[i1];
	    Vector V2=VE.V[i2];
	    Vector V3=VE.V[i3];
	    Vector W1=new Vector(10000*V1.x[0]-9999*V2.x[0],10000*V1.x[1]-9999*V2.x[1]);
	    Vector W2=new Vector(10000*V2.x[0]-9999*V1.x[0],10000*V2.x[1]-9999*V1.x[1]);
	    Q1=singleChop(W1,W2,V3,Q1);
	    Q1=Q1.normalize();
	}
	return(Q1);
    }


    /**This routine intersects a halfplane with a polygon. The
       vectors V1,V2 lie on the halfplane boundary, and V3
       lies in the interior.  Here V3 is just used to get a
       single inside point**/


    public static int[] extractOnes(int[][] K) {
	int[] A=new int[K[0].length];
	int count=0;
        for(int i=0;i<K[0].length;++i) {
	  if(K[0][i]==1) {
            A[count]=i;
	    ++count;
	  }
	}
	int[] B=new int[count];
	for(int i=0;i<count;++i) B[i]=A[i];
	return(B);
    }

    public static PolyVector singleChop(Vector V1,Vector V2,Vector V3,PolyVector P) {
	if(P==null) return(null);
	int[][] K=intersectProfile(V1,V2,V3,P);
	if(K[1][0]==1) return(P);                //(V1,V2) lies on an edge
	if(K[1][1]==1) return(P);                //no vertices on wrong side

	Vector[] W=findIntersect(V1,V2,P,K);
	PolyVector Q=new PolyVector();
        int[] A=extractOnes(K);

	if(A.length==1) {
	    Q.V[0]=W[1];
	    Q.V[1]=W[0];
	    Q.V[2]=P.V[A[0]];
	    Q.count=3;
            return(Q);
	}

	int total=A.length;
	Q.count=A.length+2;
	int[] B=gapRotate(A,total,P.count);
	for(int i=0;i<total;++i) Q.V[i]=P.V[B[i]];
	Q.V[total]=W[1];
	Q.V[total+1]=W[0];
	int test=checkLineCross(Q.V[0],W[0],Q.V[total-1],W[1]);
	if(test==1) {Q.V[total]=W[0];Q.V[total+1]=W[1];}
	return(Q);
    }


    public static Vector[] findIntersect(Vector Vec1,Vector Vec2,PolyVector P,int[][] K) {

    Vector[] W=new Vector[2];
      if(K[1][2]==2) {
	W[0]=P.V[K[1][3]];
	W[1]=P.V[K[1][4]];
	return(W);
      }

      if(K[1][2]==1) {
	W[0]=P.V[K[1][3]];
	int i1=K[1][6];
	int i2=(i1+1)%P.count;	
	W[1]=Vector.findCross(Vec1,Vec2,P.V[i1],P.V[i2]);
	return(W);
      }

      if(K[1][5]==2) {
	int i1=K[1][6];
	int i2=(i1+1)%P.count;
	W[0]=Vector.findCross(Vec1,Vec2,P.V[i1],P.V[i2]);
	int i3=K[1][7];
	int i4=(i3+1)%P.count;
	W[1]=Vector.findCross(Vec1,Vec2,P.V[i3],P.V[i4]);
	return(W);
      }
      return(null);
    }






    /*checks if the line V1V2 crosses the line V3V4*/

    public static int checkLineCross(Vector V1,Vector V2,Vector V3,Vector V4) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	Vector W3=V3.normalize();
	Vector W4=V4.normalize();
	double o1=Vector.tripleProduct(W1,W2,W3);
	double o2=Vector.tripleProduct(W1,W2,W4);

      if(Math.abs(o1)<.000001) return(1);
      if(Math.abs(o2)<.000001) return(1);
      if(o1*o2<0) return(1);
      return(0);
    }


    /* checks if the segment V1V2 crosses the segment V3V4 */

    public static int checkSegmentCross(Vector V1,Vector V2,Vector V3,Vector V4) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	Vector W3=V3.normalize();
	Vector W4=V4.normalize();

	if(V1.between(V3,V1,V4)==1) return(1);
	if(V1.between(V3,V2,V4)==1) return(1);
	if(V1.between(V1,V3,V2)==1) return(1);
	if(V1.between(V1,V4,V2)==1) return(1);

	double o1=Vector.tripleProduct(W1,W2,W3);
	double o2=Vector.tripleProduct(W1,W2,W4);
	double o3=Vector.tripleProduct(W1,W3,W4);
	double o4=Vector.tripleProduct(W2,W3,W4);

	if(Math.abs(o1)<.000000001) return(0);
	if(Math.abs(o2)<.000000001) return(0);
	if(Math.abs(o3)<.000000001) return(0);
	if(Math.abs(o4)<.000000001) return(0);

	if(o1*o2>0) return(0);
	if(o3*o4>0) return(0);
	return(1);
    }

    /**This routine starts with a list of integers, for instance
       0 2 3 4 5 6 0
       and rotates the list so that the "gap" is removed:
       2 3 4 5 6 0
    **/

    public static int[] gapRotate(int[] A,int t1,int t2) {

	int ind=gapIndex(A,t1,t2);
	int[] B=new int[t1];
	if(ind>=0) {
	    for(int i=0;i<t1;++i) {
		B[i]=A[(i+ind+1)%t1];
	    }
	    return(B);
	}
	return(A);
    }

    public static int gapIndex(int[] A,int t1,int t2) {
	for(int i1=0;i1<t1;++i1) {
	    int i2=(i1+1)%t1;
	    int d=Math.abs(A[i1]-A[i2]);
	    d=d%t2;
	    if(d>1) return(i1);
	}
	return(-1);
    }



  public static int[][] intersectProfile(Vector V1, Vector V2, Vector V3, PolyVector P) {
    int[][] K=new int[2][P.count+8];
    int edge=0;
    int corner1=-2;
    int corner2=-2;
    int edge1=-2;
    int edge2=-2;
    int edgecount=0;
    int cornercount=0;
    int bad=0;
    double o1;
    double o2=Vector.tripleProduct(V1,V2,V3);
    for(int i=0;i<P.count;++i) {
	o1=Vector.tripleProduct(V1,V2,P.V[i]);
	if(o1*o2>0) K[0][i]=1;
	if(o1*o2<0) K[0][i]=-1;
	if(Math.abs(o1)<.00001) K[0][i]=0;
	if(K[0][i]<0) ++bad;
	if((i>0)&&(K[0][i]==0)&&(K[0][i-1]==0)) edge=1;
	if((cornercount==1)&&(K[0][i]==0)) {corner2=i;++cornercount;}
	if((cornercount==0)&&(K[0][i]==0)) {corner1=i;++cornercount;}
	if((edgecount==1)&&(i>0)&&(K[0][i]*K[0][i-1]<0)) {edge2=i-1;++edgecount;}
	if((edgecount==0)&&(i>0)&&(K[0][i]*K[0][i-1]<0)) {edge1=i-1;++edgecount;}
    }

    if((edgecount==0)&&(K[0][0]*K[0][P.count-1]<0)) {edge1=P.count-1;++edgecount;}
    if((edgecount==1)&&(K[0][0]*K[0][P.count-1]<0)) {edge2=P.count-1;++edgecount;}

    if((K[0][0]==0)&&(K[0][P.count-1]==0)) edge=1;
    K[1][0]=edge;
    if(bad==0) K[1][1]=1;
    K[1][2]=cornercount;
    K[1][3]=corner1;
    K[1][4]=corner2;
    K[1][5]=edgecount;
    K[1][6]=edge1;
    K[1][7]=edge2;
    return(K);
  }


}
