import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This class contains the proof that our list of polyhedra
in the partition of the 3-torus is actually a partition of the
torus.  We perform 3 tests:

1. check that all the polyhedra are strictly convex.
2. check that the polyhedra have pairwise disjoint interiors.
3. check that the polyhedra form a covering.

The second and third test involve first refining the list of
polyhedra into a list of tetrahedra, which are easier to
handle systematically. The third test involves checking the
links of the edges, at sufficiently many slices.**/


public class Proof3DCover implements Runnable {
    int halt;


    public void run() {
	checkPlatinum();
	checkConvex();
	checkDisjoint();
	checkCover();
    }


    public void checkTemp() {
	GoldenPolyhedron[] LIST=polyList();
	GoldenReal[] LIST2=DataPartition.heightList(); 
        LIST2=GoldenReal.interlace(LIST2);
	for(int i=0;i<64;++i) {
	    for(int j=0;j<10;++j) {
	GoldenPolyWedge Q=GoldenPolyCombinatorics.intersect(LIST[i],LIST2[j]);
	if(Q!=null) Q.print();
	System.out.println("---");
	    }}
    }


    /**DISJOINTNESS TEST**/

    public void checkDisjoint() {
	int total=0;
	System.out.println("start disjoint test");
	GoldenPolyhedron[] LIST=polyList();
	LIST=TetraSplit.split(LIST);
	for(int i=0;i<LIST.length;++i) {
	  for(int j=i+1;j<LIST.length;++j) {
	      GoldenPolyhedron P1=LIST[i];
	      GoldenPolyhedron P2=LIST[j];
	      boolean test=TetraDisjoint.disjoint(P1,P2);
	      if(test==false) ++total;
	  }
	}
	System.out.println("failures "+total);
    }

    /**We call an edge of a polyhedron platinum if it intersects every
       Z[phi] horizontal slice in a point whose coords are in Z[phi].
       We call a golden polyhedron platinum if all its non-horizontal edges
       are golden.  Just for fun, we verify that all the polyhedra in
       our partition are platinum.**/
       

    public void checkPlatinum() {
	System.out.println("platinum test");
	GoldenPolyhedron[] LIST=polyList();
	int total=0;
	for(int i=0;i<LIST.length;++i) {
	    boolean test=testPlatinum(LIST[i]);
	    if(test==false) ++total;
	}
	System.out.println("failures "+total);
    }


    public static boolean testPlatinum(GoldenPolyhedron P) {
	int[][] LIST=GoldenPolyCombinatorics.edgeList(P);
	for(int a=0;a<LIST.length;++a) {
	    int i=LIST[a][0];
	    int j=LIST[a][1];
	    boolean test1=GoldenPolyCombinatorics.edge(P,i,j);
	    boolean test2=testPlatinum(P,i,j);
	    if((test1==true)&&(test2==false)) return(false);
	}
	return(true);
    }

    public static boolean testPlatinum(GoldenPolyhedron P,int i,int j) {
	GoldenVector[] V={P.V[i],P.V[j]};
	return(testPlatinum(V));
    }

    public static boolean testPlatinum(GoldenVector[] V) {
	Vector V1=V[0].toVector();
	Vector V2=V[1].toVector();
	double d=V2.x[2]-V1.x[2];
	if(Math.abs(d)<.0000001) return(true);
	double x1=(V2.x[0]-V1.x[0])/d;
	double x2=(V1.x[2]*V2.x[0]-V2.x[2]*V1.x[0])/d;
	double y1=(V2.x[1]-V1.x[1])/d;
	double y2=(V1.x[2]*V2.x[1]-V2.x[2]*V1.x[1])/d;

	double[] Y={x1,x2,y1,y2};
	for(int i=0;i<4;++i) {
	   int[] rr=GoldenRatio.recognize(Y[i],500);
	   if(Math.abs(rr[0])>50) return(false);
	   if(Math.abs(rr[1])>50) return(false);
	}
	return(true);
    }



    /**CONVEXITY TEST**/

    public void checkConvex() {
	System.out.println("start convex test");
	int total=0;
	for(int i=0;i<64;++i) {
	    GoldenPolyhedron P=DataPartition.getGoldenPolyhedron(i);
	    boolean test=convex(P,2);
	    if(test==false) ++total;
	}
	System.out.println("failures "+total);
    }

    /**This is a test for strict convexity at a vertex.
       We dot the vertex and all the others with one of the
       first (2L+1)^6 GoldenVectors and verify that the given
       vertex has the largest dot product in at least one case.
       Taking L=2 works for our purposes.*/

    public static boolean convex(GoldenPolyhedron P,int L) {
	for(int i=0;i<P.count;++i) {
	    if(extreme(P,P.V[i],L)==false) return(false);
	}
	return(true);
    }


    /**Tests if a vertex is an extreme point of the polyhedron*/
    public static boolean extreme(GoldenPolyhedron P,GoldenVector X,int L) {
	for(int i1=-L;i1<=L;++i1) {
	for(int i2=-L;i2<=L;++i2) {
	for(int i3=-L;i3<=L;++i3) {
	for(int i4=-L;i4<=L;++i4) {
	for(int i5=-L;i5<=L;++i5) {
	for(int i6=-L;i6<=L;++i6) {
	    int[] A={i1,i2,i3,i4,i5,i6};
	    GoldenVector DIR=new GoldenVector(A);
	    if(DIR.isZero()==true) return(false);
	    boolean test=GoldenPolyCombinatorics.extreme(P,0,X,DIR);
	    if(test==true) return(true);
	}}}}}}
	return(false);
     }


    /**COVERING TEST**/

    public void checkCover() {
	System.out.println("start cover test");
	GoldenPolyhedron[] LIST0=polyList();
	GoldenReal[] LIST=DataPartition.heightList();
	GoldenReal[] LIST2=GoldenReal.interlace(LIST);
	for(int i=0;i<LIST2.length;++i) {
	    boolean test=checkCover(LIST2[i]);
	    System.out.println(i+" "+test);
	}
	System.out.println("done");
    }

    public boolean checkCover(GoldenReal t) {
	GoldenPolyhedron[] LIST=polyList();
	LIST=TetraSplit.split(LIST);
	GoldenPolyhedron[] LIST2=TetraCover.hitsLevel(t,LIST);
	for(int q=0;q<LIST2.length;++q) {
	  GoldenPolyhedron e=LIST2[q];
	  GoldenVector[] V=TetraCover.orthoMatch(t,e,LIST);
	  boolean test=TetraCover.link(V);
	  if(test==false) {
             System.out.println("fail "+q);
	     return(false);
	  }
	}
	return(true);
    }


    /**VARIOUS LISTS ASSOCIATED TO THE PARTITION**/


    /**This gets the list of vertices.**/

    public static GoldenVector[] vertexList(GoldenPolyhedron[] Q) {
	GoldenVector[] LIST=new GoldenVector[200];
	int count=0;
	for(int i=0;i<Q.length;++i) {
	   GoldenPolyhedron P=Q[i];
	   for(int j=0;j<P.count;++j) {
	       GoldenVector V=new GoldenVector(P.V[j]);
		   if(onList(count,LIST,V)==false) {
		       LIST[count]=new GoldenVector(V);
		       ++count;
		   }
	   }
	}
	GoldenVector[] LIST2=new GoldenVector[count];
	for(int i=0;i<count;++i) LIST2[i]=new GoldenVector(LIST[i]);
	return(LIST2);
    }

    /**redundancy checker*/

    public static boolean onList(int n,GoldenVector[] LIST,GoldenVector V) {
	for(int i=0;i<n;++i) {
	    if(GoldenVector.equals(LIST[i],V)==true) return(true);
	}
	return(false);
    }


    /**takes the original list of 64 polyhedra and divides
       it into a list of 192 tetrahedra.**/

    public GoldenPolyhedron[] polyList() {
	int total=0;
	GoldenPolyhedron[] LIST=new GoldenPolyhedron[64];
	for(int i=0;i<64;++i) {
	    LIST[i]=DataPartition.getGoldenPolyhedron(i);
	}
	return(LIST);
    }

}





