import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This routine shows that the return-to-core map is
well defined on the fundamental triangles.  Each of
the 2 fundamental triangles is divided into 125
smaller triangle of depth 3.  Each of these is
in turn split into two pieces. We check that each
piece maps, in one direction or the other, wholly
into the core.**/

public class SanityCheck0 implements Runnable {
    Manager M; 
    int[][] SEQ=new int[100][20];
    int SEQ_COUNT;
    int halt;

    public SanityCheck0() {
    }

    public SanityCheck0(Manager MM) {
	this.M=MM;
    }

    public void run() {
	halt=1;
	System.out.println("start");
        triTest(0);
	triTest(1);
    }


    /**TRIANGLE TESTS**/


    public int[] extract5bits(int k) {
	int[] a=new int[3];
	int n=k;
	a[0]=n%5;
	n=(n-a[0])/5;
	a[1]=n%5;
	n=(n-a[1])/5;
	a[2]=n%5;
	return(a);
    }

    public void triTest(int choice) {
	int trial=0;
	while((halt==1)&&(trial<125)) {
	    int[] t=extract5bits(trial);
  	    boolean test=triTest(choice,t);
	    if(test==true)  System.out.println(t[0]+" "+t[1]+" "+t[2]+" pass");
	    if(test==false) System.out.println(t[0]+" "+t[1]+" "+t[2]+"         fail");
	    ++trial;
	}
    }


    public boolean triTest(int choice,int[] J) {
	PolyWedge P=new PolyWedge();
	if(choice==0) P=Fundamental.triangle0();
	if(choice==1) P=Fundamental.triangle1();
	PolyWedge Q=Fundamental.act(J,P);
	Q=Fundamental.verticalReflect2(Q);
	boolean test0=coreMatchTop(0,Q);
	boolean test1=coreMatchTop(1,Q);
	if(test0==true) return(true);
	if(test1==true) return(true);
	return(false);
    }



    public static int[] coreSequence(int dir,Complex z,double y) {
	int[] itin0=new int[1000];
	Vector point=new Vector(z.x,z.y,y);
	boolean test=false;
	boolean periodic=false;
	int count=0;
	int history=-1;
	int type=-1;
	while((count<1000)&&(test==false)) {
	    test=DataRenorm.insideA(point);
	    if(test==false)    {
		if(dir==0)  {
		    if(history==-1) type=PolyhedronExchange.classify(point);
		    if(history!=-1) type=PolyhedronExchange.classify(point,history);
		    history=type;
                    point=PolyhedronExchange.doDynamicsPlus(point,type);
	            itin0[count]=type;
		}
		if(dir==1)  {
                    if(history==-1) type=PolyhedronExchange.classify(point);
		    if(history!=-1) type=PolyhedronExchange.classify(point,history);
		    history=type;
                    point=PolyhedronExchange.doDynamicsMinus(point,type);
	            itin0[count]=type;
		}
	         ++count;
	    } 
            Complex w=new Complex(point.x[0],point.x[1]);
	    if(Complex.dist(z,w)<.00000001) {
               test=true;
	       periodic=true;
	    }
	}
	if(periodic==true) {
	    int[] init1={99};
	    return(init1);
	}

	int[] itin1=new int[count];
	for(int i=0;i<count;++i) itin1[i]=itin0[i];
	return(itin1);
    }


    /**Core sequences**/

    public int[] convert(int[] s) {
	int[] t=new int[s[0]];
	for(int i=0;i<s[0];++i) t[i]=s[i+1];
	return(t);
    }

    public void printOut(int i) {
	int[] t=convert(SEQ[i]);
	System.out.print(i+":   ");
	for(int j=0;j<t.length;++j) System.out.print(t[j]+" ");
	System.out.println("");
    }


    /**The polywedge here is in the dynamical plane**/


    public static boolean coreMatchTop(int dir,PolyWedge P) {
	PolyWedge Q=P.homothety(.99);
	Complex[] Z=new Complex[Q.count];
	int[][] SEQ=new int[4][1000];

	for(int i=0;i<Q.count;++i)  {
           Z[i]=TorusMap.stripToTorus(Q.z[i]);
	   SEQ[i]=coreSequence(dir,Z[i],Q.z[i].y);
	}

	for(int i=0;i<Q.count-1;++i) {
	    if(Lists.match(SEQ[i],SEQ[i+1])==false) return(false);
	}
	   return(true);
    }


    public static void printOut(int dir,int[] seq) {
	  if(dir==0) System.out.println("forward "+seq.length);
	   if(dir==1) System.out.println("backward "+seq.length);
	    for(int i=0;i<seq.length;++i) System.out.print(seq[i]+" ");
	    System.out.println("");	 
    }


}

