import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;



public class TetraDisjoint {


    /**This routine returns true if it can prove that the two tetrahedra
       have disjoint interiors.  There are two tests, both of
       which involve producing a vector normal to a separating planes.
       The first test almost always works, and the second one is brought
       in as a last resort.*/

    public static boolean disjoint(GoldenPolyhedron P1,GoldenPolyhedron P2) {
	if(disjoint1(P1,P2)==true) return(true);
	if(disjoint2(P1,P2)==true) return(true);
	return(false);
    }

    public static boolean disjoint1(GoldenPolyhedron P1,GoldenPolyhedron P2) {
	GoldenVector[] W=new GoldenVector[4];
	for(int i1=0;i1<4;++i1) {
	    for(int i2=i1+1;i2<4;++i2) {
	       for(int j1=0;j1<4;++j1) {
	          for(int j2=j1+1;j2<4;++j2) {
		      int[] u={i1,i2,j1,j2};
 	              W[0]=new GoldenVector(P1.V[u[0]]);
	              W[1]=new GoldenVector(P1.V[u[1]]);
	              W[2]=new GoldenVector(P2.V[u[2]]);
	              W[3]=new GoldenVector(P2.V[u[3]]);
	              GoldenVector X1=GoldenVector.minus(W[0],W[1]);
	              GoldenVector X2=GoldenVector.minus(W[2],W[3]);
	              GoldenVector DIR1=GoldenVector.cross(X1,X2);
                      GoldenVector DIR2=DIR1.negate();
                      boolean test=separate(P1,P2,DIR1);
	              if(test==true) return(true);
                      test=separate(P1,P2,DIR2);
	              if(test==true) return(true);
		  }
	       }
	    }
	}
	return(false);
    }


    public static boolean disjoint2(GoldenPolyhedron P1,GoldenPolyhedron P2) {
	int L=1;
	for(int i=0;i<4;++i) {
	    GoldenVector DIR1=P1.normal(i);
	    GoldenVector DIR2=GoldenVector.minus(GoldenVector.zero(),DIR1);
            boolean test=separate(P1,P2,DIR1);
	    if(test==true) return(true);
	    test=separate(P1,P2,DIR2);
	    if(test==true) return(true);
	}
	for(int i=0;i<4;++i) {
	    GoldenVector DIR1=P2.normal(i); 
            GoldenVector DIR2=DIR1.negate();
            boolean test=separate(P1,P2,DIR1);
	    if(test==true) return(true);
	    test=separate(P1,P2,DIR2);
	    if(test==true) return(true);
	}
	return(false);
    }


    public static boolean separate(GoldenPolyhedron P1,GoldenPolyhedron P2,GoldenVector DIR) {
	if(DIR.isZero()==true) return(false);

	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		GoldenReal r1=GoldenVector.dot(P1.V[i],DIR);
		GoldenReal r2=GoldenVector.dot(P2.V[j],DIR);
		GoldenReal r3=GoldenReal.minus(r1,r2);
		if(r3.isPositiveOrZero()==false) return(false);
	    }
	}
	return(true);
    }



}



