import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**The purpose of this class is provide some routines for dissecting a 
   GoldenPolyhedron into tetrahedra**/


public class TetraSplit {

    /**MAIN ROUTINE: Partitions the polyhedron list into a tetrahedron list.**/


    public static GoldenPolyhedron[] split(GoldenPolyhedron[] P) {
	GoldenPolyhedron[] LIST=new GoldenPolyhedron[0];
	for(int i=0;i<P.length;++i) LIST=concatenate(LIST,split(P[i]));
	return(LIST);
    }

    public static GoldenPolyhedron[] split(GoldenPolyhedron P) {
	int total=0;
	GoldenPolyhedron[] LIST=new GoldenPolyhedron[10];
	int[][] FL=faceList(P);
	for(int i=0;i<FL.length;++i) {
	    for(int j=1;j<FL[i].length-1;++j) {
		GoldenPolyhedron Q=cone(P,FL,i,j);
		if(Q!=null) {
		    LIST[total]=new GoldenPolyhedron(Q);
		    ++total;
		}
	    }
	}
	GoldenPolyhedron[] LIST2=new GoldenPolyhedron[total];
	for(int i=0;i<total;++i) LIST2[i]=new GoldenPolyhedron(LIST[i]);
	return(LIST2);
	}



    /**concatenates two lists of polyhedra.**/

    public static GoldenPolyhedron[] concatenate(GoldenPolyhedron[] LIST1,GoldenPolyhedron[] LIST2) {
	GoldenPolyhedron[] LIST3=new GoldenPolyhedron[LIST1.length+LIST2.length];
	for(int i=0;i<LIST1.length;++i) LIST3[i]=new GoldenPolyhedron(LIST1[i]);
	int n=LIST1.length;
	for(int i=0;i<LIST2.length;++i) LIST3[n+i]=new GoldenPolyhedron(LIST2[i]);
	return(LIST3);
    }



    /**Here FL is the face list**/

    public static GoldenPolyhedron cone(GoldenPolyhedron P,int[][] FL,int i,int j) {
	if(FL[i][0]==0) return(null);  //point is contained in face
	GoldenPolyhedron Q=new GoldenPolyhedron();
	Q.count=4;
	Q.V[0]=new GoldenVector(P.V[0]);
	Q.V[1]=new GoldenVector(P.V[FL[i][0]]);
	Q.V[2]=new GoldenVector(P.V[FL[i][j]]);
	Q.V[3]=new GoldenVector(P.V[FL[i][j+1]]);
	return(Q);
    }

    /** given a convex GoldenPolyhedron, return the list of faces. 
        The faces are given as lists of vertices, with each face
        being listed according to the following right hand rule: If you
        curl your right hand around the vertices, as they are listed,
        your thumb points along the OUTWARD normal*/


     public static int[][] faceList(GoldenPolyhedron P) {
	 int[] LIST=faceListRaw(P);
	 int[][] LIST2=new int[LIST.length][0];

	 for(int i=0;i<LIST2.length;++i) LIST2[i]=fixFace(P,LIST[i]);
	 return(LIST2);
     }


     /**This gives the list of subsets of vertices that have faces.
        However, these subsets are not cyclically ordered.**/

     public static int[] faceListRaw(GoldenPolyhedron P) {
	int[] LIST=new int[512];
	int N=P.count;
	int total=0;
	for(int i=0;i<Math.pow(2,N);++i) {
	    int[] u=binaryList(N,i);
	    boolean test=face(P,u);
	    if((u.length>=3)&&(test==true)) {
                LIST[total]=i;
		++total;
	    }
	}
	int[] LIST2=new int[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	LIST2=trim(N,LIST2);
	return(LIST2);
    }

     /**This routine converts the raw data into the list of
        vertices, and then orders the list into a circuit.*/

     public static int[] fixFace(GoldenPolyhedron P,int n) {
	 int N=P.count;
	 int[] u=binaryList(N,n);
	 for(int i=0;i<u.length-1;++i) u=nextInCircuit(P,u,i);
	 boolean test=faceOriented(P,u);
	 if(test==true) return(u);
	 /*reverse orientation*/
	 int[] v=new int[u.length];
	 for(int i=1;i<u.length;++i) v[i]=u[u.length-i];
	 v[0]=u[0];
	 return(v);
     }


    /**This routine tells which vertex comes next in the circuit.**/

     public static int[] nextInCircuit(GoldenPolyhedron P,int[] u,int k) {
	     int u2=-1;
	     int L=u.length;
	     for(int i=k+1;i<L;++i) {
		 if(edge(P,u[k],u[i])==true) u2=u[i];
	     }
	     int[] v=new int[L];
	     for(int i=0;i<=k;++i) v[i]=u[i];
	     v[k+1]=u2;
	     int total=k+2;
	     for(int i=k+1;i<L;++i) {
		 if(u[i]!=u2) {
		     v[total]=u[i];
		     ++total;
		 }
	     }
	     return(v);
     }


     /**This routine answers true if the point X is an extreme point for the linear
        functional "dot with DIR".  
        When choice=0, we insist that the point is a strict extreme point.
        This is the vertex test.
        When choice=1, we do not insist this.  This is the test we use for faces.*/

    public static boolean extreme(GoldenPolyhedron P,int choice,GoldenVector X,GoldenVector DIR) {
	int total=0;
	GoldenReal d1=GoldenVector.dot(X,DIR);
	for(int j=0;j<P.count;++j) {
	    GoldenReal d2=GoldenVector.dot(P.V[j],DIR);
	    GoldenReal d3=GoldenReal.minus(d1,d2);
	    boolean test0=d3.isZero();
	    boolean test1=d3.isPositive();
	    if(test0==true) ++total;
	    boolean test2=GoldenVector.equals(X,P.V[j]);
	    if((choice==0)&&(test1==false)&&(test2==false)) return(false);
	    if((choice==1)&&(test0==false)&&(test1==false)&&(test2==false)) return(false);
	}
	return(true);
    }

/**tells if the list of vertices is the subset of a face.  Computes the centroid
   of the list of vectors and decides if it is on the boundary or not.*/

     public static boolean face(GoldenPolyhedron P,int[] u) {
	if(u.length<3) return(false);
	GoldenPolyhedron Q=P.scale(u.length);
	GoldenVector W=GoldenVector.zero();
	GoldenVector DIR=GoldenVector.normal(Q.V[u[0]],Q.V[u[1]],Q.V[u[2]]);
	for(int i=0;i<u.length;++i) W=GoldenVector.plus(W,P.V[u[i]]);
        boolean test1=extreme(Q,1,W,DIR);
	DIR=DIR.negate();
        boolean test2=extreme(Q,1,W,DIR);
	if(test1==true) return(true);
	if(test2==true) return(true);
	return(false);
    }

     /**This only will return true if the first 3 vertices of the face
        are counter-clockwise oriented.*/

     public static boolean faceOriented(GoldenPolyhedron P,int[] u) {
	if(u.length<3) return(false);
	GoldenPolyhedron Q=P.scale(u.length);
	GoldenVector W=GoldenVector.zero();
	GoldenVector DIR=GoldenVector.normal(Q.V[u[0]],Q.V[u[1]],Q.V[u[2]]);
	for(int i=0;i<u.length;++i) W=GoldenVector.plus(W,P.V[u[i]]);
        boolean test1=extreme(Q,1,W,DIR);
	if(test1==true) return(true);
	return(false);
    }


     /**answers true if the edge lies in 2 distinct faces*/

     public static boolean edge(GoldenPolyhedron P,int i,int j) {
	 for(int k1=0;k1<P.count;++k1) {
	     for(int k2=k1+1;k2<P.count;++k2) {
		 if((i!=k1)&&(i!=k2)&&(j!=k1)&&(j!=k2)) {
		     int[] u1={i,j,k1};
		     int[] u2={i,j,k2};
		     boolean test1=face(P,u1);
		     boolean test2=face(P,u2);
		     if((test1==true)&&(test2==true)) {
			 GoldenVector V1=GoldenVector.normal(P.V[i],P.V[j],P.V[k1]);
			 GoldenVector V2=GoldenVector.normal(P.V[i],P.V[j],P.V[k2]);
			 GoldenVector W=GoldenVector.cross(V1,V2);
			 if(W.isZero()==false) return(true);
		     }
		 }
	     }
	 }
	 return(false);
    }


     /**These are combinatorial routines.*/

    /**The pairs (a,N) and (b,N) both determine subsets of the set {0,...,N-1}.
       This routine tests if the former is a subset of the latter.  The purpose
       of this routine is to help in picking out the maximal faces.**/


    public static boolean isSubset(int N,int a,int b) {
	int[] u=binaryList(N,a);
	int[] v=binaryList(N,b);
	return(isSubset(u,v));
    }

     /**straight up routine to tell if one integer list is a subset of another.*/

    public static  boolean isSubset(int[] u,int[] v) {
	for(int i=0;i<u.length;++i) {
	    boolean test=false;
	    for(int j=0;j<v.length;++j) {
		if(u[i]==v[j]) test=true;
	    }
	    if(test==false) return(false);
	}
	return(true);
    }

    public static boolean isSubset(int N,int a,int[] LIST) {
	for(int i=0;i<LIST.length;++i) {
	    if((a!=LIST[i])&&(isSubset(N,a,LIST[i])==true)) return(true);
	}
	return(false);
    }

     /**removes all but the maximal subsets.*/

    public static int[] trim(int N,int[] LIST) {
	int total=0;
	int[] LIST1=new int[LIST.length];
	for(int i=0;i<LIST.length;++i) {
	    if(isSubset(N,LIST[i],LIST)==false) {
		LIST1[total]=LIST[i];
		++total;
	    }
	}
	int[] LIST2=new int[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST1[i];
	return(LIST2);
    }


     /**Produces a subset of {0,...,N-1} from the pair (N,n)**/

    public static int[] binaryList(int N,int n) {
	int[] x=new int[N];
	int m=n;
	for(int count=0;count<N;++count) {
	    x[N-1-count]=m%2;
	    m=(m-x[N-1-count])/2;
	}
	int[] y=new int[N];
	int total=0;
	for(int i=0;i<N;++i) {
	    if(x[i]==1) {
                y[total]=i;
		++total;
	    }
	}
	int[] z=new int[total];
	for(int i=0;i<total;++i) z[i]=y[i];
	return(z);
    }






}



