
import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


class KeyCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    SelectColor SC;  
    Lever TOL,DEP,BRANCH,LEVELA,VERTEX,SPEED; 
    ListenSquare L,GRAB_A,GRAB_B,SEND;
    ListenSquare RENORM,ANIMATE;
    SelectReal[] SR=new SelectReal[3];
    SelectInteger[] IS=new SelectInteger[2];
    String[] MESSAGE=new String[30];
    Color[] COLOR=new Color[30];
    int COUNT=0;
    Animator AAA;
    ListenSquare INFO1,INFO2,INFO3;


    KeyCanvas() { 
	addMouseListener(this);
	addMouseMotionListener(this);   
	addKeyListener(this);     
        SC=new SelectColor(M,0,15,400,64); 
	TOL=new Lever(920,32,4,9);
	DEP=new Lever(920,63,4,9);
	L=new ListenSquare(0,79,1434,35);L.on=1;  //main parameter
	BRANCH=new Lever(620,63,1,3);
	VERTEX=new Lever(473,63,5,11);
	LEVELA=new Lever(410,63,1,4);  
	SPEED=new Lever(550,33,4,9);  
        RENORM=new ListenSquare(410,20,50,20); RENORM.on=1;
        ANIMATE=new ListenSquare(480,20,60,20); ANIMATE.on=0;
        INFO1=new ListenSquare(0,0,15,15);
        INFO2=new ListenSquare(711,55,12,12);
	 SR[0]=new SelectReal(840,17,70,18,1.0);
	 SR[1]=new SelectReal(840,37,70,18,1.0);
	 SR[2]=new SelectReal(840,57,70,18,1.0);
	 SEND=new ListenSquare(788,17,50,18);SEND.on=1;
	 GRAB_A=new ListenSquare(788,37,50,18);GRAB_A.on=1;
	 GRAB_B=new ListenSquare(788,57,50,18);GRAB_B.on=1;
 	 IS[0]=new SelectInteger(1050,0,30,15,0,-10000,10000,1);    //Xcoord backup
	 IS[1]=new SelectInteger(1150,0,30,15,0,-10000,10000,1);    //Ycoord backup
    }
    
   public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
      RenderingHints.VALUE_ANTIALIAS_ON); 
      g.setColor(Color.black);
      g.fillRect(0,0,getWidth(),getHeight()); 
      drawMain(g);
      drawCoords1(g,M);
      drawCoords2(g,M);
      drawKey(g);
      drawMessage(g);
      INFO1.infoRender(g);
      INFO2.infoRender(g);
   }



    public void drawMessage(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,12)); 
	for(int i=0;i<COUNT;++i) {
    	    g.setColor(COLOR[i]);
	    if(i%2==0) g.drawString(MESSAGE[i],5+60*i,130);
	    if(i%2==1) g.drawString(MESSAGE[i],5+60*(i-1),146);
	}
    }



    public void drawKey(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,13));
        g.setColor(Color.white);
        g.drawString("z: zoom in",30,12);
        g.drawString("x: set point",120,12);
        g.drawString("c: zoom out",210,12);
        g.drawString("s: go",300,12);
    }



    public void drawMain(Graphics2D g) {
	SEND.renderSmooth(g,new Color(0,0,255),Color.white,"send A");
	GRAB_A.renderSmooth(g,new Color(0,0,255),Color.white,"grab A");
	GRAB_B.renderSmooth(g,new Color(0,0,255),Color.white,"grab B");
	for(int i=0;i<2;++i) IS[i].render(g,new Color(0,0,200),Color.white,Color.white);

      for(int j=0;j<3;++j)SR[j].render(g,new Color(100,0,100),Color.magenta,Color.yellow,Color.white);


      TOL.render(g,"tolerance",new Color(0,0,100));
      DEP.render(g,"depth",new Color(0,0,100));
      LEVELA.render(g,"A layers",new Color(50,100,255));
      VERTEX.render(g,"vertex levels",new Color(50,100,255));
      BRANCH.render(g,"inverses",new Color(50,100,255));
     
      SC.render(g);  
      Color C=new Color(0,0,255);
      RENORM.renderSmooth(g,C,Color.white,"renorm");
      if(ANIMATE.on==0) C=Color.black;
      ANIMATE.renderSmooth(g,C,Color.white,"animate");  
      if(ANIMATE.on==1) SPEED.render(g,"speed",Color.blue);
      L.render(g,new Color(50,100,255));
      decorateSlider(g);
    }

    public void cleanDouble(Graphics2D g,double t,int x,int y) {
	int dep=DEP.val+4;
	double tol=Math.pow(0.1,TOL.val);
	g.setColor(Color.white);
        g.setFont(new  Font("Helvetica",Font.PLAIN,12));
	Double T=new Double(t);
	String S=T.toString();
	if(S.length()>12) S=S.substring(0,11);
	g.drawString(S,x,y);

	g.setColor(Color.yellow);
        int[] q=GoldenRatio.recognize(t,dep,tol);
	if(q!=null) {
          Integer Q0=new Integer(q[0]);
          Integer Q1=new Integer(q[1]);
	  String a0=Q0.toString();
	  String a1=Q1.toString();
          String b=a0+" "+"+"+" "+a1+" "+"\u03A6";
	  g.drawString(b,x+100,y);
	}
    }


    public void drawCoords1(Graphics2D g,Manager M) {

        g.setColor(new Color(0,0,100));
	g.fillRect(400,0,1034,15);
	g.setColor(Color.white);
	g.drawRect(400,0,1034,15);

	g.translate(1035,-317);
        g.setColor(Color.white); 
        g.setFont(new  Font("Helvetica",Font.PLAIN,12));

        g.setColor(new Color(0,0,100));
	g.fillRect(0,332,200,64);
	g.setColor(Color.white);
	g.drawRect(0,332,200,64);

        cleanDouble(g,M.PC1.SOURCE.x,7,350);
        cleanDouble(g,M.PC1.SOURCE.y,7,370);
        cleanDouble(g,M.C.getOffsetY(1),7,390);  

	g.setColor(new Color(0,0,100));
	g.fillRect(200,332,200,64);
	g.setColor(Color.white);
	g.drawRect(200,332,200,64);

          g.setColor(Color.white);
          cleanDouble(g,M.PC2.SOURCE.x,207,350);
          cleanDouble(g,M.PC2.SOURCE.y,207,370);
          cleanDouble(g,M.C.getOffsetY(2),207,390);

        g.translate(-1035,317);

	g.setColor(Color.white);
          g.setFont(new  Font("Helvetica",Font.PLAIN,16));
	  int[] L=Characteristics.getCharA(M.C.getOffsetY(1));
	  Integer LA=new Integer(L[0]);
	  Integer LB=new Integer(L[1]);
	  g.drawString(LA.toString(),700,40);
	  g.drawString(LB.toString(),730,40);


          cleanDouble(g,M.C.getOffsetX(M.C.getFocus()),1242,13);  


    }

    public void doAnimate(Point X) {  
        SPEED.process(X);
	if(ANIMATE.inside(X)==1) {
	    ANIMATE.on=1-ANIMATE.on;
   	    if(ANIMATE.on==1) {
	       AAA=new Animator(M);
              new Thread(AAA).start();
	    }
	    if(ANIMATE.on==0) AAA.halt=0;
	}
    }


    public void drawCoords2(Graphics2D g,Manager M) {
        g.setColor(Color.white); 
        g.setFont(new  Font("Helvetica",Font.PLAIN,12));
      
        cleanDouble(g,M.T.SOURCE.x,410,13);
        cleanDouble(g,M.T.SOURCE.y,850,13);
    }


     public void decorateSlider(Graphics2D g) {
       double[] PARAMETER=M.C.CON_P.PARAMETER;
       GeneralPath gp=new GeneralPath();
       double d2=GoldenRatio.phi(-2);
       double d3=GoldenRatio.phi(-3);
       g.translate(0,79);

       double s1=1435;
       double s2=.5*1435;

       gp.moveTo(0,1);
       gp.lineTo(0,35);
       gp.lineTo((float)(s2*d2),35);
       gp.lineTo((float)(s2*d2),1);

       gp.moveTo((float)(s1*d2),1);
       gp.lineTo((float)(s1*d2),35);
       gp.lineTo((float)(s1-s1*d2),35);
       gp.lineTo((float)(s1-s1*d2),1);

       gp.moveTo((float)(s1),1);
       gp.lineTo((float)(s1),35);
       gp.lineTo((float)(s1-s2*d2),35);
       gp.lineTo((float)(s1-s2*d2),1);

       g.setColor(new Color(20,40,250));
       g.fill(gp);


       g.setColor(new Color(0,0,100));
       AffineTransform AFF1=AffineTransform.getScaleInstance(d3,d2);
       AffineTransform AFF2=AffineTransform.getTranslateInstance(0,11);
       gp.transform(AFF1);
       gp.transform(AFF2);
       g.fill(gp);
       AFF2=AffineTransform.getTranslateInstance(2*d2*s2,0);
       gp.transform(AFF2); 
       g.fill(gp);
       AFF2=AffineTransform.getTranslateInstance(d2*s2+d2*s2,0);
       gp.transform(AFF2); 
       g.fill(gp);

       gp.reset();
       gp.moveTo((float)(s2*d2),35);
       gp.lineTo((float)(s2*d2),1);
       gp.lineTo((float)(2*s2*d2),1);
       gp.lineTo((float)(2*s2*d2),35);
       g.setColor(new Color(50,100,250));
       g.fill(gp);
       AFF2=AffineTransform.getTranslateInstance(d2*s2+2*d3*s2,0);
       gp.transform(AFF2); 
       g.fill(gp);


       /**midlines*/
       gp.reset();
       g.setColor(new Color(50,100,255));
       gp.moveTo((float)(s2-2),34);
       gp.lineTo((float)(s2-2),1);
       gp.lineTo((float)(s2+2),1);
       gp.lineTo((float)(s2+2),34);
       g.fill(gp);

       g.setColor(new Color(50,100,255));
       gp.moveTo((float)(d3*s2-1),23);
       gp.lineTo((float)(d3*s2-1),12);
       gp.lineTo((float)(d3*s2+1),12);
       gp.lineTo((float)(d3*s2+1),23);
       g.fill(gp);

       g.setColor(new Color(50,100,255));
       gp.moveTo((float)(s1-d3*s2-1),23);
       gp.lineTo((float)(s1-d3*s2-1),12);
       gp.lineTo((float)(s1-d3*s2+1),12);
       gp.lineTo((float)(s1-d3*s2+1),23);
       g.fill(gp);


       double y=0;
       gp.reset();
       g.setColor(Color.white);
       y=s2*PARAMETER[0];
       gp.moveTo((float)(y-2),12);
       gp.lineTo((float)(y-2),23);
       gp.lineTo((float)(y+2),23);
       gp.lineTo((float)(y+2),12);
       g.fill(gp);

       g.setColor(Color.white);
       y=s2*PARAMETER[1];
       gp.moveTo((float)(y-1),35);
       gp.lineTo((float)(y-1),0);
       gp.lineTo((float)(y+1),0);
       gp.lineTo((float)(y+1),35);
       g.fill(gp);

       g.setColor(Color.white);
       gp.reset();
       gp.moveTo((float)(d2-1),1);
       gp.lineTo((float)(d2-1),35);
       gp.moveTo((float)(d2+1),1);
       gp.lineTo((float)(d2+1),35);

       g.setColor(Color.white);
       g.draw(gp);
       g.translate(0,-79);
     }



    public void setSpecialValues(Point X) {
	double t0=0;
	double t1=0;
	VERTEX.process(X);
	if(VERTEX.isUsed(X)==1) {
	    GoldenReal r=DataPartitionRaw.getHeight(VERTEX.val);
	    t0=r.toDouble();
	    t1=GroupAction.map(t0);



	    M.C.CON_P.PARAMETER[0]=t0;
	    M.C.CON_P.PARAMETER[1]=t1;
	}

	LEVELA.process(X);
	if(LEVELA.isUsed(X)==1) {
	    double p1=GoldenRatio.phi(-1);
	    double p2=GoldenRatio.phi(-2);
            double t=M.C.CON_P.PARAMETER[0];

            int[] L=Characteristics.getCharA(t);
	    if((L[0]==2)&&(L[1]==5)&&(LEVELA.val==0)) L[0]=1;
	    if((L[0]==2)&&(L[1]==5)&&(LEVELA.val==3)) L[1]=0;
	    if((L[0]==1)&&(L[1]==4)) L[0]=0;
	    if((L[0]==3)&&(L[1]==5)) L[1]=0;
	    double[] d=Characteristics.getHeightA(L[0],L[1]);

	    boolean middle=true;
	    if(Math.abs(t-d[0])<.000000001) middle=false;
	    if(Math.abs(t-d[1])<.000000001) middle=false;

	    if((middle==false)&&(LEVELA.val==3)) {
	      L=Characteristics.getCharA(t+.000001);
              d=Characteristics.getHeightA(L[0],L[1]);
              t0=d[1]; 
              t1=GroupAction.map(t0);
	      M.C.CON_P.PARAMETER[0]=t0;
	      M.C.CON_P.PARAMETER[1]=t1;

	    }

	    if((middle==false)&&(LEVELA.val==0)) {
		if(t>.0000000001) {
                  L=Characteristics.getCharA(t-.000001);  
                  d=Characteristics.getHeightA(L[0],L[1]);
                  t0=d[0]; 
                  t1=GroupAction.map(t0);
	          M.C.CON_P.PARAMETER[0]=t0;
	          M.C.CON_P.PARAMETER[1]=t1;
		}
	    }

	    if(middle==true) {
	      t0=d[0];
	      if(LEVELA.val==0) t0=d[0];
	      if(LEVELA.val==1) t0=p1*d[0]+p2*d[1];
	      if(LEVELA.val==2) t0=p2*d[0]+p1*d[1]; 
              if(LEVELA.val==3) t0=d[1];
              t1=GroupAction.map(t0);
	      M.C.CON_P.PARAMETER[0]=t0;
	      M.C.CON_P.PARAMETER[1]=t1;
	    }
	}
    }

    public void setBranch(Point X) {
	double[] PARAMETER=M.C.CON_P.PARAMETER;
	int k=GroupAction.getBranch(PARAMETER[0],PARAMETER[1]);
	if(k!=-1) BRANCH.val=k;
	BRANCH.process(X);
	if(BRANCH.isUsed(X)==1) {
	    double[] U=GroupAction.inverseMap(PARAMETER[1]);
	    M.C.CON_P.PARAMETER[0]=U[BRANCH.val];
	}
    }

    public void setParameter(Point X) {
	double s2=1435/2.0;
	if(L.inside(X)==1) M.C.CON_P.PARAMETER[0]=X.x/s2;
           M.C.CON_P.PARAMETER[1]=GroupAction.map(M.C.CON_P.PARAMETER[0]);
	   M.PC1.repaint();
	   M.PC2.repaint();
	   M.T.repaint();
	   M.C.repaint();
    }

    public void doRenorm(Point X) {
	int test=RENORM.inside(X);
	if(test==1) iterateParameter0();
    }



    public void iterateParameter0() {
	double test1,test2;
	double t=M.C.CON_P.PARAMETER[1];
	double u=GroupAction.map(t);
	M.C.CON_P.PARAMETER[0]=t;
	M.C.CON_P.PARAMETER[1]=u;
    }

    public void iterateParameter1() {
	double t=M.C.CON_P.PARAMETER[0];
	double u=GroupAction.preferredInverse(t);
	M.C.CON_P.PARAMETER[1]=t;
	M.C.CON_P.PARAMETER[0]=u;
    }

    public void setDoubles(Point X) {
	int index=-1;
	for(int j=0;j<3;++j) {
	     if(SR[j].inside(X)==1) index=j;
	}
	if(index!=-1) {
	  for(int j=0;j<3;++j) {
	     SR[j].on=0;
	     SR[index].on=1;
	  }
	}
	if(SEND.inside(X)==1) {
	    double[] d=new double[3];
	   for(int i=0;i<3;++i) d[i]=SR[i].getValue();
	   M.PC1.SOURCE=new Complex(d[0],d[1]);
           M.C.CON_P.PARAMETER[0]=d[2];
           M.C.CON_P.PARAMETER[1]=GroupAction.map(d[2]);
	}

	if(GRAB_A.inside(X)==1) {
	    Complex z=M.PC1.SOURCE;
            double t=M.C.CON_P.PARAMETER[0];
	    SR[0].grabValue(z.x);
	    SR[1].grabValue(z.y);
	    SR[2].grabValue(t);
	}
	if(GRAB_B.inside(X)==1) {
	    Complex z=M.PC2.SOURCE;
            double t=M.C.CON_P.PARAMETER[1];
	    SR[0].grabValue(z.x);
	    SR[1].grabValue(z.y);
	    SR[2].grabValue(t);
	}
    }

    public void setGraphCoords(Point X) {
	boolean test=false;
        for(int i=0;i<2;++i) {
               IS[i].modify(X);
	       if(IS[i].isModified(X)==1) test=true;
	}
	if(test==true)  {
           M.A1.SOURCE=new Complex(IS[0].val,IS[1].val);
	   M.A1.repaint();
	}
    }

    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}


    public void mouseDragged(MouseEvent e) {
	SC.process(e);
  	MouseData J=MouseData.process(e);
	TOL.process(J.X);
	DEP.process(J.X);
	setParameter(J.X);
	repaint();
    }

    public void mouseClicked(MouseEvent e) {
	SC.process(e);
  	MouseData J=MouseData.process(e);
	TOL.process(J.X);
	DEP.process(J.X);
	setParameter(J.X); 
        setBranch(J.X);
        setSpecialValues(J.X);	
        doRenorm(J.X);
	doAnimate(J.X);
	setDoubles(J.X);
	setGraphCoords(J.X);
	documentStuff(J.X);
	repaint();
    }
    public void mouseMoved(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}


    public void keyTyped(KeyEvent e) {
	for(int j=0;j<3;++j) {
	    if(SR[j].on==1) SR[j].modify(e);
	}
	repaint();
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


    /**DOCUMENTATION**/

    public void documentStuff(Point X) {
	DocumentKey DOC=new DocumentKey(M);
	if(INFO1.inside(X)==1) DOC.colorInfo();
	if(INFO2.inside(X)==1) DOC.coordInfo();
    }

}









