import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Lists  {

    public Lists() {} 

    /**This class performs irredundancy checks and other manipulations
       for lists of objects        of various kinds.**/


    public static void printout(int[] u) {
	if(u!=null) {
	  for(int i=0;i<u.length;++i) System.out.print(u[i]+" ");
	}
	System.out.println("");
    }



    public static int[] reverse(int[] B) {
	int L=B.length;
	int[] C=new int[B.length];
	for(int j=0;j<B.length;++j) C[L-j-1]=B[j]; 
	return(C);
    }



    public static int[][] reverse(int[][] B) {
	int L=B.length;
	int[][] C=new int[B.length][4];
	for(int j=0;j<B.length;++j) C[L-j-1]=B[j]; 
	return(C);
    }




    /**for golden reals**/

    /**checks if a goldenreal is on a list of them.**/

    public static boolean match(GoldenReal V,GoldenReal[] LIST,int count) {

	for(int i=0;i<count;++i) {
	    if(GoldenReal.equals(V,LIST[i])==true) return(true);
	}
	return(false);
    }

    /**checks if two lists of goldenreals coincide.**/

    public static boolean match(GoldenReal[] LIST1,GoldenReal[] LIST2,int total) {
	for(int i=0;i<total;++i) {
	    if(match(LIST1[i],LIST2,total)==false) return(false);
	}
	return(true);
    }


    /**for golden vectors**/

    public static boolean match(GoldenVector V,GoldenVector[] LIST,int count) {

	for(int i=0;i<count;++i) {
	    if(GoldenVector.equals(V,LIST[i])==true) return(true);
	}
	return(false);
    }






    /**for golden complexes**/


    public static  boolean match(GoldenComplex z,GoldenComplex[] LIST,int count) {
	for(int i=0;i<count;++i) {
	    if(GoldenComplex.equals(z,LIST[i])==true) return(true);
	}
	return(false);
    }

    public static  boolean match(GoldenComplex[] LIST1,GoldenComplex[] LIST2,int count) {
	for(int i=0;i<count;++i) {
	    if(match(LIST1[i],LIST2,count)==false) return(false);
	}
	return(true);
    }

    /**for vectors**/

    public static boolean match(Vector X,Vector[] DONE,int tot) {
	for(int i=0;i<tot;++i) {
	    if(Vector.dist(X,DONE[i])<.000000001) return(true);
	}
	return(false);
    }

    /**checks equality of 2 integer lists**/

    public static boolean match(int[] q1,int[] q2) {
	if((q1==null)&&(q2==null)) return(true);
	if((q1!=null)&&(q2==null)) return(false);
	if((q2!=null)&&(q1==null)) return(false);

	if(q1.length!=q2.length) return(false);
	for(int i=0;i<q1.length;++i) {
	    if(q1[i]!=q2[i]) return(false);
	}
	return(true);
    }


    /**checks if an integer is on a list of integers**/

    public static boolean onList(int x,int[] y) {
	if(y==null) return(false);
	for(int i=0;i<y.length;++i) {
	    if(x==y[i]) return(true);
	}
	return(false);
    }



    /**checks if an integer pair is on a list of integers**/

    public static boolean onList(int[] x,int[][] y) {
	if(y==null) return(false);
	for(int i=0;i<y.length;++i) {
	    if((x[0]==y[i][0])&&(x[1]==y[i][1])) return(true);
	}
	return(false);
    }



    /**For polyhedra: This is kind of cheap**/

    public static boolean centerMatch(Polyhedron X,Polyhedron[] DONE,int tot) {
	for(int i=0;i<tot;++i) {
	    if(centerMatch(X,DONE[i])==true) return(true);
	}
	return(false);
    }


    public static boolean centerMatch(Polyhedron P,Polyhedron Q) {
	Vector p=P.getCenter();
	Vector q=Q.getCenter();
	if(Vector.dist(p,q)<.000000001) return(true);
	return(false);
    }



    /**tests if a point is "well inside" one of the polyhedra on the list.**/

    public static boolean inside(Polyhedron[] LIST,int total,Vector V) {
	for(int i=0;i<total;++i) {
	    if(inside(LIST[i],V)==true) return(true);
	}
	return(false);
    }


    public static boolean inside(Polyhedron P,Vector V) {
	if(P==null) return(false);
	for(int j=-1;j<=1;j=j+2) {
	  for(int i=0;i<4;++i) {
	    double c=Math.cos(Math.PI/4+Math.PI*i/2);
	    double s=Math.sin(Math.PI/4+Math.PI*i/2);
	    double r=.0000001;
	    Vector E=new Vector(r*c,r*s,j*r);
	    if(inside(P,V,E)==true) return(true);
	  }
	}
	return(false);
    }

    public static boolean inside(Polyhedron P,Vector V,Vector E) {
	Vector W=Vector.plus(V,E);
	PolyWedge PP=PolyhedronSlicer.basicSlice(P,W.x[2]);
	if(PP==null) return(false);
        GeneralPath gp=PP.toGeneralPath();
	if(gp.contains(W.x[0],W.x[1])==true) return(true);
	return(false);
    }



    /**merging two lists of polyhedra*/

    public static GoldenPolyhedron[] merge(GoldenPolyhedron[] LIST1,GoldenPolyhedron[] LIST2) {
	GoldenPolyhedron[] LIST3=new GoldenPolyhedron[LIST1.length+LIST2.length];
	int total=0;

	for(int i=0;i<LIST1.length;++i) {
	    LIST3[total]=LIST1[i];
	    ++total;
	}

        for(int i=0;i<LIST2.length;++i) {
	    LIST3[total]=LIST2[i];
	    ++total;
	}
	return(LIST3);
    }


    /**This routine takes a list of objects, in which only the
       first (total) are defined, and returns a new list with precisely
       the length total.*/

    public static int[] clean(int[] LIST,int total) {
	int[] LIST2=new int[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }

    public static GoldenReal[] clean(GoldenReal[] LIST,int total) {
	GoldenReal[] LIST2=new GoldenReal[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }

    public static GoldenComplex[] clean(GoldenComplex[] LIST,int total) {
	GoldenComplex[] LIST2=new GoldenComplex[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }

    public static GoldenPolyWedge[] clean(GoldenPolyWedge[] LIST,int total) {
	GoldenPolyWedge[] LIST2=new GoldenPolyWedge[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }

    public static GoldenPolyhedron[] clean(GoldenPolyhedron[] LIST,int total) {
	GoldenPolyhedron[] LIST2=new GoldenPolyhedron[total];
	for(int i=0;i<total;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }
}
