import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class helps navigate the partition**/



public class Navigator extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    Complex DIR;
    Vector[] FRAME=new Vector[2];
    ListenSquare[] T=new ListenSquare[6];
    ListenSquare[] PRESET=new ListenSquare[10];
    ListenSquare INFO;

     public Navigator() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 DIR=new Complex(150,90);
	 for(int i=0;i<4;++i) {
	    PRESET[i]=new ListenSquare(380,15*i,15,15,null); PRESET[i].on=1;
	 }
	 for(int i=0;i<6;++i) {
	     int t=0;
	     if(i>=3) t=5;
             T[i]=new ListenSquare(50,30*i+t,300,20);
             T[i].on=1;
	 }
	 FRAME[0]=new Vector(1,0,0);
	 FRAME[1]=new Vector(0,1,0);
         INFO=new ListenSquare(386,166,14,14);
     }

   public void paint(Graphics g2) {
         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
         drawBG(g); 
	 if(M.C.CON_P.NAVIGATE.on==0) drawCoords(g);
	 if(M.C.CON_P.NAVIGATE.on==1) drawControls(g);
	 INFO.infoRender(g);
	 drawFrame(g);

   }


    public void drawBG(Graphics2D g) {
	g.setColor(new Color(50,0,50));
        g.fillRect(0,0,getWidth(),getHeight());	
    }

    public void drawFrame(Graphics2D g) {
	g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }

    public void drawControls(Graphics2D g) {
	Color C=new Color(50,100,255);
	double[] t={FRAME[0].x[0],FRAME[0].x[1],FRAME[0].x[2],FRAME[1].x[0],FRAME[1].x[1],FRAME[1].x[2]};
	for(int i=0;i<6;++i) {
           T[i].renderSmooth(g,C,C);
	   GeneralPath gp=new GeneralPath();
	   t[i]=200+150*t[i];
	   gp.moveTo((float)(t[i]-1),30*i);
	   gp.lineTo((float)(t[i]+1),30*i);
	   gp.lineTo((float)(t[i]+1),30*i+20);
	   gp.lineTo((float)(t[i]-1),30*i+20);
	   g.setColor(Color.white);
	   g.fill(gp);
	}

	for(int i=0;i<4;++i) PRESET[i].render(g,new Color(200,0,200));
    }


    public Vector[] basic() {
	Vector V1=new Vector(1,0,0);
	Vector V2=new Vector(0,1,0);
	Vector[] V={V1,V2};
	return(V);
    }


    public Vector[] getFrame(boolean nav) {
	if(nav==false) return(basic());
	return(FRAME);
    }


    public void doMove(MouseEvent e) {
	MouseData J=MouseData.process(e);
	for(int i=0;i<3;++i) {
	    double t=(J.X.x-200)/150.0;
	    if(T[i+0].inside(J.X)==1) FRAME[0].x[i]=t;
	    if(T[i+3].inside(J.X)==1) FRAME[1].x[i]=t;
	}

	if(PRESET[0].inside(J.X)==1) {
	  FRAME[0]=new Vector(GoldenRatio.phi(-1),.5,0);
	  FRAME[1]=new Vector(0,-.5,1);
	}

	if(PRESET[1].inside(J.X)==1) {
	    FRAME[0]=new Vector(1,0,0);
	    FRAME[1]=new Vector(0,1,0);
	}

	if(PRESET[2].inside(J.X)==1) {
	    FRAME[0]=new Vector(1,0,0);
	    FRAME[1]=new Vector(0,0,1);
	}

	if(PRESET[3].inside(J.X)==1) {
	    FRAME[0]=new Vector(0,1,0);
	    FRAME[1]=new Vector(0,0,1);
	}


    }


    /**COORDINATE DISPLAY**/



    public void drawCoords(Graphics2D g) {
	g.setColor(new Color(50,100,255));
	g.drawLine(200,0,200,200);
	g.drawLine(200,50,400,50);
	g.drawLine(200,100,400,100);
        g.setFont(new  Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	int q=M.C.CON_P.ZONE.val;

	int[] m=DataPartition.getMove(q);
	int[] A={m[0]+m[1],m[0]-3*m[1],m[1],m[1]};

	/**draw the dynamical plane m**/
	String S=new String();
	Integer I=new Integer(2*m[0]);
	S=S+I.toString();
	I=new Integer(2*m[1]);
	S=I.toString()+" A + "+S;
	g.drawString("strip move",220,20);
	g.drawString(S,220,40);


	/**draw the poly exchange move**/


	S=new String();
	I=new Integer(A[1]);
	S=I.toString()+" A + ";
	I=new Integer(A[0]);
	S=S+I.toString();
	S=S+"      ";
	I=new Integer(A[3]);
	S=S+I.toString()+" A + ";
	I=new Integer(A[2]);
	S=S+I.toString()+"     0";

	g.drawString("poly move",220,70);
	g.drawString(S,220,90);

	/**conversion**/
	S="A=-3 + 2 \u03A6";
	g.drawString(S,320,40);







	/**draw the polyhedron coords**/
	GoldenPolyhedron GP=DataPartition.getGoldenPolyhedron(q);
	int shift=0;
	for(int i=0;i<GP.count;++i) {
	    S="";
	    for(int j=0;j<3;++j) {
	      Long J=new Long(GP.V[i].x[j].a[0]);
	      S=S+I.toString(); 
	      S=S+"+";
              J=new Long(GP.V[i].x[j].a[1]);
	      S=S+J.toString()+" \u03A6     ";
	    }
 	    g.drawString(S,10,20+18*shift);
	    S="";
	    ++shift;
	}

        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	Integer N1=M.PC1.COUNT;
  	Integer N2=M.PC2.COUNT;
        g.drawString("tile count:",220,120);
        g.drawString(N1.toString(),220,140);
        g.drawString(N2.toString(),220,160);


    }



    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
     }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
	doMove(e);
 	MouseData J=MouseData.process(e);
	documentStuff(M,J.X);
	repaint();
	if(INFO.inside(J.X)==0) M.PC1.repaint();
    }

    
    public void mouseDragged(MouseEvent e) {

	MouseData J=MouseData.process(e);
	if((J.X.x<385)&&(J.X.y<165)) {
	  doMove(e);
	  repaint();
	  if(INFO.inside(J.X)==0) M.PC1.repaint();
	}
    }

    public void doMouseDrag() {
    }
  
    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }


    /**DOCUMENTATION**/

    public void documentStuff(Manager M,Point X) {
	Document3D DOC=new Document3D(M);
	if(INFO.inside(X)==1) DOC.navigateInfo();
    }




}

