import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**This class does the basic iterations associated
   to the outer billiards map**/

public class OuterBilliards {

    /**This routine finds the vertex such that rotation about this
       vertex does the outer billiards map.**/

      public static int findGoodVertex(Complex w) { 
        PolyWedge Q=PolyWedge.penroseKite(); 
	int index=0;
	for(int i=0;i<4;++i) {
	    boolean test=Complex.isPositivelyOriented(w,Q.z[index],Q.z[i]);
	    if(test==true) {
		index=i;
	    }
	}
      return(index);
      }


    /**This does one step of the outer billiards map**/

    public static Complex nextComplex(Complex z) {
        PolyWedge Q=PolyWedge.penroseKite(); 
	int k=findGoodVertex(z);
	Complex Z=new Complex(Q.z[k]);
	Z=Complex.plus(Z,Z);
	Z=Complex.minus(Z,z);
	Z.history=k;
	return(Z);
    }

    /**This does the outer billiards map for a polygon.  We use the
       center point to define the map.  Hence, this construction is
       only valid for a polygon that is contained in an orbit tile.*/

    public static PolyWedge nextPoly(PolyWedge P) {
        PolyWedge Q=PolyWedge.penroseKite();
	int k=findGoodVertex(P.getCenter());
	Complex Z=new Complex(Q.z[k]);
 	Z=Complex.plus(Z,Z);
	PolyWedge PP=new PolyWedge();
	for(int i=0;i<P.count;++i) {
	    PP.z[i]=Complex.minus(Z,P.z[i]);
	}
	PP.count=P.count;
	return(PP);
    }

    /**When we use the pinwheel map to compute a tile, we need to
       start in the fundamental strip. This map iterates the outer
       billiards map until reaching a point in the strip -- we call
       this point a good start.*/


    public static Complex goodStart(Complex z) {
	Complex w=new Complex(z);
	for(int i=0;i<100;++i) {
	if((w.x>0)&&(Math.abs(w.y)<w.x+1)) return(w);
	   w=nextComplex(w);
	   w=nextComplex(w);
	}
	return(z);
    }


    /**This routine returns true if the point is in
       the half strip Sigma_+.*/

    public static int positiveTest(Complex z) {
            double x=z.x;
	    double y=z.y;
	    int test1=1;
	    if(y>2) test1=0;
	    if(y<-2) test1=0;
	    if(x<y-1) test1=0;
	    if(x<-y-1) test1=0;
	    return(test1);
    }


    /**This routine returns true if the point is in
       the half strip Sigma_-.*/


    public static int negativeTest(Complex z) {
	    double a=Math.sqrt(5)-2;
	    double x=z.x;
	    double y=z.y;
	    int test1=1;
	    if(y>2) test1=0;
	    if(y<-2) test1=0;
	    if(x>-a*y+a) test1=0;
	    if(x>a*y+a) test1=0;
	    return(test1);
    }
}




