import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**The 2D dynamical plane**/



public class OuterCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    AffineTransform[] A=new AffineTransform[5];
    ComputeOuter TC;
    String[] STAT=new String[5];
    Point KEY;
    boolean DRAG;
    int INDEX;

    Complex SOURCE=new Complex(0,0);
    Color[] TILECOLOR=new Color[200000];
    Color[] OUTLINECOLOR=new Color[200000];
    PolyWedge[] TILE=new PolyWedge[200000];
    ListenSquare STATS,INFO;
    Output OUT;

    int orbit=0;
    int tile=0;
    int halt=0;
    int block=0; 
    Point JX;

    PolyWedge WEDGE;
    PolyVector VECTOR;
    ListenSquare[] L=new ListenSquare[10];
    int MEM;


    public OuterCanvas addManager(Manager M) {
	OuterCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public OuterCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 KEY=new Point();
	 DRAG=false;
	 TC=new ComputeOuter();
	 double x=magicScale();
	 double phi=(Math.sqrt(5)+1)/2;
	 setScales(312,160,80,80);
	 INDEX=-1;  //the selected tile
	 INFO=new ListenSquare(0,0,12,12);
     }

    public double magicScale() {
	 double A=Math.sqrt(5)-2;
	 double r1=2/(1+A);
	 double r2=Math.sqrt(GoldenRatio.phi(-2)*4-GoldenRatio.phi(-4));
	 return(r2/r1);
    }

   public void paint(Graphics g2) {
         OUT=new Output("Output/outer");
	 OUT.ACTIVE=false;
	 if(M.C.EXPORT.on==1) OUT.ACTIVE=true;
         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
         drawBG(g); 
         OuterMarkings.drawTotal1(g,M,OUT); 
         RenormDisplay.drawTotal(g,M,OUT);
	 drawKite(g); 
         drawTiles(g);   
         OuterMarkings.drawTotal2(g,M,OUT);
         drawFrame(g); 
	 INFO.infoRender(g);
   }


    public void drawBG(Graphics2D g) {
	Color C=M.C.COL.BG.C;
	OUT.tclBgSet(C);
	g.setColor(C);
        g.fillRect(0,0,getWidth(),getHeight());
    }



    public void drawFrame(Graphics2D g) {
        g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()-1);  
    }


    public void drawKite(Graphics2D g) {
     PolyWedge KITE=PolyWedge.penroseKite();
     GeneralPath gp=KITE.toGeneralPath();
     Color C1=M.C.CON_T.COLORS.L[0].C;
     Color C2=M.C.COL.OUTLINE.C;
     OUT.polyPrint(gp,C1,C2);
     gp=transform(gp);
     g.setColor(C1);
     g.fill(gp);
     g.setColor(C2);
     g.draw(gp);  
    }

    public void recognizeTile() {
	int total=DataPinwheel.COUNT();
	int index=-999;
	int val=0;
	PolyWedge P=new PolyWedge();
	for(int i=0;i<total;++i) {
	    GoldenPolyWedge IP=DataPinwheel.returnPoly(i);
	    P=IP.toPolyWedge();
	    GeneralPath gp=P.toGeneralPath();
	    if(gp.contains(SOURCE.x,SOURCE.y)==true) {
                  index=i;
		  val=P.count;
	    }
	}  
        if(index!=-999) M.C.CON_T.ZONE.val=index;
    }



    public void decideAction() {
	    TC=new ComputeOuter(M);
	    new Thread(TC).start();
    }


    public void addPoly(PolyWedge W) {
	addPoly(W,M.K.SC.C,M.C.CON_T.COLORS.L[1].C);
    }

    public void addPoly(PolyWedge W,Color C1) {
	addPoly(W,C1,M.C.CON_T.COLORS.L[1].C);
    }

    public void addPoly(PolyWedge W,Color C1,Color C2) {
         TILE[tile]=new PolyWedge(W);
         TILECOLOR[tile]=C1;
	 OUTLINECOLOR[tile]=C2;
	 ++tile;
    }




        public void setCoord() {
	     Double Sx=new Double(SOURCE.x);
	     Double Sy=new Double(SOURCE.y);
	     double d=Math.floor((SOURCE.x+1)/4);
	     Integer II=new Integer((int)(d));
	     STAT[2]="coord "+Sx.toString()+"   "+Sy.toString();
	     if(M.C.LINK.L[0].on==1) Links.stripToTorus(M);
       }

    public void drawTiles(Graphics2D g) {
      for(int i=0;i<tile;++i) {
            GeneralPath X=TILE[i].toGeneralPath();
	    OUT.polyPrint(X,TILECOLOR[i],Color.black);
            X=transform(X);
            g.setColor(TILECOLOR[i]);
            g.fill(X); 
            g.setColor(OUTLINECOLOR[i]);
	    if(i==INDEX)   g.setStroke(new BasicStroke(3));
            g.draw(X); 
            g.setStroke(new BasicStroke(1));
      }
    }

    public GeneralPath getContains() {
       for(int i=0;i<tile;++i) {
         GeneralPath X=TILE[i].toGeneralPath();
         if(X.contains(SOURCE.x,SOURCE.y)==true) {
	 INDEX=i;
         return(X);
	 }
       }
       return(null);
    }

    public void modifyTiles() {
	int mode=M.C.CON_T.EDIT.mode;
	getContains();

	/*erase*/
	if(mode==1) {
	    for(int i=INDEX;i<tile-1;++i) {
		TILE[i]=TILE[i+1];
		TILECOLOR[i]=TILECOLOR[i+1];
		OUTLINECOLOR[i]=OUTLINECOLOR[i+1];
	    }
	    if(tile>0) --tile;
	}

	if(mode==2) {
	    TILECOLOR[INDEX]=M.K.SC.C;
	}


	if(mode==3) {
	    GoldenPolyWedge G=new GoldenPolyWedge(TILE[INDEX],20,.00000001);
	    G.print2();
	}

	if(INDEX!=-1) TileStats.stats(M.C,TILE[INDEX],SOURCE,1,false);

    }



    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
     }

    public void mouseExited(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	KEY=J.X;
	if(DRAG==true) doMouseDrag();
    }



    public void setSource(Complex z) {
	int t=M.C.LINK.L[4].on;
	if(t==0) SOURCE=new Complex(z);
	if(t==1) SOURCE.x=z.x;
    }



    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	Point X=J.X;
	int mode=J.mode; 
	int block=INFO.inside(KEY);
        if((mode==1)&&(block==0)) scaleUp(X,-1);
        if((mode==3)&&(block==0)) scaleUp(X,+1);
	if(mode==2) {
          Complex temp=unTransform(X);
	  setSource(temp);
	  setCoord();
	  decideAction(); 
          if(M.C.CON_T.MULTI.mode==0) modifyTiles();
	}	
        documentStuff(X);
	recognizeTile();
	M.C.repaint();
	M.K.repaint();
	repaint();
    }

    public void doMouseClick(int mode) {
	int block=INFO.inside(KEY);
        if((mode==1)&&(block==0)) scaleUp(KEY,-1);
        if((mode==3)&&(block==0)) scaleUp(KEY,+1);
	if(mode==2) {
          Complex temp=unTransform(KEY);
	  setSource(temp);
	  setCoord();
	  decideAction();
	  if(M.C.CON_T.MULTI.mode==0) modifyTiles();
	}

	documentStuff(KEY);
	recognizeTile();
	M.C.repaint();
	M.K.repaint();
	repaint();
    }
  

    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	KEY=J.X;
	if(J.mode==2) doMouseDrag();
    }


    public void doMouseDrag() {
        Complex temp=unTransform(KEY);
	setSource(temp);
	setCoord();
	repaint();
	M.K.repaint();
    }
  
    public void keyReleased(KeyEvent e) {
	DRAG=false;
    }

    public void keyPressed(KeyEvent e) {
	DRAG=true;
    }

    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }

    /**DOCUMENTATION**/

    public void documentStuff(Point X) {
	DocumentOuter DOC=new DocumentOuter(M);
	if(INFO.inside(X)==1) DOC.outerInfo();
    }

}

