import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class OuterMarkings {
    public OuterMarkings() {
    }

    public static void drawTotal1(Graphics2D g,Manager M,Output OUT) {
	int[] d=new int[12];
	Color[] C=new Color[12];
	for(int i=0;i<9;++i) d[i]=M.C.CON_T.MARKINGS.L[i].on;
	for(int i=0;i<9;++i) C[i]=M.C.CON_T.MARKINGS.M[i].C;
	if(d[0]==1) drawFundamentalStrip(g,M,C[0],OUT);
        if(d[6]==1) drawPinwheel(g,M,OUT);
 	if(d[5]==1) drawTri(g,M,C[5],OUT);
 	if(d[7]==1) drawStrips(g,M,C[7]);
 	if(d[1]==1) drawBox(g,M,C[1],OUT);	
    }

    public static void drawTotal2(Graphics2D g,Manager M,Output OUT) {
	int[] d=new int[12];
	Color[] C=new Color[12];
	for(int i=0;i<9;++i) d[i]=M.C.CON_T.MARKINGS.L[i].on;
	for(int i=0;i<9;++i) C[i]=M.C.CON_T.MARKINGS.M[i].C;
	if(d[2]==1) drawHorizontals(g,M,C[2],OUT);
	if(d[3]==1) drawHorizontalCursor1(g,M,C[3],OUT);
	if(d[4]==1) drawHorizontalCursor2(g,M,C[4],OUT);
	if(d[8]==1) drawCursor(g,M,C[8],OUT);
    }


    public static void drawCursor(Graphics2D g,Manager M,Color C,Output OUT) {
	double x=M.T.SOURCE.x;
	double y=M.T.SOURCE.y;
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(x-100),(float)(y-100));
	gp.lineTo((float)(x+100),(float)(y+100));
	OUT.polyPrint(gp,C,C);
	gp=M.T.transform(gp);
	g.setColor(C);
	g.draw(gp);
	gp.reset();
	gp.moveTo((float)(x+100),(float)(y-100));
	gp.lineTo((float)(x-100),(float)(y+100));
	OUT.polyPrint(gp,C,C);
	gp=M.T.transform(gp);
	g.setColor(C);
	g.draw(gp);
    }

    public static void drawTri(Graphics2D g,Manager M,Color C,Output OUT) {
	g.setStroke(new BasicStroke(3));
	g.setColor(C);
	PolyWedge P=new PolyWedge();
	P=Fundamental.triangleMain();
	GeneralPath gp=P.toGeneralPath();
	OUT.polyPrint(gp,C,Color.black);
	gp=M.T.transform(gp);
	g.draw(gp);

	P=Fundamental.verticalReflect2(P);
        gp=P.toGeneralPath();
	OUT.polyPrint(gp,C,Color.black);
	gp=M.T.transform(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }


    public static void drawBox(Graphics2D g,Manager M,Color C,Output OUT) {
      GeneralPath gp=new GeneralPath();  
      double A=GoldenRatio.phi(-3);
      float[] f={(float)(2+A),24};
      for(int i=0;i<2;++i) {
        gp.reset();
	gp.moveTo(0,0);
	gp.lineTo(0,2);
	gp.lineTo(f[i],2);
	gp.lineTo(f[i],0);
	gp.closePath();
	g.setColor(C);
	OUT.linePrint(gp,Color.black);
	gp=M.T.transform(gp);
	g.setStroke(new BasicStroke(3));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
      }
    }


    public static void drawFundamentalStrip(Graphics2D g,Manager M,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();  
	gp.moveTo(-1,0);
	gp.lineTo(1,2);
	gp.lineTo(101,2);
	gp.lineTo(101,-2);
	gp.lineTo(1,-2);
	gp.closePath();
	OUT.polyPrint(gp,C,Color.black);
	gp=M.T.transform(gp);
	g.setColor(C);
	g.fill(gp);
	g.setColor(Color.black);
	g.draw(gp);

	double A=Math.sqrt(5)-2;
	gp.reset();
	gp.moveTo(A,0);
	gp.lineTo(-A,2);
	gp.lineTo(-101,2);
	gp.lineTo(-101,-2);
	gp.lineTo(-A,-2);
	gp.closePath();	
        OUT.polyPrint(gp,C,Color.black);
	gp=M.T.transform(gp);
	g.setColor(C);
	g.fill(gp);
	g.setColor(Color.black);
	g.draw(gp);
    }


    public static void drawHorizontals(Graphics2D g,Manager M,Color C,Output OUT) {
	 GeneralPath gp=new GeneralPath();
         double A=GoldenRatio.phi(-3);
	 double B=GoldenRatio.phi(-2);
	 double[] y0={0,B,2*B,1,2-2*B,2-B,2};
	 double[] y1=new double[7];

	  float[] fy=new float[7];
	  for(int i=0;i<7;++i) {
            fy[i]=(float)(y0[i]);
	    gp.reset();
	    gp.moveTo(0,fy[i]);
	    gp.lineTo(20,fy[i]);
	    OUT.polyPrint(gp,C,C);
	    g.setColor(C);
	    gp=M.T.transform(gp);
	    g.setStroke(new BasicStroke(3));
	    g.draw(gp);
	  }

          g.setStroke(new BasicStroke(1));

	  for(int i=1;i<6;++i) {
	      y1[i]=A*y0[i];
            fy[i]=(float)(y1[i]);
	    gp.reset();
	    gp.moveTo(0,fy[i]);
	    gp.lineTo(20,fy[i]);
	    OUT.polyPrint(gp,C,C);
	    g.setColor(C);
	    gp=M.T.transform(gp);
	    g.draw(gp);
	  }

	  for(int i=1;i<6;++i) {
	      y1[i]=2-(A*y0[i]);
            fy[i]=(float)(y1[i]);
	    gp.reset();
	    gp.moveTo(0,fy[i]);
	    gp.lineTo(20,fy[i]);
	    OUT.polyPrint(gp,C,C);
	    g.setColor(C);
	    gp=M.T.transform(gp);
	    g.draw(gp);
	  }

	  for(int i=0;i<6;++i) {
	    y1[i]=A*y0[i]+2*GoldenRatio.phi(-2);
            fy[i]=(float)(y1[i]);
	    gp.reset();
	    gp.moveTo(0,fy[i]);
	    gp.lineTo(20,fy[i]);
	    OUT.polyPrint(gp,C,C);
	    g.setColor(C);
	    gp=M.T.transform(gp);
	    g.draw(gp);
	  }



    }


    public static void drawHorizontalCursor1(Graphics2D g,Manager M,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	  double y1=M.C.CON_P.PARAMETER[0];
	  gp.moveTo(-100,(float)(y1));
	  gp.lineTo(100,(float)(y1));
          OUT.polyPrint(gp,C,C); 
          g.setColor(C);
          gp=M.T.transform(gp);
	  g.draw(gp); 

	  gp.reset();
	  gp.moveTo(-100,(float)(y1-2));
	  gp.lineTo(100,(float)(y1-2));
	  g.setColor(C);
	  OUT.polyPrint(gp,C,C);
	  gp=M.T.transform(gp);
	  g.draw(gp); 
    }

    public static void drawHorizontalCursor2(Graphics2D g,Manager M,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	  double y1=M.C.CON_P.PARAMETER[1];
	  gp.moveTo(-100,(float)(y1));
	  gp.lineTo(100,(float)(y1));
          OUT.polyPrint(gp,C,C); 
          g.setColor(C);
          gp=M.T.transform(gp);
	  g.draw(gp); 

	  gp.reset();
	  gp.moveTo(-100,(float)(y1-2));
	  gp.lineTo(100,(float)(y1-2));
	  g.setColor(C);
	  OUT.polyPrint(gp,C,C);
	  gp=M.T.transform(gp);
	  g.draw(gp); 
    }




    /**These routines are used with the pinwheel pointer**/



    public static void drawPinwheel(Graphics2D g,Manager M,Output OUT) {
	int count=DataPinwheel.COUNT();
	for(int i=0;i<count;++i) {
	    GoldenPolyWedge IP=DataPinwheel.returnPoly(i);
	    PolyWedge P=IP.toPolyWedge();
	    GeneralPath gp=P.toGeneralPath();
	    Complex z=P.getCenter();
            Color[] C=getColor1(z,M);
	    if(M.C.TOGGLE.mode==1) C[0]=getColor2(i,M);
	    OUT.polyPrint(gp,C[0],C[1]);
            gp=M.T.transform(gp);
	    g.setColor(C[0]);
	    g.fill(gp);
	    g.setColor(C[1]);
	    g.draw(gp);
	}
    }

    public static Color[] getColor1(Complex z,Manager M) {
  	    PinwheelMap PIN=new PinwheelMap();
	    int[] r=PIN.piIntegral(z);
            int[] rr={r[1],r[0]};
	    Color[] C=M.C.COL.getColor(rr); 
	    return(C);
    }

    public static Color getColor2(int q,Manager M) {
	int i=DataPinwheel.classify(q);
	int prism=DataPartitionRaw.getPrism(i);
        Color C=M.C.COL.getColor2(prism);
	return(C);
    }

    public static void drawStrips(Graphics2D g,Manager M,Color C) {
	for(int i=0;i<2;++i) {
	  GeneralPath gp=strip(i);
	  GeneralPath gp2=new GeneralPath(gp);
	  AffineTransform AFF=AffineTransform.getScaleInstance(1,-1);
	  gp2.transform(AFF);
	  gp=M.T.transform(gp);
 	  gp2=M.T.transform(gp2);
	  g.setColor(C);
	  g.fill(gp);
	  g.fill(gp2);
	  Color C2=new Color(C.getRed(),C.getGreen(),C.getBlue());
	  g.setColor(C2);
	  g.draw(gp);
	  g.draw(gp2);
	}
    }


    public static GeneralPath strip(int k) {
	if(k==0) return(strip1());
	return(strip2());
    }

    public static GeneralPath strip1() {
	GeneralPath H0=new GeneralPath();
	PolyWedge KITE=PolyWedge.penroseKite();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=KITE.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	int a1,a2,a3;

	a1=0;
	a2=3;
	a3=1;

	p1[0]=(float)(64*z[a1].x-63*z[a2].x);
	p2[0]=(float)(64*z[a2].x-63*z[a1].x);
	p1[1]=(float)(64*z[a1].y-63*z[a2].y);
	p2[1]=(float)(64*z[a2].y-63*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(64*zz[a1].x-63*zz[a2].x);
	p2[0]=(float)(64*zz[a2].x-63*zz[a1].x);
	p1[1]=(float)(64*zz[a1].y-63*zz[a2].y);
	p2[1]=(float)(64*zz[a2].y-63*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();
	return(H0);
    }

    public static GeneralPath strip2() {
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	PolyWedge KITE=PolyWedge.penroseKite();
	for(int i=0;i<4;++i) z[i]=KITE.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	int a1,a2,a3;

	a1=2;
	a2=1;
	a3=0;

	p1[0]=(float)(64*z[a1].x-63*z[a2].x);
	p2[0]=(float)(64*z[a2].x-63*z[a1].x);
	p1[1]=(float)(64*z[a1].y-63*z[a2].y);
	p2[1]=(float)(64*z[a2].y-63*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(64*zz[a1].x-63*zz[a2].x);
	p2[0]=(float)(64*zz[a2].x-63*zz[a1].x);
	p1[1]=(float)(64*zz[a1].y-63*zz[a2].y);
	p2[1]=(float)(64*zz[a2].y-63*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);	

        H0.closePath();
	return(H0);
    }


}