#! /usr/local/bin/wish  -f

canvas .plot -width 800 -height 800 -bg white
canvas .post -width 800 -height 20 -bg black
pack .post
pack .plot
.plot create rectangle -10 -10 1000 1000 -fill white -outline white -tag bg
######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1
set WIDTH 800
set HEIGHT 800

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

.plot itemconfigure bg -fill white -outline white

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}

proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}

## window size


.post create rectangle 0 0 70 50 -fill green -tag export
.post create text 8 13 -anchor w -text "export" -fill black -tag export

.post create rectangle 200 0 270 50 -fill orange -tag wind1
.post create text 208 13 -anchor w -text "width" -fill black -tag wind1

.post create rectangle 270 0 340 50 -fill orange -tag wind2
.post create text 278 13 -anchor w -text "height" -fill black -tag wind2

.post bind export <Any-Button> post

.post bind wind1 <Button-1> {
   global WIDTH HEIGHT
    set WIDTH [expr $WIDTH-50]
    make_frame
}

.post bind wind1 <Button-2> {
   global WIDTH HEIGHT
    set WIDTH [expr $WIDTH+50] 
    make_frame
}

.post bind wind1 <Button-3> {
   global WIDTH HEIGHT
    set WIDTH [expr $WIDTH+50]   
     make_frame
 
}

.post bind wind2 <Button-1> {
   global WIDTH HEIGHT
    set HEIGHT [expr $HEIGHT-50]   
    make_frame
}

.post bind wind2 <Button-2> {
   global WIDTH HEIGHT
    set HEIGHT [expr $HEIGHT+50]  
    make_frame
}

.post bind wind2 <Button-3> {
   global WIDTH HEIGHT
    set HEIGHT [expr $HEIGHT+50] 
    make_frame
}

proc make_frame {} {
   global WIDTH HEIGHT
   .plot delete wind
   .plot create rectangle 0 0 $WIDTH $HEIGHT -outline white -width 5 -tag wind 
   .plot create rectangle 0 0 $WIDTH $HEIGHT -outline black -width 3 -tag wind 
   .plot raise wind
}


# file selection

.post create rectangle 100 0 120 25 -fill red -outline black -tag f1
.post create rectangle 120 0 140 25 -fill red -outline black -tag f2
.post create rectangle 140 0 160 25 -fill red -outline black -tag f3
.post create rectangle 160 0 180 25 -fill red -outline black -tag f4

.post bind f1 <Any-Button> {
.plot delete X
source partition2
.plot scale X 0 0 400 -400
}

.post bind f2 <Any-Button> {
.plot delete X
source partition1
.plot scale X 0 0 400 -400
}


.post bind f3 <Any-Button> {
.plot delete X
source graph
.plot scale X 0 0 20 -20
}


.post bind f4 <Any-Button> {
.plot delete X
source outer
.plot scale X 0 0 20 -20
}


proc post {} {
global WIDTH HEIGHT
.plot postscript -pageheight 800 -pagewidth 800 \
    -height [expr $HEIGHT+1] -width $WIDTH \
-file "temp.ps"
}
