import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


public class PartitionCanvas extends ScaleCanvas implements KeyListener,MouseListener,MouseMotionListener{
    Manager M;
    int TYPE;
    int COUNT=0;
    Polyhedron[] POLY=new Polyhedron[100000];
    Color[] COLOR=new Color[100000];
    Complex SOURCE;
    Output OUT;
    Point KEY;
    AffineTransform[] FIT;
    Color[] RANDOM=new Color[100];
    ListenSquare INFO;

    public PartitionCanvas(int type) {
	TYPE=type;
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	if(TYPE==1) setScales(62,500,250,250);  
        if(TYPE==2) setScales(45,314,157,157);
	SOURCE=new Complex();
	KEY=new Point();
	randomColors();
	INFO=new ListenSquare(0,0,12,12);
    }

    public void randomColors() {
      for(int i=0;i<100;++i) {
	int a0=(int)(255*Math.random());
	int a1=(int)(255*Math.random());
	int a2=(int)(255*Math.random());
	RANDOM[i]=new Color(a0,a1,a2);
      }
    }

    /**This is how the computing routines add polyhedra to the list.**/

    public void nextPolyLast(Polyhedron P) {
	if(P!=null) {
	  POLY[COUNT]=P;
          COLOR[COUNT]=M.K.SC.C;
          ++COUNT; 
	}
    }

   public void paint(Graphics g2) {  
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      setExport();

      int[] s=new int[16];
      for(int i=0;i<14;++i) s[i]=M.C.CON_P.SHOW.L[i].on;
      drawBackground(g);
      drawPieces(g,1); 
      if(s[4]==1) drawPieces(g,2);    
      if(s[3]==1) drawPiecesMove(g);    
      if(s[1]==1) drawZonePointer(g);   
      if(s[2]==1) drawVertexPointer(g);

    
      if((TYPE==1)&&(s[5]==1)) drawRenormA(g);
      if((TYPE==1)&&(s[6]==1)) drawRenormAPoly(g,0);
      if((TYPE==1)&&(s[7]==1)) drawRenormAPoly(g,1);

      if((TYPE==2)&&(s[8]==1)) drawRenormB(g);
      if((TYPE==2)&&(s[9]==1)) drawRenormBPoly(g,0);
      if((TYPE==2)&&(s[10]==1)) drawRenormBPoly(g,1);


      if((TYPE==1)&&(s[11]==1)) drawRenormB(g);
      if((TYPE==1)&&(s[12]==1)) drawRenormBPoly(g,0);
      if((TYPE==1)&&(s[13]==1)) drawRenormBPoly(g,1);

      drawTiles(g);
      drawFoliation(g);
      if(s[0]==1) drawCrosshairs(g); 
      INFO.infoRender(g);
      drawFrame(g);
   }

    public void setExport() {
      if(TYPE==1) OUT=new Output("output/partition1");
      if(TYPE==2) OUT=new Output("output/partition2");
      OUT.ACTIVE=false;
      if(M.C.EXPORT.on==1) OUT.ACTIVE=true;
    }

    public void drawBackground(Graphics2D g) {
        Color C=M.C.COL.BG.C;
	g.setColor(C);
        g.fillRect(0,0,getWidth(),getHeight());
	if(M.C.CON_P.NAVIGATE.on==0) drawGrid(g);
    }

    public void drawGrid(Graphics2D g) {
	Color C=new Color(0,0,0,100);
	g.setColor(C);
	GeneralPath gp=new GeneralPath();
	for(int i=-8;i<8;i=i+2) {
		gp.reset();
		gp.moveTo(-10,i);
		gp.lineTo(10,i);
		gp.moveTo(i,-10);
		gp.lineTo(i,10);
		gp=transform(gp);
		g.draw(gp);
	}
    }

    public void drawFrame(Graphics2D g) {
      g.setColor(Color.white);
      g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }

    public GeneralPath getContains() {
 	boolean nav=M.C.CON_P.navigate();
	Vector[ ] F=getFrame(nav);
	for(int i=0;i<COUNT;++i) {
            PolyWedge Q=PolyhedronSlicer.slice(F[0],F[1],F[2],POLY[i],false);
	    if(Q!=null) {
	      GeneralPath gp=Q.toGeneralPath();
	      if(gp.contains(SOURCE.x,SOURCE.y)==true) return(gp);
	    }
	}
	return(null);
    }


    public void drawTiles(Graphics2D g) {
	int n=M.C.CON_P.OUTLINE.mode;
	boolean nav=M.C.CON_P.navigate();
	Vector[ ] F=getFrame(nav);

 	for(int i=0;i<COUNT;++i) {
	    PolyWedge Q=PolyhedronSlicer.slice(F[0],F[1],F[2],POLY[i],nav);
	     Color C=Color.white;
	     if(n==1) C=Color.black;
	     if(n==2) C=new Color(0,0,0,0);
	     if(n==3) C=COLOR[i];
	     if(Q!=null) drawPoly(g,Q,COLOR[i],C,1);
	}
    }


    public void drawFoliation(Graphics2D g) {
          int[] a={0,0,1,1,0,0,1,1};
          int[] b={0,1,0,1,1,0,1,0};
            GeneralPath gp=new GeneralPath();
            for(int j=0;j<4;++j) {
	      if(M.C.CON_P.FOLIATION.L[j].on==1) {
	      int ex=M.C.CON_P.FOL[j].val;
	      gp=ComputeFoliation.getFoliation(TYPE,a[j],b[j],M.C.getOffsetY(TYPE),ex);
	      for(int k=-4;k<=4;++k) {
	        AffineTransform AF=AffineTransform.getTranslateInstance(2*k,0);
	        GeneralPath gp2=new GeneralPath(gp);
	        gp2.transform(AF);
	        gp2=transform(gp2);
	        g.setColor(M.C.CON_P.FOLIATION.M[j].C);
	        g.draw(gp2);
	      }
	    }
	}
    }



    /**This changes the lattice and polyhedra to a more geometrically
       natural affine coordinate system.  We don't use this in the paper.**/

    public void drawPoly(Graphics2D g,PolyWedge P,Color C1,Color C2,int thickness) {
      if(P!=null) {
	GeneralPath gp=P.toGeneralPath();
	OUT.polyPrint(gp,C1,C2);             //for pictures
 	gp=transform(gp);
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.setStroke(new BasicStroke(thickness));
	g.draw(gp);
        g.setStroke(new BasicStroke(1));
      }
    }

    public void drawRenormA(Graphics2D g) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int total=0;
	for(int levelA=0;levelA<5;++levelA) {
	  for(int levelB=0;levelB<6;++levelB) {	
	    for(int branch=0;branch<4;++branch) {
	        PolyWedge P=DataRenorm.polyA(levelA,levelB,branch,F[0],F[1],F[2],nav);
                Color C=M.C.CON_P.SHOW.M[5].C;
	        Color C2=M.C.COL.OUTLINE.C;
	        if(P!=null) drawPoly(g,P,C,C2,1);
	    }
	  }
	}
    }

    public void drawRenormB(Graphics2D g) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int total=0;
	for(int levelB=0;levelB<6;++levelB) {
	  for(int branch=0;branch<4;++branch) {
	      PolyWedge P=DataRenorm.polyB(levelB,branch,F[0],F[1],F[2],nav);
	     int col=11;
	     if(TYPE==2) col=8;
             Color C=M.C.CON_P.SHOW.M[col].C;  
             Color C2=M.C.COL.OUTLINE.C;
	     if(P!=null) drawPoly(g,P,C,C2,1);
	  }
	}
    }



    public void drawRenormAPoly(Graphics2D g,int direction) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int total=0;
	int[] L=Characteristics.getCharA(F[2].x[2]);
	int levelA=L[0];
	int levelB=L[1]; 
         int n=M.C.CON_P.OUTLINE.mode;
	  for(int branch=0;branch<4;++branch) {  
	     int lim=DataRenormReturn.limits(levelB,branch);
	     for(int k=0;k<lim;++k) {
		Polyhedron P=DataRenormReturn.getA(levelA,levelB,branch,k,direction);
		if(P!=null) {
		    PolyWedge Q=PolyhedronSlicer.slice(F[0],F[1],F[2],P,nav);
                    Color C0=M.C.CON_P.SHOW.M[6].C; 
                    if(direction==1)  C0=M.C.CON_P.SHOW.M[7].C;
                    Color C1=Color.white;
	            if(n==1) C1=Color.black;
	            if(n==2) C1=new Color(0,0,0,0);
	            if(n==3) C1=C0;
	            if(Q!=null) drawPoly(g,Q,C0,C1,1);
	       }
	     }
	  }
    }



    public void drawRenormBPoly(Graphics2D g,int direction) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int total=0;
	int levelB=Characteristics.getCharB(F[2].x[2]); 
        int n=M.C.CON_P.OUTLINE.mode;
	  for(int branch=0;branch<4;++branch) {  
	      int lim=DataRenormReturn.limits(levelB,branch); 
	      for(int k=0;k<lim;++k) {
		  Polyhedron P=DataRenormReturn.getB(levelB,branch,k,direction);
		  if(P!=null) {
		      PolyWedge Q=PolyhedronSlicer.slice(F[0],F[1],F[2],P,nav);
		      int col=0;
		      if((direction==0)&&(TYPE==2)) col=9;
		      if((direction==0)&&(TYPE==1)) col=12;
		      if((direction==1)&&(TYPE==2)) col=10;
		      if((direction==1)&&(TYPE==1)) col=13;
	              Color C0=M.C.CON_P.SHOW.M[col].C;  
                      Color C1=Color.white;
	              if(n==1) C1=Color.black;
	              if(n==2) C1=new Color(0,0,0,0);
	              if(n==3) C1=C0;
	              if(Q!=null) drawPoly(g,Q,C0,C1,1);
		  }
	     }
	  }
    }



    public void setZonePointer() {
	double h=M.C.getOffsetY(TYPE);
	Vector V=new Vector(SOURCE.x,SOURCE.y,h);
        int i=PolyhedronExchange.classify(V);
        M.C.CON_P.ZONE.val=i;
        double y=M.C.getOffsetY(M.C.getFocus());
	PolyWedge P=DataPartition.poly(i,y);
	M.C.CON_P.POINT.val=0;
	M.C.CON_P.POINT.max=0;
	if(P!=null) M.C.CON_P.POINT.max=P.count;
    }


    public void drawZonePointer(Graphics2D g) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int i=M.C.CON_P.ZONE.val;  
        int[] move=DataPartition.getMove(i);
        Color D=M.C.CON_P.SHOW.M[1].C;  
        Color[] C=M.C.COL.getColor(move);
	PolyWedge P=DataPartition.poly(i,F[0],F[1],F[2],0,0,0,nav);
        drawPoly(g,P,C[0],C[1],1); 
        drawPoly(g,P,new Color(0,0,0,0),D,3);
    }



    public void drawVertexPointer(Graphics2D g) {
	boolean nav=M.C.CON_P.navigate();
	Vector[] F=getFrame(nav);
	int i=M.C.CON_P.ZONE.val;  
        int[] move=DataPartition.getMove(i);
        Color D=M.C.CON_P.SHOW.M[2].C;
	PolyWedge P=DataPartition.poly(i,F[0],F[1],F[2],0,0,0,nav);
	 if((P!=null)&&(nav==false)) {
	   try{
              PolyWedge Q=new PolyWedge();
	      Q.count=2;
	      Q.z[0]=P.getCenter();
	      Q.z[1]=P.z[M.C.CON_P.POINT.val]; 
              drawPoly(g,Q,new Color(0,0,0,0),D,2); //vertex pointer
	   }
	   catch(Exception e) {}
	 }
    }


    /**MAIN DRAWING ROUTINE:  this is the partition.*/

    public void drawPieces(Graphics2D g,int choice) {
      if(choice==TYPE) {
	boolean nav=M.C.CON_P.navigate();
	int  t=translationLimits();
	Vector[] F=getFrame(nav);
	int total=0;
	for(int i=0;i<64;++i) {
	  for(int j=-t;j<=t;++j) {
	     for(int k=-t;k<=t;++k) {
	        int[] move=DataPartition.getMove(i);
	        Color[] C=M.C.COL.getColor(move);
	        int prism=DataPartitionRaw.getPrism(i);
	        PolyWedge P=DataPartition.poly(i,F[0],F[1],F[2],2*j,2*k,0,nav);
	        if(M.C.TOGGLE.mode==1) C[0]=M.C.COL.getColor2(prism);
	        drawPoly(g,P,C[0],C[1],1);
	     }
	  }
	}
      }
    }

    public Vector[] getFrame(boolean nav) {
	double z=M.C.getOffsetY(TYPE);
	Vector POS=new Vector(SOURCE.x,SOURCE.y,z);
	Vector[] G=M.N.getFrame(nav);
	Vector[] F={G[0],G[1],POS};
	return(F);
    }



    public int translationLimits() {
	int lim=0;
	if(M.C.CON_P.TILE.on==1) lim=1;
	return(lim);
    }

    public void drawPiecesMove(Graphics2D g) {
      if(TYPE==1) {
	double y=M.C.getOffsetY(TYPE);
	for(int i=0;i<64;++i) {
	    int[] move=DataPartition.getMove(i);
	    Color[] C=M.C.COL.getColor(move);
	    PolyWedge P=DataPartition.polyMoved(i,y);
	    if(P!=null) {
		P=P.translate(new Complex(-2,0));
	       drawPoly(g,P,C[0],C[1],1);
	    }
	}
      }
    }

    public void drawCrosshairs(Graphics2D g) {
	double x1=SOURCE.x;
	double x2=SOURCE.y;
	if(M.C.CON_P.NAVIGATE.on==1) {x1=0;x2=0;}
        PolyWedge P1=new PolyWedge();
        P1.count=2;
        P1.z[0]=new Complex(x1,-2);
        P1.z[1]=new Complex(x1,4);
        PolyWedge P2=new PolyWedge();
        P2.count=2;
        P2.z[0]=new Complex(-2,x2);
        P2.z[1]=new Complex(4,x2);
	Color C=M.C.CON_P.SHOW.M[0].C;
        drawPoly(g,P1,C,C,1);
        drawPoly(g,P2,C,C,1);
    }


    public void doAction() {
        M.C.GLOBAL.forceMode(2);
        M.C.FOCUS[3-TYPE].on=0;
        M.C.FOCUS[TYPE].on=1;
        Compute3D C3D=new Compute3D(TYPE,M);
        new Thread(C3D).start();
    }
      


    /**mouse events**/ 

    public void mouseExited(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	KEY=J.X;
    }

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {
	M.C.FOCUS[TYPE].on=1;
	M.C.FOCUS[3-TYPE].on=0;

	if((KEY.x<3)&&(KEY.y>197)&&(KEY.y<203)) {
	    KEY.x=0;
	    KEY.y=200;
	}

	int block=INFO.inside(KEY);
        if((block==0)&&(mode==1)) scaleUp(KEY,0);
	if((block==0)&&(mode==3)) scaleUp(KEY,1);

        if((mode==2)||(mode==4)) {
  	   SOURCE=unTransform(KEY);
	   SOURCE=TorusMap.fundamentalDomain(SOURCE);
	   setZonePointer();
	   Links.renormLink(M,TYPE);
	}
	if(mode==4) doAction();
	documentStuff(KEY);
	M.repaint();
    }

    /**key events*/

    public void keyReleased(KeyEvent e) {}
    public void keyPressed(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(ch=='s') test=4;
	if(test>0) doMouseClick(test);
	if(ch=='v') {M.K.SC.cycleColors();M.C.repaint();}
	repaint();
    }

    /**DOCUMENTATION**/

    public void documentStuff(Point X) {
	Document3D DOC=new Document3D(M);
	if(INFO.inside(X)==1) DOC.polyInfo();
    }
}
