import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class PlotCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] POINT=new Complex[1000000];
    Color[] COLOR=new Color[1000000];
    int COUNT;

    public PlotCanvas() {
                 addMouseListener(this);
	addMouseMotionListener(this);
                  SOURCE=new Complex(0,0);
                  COUNT=0;
	setScales(300,160,20);
    }

    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
      RenderingHints.VALUE_ANTIALIAS_ON);
      drawBackground(g);
      drawPlot(g);
    }


    public void drawBackground(Graphics2D g) {
      g.setColor(Color.black);
      g.fillRect(0,0,this.getWidth(),this.getHeight());
      GeneralPath gp=new GeneralPath();
      for(int i=-5;i<=5;++i) {
      gp.reset();
      gp.moveTo(-5,i);
      gp.lineTo(5,i);
      gp.moveTo(i,-5);
     gp.lineTo(i,5);
      gp=transform(gp);
      g.setColor(new Color(0,0,200,100));
      if(i==0) g.setColor(new Color(50,100,255));
      g.draw(gp);
      }
    }


    public void drawPoint(Graphics2D g,Complex z,Color C,double size) {
	float x=(float)(z.x);
	float y=(float)(z.y);
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(x-size),(float)(y-size));
	gp.lineTo((float)(x-size),(float)(y+size));
	gp.lineTo((float)(x+size),(float)(y+size));
	gp.lineTo((float)(x+size),(float)(y-size));
	gp.closePath();
	gp=transform(gp);
	g.setColor(C);
	g.fill(gp);
	g.draw(gp);
    }

    public void drawPlot(Graphics2D g) {
	for(int i=0;i<COUNT;++i) {
	    drawPoint(g,POINT[i],COLOR[i],.001);
	}
    }

   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}


   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

    public void mouseMoved(MouseEvent e) {}

    public void mouseClicked(MouseEvent e) {
   }

}
